define(['angular','ngMock'], function(angular) {

    // declare what we need for this unit test in a clear manner
    let scope = null;
    let locationPathString = null;

    // description of what we are testing
    // to test this unit test go to NavigationCtrl.js
    // and comment everything in the isCurrentPath.isCurrentPath function so it returns undefined
   describe('NavigationCtrl', function() {

       // first load the app and making sure properties exists in the $rootScope
       beforeEach(module('app'));

       // before each test case (it statements), inject dependencies
       // and do some variable definitions
       beforeEach( inject(function($location, $rootScope, $controller) {
           // first we create a new scope from inheriting $rootScope
           scope = $rootScope.$new();

           // roles are taken by a server call, so we need to hardcode them
           // because when instantiating the NavigationCtrl, the roles have to be defined
           // test test 
           scope.xgos.user = {roles: ["rootUser", "ANCadmin"]};

           // instantiating the controller and pass him the $scope
           // after instantiating the NavigationCtrl, we have all the functions defined on $scope in the controller
           $controller('NavigationCtrl', {
               $scope: scope
           });

           locationPathString = '/users';
           $location.path(locationPathString);
       }));

       // test cases for different functions in the NavigationCtrl
       it('should set the correct path with the given string', () => {
           // we set the location.path in the beforeEach
           // so when the function is called with the same param('/users')
           // it should return true
           expect(scope.isCurrentPath(locationPathString)).toBe(true);

           // isCurrentPath accepts a string param
           // if we pass an empty array, according to the function
           // it should return false
           expect(scope.isCurrentPath([])).toBe(false);
       });
    });
});