'use strict';
define(function() {
  /**
   * List of the select utilities directives
   */
  var selectDirectivesProvider = function() {
    this.$get = function($filter) {
      var gcselect = {
        name: 'drag',
        label: 'tools.builder.fields.select.select_and_drag.title',
      };
      var gcselectpolyg = {
        name: 'selectpolygon',
        label: 'tools.builder.fields.select.polygon.title',
      };
      var gcselectline = {
        name: 'selectline',
        label: 'tools.builder.fields.select.line.title',
      };

      var gcselecteditclick = {
        name: 'selecteditclick',
        label: 'tools.builder.fields.select.select_click.title',
      };
      var gcselectandbufferise = {
        name: 'dragandbuffer',
        label: 'tools.builder.fields.select.select_and_buffer.title',
      };
      var gcselectmultiple = {
        name: 'selectmultiple',
        label: 'tools.builder.fields.select.multiple.title',
      };
      var gcselectandbuffercomponent = {
        name: 'selectandbuffercomponent',
        label: 'tools.builder.fields.select.select_and_buffer_component.title',
      };
      var gcselectspecialhpo = {
        name: 'selectspecialhpo',
        label: 'tools.builder.fields.select.select_special_hpo.title',
      };
      var gcselectsearchdata = {
        name: 'selectsearchdata',
        label: 'tools.builder.fields.select.select_search_data.title',
      };

      return {
        /**
         * Retrieve list of available directives
         * @returns {*[]}
         */
        getDirectives: function() {
          return [
            gcselect,
            gcselectpolyg,
            gcselectline,
            gcselecteditclick,
            gcselectandbufferise,
            gcselectmultiple,
            gcselectandbuffercomponent,
            gcselectspecialhpo,
            gcselectsearchdata
          ];
        },
      };
    };
    this.$get.$inject = ['$filter'];
  };
  return selectDirectivesProvider;
});
