'use strict';
define(function() {
  var gcdataimport = function(ImportExportFactory, ngDialog) {
    return {
      templateUrl: 'js/XG/widgets/utilities/model/views/gcdataimport.html',
      restrict: 'AE',
      scope: {
        targets: '=',
        importProcessDone: '&',
      },
      link: function(scope, element, attrs, ctrl) {
        var fileExtension = '';
        var ngDialogPromise;
        scope.columnDelimiter = ',';
        scope.decimalDelimiter = '.';

        scope.uploadProcessID = -1;
        scope.importedFeatures = [];
        scope.destinationFeatures = [];

        scope.selectedImpFeature = null;
        scope.importDestFeature = null;
        scope.impCorrespAttrArray = [];
        scope.selectImpAttributes = [];

        scope.srcsrid = '';

        scope.waitImport = false;
        scope.applyRules = false;

        scope.nbImportedRows = 0;

        /**
         * [initDestinationFeatures description]
         * @return {[type]}         [description]
         */
        function initDestinationFeatures() {
          scope.destinationFeatures = [];

          for (var i = 0; i < scope.targets.length; i++) {
            var fti = scope.targets[i];

            if (scope.selectedImpFeature.typeInfo == fti.typeInfo) {
              scope.destinationFeatures.push(fti);
            }
          }
        }

        /**
         * Ouvre l'IHM de choix du format csv en entrée.
         * @returns {undefined}
         *
         */
        function openCsvFormat() {
          ngDialogPromise = ngDialog.openConfirm({
            template:
              'js/XG/widgets/mapapp/importexport/views/csvFormatPrompt.html',
            scope: scope,
            showClose: false,
          });
          ngDialogPromise.then(
            function(data) {
              scope.columnDelimiter = data.charAt(0);
              scope.decimalDelimiter = data.charAt(1);
              ImportExportFactory.loadSchemaCsv(
                scope.uploadProcessID,
                scope.columnDelimiter,
                scope.decimalDelimiter
              ).then(function(importResult) {
                scope.importedFeatures = importResult.data;
                scope.destinationFeatures = [];
                scope.nbImportedRows = -1;
              });
            },
            function(data) {}
          );
        }

        /**
         * [importFile description]
         * @return {[type]} [description]
         */
        scope.importFile = function() {
          if (scope.dropzoneComponent.files.length > 0) {
            var firstFileName = scope.dropzoneComponent.files[0].name;
            fileExtension = firstFileName.substring(
              firstFileName.lastIndexOf('.') + 1,
              firstFileName.length
            );

            if (fileExtension == 'csv') {
              openCsvFormat();
            } else {
              ImportExportFactory.loadSchema(scope.uploadProcessID).then(
                function(importResult) {
                  scope.importedFeatures = importResult.data;

                  scope.destinationFeatures = [];

                  scope.nbImportedRows = -1;
                }
              );
            }
          }
        };

        /**
         * [clearDropzone description]
         * @return {[type]} [description]
         */
        scope.clearDropzone = function() {
          if (scope.dropzoneComponent.files.length > 0) {
            scope.dropzoneComponent.removeAllFiles();

            scope.selectedImpFeature = null;

            scope.importDestFeature = null;

            scope.impCorrespAttrArray = [];

            scope.importedFeatures = [];

            scope.destinationFeatures = [];

            scope.nbImportedRows = 0;
          }
        };

        /**
         * [selectedImpLayerChange description]
         * @return {[type]} [description]
         */
        scope.selectedImpLayerChange = function() {
          scope.srcsrid = scope.selectedImpFeature.srid;

          scope.selectImpAttributes = scope.selectedImpFeature.attributes;

          initDestinationFeatures();

          scope.impCorrespAttrArray = [];

          for (var i = 0; i < scope.selectImpAttributes.length; i++) {
            var attribute = scope.selectImpAttributes[i];

            var attribCorresp = {
              source: attribute.name,
              destination: '',
              choises: [],
            };

            scope.impCorrespAttrArray.push(attribCorresp);
          }

          if (scope.destinationFeatures.length == 1) {
            var uniqFti = scope.destinationFeatures[0];

            scope.importDestFeature = uniqFti;

            scope.destinationLayerChange();
          }
        };

        /**
         * [destinationLayerChange description]
         * @return {[type]} [description]
         */
        scope.destinationLayerChange = function() {
          if (scope.impCorrespAttrArray.length > 0) {
            for (var i = 0; i < scope.impCorrespAttrArray.length; i++) {
              var attribCorresp = scope.impCorrespAttrArray[i];

              var destAttributes = scope.importDestFeature.attributes;

              var destValue = false;

              attribCorresp.choices = [];

              //attribCorresp.choices.push('aucun');

              for (var j = 0; j < destAttributes.length; j++) {
                var destAttribute = destAttributes[j];

                attribCorresp.choices.push(destAttribute);

                if (attribCorresp.source === destAttribute.name) {
                  attribCorresp.destination = destAttribute.name;

                  destValue = true;
                }
              }

              if (!destValue) {
                attribCorresp.destination = 'aucun';
              }
            }
          }
        };

        /**
         * [validateCorrespondence description]
         * @return {[type]} [description]
         */
        scope.validateCorrespondence = function() {
          scope.waitImport = true;

          var sourceFeatureType = scope.selectedImpFeature.name;
          var destFeatureType = scope.importDestFeature.uid;

          var attrCorrespArray = [];

          for (var i = 0; i < scope.impCorrespAttrArray.length; i++) {
            var attrCorresp = scope.impCorrespAttrArray[i];

            var correspObj = {
              source: attrCorresp.source,
              destination: attrCorresp.destination,
            };

            attrCorrespArray.push(correspObj);
          }

          var strAttrCorrespArray = JSON.stringify(attrCorrespArray);

          ImportExportFactory.loaddata(
            scope.uploadProcessID,
            sourceFeatureType,
            destFeatureType,
            strAttrCorrespArray,
            scope.srcsrid,
            null,
            false,
            false,
            scope.applyRules
          ).then(function(loadResult) {
            scope.nbImportedRows = loadResult.data;

            var idxImpFti = scope.importedFeatures.indexOf(
              scope.selectedImpFeature
            );
            if (idxImpFti > -1) {
              scope.importedFeatures.splice(idxImpFti, 1);

              scope.selectedImpFeature = null;

              scope.importDestFeature = null;

              scope.impCorrespAttrArray = [];

              scope.destinationFeatures = [];

              if (scope.importedFeatures.length == 0) {
                scope.dropzoneComponent.removeAllFiles();
              }

              scope.importProcessDone();
            }

            scope.waitImport = false;
          });
        };

        /**
         * [unselectCorrespondence description]
         * @return {[type]} [description]
         */
        scope.unselectCorrespondence = function() {
          for (var i = 0; i < scope.impCorrespAttrArray.length; i++) {
            var attrCorresp = scope.impCorrespAttrArray[i];

            attrCorresp.destination = 'aucun';
          }
        };

        /**
         * [cancelCorrespondence description]
         * @return {[type]} [description]
         */
        scope.cancelCorrespondence = function() {
          scope.selectedImpFeature = null;

          scope.importDestFeature = null;

          scope.impCorrespAttrArray = [];

          scope.importedFeatures = [];

          scope.destinationFeatures = [];

          scope.nbImportedRows = 0;
        };
      },
    };
  };

  gcdataimport.$inject = ['ImportExportFactory', 'ngDialog'];
  return gcdataimport;
});
