'use strict';
define(function() {
  var itvSoumission = function(
    itvSoumfactory,
    gclayers,
    itvVisuFactory,
    QueryFactory,
    gaJsUtils,
    ngDialog,
    PortalsFactory
  ) {
    return {
      templateUrl:
          'js/XG/widgets/utilities/itv/views/soumission/itvSoumissionRapport.html',
      restrict: 'A',
      scope: {
        itvid: '=itvid',
        partdetail: '=partdetail',
        details: '=details',
        selected: '=selected',
        from: '=from', // from sert à faire planter la directive quand il est false/undefined
        map: '=map',
        //-- laonfiguration nous permet de récupérer lorsqu'ils sont configurés
        //-- les tables et couches arcgis.
        conf: '=conf'
      },

      controller: ['$scope', '$element', '$attrs', function () {
      }],

      link: function (scope) {
        var portalid = angular.module('gcMain').portalid;
        if (portalid == undefined || portalid == '') {
          portalid = PortalsFactory.getPortalId();
        }
        var app = angular.module('gcMain').app;
        if (app == undefined || app == '') {
          app = localStorage.getItem('app');
        }

        let detailDesc;
        if (scope.conf && scope.conf.arcgiscomponent) {
          detailDesc = scope.conf.arcgiscomponent.EVT_Inspection_Part_Detail;
        }

        scope.index = scope.details
          .map(function (x) {
            if (angular.equals(x, scope.partdetail)) {
              return x.ref_photo;
            }
          })
          .indexOf(scope.selected);

        if (scope.index == 0) {
          scope.firstelement = true;
          scope.lastelement = false;
        }
        if (scope.index == scope.details.length - 1) {
          scope.firstelement = false;
          scope.lastelement = true;
        }
        if (scope.index == 0 && scope.index == scope.details.length - 1) {
          scope.firstelement = true;
          scope.lastelement = true;
        }
        if (scope.index !== 0 && scope.index !== scope.details.length - 1) {
          scope.firstelement = false;
          scope.lastelement = false;
        }

        scope.detail = scope.details[scope.index];
        scope.imageName = 'picture-' + Math.round(Math.random() * 10000);
        scope.element = angular.element('.picture');
        scope.element.attr('class', scope.imageName);

        scope.opened = false;
        var opendialog;

        /**
         * Demande au serveur une photo ITV d'aprés son nom
         * et la met en place dans le html de visualisation.
         */
        const getPicture4Visu = (detailId) => {
          let detailFtiName = '';
          if (detailDesc) {
            detailFtiName = detailDesc.name;
          }
          const promise = itvVisuFactory.getPictureForVisualisation(
            scope.detail.ref_photo, detailId, detailFtiName);
          promise.then((res) => {
            scope.element.empty();
            scope.img = document.createElement('img');
            scope.img.onload = () => {
              const coef = scope.img.height / scope.img.width;
              scope.img.width = 256;
              scope.img.height = 256 * coef;
              scope.img.onclick = () => {
                if (scope.img.src !==
                    './img/widget/itv/no-available-image.png') {
                  toogleDialog();
                }
              };
              scope.element.append(scope.img);
            };
            try {
              scope.img.src = 'data:' + res.data.mime_type + ';base64, ' +
                  atob(res.data.img);
            } catch (e) {
              e.stack;
              scope.img.src = './img/widget/itv/no-available-image.png';
            }
          });
        };

        /**
         * Gestion du cas ArcGIS avec champ id configuré au niveau du portail
         * comme étant autre chose que le défaut qui est objectid.
         * Donc si on n'est pas dans le cas ArcGIS ou qu'il n'y a pas eut
         * de configuration du champ ID, il faut utiliser l'ID habituel,
         * sinon il faut utiliser l'ID tel que configuré.
         *
         * @param {*} feat : détail d'inspection lu dans la source de données
         * @returns : Ientifiant à utiliser (document joint)
         */
        const getDetailId = (feat) => {
          let detailId = scope.detail.id;
          if (detailDesc && detailDesc.fti.type === 'esri'
              && detailDesc.fti.esriIdField !== 'objectid') {
            if (feat.properties[detailDesc.fti.esriIdField]) {
              detailId = feat.properties[detailDesc.fti.esriIdField];
            }
          }
          return detailId;
        };


        /**
         * Dessin de l'observation sur la carte avec
         * la légende de couleur voulue.
         */
        const drawDetailOnMap = () => {
          var detailSTYLE = new ol.style.Style({
            image: new ol.style.RegularShape({
              fill: new ol.style.Fill({
                color: scope.detail.color,
              }),
              stroke: new ol.style.Stroke({
                color: 'rgb(0,0,0)',
                width: 2,
              }),
              points: 3,
              radius: 10,
              rotation: Math.PI / 4,
              angle: 0,
            }),
          });

          var id = gclayers.getOperationalLayerByName(
            scope.detail.id.split('.')[0]
          ).uid;
          QueryFactory.get(id, scope.detail.id,
            scope.map.getView().getProjection().getCode()).then((res) => {
            var olGeometry = new ol.format.GeoJSON().readGeometry(
              res.data.features[0].geometry
            );
            var confirmDetail = new ol.Feature({
              name: '',
              geometry: olGeometry,
            });
            confirmDetail.setStyle(detailSTYLE);
            var originSourceDetail = new ol.source.Vector({
              //create empty vector
            });
            originSourceDetail.addFeature(confirmDetail);
            var originLayerDetail = new ol.layer.Vector({
              source: originSourceDetail,
              style: detailSTYLE,
              name: 'detail',
            });
            scope.map.getLayers().forEach(function (l) {
              if (
                l.getProperties().name ===
                    originLayerDetail.getProperties().name
              ) {
                scope.map.removeLayer(l);
              }
            });
            originLayerDetail.setZIndex(gaJsUtils.getZIndexMax(scope.map) + 1);
            scope.map.getLayers().insertAt(15, originLayerDetail);

            getPicture4Visu(getDetailId(res.data.features[0]));
          });
        };


        scope.getImage = () => {
          if (scope.from) {
            if (scope.detail.ref_photo !== '') {
              itvSoumfactory
                .getPicture(scope.detail.ref_photo, scope.itvid)
                .then(function (res) {
                  scope.element.empty();
                  scope.img = document.createElement('img');
                  //img = document.getElementsByClassName(str);
                  scope.img.onload = function () {
                    var width = scope.img.width;
                    var height = scope.img.height;
                    var coef = height / width;
                    scope.img.width = 256;
                    scope.img.height = 256 * coef;
                    scope.img.onclick = function () {
                      if (scope.img.src !==
                        './img/widget/itv/no-available-image.png'
                      ) {
                        toogleDialog();
                      }
                    };
                    scope.element.append(scope.img);
                  };
                  try {
                    scope.img.src = 'data:' + res.data.mime_type + ';base64, ' +
                      atob(res.data.img);
                  } catch (e) {
                    e.stack;
                    scope.img.src = './img/widget/itv/no-available-image.png';
                  }
                });
            } else {
              scope.element.empty();
              scope.img = document.createElement('img');
              scope.img.onload = function () {
                scope.element.append(scope.img);
              };
              scope.img.src = './img/widget/itv/no-available-image.png';
            }
          } else {
            drawDetailOnMap();
            scope.element.empty();
            scope.img = document.createElement('img');
            scope.img.onload = function () {
              scope.element.append(scope.img);
            };
            //img = document.getElementsByClassName(str);
            scope.img.src = './img/widget/itv/no-available-image.png';
          }
        };

        scope.getImage();

        scope.change = function (newindex) {
          if (newindex < scope.details.length && newindex >= 0) {
            scope.index = newindex;
            scope.detail = scope.details[scope.index];
            scope.getImage();
          }

          if (newindex == 0) {
            scope.firstelement = true;
            scope.lastelement = false;
          }
          if (newindex == scope.details.length - 1) {
            scope.firstelement = false;
            scope.lastelement = true;
          }
          if (newindex == 0 && newindex == scope.details.length - 1) {
            scope.firstelement = true;
            scope.lastelement = true;
          }
          if (newindex !== 0 && newindex !== scope.details.length - 1) {
            scope.firstelement = false;
            scope.lastelement = false;
          }
        };

        var toogleDialog = function () {
          scope.editedimg = scope.img.cloneNode(true);
          scope.editedimg.onload = function () {
            scope.editedimg.width = '800px';
            scope.editedimg.height = '600px';
            opendialog = ngDialog.open({
              template:
                  'js/XG/widgets/utilities/itv/views/soumission/itvSoumissionPicture.html',
              className: 'ngdialog-theme-plain width800 height600 nopadding',
              closeByDocument: false,
              showClose: false,
              scope: scope,
            });
          };
        };

        /**
         * Au clic sur la popup de l'agrandissement de la photo de l'observation,
         * referme la popup de l'agrandissement de la photo
         */
        scope.cliquedImg = () => {
          if (scope.editedimg.src !== './img/widget/itv/no-available-image.png') {
            opendialog.close();
          }
        };

        /**
         * Vérifie si le détail d'observation de la portion possède les propriétés suivantes:
         * _car1, _car2, quant1, quant2.
         * @param {object} detail détail d'observation d'une portion d'ITV
         * @return {boolean} true si le détail possède une valeur pour chacune de ces propriétés
         */
        scope.detailHasInfos = (detail) => {
          return (detail.hasOwnProperty('_car1') && detail._car1 !== undefined && detail._car1
              !== '' && detail._car1 !== null)
              || (detail.hasOwnProperty('_car2') && detail._car2 !== undefined && detail._car2
                  !== '' && detail._car2 !== null)
              || (detail.hasOwnProperty('quant1') && detail.quant1 !== undefined && detail.quant1
                  !== '' && detail.quant1 !== null)
              || (detail.hasOwnProperty('quant2') && detail.quant2 !== undefined && detail.quant2
                  !== '' && detail.quant2 !== null)
              || (detail.hasOwnProperty('remarques') && detail.remarques !== undefined
                  && detail.remarques !== '' && detail.remarques !== null);
        };

        /**
         * Vérifie si le détail possède une propriété dont le nom est défini en paramètre
         * @param {object} detail détail d'observation d'une portion d'ITV
         * @param {string} info nom de la propriété dont on veut vérifier la présence
         * @return {boolean} true si le détail possède une valeur à la propriété en entrée
         */
        scope.detailsHasInfo = (detail, info) => {
          return detail.hasOwnProperty(info) && detail[info] !== undefined && detail[info] !== '';
        };

        /**
         * Récupère le libellé formaté d'un code d'observation fourni en paramètre
         * @param {object} detail détail d'une portion d'ITV. Elément du tableau de détails de la directive
         * @param info nom d'une propriété de l'objet detail. Cette propriété est un code qui doit être associé à un libellé explicite
         * @return {string} libellé formaté de la propriété du détail de l'itv
         */
        scope.getDetailLabelByCode = (detail, info) => {
          const detailHasLabelInfo = detail.hasOwnProperty('libelles')
              && gaJsUtils.notNullAndDefined(detail.libelles, info) && detail.libelles[info].length > 0;
          if (detail.hasOwnProperty('libelles') && detailHasLabelInfo) {
            let label;
            switch (info) {
              case 'quant1':
              case 'quant2':
                label = '(' + detail.libelles[info] + ')';
                break;
              default:
                label = detail.libelles[info];
            }
            return label;
          }
          return '';
        };
      },
    };
  };

  itvSoumission.$inject = [
    'itvSoumFactory',
    'gclayers',
    'itvVisuFactory',
    'QueryFactory',
    'gaJsUtils',
    'ngDialog',
    'PortalsFactory',
  ];
  return itvSoumission;
});
