/**
 * Après une sélection d’objets du patrimoine (tronçons, regards, raccords,…) concernés par l’intervention, 
 * on veut rapatrier le maximum d’informations attributaires en commun avec l’intervention pour éviter la recherche manuelle
 * et la saisie par l’utilisateur.
 * Auteur : @RSE
 * Date: 24/11/2021
 */
'use strict';
define(function () {
  const setDataFromCollectionFunction = function () {
    this.$get = function (
      $q,
      $filter,
      FeatureTypeFactory,
      QueryFactory,
      attributeRestrictionsUtils
      ) {

      /**
       * any faire la recherche sur toutes les features contenues dans la collection 
       * first faire la recherche sur la première feature contenue dans la collection 
       * lastr faire la recherche sur la dernière feature contenue dans la collection
       */
      return {
        /**
         * la description retournée est exploitée dans functionsBrowser.html.
         *
         * @returns : description des paramétres de la fonction
         */
        getParametersDesc: () => {
          return [
            [0, 'select', [
              {
                id: '0',
                label: $filter('translate')(
                  'functions_browser.functions.setDataFromCollection.any'),
                operator: 'any'
              }, {
                id: '1',
                label: $filter('translate')(
                  'functions_browser.functions.setDataFromCollection.first'),
                operator: 'first'
              }, {
                id: '2',
                label: $filter('translate')(
                  'functions_browser.functions.setDataFromCollection.last'),
                operator: 'last'
              }, {
                id: '3',
                label: $filter('translate')(
                  'functions_browser.functions.setDataFromCollection.sum'),
                operator: 'sum'
              }, {
                id: '4',
                label: $filter('translate')(
                  'functions_browser.functions.setDataFromCollection.average'),
                operator: 'average'
              }, {
                id: '5',
                label: $filter('translate')(
                  'functions_browser.functions.setDataFromCollection.min'),
                operator: 'min'
              }, {
                id: '6',
                label: $filter('translate')(
                  'functions_browser.functions.setDataFromCollection.max'),
                operator: 'max'
              }
            ]],
            [1, 'variable'],
            [2, 'variable'],
            [3, 'componentAttributeSelector'],
            [4, 'boolean']
          ];
        },
        setDataFromCollection: function (variables, ftiOfCurrent, typeRecherche, destination, source,
            composants, decodeTableRestriction) {
          let def = $q.defer();
          const destinationArray = destination.split(".");
          const destinationAttributeName = destinationArray.pop();
          const destinationProperties = destinationArray.pop();
          const destinationVariable = destinationArray.pop();
          const composantsArray = composants.split("/");
          let valueFound;
          let composantUID;
          let composantAttribute;
          let sourceFti;
          let length = 0;
          // KIS-3646 | Convertir 'typeRecherche' en JSON pour pouvoir accéder à l'opérateur
          typeRecherche = JSON.parse(typeRecherche);
          let isRechercheAction = ['any','first','last'].includes(typeRecherche.operator);
          if(variables[source] && variables[source].features && variables[source].features.length>0 && composantsArray && composantsArray.length>0 && 
            variables[destinationVariable] && variables[destinationVariable][destinationProperties]){
            for(let i=0;i<composantsArray.length;i++){
              // cette logique n'est pas adapté que pour le any first last
              if(angular.isDefined(valueFound) && isRechercheAction){
                break;
              }
              const composantData = composantsArray[i].split(";")
              composantAttribute = composantData.pop();
              composantUID = composantData.pop();
              sourceFti = FeatureTypeFactory.getFeatureByUid(composantUID);
              
              for(let j=0;j<variables[source].features.length;j++){
                const feature = variables[source].features[typeRecherche.operator === 'last' ? variables[source].features.length-j-1 : j];
                const currentFeatureComponentName = feature.id.split('.')[0];
                if (currentFeatureComponentName === sourceFti.name) {
                  length ++;
                  // je le mets pas dans le switch puisqu'il y a une logique par rapport au break et continue
                  if (isRechercheAction) {
                    if(!angular.isDefined(feature.properties[composantAttribute]) || feature.properties[composantAttribute]==null ||
                        feature.properties[composantAttribute] === ""){
                      if (typeRecherche.operator !== 'any') {
                        break;
                      }
                    } else {
                      if (decodeTableRestriction === 'tab-true') {
                        if (!ftiOfCurrent || (ftiOfCurrent && !Array.isArray(ftiOfCurrent.attributes))) {
                          // si le fti fourni par formFieldRender n'existe pas
                          // alors on ne peut pas déterminer l'absence de restriction sur l'attribut de destination
                          console.error('setDataFromCollection : ftiOfCurrent est vide ou null. ftiOfCurrent = ', ftiOfCurrent);
                          break;
                        }
                        // Si on souhaite récupérer la valeur à partir d'une clé stockée dans un attribut lié à une table/domaine de restriction (decodeTableRestriction === 'tab-true')
                        // on doit vérifier si l'attribut source possède bien une table ou un domaine de restriction
                        // et on doit vérifier si l'attribut de destination soit un "champ libre" (sans table/domaine de restriction)
                        const sourceAttHasRestriction = attributeRestrictionsUtils.attributeHasTableOrDomainRestriction(
                            sourceFti, composantAttribute);
                        const destAttHasRestriction = attributeRestrictionsUtils.attributeHasRestriction(
                            ftiOfCurrent, destination);

                        if (sourceAttHasRestriction && !destAttHasRestriction) {
                          // l'attribut source possède une table ou un domaine de restriction et l'attribut de destination est un champ libre
                          const restrictionKey = feature.properties[composantAttribute];

                          if (attributeRestrictionsUtils.attributeHasRestrictionType(sourceFti,
                              composantAttribute, attributeRestrictionsUtils.TABLE)) {
                            // on décode une table de restriction
                            return QueryFactory.getValueRestrictionTable(sourceFti.uid,
                                composantAttribute, restrictionKey).then(
                                response => {
                                  if (response.data && response.data.value) {
                                    variables[destinationVariable][destinationProperties][destinationAttributeName] = response.data.value;
                                  } else {
                                    require('toastr').error($filter('translate')
                                        (
                                            'functions_browser.functions.setDataFromCollection.error_value_not_found')
                                        + " : " + feature.properties[composantAttribute]);
                                  }
                                }
                            );
                          } else {
                            // on décode un domaine de restriction
                            const sourceAttribute = sourceFti.attributes.find(
                                attr => attr.name === composantAttribute);
                            valueFound = angular.copy(
                                sourceAttribute.restrictions[0].listofValues[restrictionKey]);
                          }
                        }
                      } else {
                        valueFound = angular.copy(feature.properties[composantAttribute]);
                      }
                      break;
                    }
                  } else {
                    let value = feature.properties[composantAttribute];
                    if(angular.isDefined(value) && value != null && value !=='' && !isNaN(value)){
                      switch(typeRecherche.operator){
                        case 'sum':
                        case 'average': valueFound = angular.isDefined(valueFound)? valueFound+Number(value):Number(value);break;
                        case 'max': valueFound = angular.isDefined(valueFound)? 
                                                              (valueFound>value?valueFound:Number(value)):Number(value);break;
                        case 'min': valueFound = angular.isDefined(valueFound)?
                                                              (valueFound<value?valueFound:Number(value)):Number(value);break;  
                      }
                    }
                  }
                }
              }
            }
            if(typeRecherche.operator === 'average'){
              valueFound = valueFound/length;
            }
            if(angular.isDefined(valueFound)){
              if(isRechercheAction){
                variables[destinationVariable][destinationProperties][destinationAttributeName] = valueFound;
                def.resolve();
              } else {
                const destinationAttributedef = ftiOfCurrent.attributes.find(att => att.name === destinationAttributeName);
                const typeArray = ['java.math.BigDecimal','java.lang.Integer','java.lang.Long',
                                    'java.lang.Double','java.lang.Float', 'java.lang.String'];
                if(!typeArray.includes(destinationAttributedef.type)){
                  require('toastr').error($filter('translate')
                        ('functions_browser.functions.setDataFromCollection.error_incompatible_type')+ " "+destinationAttributeName);
                } else if(['java.lang.Integer','java.lang.Long'].includes(destinationAttributedef.type)){
                  variables[destinationVariable][destinationProperties][destinationAttributeName] = Math.round(valueFound);
                } else {
                  variables[destinationVariable][destinationProperties][destinationAttributeName] = valueFound;
                }
                def.resolve();
              }
            } else {
              def.resolve();
            }
          } else {
            def.resolve();
          }
          return def.promise;
        },
      };
    };

    this.$get.$inject = [
      '$q',
      '$filter',
      'FeatureTypeFactory',
      'QueryFactory',
      'attributeRestrictionsUtils'
    ];
  };
  return setDataFromCollectionFunction;
});
