'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    mapJsUtils
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/edit/views/gclocalisation.html',
      restrict: 'A',
      scope: {
        map: '=map',
        feature: '=feats',
        res: '=res',
        onfinish: '&?onfinish',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.isActive = false;
        /**
         * [localiseandupdate description]
         * @return {[type]} [description]
         */
        scope.localise = function() {
          if (scope.isActive) {
            gclayers.clearhighLightFeatures();
            scope.isActive = false;
          } else {
            scope.isActive = true;
            if (scope.feature) {
              scope.feature['type'] = 'Feature';
              mapJsUtils.localiseData(scope.feature, scope.map);
            }
          }
        };
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    'mapJsUtils'
  ];
  return gcelement;
});
