'use strict';
define(function() {
  var scheduleCtrl = function(
    $scope,
    ParametersFactory,
    $location,
    SirocoFactory,
    gaDomUtils
  ) {
    $scope.planning = false;
    var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));

    ParametersFactory.getbytype('siroco_plannification').then(function(res) {
      if (res.data.length > 0) {
        res.data.forEach(function(cfg) {
          if (cfg.data.app == sirocoCfg.appuid) {
            $scope.planning = cfg;
          }
        });
      }
    });

    /**
     * exportXLS
     */
    $scope.exportXLS = function() {
      var seuil = $scope.planning.data.seuil;
      var methode = seuil == 'annee' ? 'realisation' : 'rendement';
      gaDomUtils.showGlobalLoader();
      SirocoFactory.tableauprogrammation(methode).then(function(res) {
        window.open(res.data.strValeur);
        gaDomUtils.hideGlobalLoader();
      });
    };
  };
  scheduleCtrl.$inject = [
    '$scope',
    'ParametersFactory',
    '$location',
    'SirocoFactory',
    'gaDomUtils',
  ];
  return scheduleCtrl;
});
