'use strict';
define(function() {
  var selectiontoolstoolbarDirective = function(
    gcPopup,
    gclayers,
    extendedNgDialog,
    $filter
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/selectiontools/views/selectiontoolswidget.html',

      restrict: 'A',
      controller: [
        '$scope',
        function($scope) {
          // console.log($scope);
        },
      ],

      link: function(scope, element) {
        scope.isActive = false;
        //-- Indique aux boutons qu ils snt dans une petite toolbar :).
        scope.insideToolbar = true;
        scope.toolbarInfo = {
          setActiveBtn: function(directive, origin) {
            if (scope.activeBtn != undefined)
              scope.$broadcast('closeToolsBar_' + scope.activeBtn, {
                origin: origin,
              });
            if (scope.activeBtn == directive) scope.activeBtn = undefined;
            else scope.activeBtn = directive;
          },
        };

        scope.$on('closeToolsBar_toolbarselectiontoolsdirective', function(
          event
        ) {
          scope.reset();
          if (scope.isActive)
            $('#toolbar_toolbarselectiontoolsdirective_popover').click();
          scope.isActive = false;
        });

        var btnElt = $(element.children()[0]);
        btnElt.bind('click', function() {
          if (scope.isActive) {
            scope.isActive = false;
            scope.reset();
            scope.toolbarInfo.setActiveBtn(undefined);
          } else {
            scope.isActive = true;
          }
        });

        /**
         * [fct description]
         * @param  {[type]} evt [description]
         * @return {[type]}     [description]
         */
        var fct = function(evt) {
          if (evt.dragging) {
            return;
          }
          /** @type {string} */
          var helpMsg = $filter('translate')(
            'selectiontoolsdirective.helpMessage'
          );
          /** @type {ol.Coordinate|undefined} */

          scope.helpTooltipElement.innerHTML = helpMsg;
          scope.helpTooltip.setPosition(evt.coordinate);
        };

        scope.reset = function() {
          scope.currentmode = '';
          scope.map.un('pointermove', fct);
          if (scope.drawinteraction != null) {
            scope.map.removeInteraction(scope.drawinteraction);
          }
          if (scope.helpTooltipElement != null) {
            scope.helpTooltipElement.remove();
          }
          scope.map.getOverlays().clear();
          scope.helpTooltipElement = null;
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();
        };

        /**
         * format length output
         * @param {ol.geom.LineString} line
         * @return {string}
         */
        /**
         * Handle pointer move.
         * @param {ol.MapBrowserEvent} evt
         */
        //scope.pointerMoveHandler =
        scope.createHelpTooltip = function() {
          if (scope.helpTooltipElement) {
            scope.helpTooltipElement.parentNode.removeChild(
              scope.helpTooltipElement
            );
          }
          scope.helpTooltipElement = document.createElement('div');
          scope.helpTooltipElement.className = 'tooltip';
          scope.helpTooltip = new ol.Overlay({
            element: scope.helpTooltipElement,
            offset: [15, 0],
            positioning: 'center-left',
          });
          scope.map.addOverlay(scope.helpTooltip);
        };
      },
    };
  };

  selectiontoolstoolbarDirective.$inject = [
    'gcPopup',
    'gclayers',
    'extendedNgDialog',
    '$filter'
  ];
  return selectiontoolstoolbarDirective;
});
