'use strict';
define(function() {
  /**
   * [indigauwidget description]
   */
  var indigauwidget = function(
    ConfigFactory,
    $filter,
    ngDialog,
    $translate,
    FeatureTypeFactory,
    SelectManager,
    ogcFactory,
    $q,
    QueryFactory,
    IndigauFactory,
    extendedNgDialog,
    gaDomUtils,
    ngTableParams,
    EditFactory,
    gclayers,
    $rootScope,
    $compile
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/indigau/views/indigauwidget.html',
      restrict: 'A',

      link: function(scope) {
        var headersFieldCode = 'code';
        var headersFieldValue = 'valeur';

        var detailFields = [
          'code_principal',
          'type_detail',
          'car1',
          'car2',
          'quant1',
          'quant2',
          'remarques',
          'emplct_circ_1',
          'emplct_circ_2',
          'emplct_lng_vert',
          'defaut_cont',
          'assemblage',
          'description_emplct',
          'ref_photo',
        ];

        var format = new ol.format.GeoJSON();

        var srid = scope.map
          .getView()
          .getProjection()
          .getCode();

        var title_tab_import = 'Affichage des résultats';
        $translate('indigauwidget.tab_import').then(function(res) {
          title_tab_import = res;
        });

        var title_tab_export = 'Export ITV';
        $translate('indigauwidget.tab_export').then(function(res) {
          title_tab_export = res;
        });

        var cptTotalStr = "Nombre d'inspection soumises : ";
        $translate('indigauwidget.cptTotal').then(function(res) {
          cptTotalStr = res;
        });

        var cptErrorStr = "Nombre d'inspection non ajoutées : ";
        $translate('indigauwidget.cptError').then(function(res) {
          cptErrorStr = res;
        });

        var cptOKStr = "Nombre d'inspection ajoutées : ";
        $translate('indigauwidget.cptOK').then(function(res) {
          cptOKStr = res;
        });

        var cptDetailsStr = 'Nombre de détails ajoutées : ';
        $translate('indigauwidget.cptDetails').then(function(res) {
          cptDetailsStr = res;
        });

        var cptDetailsNonAjoutesStr = 'Nombre de détails non ajoutées : ';
        $translate('indigauwidget.cptDetailsNonAjoutes').then(function(res) {
          cptDetailsNonAjoutesStr = res;
        });

        var cptNoAAAStr = "Nombre d'inspection sans id : ";
        $translate('indigauwidget.cptNoAAA').then(function(res) {
          cptNoAAAStr = res;
        });

        var cptNoDetailStr = "Nombre d'inspection sans détails : ";
        $translate('indigauwidget.cptNoDetail').then(function(res) {
          cptNoDetailStr = res;
        });

        scope.tabs = [
          { title: title_tab_export },
          { title: 'Calcul' },
          { title: title_tab_import },
        ];

        scope.tabs.activeTab = 0;

        scope.conf = {
          loginMode: 'config',
          nbQueryParts: 50,
        };

        scope.selectType = 'current';

        scope.showData = scope.showAuth = true;

        scope.info = {
          displayMsg: '',
        };

        scope.currentPartsJson = {
          objects: [],
        };

        var totalQueries = 0;
        var totalResponses = 0;

        scope.criteres = [];

        scope.selectedChoice = 'cana_indigau_choix1';

        var critere1Results = {
          id: undefined,
          name: undefined,
          G: [],
          G1: [],
          G2: [],
          G3: [],
          G4: [],
        };

        var critere2Results = {
          id: undefined,
          name: undefined,
          G: [],
          G1: [],
          G2: [],
          G3: [],
          G4: [],
        };

        var critere3Results = {
          id: undefined,
          name: undefined,
          G: [],
          G1: [],
          G2: [],
          G3: [],
          G4: [],
        };

        scope.importResultsData = [];

        var canaResultFeatures = [];

        scope.importResults = undefined;

        var infoPopup;

        var resultsPopup;

        scope.exportResult = {
          cptTotal: 0,
          cptOK: 0,
          cptError: 0,
          cptDetails: 0,
          cptDetailsNonAjoutes: 0,
          cptNoAAA: 0,
          cptNoDetail: 0,
        };

        function getCritereListFromServer() {
          var promise = IndigauFactory.getCritereITV(
            scope.conf.login,
            scope.conf.password
          );

          promise.then(
            function(res) {
              scope.criteres = [];

              console.log(res.data);

              var criteresArrayResult = res.data;

              for (var i = 0; i < criteresArrayResult.length; i++) {
                var critereResult = criteresArrayResult[i];

                //scope.criteres

                if (critereResult.type != null) {
                  scope.criteres.push(critereResult);
                }
              }
            },
            function() {
              console.error(
                "Erreur à l'appel de IndigauFactory.getCritereITV()."
              );
            }
          );
        }

        function getConfig(openPop) {
          ConfigFactory.get('IndigauWidget', 'mainConfig').then(function(res) {
            var data = res.data;

            scope.conf = angular.copy(data);

            getCritereListFromServer();

            if (openPop) {
              ngDialog.open({
                template:
                  'js/XG/widgets/mapapp/indigau/views/indigauWidgetConfig.html',
                className: 'ngdialog-theme-plain width800 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
              });
            }
          });
        }

        getConfig(false);

        scope.configIndigauWidget = function() {
          getConfig(true);
        };

        scope.saveIndigauWidgetConfig = function() {
          ConfigFactory.add(scope.conf, 'IndigauWidget', 'mainConfig').then(
            function(res) {
              if (res.data == true) {
                $translate('indigauwidget.config.saveSuccessMsg').then(function(
                  res
                ) {
                  require('toastr').success(res);
                });

                if (
                  angular.isDefined(scope.conf.canaLayerUID) &&
                  angular.isDefined(scope.conf.canaNoteField1) &&
                  angular.isDefined(scope.conf.canaNoteField1.name) &&
                  angular.isDefined(scope.conf.canaNoteField2) &&
                  angular.isDefined(scope.conf.canaNoteField2.name) &&
                  angular.isDefined(scope.conf.canaNoteField3) &&
                  angular.isDefined(scope.conf.canaNoteField3.name)
                ) {
                  var promise = IndigauFactory.generatestyles(
                    scope.conf.canaLayerUID,
                    scope.conf.canaNoteField1.name,
                    scope.conf.canaNoteField2.name,
                    scope.conf.canaNoteField3.name
                  );

                  promise.then(
                    function(res) {
                      console.log(res.data);
                    },
                    function() {
                      console.error(
                        "Erreur à l'appel de IndigauFactory.generatestyles()."
                      );
                    }
                  );
                }
              } else {
                $translate('indigauwidget.config.saveErrorMsg').then(function(
                  res
                ) {
                  require('toastr').error(res);
                });
              }
            }
          );
        };

        scope.getInspectionPortions = function() {
          totalQueries = 0;
          totalResponses = 0;

          scope.currentPartsJson = {
            objects: [],
          };

          if (scope.selectType == 'current') {
            var inspectionFti = FeatureTypeFactory.getFeatureByUid(
              scope.conf.inspectionLayerUID
            );

            if (inspectionFti != null) {
              var inspectionsIds = SelectManager.getFeaturesIdByftiType(
                inspectionFti.name
              );

              if (inspectionsIds.length > 0) {
                var cql_filter = getIdsCqlFilter(
                  scope.conf.inspectionLinkId.name,
                  inspectionsIds
                );

                getInspectionParts(cql_filter, false);
              } else {
                $translate('indigauwidget.emptySelection').then(function(res) {
                  require('toastr').warning(res);
                });
              }
            }
          } else if (scope.selectType == 'date') {
            if (
              angular.isDefined(scope.dateStart) &&
              angular.isDefined(scope.dateEnd)
            ) {
              getInspectionPartsByDate();
            } else {
              $translate('indigauwidget.emptyDate').then(function(res) {
                require('toastr').warning(res);
              });
            }
          } else if (scope.selectType == 'all') {
            getInspectionParts('1=1', false);
          }
        };

        function thisAlert(mess) {
          swal({
            title: $filter('translate')('indigauwidget.dialog_error'),
            text: mess,
            type: 'error',
            confirmButtonColor: '#F50072',
            showCancelButton: false,
            //                      confirmButtonText: $filter('translate')("common.yes"),
            showConfirmButton: true,
          });
        }

        scope.exportToIndigau = function() {
          scope.exportResult = {
            cptTotal: 0,
            cptOK: 0,
            cptError: 0,
            cptDetails: 0,
            cptDetailsNonAjoutes: 0,
            cptNoAAA: 0,
            cptNoDetail: 0,
          };

          gaDomUtils.showGlobalLoader();

          var currentPartsJsonArray = [];
          var tempObjectArray = [];

          var totalImportQueries = 0;
          var totalImportResponses = 0;
          var tempObjetsJson;

          for (var i = 0; i < scope.currentPartsJson.objects.length; i++) {
            var loopObject = scope.currentPartsJson.objects[i];

            tempObjectArray.push(loopObject);

            if (tempObjectArray.length == scope.conf.nbQueryParts) {
              tempObjetsJson = {
                objects: tempObjectArray,
              };

              currentPartsJsonArray.push(tempObjetsJson);

              tempObjectArray = [];
            }
          }

          if (tempObjectArray.length > 0) {
            tempObjetsJson = {
              objects: tempObjectArray,
            };

            currentPartsJsonArray.push(tempObjetsJson);
          }

          for (var j = 0; j < currentPartsJsonArray.length; j++) {
            var loopPartsJson = currentPartsJsonArray[j];

            var strPartsJson = JSON.stringify(loopPartsJson);

            totalImportQueries++;

            var promise = IndigauFactory.importITV(
              scope.conf.login,
              scope.conf.password,
              strPartsJson
            );

            promise.then(
              function(res) {
                totalImportResponses++;

                if (
                  typeof res.data == 'string' &&
                  res.data.indexOf('cptTotal') == -1
                )
                  thisAlert(res.data);

                var responseJson = res.data;

                scope.exportResult.cptTotal += responseJson.cptTotal;
                scope.exportResult.cptOK += responseJson.cptOK;
                scope.exportResult.cptError += responseJson.cptError;
                scope.exportResult.cptDetails += responseJson.cptDetails;
                scope.exportResult.cptDetailsNonAjoutes +=
                  responseJson.cptDetailsNonAjoutes;
                scope.exportResult.cptNoAAA += responseJson.cptNoAAA;
                scope.exportResult.cptNoDetail += responseJson.cptNoDetail;

                if (totalImportResponses >= totalImportQueries) {
                  gaDomUtils.hideGlobalLoader();

                  var strRes =
                    cptTotalStr +
                    scope.exportResult.cptTotal +
                    '\n' +
                    cptOKStr +
                    scope.exportResult.cptOK +
                    '\n' +
                    cptErrorStr +
                    scope.exportResult.cptError +
                    '\n' +
                    cptDetailsStr +
                    scope.exportResult.cptDetails +
                    '\n' +
                    cptDetailsNonAjoutesStr +
                    scope.exportResult.cptDetailsNonAjoutes +
                    '\n' +
                    cptNoAAAStr +
                    scope.exportResult.cptNoAAA +
                    '\n' +
                    cptNoDetailStr +
                    scope.exportResult.cptNoDetail;

                  openInfoPopup(strRes);
                }
              },
              function() {
                totalImportResponses++;

                if (totalImportResponses >= totalImportQueries) {
                  gaDomUtils.hideGlobalLoader();
                }

                thisAlert(res.data);
                console.error(
                  "Erreur à l'appel de IndigauFactory.importITV()."
                );
              }
            );
          }
        };

        scope.emptyIndigauBase = function() {
          var promise = IndigauFactory.razITV(
            scope.conf.login,
            scope.conf.password
          );

          promise.then(
            function(res) {
              openInfoPopup(res.data);
            },
            function() {
              console.error("Erreur à l'appel de IndigauFactory.razITV().");
            }
          );
        };

        scope.okButtonInfoClickHandler = function() {
          if (infoPopup != undefined) {
            infoPopup.close();
          }
        };

        scope.refreshCritereList = function() {
          getCritereListFromServer();
        };

        scope.importFromIndigau = function() {
          scope.importResultsData = [];

          critere1Results = {
            id: undefined,
            name: undefined,
            G: [],
            G1: [],
            G2: [],
            G3: [],
            G4: [],
          };

          critere2Results = {
            id: undefined,
            name: undefined,
            G: [],
            G1: [],
            G2: [],
            G3: [],
            G4: [],
          };

          critere3Results = {
            id: undefined,
            name: undefined,
            G: [],
            G1: [],
            G2: [],
            G3: [],
            G4: [],
          };

          var c1, c2, c3;

          if (angular.isDefined(scope.selectedCritere1)) {
            c1 = scope.selectedCritere1;

            critere1Results.id = scope.selectedCritere1;

            critere1Results.name = getCritereNameById(scope.selectedCritere1);
          } else {
            c1 = '';
          }

          if (angular.isDefined(scope.selectedCritere2)) {
            c2 = scope.selectedCritere2;

            critere2Results.id = scope.selectedCritere2;

            critere2Results.name = getCritereNameById(scope.selectedCritere2);
          } else {
            c2 = '';
          }

          if (angular.isDefined(scope.selectedCritere3)) {
            c3 = scope.selectedCritere3;

            critere3Results.id = scope.selectedCritere3;

            critere3Results.name = getCritereNameById(scope.selectedCritere3);
          } else {
            c3 = '';
          }

          var promise = IndigauFactory.resultITV(
            scope.conf.login,
            scope.conf.password,
            c1,
            c2,
            c3
          );

          promise.then(
            function(res) {
              scope.importResults = res.data;

              Object.keys(scope.importResults).forEach(function(key) {
                var criteresG = scope.importResults[key];

                Object.keys(criteresG).forEach(function(key2) {
                  var gValue = criteresG[key2];

                  updateCritereResult(key2, gValue, key, critere1Results);

                  updateCritereResult(key2, gValue, key, critere2Results);

                  updateCritereResult(key2, gValue, key, critere3Results);
                });
              });

              var row1 = {
                name: critere1Results.name,
                G1: critere1Results.G1.length,
                G2: critere1Results.G2.length,
                G3: critere1Results.G3.length,
                G4: critere1Results.G4.length,
                G: critere1Results.G.length,
              };

              var row2 = {
                name: critere2Results.name,
                G1: critere2Results.G1.length,
                G2: critere2Results.G2.length,
                G3: critere2Results.G3.length,
                G4: critere2Results.G4.length,
                G: critere2Results.G.length,
              };

              var row3 = {
                name: critere3Results.name,
                G1: critere3Results.G1.length,
                G2: critere3Results.G2.length,
                G3: critere3Results.G3.length,
                G4: critere3Results.G4.length,
                G: critere3Results.G.length,
              };

              if (angular.isDefined(critere1Results.name)) {
                scope.importResultsData.push(row1);
              }

              if (angular.isDefined(critere2Results.name)) {
                scope.importResultsData.push(row2);
              }

              if (angular.isDefined(critere3Results.name)) {
                scope.importResultsData.push(row3);
              }

              scope.importResultsTableParams = new ngTableParams(
                {
                  count: 3,
                },
                {
                  counts: [],
                  total: 1,

                  getData: function($defer) {
                    var data = scope.importResultsData;

                    $defer.resolve(data);
                  },
                }
              );

              openResultsPopup();
            },
            function() {
              console.error("Erreur à l'appel de IndigauFactory.resultITV().");
            }
          );
        };

        scope.displayRepresentation = function() {
          if (scope.importResults != undefined) {
            canaResultFeatures = [];

            var featuresIds = [];

            Object.keys(scope.importResults).forEach(function(key) {
              var featIDStr, strLengthEnd;

              if (key.indexOf('.') == -1) {
                strLengthEnd = key.length - 1;
                featIDStr = key.substring(1, strLengthEnd);
              } else {
                featIDStr = key.split('.')[1];
              }

              featuresIds.push(featIDStr);
            });

            if (featuresIds.length > 0) {
              var promise = QueryFactory.get(
                scope.conf.canaLayerUID,
                featuresIds.toString()
              );
              promise.then(
                function(res) {
                  var canaFeatures = format.readFeatures(res.data);

                  if (canaFeatures != undefined && canaFeatures.length > 0) {
                    for (var i = 0; i < canaFeatures.length; i++) {
                      var canaFeature = canaFeatures[i];

                      var resFeature = setResultNoteToFeature(canaFeature);

                      var writeFeature = format.writeFeatureObject(resFeature);

                      console.log(writeFeature);

                      canaResultFeatures.push(writeFeature);
                    }
                  }

                  if (canaResultFeatures.length > 0) {
                    var featcollect = {
                      type: 'FeatureCollection',
                      features: canaResultFeatures,
                    };

                    EditFactory.updatebyfilter(
                      scope.conf.canaLayerUID,
                      '1=1',
                      scope.conf.canaNoteField1.name,
                      'string',
                      '_'
                    ).then(function() {
                      EditFactory.updatebyfilter(
                        scope.conf.canaLayerUID,
                        '1=1',
                        scope.conf.canaNoteField2.name,
                        'string',
                        '_'
                      ).then(function() {
                        EditFactory.updatebyfilter(
                          scope.conf.canaLayerUID,
                          '1=1',
                          scope.conf.canaNoteField3.name,
                          'string',
                          '_'
                        ).then(function() {
                          var promiseupdate = EditFactory.update(
                            scope.conf.canaLayerUID,
                            featcollect,
                            ''
                          );
                          promiseupdate.then(
                            function() {
                              gclayers
                                .getOperationalLayer()
                                .forEach(function(layer) {
                                  if (
                                    scope.conf.canaLayerUID ===
                                    layer.get('fti').uid
                                  ) {
                                    layer.style = scope.selectedChoice;

                                    $rootScope.$broadcast(
                                      'gcOperationalLayerChange',
                                      '',
                                      'applyall'
                                    );
                                  }
                                });
                            },
                            function() {
                              console.error(
                                "Erreur à l'appel de EditFactory.update()."
                              );
                            }
                          );
                        });
                      });
                    });
                  }
                },
                function() {
                  console.error(
                    "Erreur à l'appel de QueryFactory.get()."
                  );
                }
              );
            }
          }
        };

        function setResultNoteToFeature(feature) {
          var featureId = feature.getId();

          Object.keys(scope.importResults).forEach(function(key) {
            var featIDStr, strLengthEnd;

            if (key.indexOf('.') == -1) {
              strLengthEnd = key.length - 1;
              featIDStr = key.substring(1, strLengthEnd);
            } else {
              featIDStr = key;
            }

            if (featureId == featIDStr) {
              var featureProps = feature.getProperties();

              var criteresG = scope.importResults[key];

              if (angular.isDefined(scope.selectedCritere1)) {
                var note1Value = criteresG[scope.selectedCritere1];

                featureProps[scope.conf.canaNoteField1.name] = note1Value;
              }

              if (angular.isDefined(scope.selectedCritere2)) {
                var note2Value = criteresG[scope.selectedCritere2];

                featureProps[scope.conf.canaNoteField2.name] = note2Value;
              }

              if (angular.isDefined(scope.selectedCritere3)) {
                var note3Value = criteresG[scope.selectedCritere3];

                featureProps[scope.conf.canaNoteField3.name] = note3Value;
              }

              feature.setProperties(featureProps);
            }
          });

          return feature;
        }

        function getInspectionParts(cql_filter, exportALL) {
          var inspectPartIds = [];

          if (!configOk()) return;

          gaDomUtils.showGlobalLoader();
          var promise1 = ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            scope.conf.inspectionPartLayerUID,
            'json',
            srid,
            cql_filter
          );
          promise1.then(
            function(res) {
              var inspectionsParts = format.readFeatures(res.data);

              if (
                inspectionsParts != undefined &&
                inspectionsParts.length > 0
              ) {
                var inspectionsPartsFrag = [];

                for (var i = 0; i < inspectionsParts.length; i++) {
                  var inspectionPart = inspectionsParts[i];

                  var partID = inspectionPart.getId();

                  inspectionsPartsFrag.push(partID);

                  if (inspectionsPartsFrag.length == scope.conf.nbQueryParts) {
                    var arrayClone = inspectionsPartsFrag.slice(0);

                    inspectPartIds.push(arrayClone);

                    inspectionsPartsFrag = [];
                  }
                }

                if (inspectionsPartsFrag.length > 0) {
                  var arrayClone = inspectionsPartsFrag.slice(0);

                  inspectPartIds.push(arrayClone);
                }

                for (var j = 0; j < inspectPartIds.length; j++) {
                  var arrayFrags = inspectPartIds[j];

                  getInspectionPartJson(arrayFrags, exportALL);
                }
              }
            },
            function() {
              console.error(
                "Erreur à l'appel de ogc.data(), cql_filter : " + cql_filter
              );

              gaDomUtils.hideGlobalLoader();
            }
          );
        }

        function configOk() {
          if (
            scope.conf.inspectionPartLayerUID == undefined ||
            scope.conf.inspectionLayerUID == undefined ||
            scope.conf.inspectionLinkId == undefined ||
            scope.conf.inspectionPartHeaderLayerUID == undefined ||
            scope.conf.login == undefined ||
            scope.conf.password == undefined
          ) {
            thisAlert($filter('translate')('indigauwidget.badConfig'));
            return false;
          }
          return true;
        }

        function getInspectionPartsByDate() {
          if (!configOk()) return;
          gaDomUtils.showGlobalLoader();

          var inspectPartIds = [];

          //-- ABF: date d'inspection dans le cas de collecteur.
          //-- CBF: date d'inspection dans le cas de chambre
          //--      de ou regard.
          var cql_filter = headersFieldCode + " = 'ABF'";
          cql_filter += ' or ' + headersFieldCode + " = 'CBF'";

          var promise = QueryFactory.data(
            scope.conf.inspectionPartHeaderLayerUID,
            cql_filter
          );
          promise.then(
            function(res2) {
              var dateHeaderFeatures = format.readFeatures(res2.data);

              if (
                dateHeaderFeatures != undefined &&
                dateHeaderFeatures.length > 0
              ) {
                var startDate = new Date(scope.dateStart);

                var endDate = new Date(scope.dateEnd);

                for (var i = 0; i < dateHeaderFeatures.length; i++) {
                  var dateHeaderFeature = dateHeaderFeatures[i];

                  var dateHeaderFeatureProps = dateHeaderFeature.getProperties();

                  var valueDateStr = dateHeaderFeatureProps[headersFieldValue];

                  var valueDate = new Date(valueDateStr);

                  if (valueDate >= startDate && valueDate <= endDate) {
                    var idPart =
                      dateHeaderFeatureProps[
                        scope.conf.inspectionPartHeaderLinkId.name
                      ];

                    if (inspectPartIds.indexOf(idPart) == -1) {
                      inspectPartIds.push(idPart);
                    }
                  }
                }

                var inspectionsPartsFrag = [];

                var inspectPartIdsArray = [];

                for (var i = 0; i < inspectPartIds.length; i++) {
                  var partID = inspectPartIds[i];

                  inspectionsPartsFrag.push(partID);

                  if (inspectionsPartsFrag.length == scope.conf.nbQueryParts) {
                    var arrayClone = inspectionsPartsFrag.slice(0);

                    inspectPartIdsArray.push(arrayClone);

                    inspectionsPartsFrag = [];
                  }
                }

                if (inspectionsPartsFrag.length > 0) {
                  arrayClone = inspectionsPartsFrag.slice(0);

                  inspectPartIdsArray.push(arrayClone);
                }

                for (var j = 0; j < inspectPartIdsArray.length; j++) {
                  var arrayFrags = inspectPartIdsArray[j];

                  getInspectionPartJson(arrayFrags, false);
                }
              }
            },
            function() {
              console.error(
                "Erreur à l'appel de QueryFactory.data(), cql_filter : " +
                  cql_filter
              );

              gaDomUtils.hideGlobalLoader();
            }
          );
        }

        function getInspectionPartJson(inspectPartIds, exportALL) {
          var promises = [];

          var inspectPartHeaders = [];
          var inspectPartDetails = [];

          var cql_filter2;
          if (exportALL) {
            cql_filter2 = '1=1';
          } else {
            cql_filter2 = getIdsCqlFilter(
              scope.conf.inspectionPartHeaderLinkId.name,
              inspectPartIds
            );
          }

          var promise2 = QueryFactory.data(
            scope.conf.inspectionPartHeaderLayerUID,
            cql_filter2
          );
          promise2.then(
            function(res2) {
              inspectPartHeaders = format.readFeatures(res2.data);
            },
            function() {
              console.error(
                "Erreur à l'appel de ogc.data(), cql_filter2 : " + cql_filter2
              );
            }
          );

          promises.push(promise2);

          var promise3 = ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            scope.conf.inspectionPartDetailLayerUID,
            'json',
            srid,
            cql_filter2
          );
          promise3.then(
            function(res3) {
              inspectPartDetails = format.readFeatures(res3.data);
            },
            function() {
              console.error(
                "Erreur à l'appel de ogc.data(), cql_filter2 : " + cql_filter2
              );
            }
          );

          promises.push(promise3);

          totalQueries++;

          $q.all(promises).then(
            function(totalRes) {
              totalResponses++;

              buildIndigauJson(
                inspectPartIds,
                inspectPartHeaders,
                inspectPartDetails
              );

              if (totalResponses >= totalQueries) {
                gaDomUtils.hideGlobalLoader();
              }
            },
            function() {
              console.error("Erreur à l'appel de $q.all().");

              if (totalResponses >= totalQueries) {
                gaDomUtils.hideGlobalLoader();
              }
            }
          );
        }

        function buildIndigauJson(
          inspectPartIds,
          inspectPartHeaders,
          inspectPartDetails
        ) {
          for (var i = 0; i < inspectPartIds.length; i++) {
            var inspectPartId = inspectPartIds[i];

            var headers = getInspectionPartHeaders(
              inspectPartId,
              inspectPartHeaders
            );

            var details = getInspectionPartDetail(
              inspectPartId,
              inspectPartDetails
            );

            var partObject = {
              headers: headers,
              details: details,
            };

            scope.currentPartsJson.objects.push(partObject);
          }
        }

        function getInspectionPartHeaders(inspectPartId, inspectPartHeaders) {
          var headers = [];

          if (
            inspectPartHeaders != undefined &&
            inspectPartHeaders.length > 0
          ) {
            for (var i = 0; i < inspectPartHeaders.length; i++) {
              var inspectPartHeader = inspectPartHeaders[i];

              var inspectPartHeaderProps = inspectPartHeader.getProperties();

              var inspectPartHeaderPartId =
                inspectPartHeaderProps[
                  scope.conf.inspectionPartHeaderLinkId.name
                ];

              if (inspectPartId == inspectPartHeaderPartId) {
                var code = inspectPartHeaderProps[headersFieldCode];

                var value = inspectPartHeaderProps[headersFieldValue];

                var header = {
                  code: code,
                  value: value,
                };

                headers.push(header);
              }
            }
          }

          return headers;
        }

        function getInspectionPartDetail(inspectPartId, inspectPartDetails) {
          var details = [];

          if (
            inspectPartDetails != undefined &&
            inspectPartDetails.length > 0
          ) {
            for (var i = 0; i < inspectPartDetails.length; i++) {
              var inspectPartDetail = inspectPartDetails[i];

              var inspectPartDetailProps = inspectPartDetail.getProperties();

              var inspectPartDetailPartId =
                inspectPartDetailProps[
                  scope.conf.inspectionPartDetailLinkId.name
                ];

              if (inspectPartId == inspectPartDetailPartId) {
                var detail = {};

                for (var j = 0; j < detailFields.length; j++) {
                  var detailField = detailFields[j];

                  var detailFieldValue = inspectPartDetailProps[detailField];

                  detail[detailField] = detailFieldValue;
                }

                details.push(detail);
              }
            }
          }

          return details;
        }

        function getIdsCqlFilter(fieldName, idsArray) {
          var result = '';

          if (idsArray.length > 0) {
            for (var i = 0; i < idsArray.length - 1; i++) {
              var id = idsArray[i];

              result = result + '' + fieldName + " = '" + id + "' OR ";
            }

            var lastId = idsArray[idsArray.length - 1];

            result = result + '' + fieldName + " = '" + lastId + "'";
          }

          return result;
        }

        function getCritereNameById(idCritere) {
          for (var i = 0; i < scope.criteres.length; i++) {
            var loopCritere = scope.criteres[i];

            if (loopCritere.id == idCritere) {
              return loopCritere.nom;
            }
          }

          return undefined;
        }

        function updateCritereResult(id, gValue, canaArray, critereResults) {
          if (id == critereResults.id) {
            if (gValue == 'G') {
              critereResults.G.push(canaArray);
            } else if (gValue == 'G1') {
              critereResults.G1.push(canaArray);
            } else if (gValue == 'G2') {
              critereResults.G2.push(canaArray);
            } else if (gValue == 'G3') {
              critereResults.G3.push(canaArray);
            } else if (gValue == 'G4') {
              critereResults.G4.push(canaArray);
            }
          }
        }

        function openInfoPopup(msg) {
          scope.info.displayMsg = msg;

          if (infoPopup != undefined) {
            infoPopup.close();
          }

          infoPopup = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/indigau/views/indigauInfoPopup.html',
            className: 'ngdialog-theme-plain width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('indigauwidget.info.infoHeader'),
            draggable: true,
          });
        }

        function openResultsPopup() {
          if (resultsPopup != undefined) {
            resultsPopup.close();
          }

          resultsPopup = extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/indigau/views/indigauResultPopup.html',
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('indigauwidget.result.resultHeader'),
            draggable: true,
          });
        }

        scope.$on('openCloseTools_indigauwidget', function(event, arg) {
          if (arg.directive === 'indigauwidget') {
            if (arg.active == false) {
              gclayers.getOperationalLayer().forEach(function(layer) {
                if (scope.conf.canaLayerUID === layer.get('fti').uid) {
                  if (
                    layer.style == 'cana_indigau_choix1' ||
                    layer.style == 'cana_indigau_choix2' ||
                    layer.style == 'cana_indigau_choix3'
                  ) {
                    var canaFti = FeatureTypeFactory.getFeatureByUid(
                      scope.conf.canaLayerUID
                    );

                    layer.style = canaFti.defaultStyle;

                    $rootScope.$broadcast(
                      'gcOperationalLayerChange',
                      '',
                      'applyall'
                    );
                  }
                }
              });
            }
          }
        });

        scope.calscores = function(
          div_retour,
          pagephp,
          div_max,
          pas,
          nomprogressbar,
          avancement,
          loadDialog
        ) {
          IndigauFactory.calscores(
            div_retour,
            pagephp,
            div_max,
            pas,
            nomprogressbar,
            avancement,
            loadDialog
          ).then(function(res) {
            scope.afficheResultat(
              'calculs/anomalies_calcul.php',
              'from_ng=true',
              'retourde_calscores',
              'get'
            );
          });
        };

        scope.afficheResultat = function(
          pPage,
          pParams,
          pDiv,
          pEltsToDisable,
          getOrPost,
          usediv
        ) {
          IndigauFactory.getResCalcul(pPage, pParams, getOrPost).then(function(
            res
          ) {
            if (res.data != '') {
              var elt;
              if (usediv == 'usediv') {
                elt = document.getElementById(pDiv);
                angular.element(elt).empty();
                elt.innerHTML = res.data;
              } else {
                elt = document.getElementById('indigau_calcul');
                var cmp = $compile(res.data)(scope);
                angular.element(elt).append(cmp);
              }
            }
          });
        };

        scope.GetDetailResulttrUrl = function() {
          var elt;
          elt = document.getElementById('selAnomCalcCommunes');
          if (elt != undefined)
            window.open(
              '/indigau/evaluation/calculs/detailresulttr.php?Commune=' +
                elt.value
            );
          else window.open('/indigau/evaluation/calculs/detailresulttr.php');
        };

        function tabSelected(evt, tag) {
          if (scope.tabs.activeTab == 1) {
            IndigauFactory.getCalculPage().then(
              function(res) {
                var elt = document.getElementById('indigau_calcul');
                var cmp = $compile(res.data)(scope);
                angular.element(elt).empty();
                angular.element(elt).append(cmp);
              },
              function(res) {
                $translate('indigauwidget.tabSelectionError').then(function(
                  res
                ) {
                  require('toastr').error(res);
                });
              }
            );
          }
        }

        scope.$watch('tabs.activeTab', tabSelected);
      },
    };
  };

  indigauwidget.$inject = [
    'ConfigFactory',
    '$filter',
    'ngDialog',
    '$translate',
    'FeatureTypeFactory',
    'SelectManager',
    'ogcFactory',
    '$q',
    'QueryFactory',
    'IndigauFactory',
    'extendedNgDialog',
    'gaDomUtils',
    'ngTableParams',
    'EditFactory',
    'gclayers',
    '$rootScope',
    '$compile',
  ];
  return indigauwidget;
});
