'use strict';
define(function() {
  var anIndicator = function(
    ReportIndicatorFactory,
    ngDialog,
    IndicatorParamsFactory,
    gaJsUtils,
    SelectManager,
    FeatureTypeFactory,
    gclayers,
    PortalsFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/dashboard/views/anIndicator.html',
      restrict: 'E',

      scope: {
        indicator: '=indattr', //double bind entre la vue et la donnée
        save: '&'
      }, //scope propre à cette directive

      //methode executée au chargement de la page
      link: function(scope) {
        scope.showparam = false;
        scope.parameters = [];
    
        scope.displayFilters = () => {
          scope.showparam = true;
          
        }
        scope.allPanelHidden = false;
        scope.hideAllPanels = () => {
          scope.allPanelHidden = true;

        };

        scope.totalPageNumber = 0;
        scope.closeCurrentForm = () => {
          ngDialog.close();
        }
        /**
         * Récupére la liste des paramètres de l'indicateur depuis la configuration
         * pour la mettre dans le scope courant.
         * Puis récupère les méta données de l'indicateur ainsi que les valeurs des paramètres
         * @returns {undefined}
         */
        function readIndParamsFromConfig() {
          scope.parameters = scope.indicator.params;

          // si l'indicateur n'a pas d'identifier cela signifie qu'il n'a jamais été généré
          // alors il est impossible d'en récupérer les paramètres
          if (scope.indicator.identifier){

            //Récupération des méta données de l'indicateur ainsi que les valeurs des paramètres
            IndicatorParamsFactory.getIndicatorParametersByName(
                scope.indicator
            ).then(
                function(res) {
                  const resultObject = res.data;
                  const isOk = typeof resultObject === 'object';
                  if (isOk) {
                    //Récupération des méta données de l'indicateur
                    scope.indicator.identifier = resultObject.id;
                    scope.indicator.login = resultObject.login;
                    if (
                        resultObject.datemodificationasstring !== '' &&
                        resultObject.datemodificationasstring !== undefined &&
                        resultObject.datemodificationasstring !== null
                    ) {
                      scope.indicator.date = resultObject.datemodificationasstring;
                    } else {
                      scope.indicator.date = resultObject.datecreationasstring;
                    }
                    scope.totalPageNumber = Number(resultObject.description);

                    //Récupération des valeurs des paramètres de l'indicateur
                    const params = resultObject.data;
                    //Pour chaque paramètre de l'indicateur
                    if (scope.parameters === undefined) scope.parameters = [];
                    for (var i = 0; i < scope.parameters.length; ++i) {
                      //Recherche de la bonne clée dans la liste de résultat des valeurs
                      for (var key in params) {
                        //Si la clé des paramètres resultat correspond au nom du paramètre courant
                        if (scope.parameters[i].name === key && params.hasOwnProperty(key)) {
                          if (
                              scope.parameters[i].type === 'real' ||
                              scope.parameters[i].type === 'int' ||
                              scope.parameters[i].type === 'relativeint'
                          ) {
                            scope.parameters[i].value = Number(params[key]);
                          } else if (scope.parameters[i].type === 'date') {
                            scope.parameters[i].value = Number(params[key]);
                          } else {
                            scope.parameters[i].value = params[key];
                          }
                          break;
                        }
                      }
                    }
                    if (scope.indicator.fileNameGenerated && scope.indicator.fileNameGenerated.length > 0) {
                      if (scope.indicator.format === 'pdf') {
                        scope.thumbSrc =
                            '/services/' +
                            portalid +
                            '/indicator/' +
                            appn +
                            '/thumbnail?jasperFileName=' +
                            scope.indicator.fileNameGenerated;
                      } else {
                        scope.thumbSrc = 'img/widget/indicator/' + scope.indicator.format + '.png';
                      }
                    }
                  } else if (typeof resultObject === 'string') {
                    console.error(
                        'getIndicatorParametersByName result for indicator ' +
                        scope.indicator.id +
                        ': ' +
                        resultObject
                    );
                  } else {
                    console.log(
                        'getIndicatorParametersByName no parameters for indicator: ' +
                        scope.indicator.id
                    );
                  }
                },
                function(reason) {
                  console.log(
                      'getIndicatorParametersByName echec : ' + reason
                  );
                  require('toastr').error(
                      'getIndicatorParametersByName:' + reason
                  );
                }
            );
          }
        }
        readIndParamsFromConfig();

        //fonctionne : scope.thumbSrc = "http://localhost:9090/xgos5/tmp/defaultReport.jpeg";
        /**
         *
         * Chemin vers l'image representant l'aperçu
         */
        var portalid = PortalsFactory.getPortalId();
        var appn = localStorage.getItem('app');

        if (angular.isDefined(scope.indicator.fileNameGenerated)) {
          if (!scope.indicator.format || scope.indicator.format === 'pdf') {
            scope.thumbSrc =
                '/services/' +
                portalid +
                '/indicator/' +
                appn +
                '/thumbnail?jasperFileName=' +
                scope.indicator.fileNameGenerated;
          } else {
            scope.thumbSrc = 'img/widget/indicator/' + scope.indicator.format + '.png';
          }
        } else {
          scope.thumbSrc = 'img/widget/indicator/nothumb.png';
        }

        /**
         * Get an overview (first page) of this indicator's report
         * @returns {undefined}
         */

        scope.getThumbnail = function() {
          if (!scope.indicator.fileNameGenerated) {
            return;
          }
          if (scope.indicator.format === 'pdf') {
            ReportIndicatorFactory.getThumbnail(
                scope.indicator.fileNameGenerated
            ).then(
                function(res) {
                  scope.thumbSrc = res.data;
                },
                function(reason) {
                  require('toastr').error(reason);
                }
            );
          } else {
            scope.thumbSrc = 'img/widget/indicator/' + scope.indicator.format + '.png';
          }
        };
        //Modif FRT pour eviter une parametre de trop
        //scope.getThumbnail();

        scope.iswait = false;

        /**
         *     Construction des chaine liste des layer et liste des style associé
         *  pour url GeServer. On retourne 2chaines qui ressemblent
         *  à l'exemple suivant:
         *    LAYERS: 'PARCELLE_2011%2CSECTION_2011'
         *    STYLES: 'ppp%2CPCI_SECTION_2011'
         */
        function getLayersForGs() {
          var layers = gclayers.getOperationalLayerCollection();
          var map = gaJsUtils.getMap(scope);
          var resolution = map.getView().getResolution();
          var fti;
          var addedLayerSld = '',
            addedLayer = '',
            opacities = '',
            filters = '';

          angular.forEach(layers, function(layer) {
            fti = layer.get('fti');
            if (
              layer.name === 'Edition' ||
              (layer.visible &&
                (layer.getMinResolution() === undefined ||
                  resolution >= layer.getMinResolution()) &&
                (layer.getMaxResolution() === Infinity ||
                  resolution < layer.getMaxResolution()) &&
                (!fti || (fti && addedLayer.indexOf(fti.name) === -1)))
            ) {
              if (addedLayerSld !== '') {
                addedLayerSld += '%2C';
                addedLayer += '%2C';
                opacities += '%2C';
                filters += '%2C';
              }
              addedLayerSld += fti.defaultStyle;
              addedLayer += layer.name;
              opacities += '1';
              filters += '1%3D1';
            }
          });
          return [addedLayer, addedLayerSld, opacities, filters];
        }

        /**
         *    Construction de l'URL permettant d'ateindre le serveur WMS qui retourne la carte.
         */
        function getWmsMapUrl() {
          var ii,
            url0,
            url,
            urlRet = {},
            portal;
          var map = gaJsUtils.getMap(scope);
          var bb = map.getView().calculateExtent();
          var newHh, newWw;

          //-- CARTE KIS
          //yyyyyyyyy bb = getBbFromFeature(chantier);
          //-- Construire l'url'
          ii = location.hash.indexOf('portal=');
          portal = location.hash.substr(ii + 7);
          ii = portal.indexOf('&');
          portal = portal.substr(0, ii);
          url0 = location.origin + '/services/' + portal + '/geoserver';
          url0 += '/wms?token=' + localStorage.auth_token;
          var fac = 440 / 363;
          var hh = bb.ymax - bb.ymin;
          var ww = bb.xmax - bb.xmin;
          var centerx = (bb.xmin + bb.xmax) / 2;
          var centery = (bb.ymin + bb.ymax) / 2;
          if (hh > ww) {
            newWw = (hh * fac) / 2.0;
            bb.xmin = centerx - newWw;
            bb.xmax = centerx + newWw;
          } else {
            newHh = ww / fac / 2.0;
            bb.ymin = centery - newHh;
            bb.ymax = centery + newHh;
          }

          let layersForGs;
          layersForGs = getLayersForGs();
          url0 +=
            '&SERVICE=WMS&VERSION=1.3.0&REQUEST=GetMap&FORMAT=image%2Fpng';
          url0 += '&TRANSPARENT=true&LAYERS=' + layersForGs[0];
          //        '&TRANSPARENT=true&LAYERS=PARCELLE_2011%2CSECTION_2011';
          url0 += '&tiled=false&STYLES=' + layersForGs[1];
          //      url0 += '&tiled=false&STYLES=ppp%2CPCI_SECTION_2011';
          url0 += '&OPACITY=' + layersForGs[2]; //+'&CQL_FILTER='+layersForGs[3];
          //      url0 += '&OPACITY=1%2C1&CQL_FILTER=1%3D1;1%3D1';
          url = url0 + '&type=g2c&t=245&WIDTH=880&HEIGHT=726&CRS=EPSG%3A3857';
          url +=
            '&BBOX=' + bb[0] + '%2C' + bb[1] + '%2C' + bb[2] + '%2C' + bb[3];
          urlRet.plan = url;

          //-- Plan pour prévisualisation zoom proche
          url = url0 + '&type=g2c&t=245&WIDTH=600&HEIGHT=600&CRS=EPSG%3A3857';

          //-- FOND DE PLAN
          //https://magosm.magellium.com/geoserver/ows?service=wms&version=1.3.0&request=GetCapabilities

          url0 = 'https://ows.terrestris.de/osm/service?';
          url0 += 'SERVICE=WMS&VERSION=1.1.0&REQUEST=GetMap&';
          url0 += 'FORMAT=image%2Fpng&TRANSPARENT=true&';
          url0 += 'layers=OSM-WMS&layers=OSM-Overlay-WMS&';
          url0 += 'styles=&styles=&styles=&styles=&';
          url = url0 + 'WIDTH=880&HEIGHT=726&SRS=EPSG%3A3857&';
          url +=
            'BBOX=' + bb[0] + '%2C' + bb[1] + '%2C' + bb[2] + '%2C' + bb[3];
          urlRet.fdplan = url;

          return urlRet;
        }

        function checkReportparams() {
          var iPar,
            urls,
            feats,
            ids = '';

          if (angular.isDefined(scope.parameters)) {
            for (iPar = 0; iPar < scope.parameters.length; iPar++) {
              if (scope.parameters[iPar].type === 'map') {
                if (urls === undefined) urls = getWmsMapUrl();
                scope.parameters[iPar].value = urls.plan;
              } else if (scope.parameters[iPar].type === 'mapbg') {
                if (urls === undefined) urls = getWmsMapUrl();
                scope.parameters[iPar].value = urls.fdplan;
              } else if (scope.parameters[iPar].type === 'idSel') {
                var fti, fid;
                fti = FeatureTypeFactory.getFeatureByUid(
                  scope.parameters[iPar].comp
                );
                feats = SelectManager.getfeatures().features;
                for (let iFeat = 0; iFeat < feats.length; iFeat++) {
                  fid = feats[iFeat].id.split('.');
                  if (fti.name === fid[0]) {
                    if (ids !== '') ids += ',';
                    ids += fid[1];
                  }
                }
                scope.parameters[iPar].value = ids;
              }
            }
          }
        }

        /**
         * Request the report generation with current parameters values.
         * @returns {undefined}
         *
         */
        scope.generateReport = function() {
          checkReportparams();
          const jsonParameters = IndicatorParamsFactory.buildJsonParams(
            scope.parameters
          );
          scope.iswait = true;
          ReportIndicatorFactory.generate(
            scope.indicator.jasperFileName,
            jsonParameters,
            null,
            scope.indicator.format
          ).then(
            (res) => {
              scope.iswait = false;
              const resultObject = res.data;

              scope.totalPageNumber = resultObject.totalPageNumber;
              scope.indicator.totalPages = resultObject.totalPageNumber;
              scope.indicator.fileNameGenerated =
                resultObject.fileNameGenerated;
              scope.getThumbnail();
              scope.save();
              saveIndicatorParameters(scope.indicator, jsonParameters);
              if (scope.indicator.format === 'pdf') {
                scope.thumbSrc =
                    '/services/' +
                    portalid +
                    '/indicator/' +
                    appn +
                    '/thumbnail?jasperFileName=' +
                    scope.indicator.fileNameGenerated;
              } else {
                scope.thumbSrc = 'img/widget/indicator/' + scope.indicator.format + '.png';
              }
              console.log('generateReport result =', resultObject);
              require('toastr').info('Rapport généré !');
            },
            err => {
              scope.iswait = false;
              console.log('generateReport echec : ', err.data.message);
              require('toastr').error(err.data.message);
            }
          );
        };

        /**
         * Save the indicator's parameters
         * @param indicator
         * @param {type} jsonParameters
         */
        function saveIndicatorParameters(indicator, jsonParameters) {
          if (indicator.identifier === undefined) {
            IndicatorParamsFactory.addIndicatorParameters(
              indicator,
              jsonParameters
            ).then(
              (res) => {
                const resultObject = res.data;
                const isOk = typeof resultObject === 'object';
                if (isOk) {
                  indicator.identifier = resultObject.id;
                  indicator.login = resultObject.login;
                  indicator.date = resultObject.datecreationasstring;

                  console.log(
                    'saveIndicatorParameters result =', resultObject
                  );
                  //require('toastr').info('saveIndicatorParameters done !');
                } else {
                  require('toastr').error(
                    'addIndicatorParameters result =', resultObject
                  );
                }
              },
              (reason) => {
                const resultObject = reason.data;
                console.log('saveIndicatorParameters echec : ', resultObject.message);
                require('toastr').error(resultObject.message);
              }
            );
          } else {
            IndicatorParamsFactory.updateIndicatorParameters(
              indicator,
              jsonParameters
            ).then(
              (res) => {
                const resultObject = res.data;
                indicator.login = resultObject.login;
                indicator.date = resultObject.datemodificationasstring;
                console.log('saveIndicatorParameters result =', resultObject);
                //require('toastr').info('saveIndicatorParameters done !');
              },
              (reason) => {
                console.log('saveIndicatorParameters echec : ', reason);
                require('toastr').error(
                  'saveIndicatorParameters:' + reason
                );
              }
            );
          }
        }

        /**
         * Open a popup to consult generated report
         */
        scope.openOverview = function() {
          if (!scope.indicator.format || scope.indicator.format === 'pdf') {
            scope.getPdf();
          } else {
            ReportIndicatorFactory.downloadReport(scope.indicator.fileNameGenerated, scope.indicator.format);
          }
        };

        /**
         * Demande le fichier PDF du rapport généré et ouvre le PDF dans un nouvel onglet du navigateur.
         */
        scope.getPdf = () => {
          ReportIndicatorFactory.getPdf(scope.indicator.fileNameGenerated).then(
              res => {
                const blob = new Blob([res.data], {
                  type: 'application/pdf',
                });
                const objectUrl = URL.createObjectURL(blob);
                window.open(objectUrl);
                //Libération de la mémoire de l'objet URL
                window.URL.revokeObjectURL(objectUrl);
              },
              err => {
                if (err.data && err.data.message) {
                  require('toastr').error(err.data.message);
                }
              }
          );
        };
      },
    };
  };
  anIndicator.$inject = [
    'ReportIndicatorFactory',
    'ngDialog',
    'IndicatorParamsFactory',
    'gaJsUtils',
    'SelectManager',
    'FeatureTypeFactory',
    'gclayers',
    'PortalsFactory',
  ];
  return anIndicator;
});
