'use strict';
define(function() {
  /////////////////////////////////////////
  //
  // COMPOSANT DE CREATION DE FEATURE POINT OU
  // FEATURE LIGNE
  // PAR POINT DE DEPART CLIQUE ET UNE DISTANCE
  //
  //////////////////////////////////////////
  var distancePlacement = function(
    FeatureTypeFactory,
    gclayers,
    ogcFactory,
    GeometryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/bizedition/views/distancePlacement.html',
      restrict: 'E',
      scope: {
        map: '=map',
        type: '@type',
        editdescription: '=editdescription',
        onfinish: '&',
      },
      link: function(scope, elt, attrs, ctrl) {
        var map = scope.map;
        var format = new ol.format.GeoJSON();

        //Feature point de départ
        var startFeature = undefined;
        //Feature linéaire sur lequel placer le point de départ
        var currentLineSelected = undefined;

        //Géométrie du feature point à créer.
        scope.geomPointCreated = undefined;

        //feature point à créer si l'outil est en mode de création de point.
        var featurePointCreated = undefined;

        //feature line à créer si l'outil est en mode de création de ligne (un branchement)
        var featureLineCreated = undefined;

        //Utilisé si  l'outil est en mode de création de ligne
        //Indique si l'angle est par rapport à la conduite ou par rapport au nord
        scope.angleChoice = { value: 'angle' };

        //Utilitaire de visualisation de feature sur la carte.
        function highLightFeature(f) {
          gclayers.addhighLightFeature(f);
        }
        function removehighLightFeature(f) {
          gclayers.removehighLightFeatures(f);
        }

        // Récupération de la liste des layers line correpondantes au theme de l'édition
        function isFeatureLine(ft) {
          return ft.typeInfo == 'LINE';
        }

        //ID des layers éditables à considérer lors de la recherche de linéaire au clic de sélection sur la carte.
        var layersUidList = '';
        //var layers = gclayers.getOperationalLayer().filter(isFeatureLine);
        var layers = FeatureTypeFactory.resources.featuretypes.filter(
          isFeatureLine
        );

        /**
         * Donne l'index 'cuttingIndex' correspondant au premier point de la simpleLine 'lineCoordinates' du segment sur lequel se trouve le point 'intersectionPointCoordinate'.
         * Retourne undefined si le point n'est pas situé sur la simple line.
         * @param {type} lineCoordinates
         * @param {type} intersectionPointCoordinate
         * @returns {Number}cuttingIndex
         */
        function getIndexOnSimpleLine(
          lineCoordinates,
          intersectionPointCoordinate
        ) {
          var cuttingIndex = undefined;

          //Pour chaque segment de la simple line
          for (var i = 0; i < lineCoordinates.length - 1; i++) {
            //Les deux points du segments
            var p1 = lineCoordinates[i];
            var p2 = lineCoordinates[i + 1];

            //Si le point édité est posé sur le premier point du segment ou sur le second point (x et y sont les mêmes à 1cm près)
            if (
              (Math.round(intersectionPointCoordinate[0] * 100) ==
                Math.round(p1[0] * 100) &&
                Math.round(intersectionPointCoordinate[1] * 100) ==
                  Math.round(p1[1] * 100)) ||
              (Math.round(intersectionPointCoordinate[0] * 100) ==
                Math.round(p2[0] * 100) &&
                Math.round(intersectionPointCoordinate[1] * 100) ==
                  Math.round(p2[1] * 100))
            ) {
              cuttingIndex = i;
              break;
            }
            //Si le point édité est posé entre les deux points du segment
            else {
              //Coef directeur de la line
              var coef = (p2[1] - p1[1]) / (p2[0] - p1[0]);
              //Coef directeur de la droite intersectionPointCoordinate et une des extrémité (celle qui ne se superpose pas au point édité)
              var coef2 = NaN;
              coef2 =
                (intersectionPointCoordinate[1] - p1[1]) /
                (intersectionPointCoordinate[0] - p1[0]);
              //Si intersectionPoint appartient à la DROITE line correspondant au segment en cours P1P2
              if (
                Math.abs(Math.round(coef * 100)) ==
                Math.abs(Math.round(coef2 * 100))
              ) {
                //Vérification si intersectionPointCoordinate appartient au SEGMENT P1P2
                if (
                  intersectionPointCoordinate[0] <= Math.max(p1[0], p2[0]) &&
                  intersectionPointCoordinate[0] >= Math.min(p1[0], p2[0]) &&
                  intersectionPointCoordinate[1] <= Math.max(p1[1], p2[1]) &&
                  intersectionPointCoordinate[1] >= Math.min(p1[1], p2[1])
                ) {
                  cuttingIndex = i;
                  break;
                }
              }
            }
          }
          return cuttingIndex;
        }

        //Activation de l'écoute du point de départ cliqué
        scope.start = function() {
          reset();
          map.on('click', onClicSelection); //TODO: deasbonnement à la fermeture de la popup par clic sur la croix de fermeture.
        };

        /**
         * Handler de clic de selection d'un point de départ sur la carte.
         * @param {type} mapBrowserEvent
         * @returns {undefined}
         */
        function onClicSelection(mapBrowserEvent) {
          require('toastr').clear();
          //Réinitialisation de la visualisation
          gclayers.clearhighLightFeatures();

          var selectCoord = mapBrowserEvent.coordinate;
          var leftX = selectCoord[0] - 1;
          var bottomY = selectCoord[1] - 1;
          var rightX = selectCoord[0] + 1;
          var topY = selectCoord[1] + 1;
          var cql_filter =
            'INTERSECTS(geom, POLYGON((' +
            leftX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            bottomY +
            ',' +
            rightX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            topY +
            ',' +
            leftX +
            ' ' +
            bottomY +
            ')))';

          if (layersUidList.length == 0) {
            //Pour chaque nom de layer en config de cette règle
            for (var j = 0; j < layers.length; j++) {
              var fti = layers[j];
              var curTheme = fti.theme;
              if (curTheme == scope.editdescription.theme) {
                layersUidList += fti.uid + ',';
              }
            }
            if (layersUidList.length > 0) {
              layersUidList = layersUidList.substring(
                0,
                layersUidList.length - 1
              );
            } else {
              console.error(
                'La liste des layers linéaires à requeter est vide !'
              );
              return;
            }
          }

          var promise = ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            layersUidList,
            'json',
            map
              .getView()
              .getProjection()
              .getCode(),
            cql_filter
          );
          promise.then(onLineFeatureGotten, function(error) {
            console.error(
              'ogcFactory.getfeatures in distancePointPlacement, error:' + error
            );
            require('toastr').error(error);
          });

          startFeature = new ol.Feature({
            geometry: new ol.geom.Point(selectCoord),
            name: 'startingPoint',
          });

          //Visualisation du point de départ
          highLightFeature(startFeature);
        }

        /**
         * Appelé au résultat de la recherche d'un objet linéaire
         *  situé sous le clic de départ.
         * @param {type} res
         * @returns {undefined}
         */
        function onLineFeatureGotten(res) {
          if (
            res.data.type != undefined &&
            res.data.type == 'FeatureCollection'
          ) {
            //Decodage de la featureCollection, retourne un tableau de ol.feature
            var intersectedFeatures = format.readFeatures(res.data);

            //Si le startPoint intersecte bien un objet linéaire,
            if (intersectedFeatures.length > 0) {
              currentLineSelected = intersectedFeatures[0];
              //Visualisation de la ligne sélectionnée.
              // highLightFeature(currentLineSelected);

              //Calcul des coordonnées de l'objet point à créer.
              calculateTargetFeature();
            }
            //Sinon
            else {
              removehighLightFeature(startFeature);
              require('toastr').warning('Aucun linéaire trouvé.');
            }
          }
        }

        /**
         * Calcule le feature point à créer.
         * @returns {undefined}
         */
        function calculateTargetFeature() {
          gclayers
            .getDrawLayer()
            .getSource()
            .clear(true);

          if (currentLineSelected == undefined) {
            require('toastr').warning(
              'Sélectionnez un point de départ sur un objet linéaire.'
            );
            return;
          }
          if (
            scope.distanceInput == undefined ||
            scope.distanceInput.length == 0
          ) {
            require('toastr').warning('Rentrez une distance.');
            return;
          }

          var geoms = [];
          var lineGeoJson = format.writeGeometryObject(
            currentLineSelected.getGeometry()
          );
          geoms.push(lineGeoJson);
          var startingPointGeoJson = format.writeGeometryObject(
            startFeature.getGeometry()
          );
          geoms.push(startingPointGeoJson);

          var firstPromise = GeometryFactory.getPointAtDistanceOnLine(
            geoms,
            scope.distanceInput
          );
          firstPromise.then(
            function(res) {
              //Le résultat du serveur est toujours un point géométrique
              if (res.data.type != undefined && res.data.type == 'Point') {
                //Récupération de la géométrie du point à créer.
                scope.geomPointCreated = format.readGeometry(res.data);

                //Création de l'objet feature
                if (scope.type == 'point') {
                  createFeaturePoint();
                } else if (scope.type == 'line') {
                  createFeatureLine();
                }
              }
            },
            function(error) {
              console.error(
                'Erreur lors de la requete getPointAtDistanceOnLine'
              );
            }
          );
        }

        /**
         * Instancie et affiche sur la carte le feature point résultat.
         * @returns {undefined}
         */
        function createFeaturePoint() {
          if (scope.geomPointCreated != undefined) {
            featurePointCreated = new ol.Feature({
              name: 'thePoint',
            });
            featurePointCreated.setGeometry(scope.geomPointCreated);

            //Centrage de la carte sur le point créé
            map.getView().setCenter(scope.geomPointCreated.getCoordinates());

            //Visualisation du résultat
            gclayers
              .getDrawLayer()
              .getSource()
              .addFeature(featurePointCreated);
          }
        }

        /**
         * Calcule l'angle (sens trigonometrique) formé entre l'axe x et le segment des deux derniers vertex du tableau de coordinates de la geometrie en cours lors du dernier evenement de souris.
         * @param {type} coordinates
         * @returns {Number}
         */
        function getRadianAngle() {
          var radian = 0;

          var degre = scope.angleInput != undefined ? scope.angleInput : 90;

          radian = degre * (Math.PI / 180);

          return radian;
        }

        /**
         * COnvertis la valeur d'angle de degrè vers radian dans le sens trigonométrique
         *  pour avoir une valeur utilisable pour les calculs.
         * @returns {Number|scope.azimutInput}
         */
        function getRadianAzimut() {
          var radian = 0;

          var degre = scope.azimutInput != undefined ? scope.azimutInput : 90;

          radian = degre * (Math.PI / 180);

          //conversion de l'azimut en angle trigonométrique.
          radian = Math.PI / 2 - radian;

          return radian;
        }

        /**
         * Calcul les coordonnées de l'extremité du branchement à créer.
         */
        function getScdCoordinate() {
          var line = currentLineSelected.getGeometry();

          ////// Recherche des points A et B delimitant le segment de linéaire sur lequel se trouve le premier point du branchement à créer.

          var isSimpleLine = line instanceof ol.geom.LineString;
          var isMultiLine = line instanceof ol.geom.MultiLineString;

          //Index du segment sur lequel se trouve la première coordonnée
          var cuttingIndex = undefined;
          var cuttinglineIndex = undefined;

          //Points du segment courant pour lequel on recherche l'intersection avec le featurePoint
          var pA = undefined;
          var pB = undefined;
          if (isSimpleLine) {
            var lineCoordinates = line.getCoordinates();
            cuttingIndex = getIndexOnSimpleLine(
              lineCoordinates,
              scope.geomPointCreated.getCoordinates()
            );

            if (cuttingIndex == undefined) {
              console.info(
                'getScdCoordinate() Pas de segment trouvé sous le point'
              );
              return;
            }
            pA = lineCoordinates[cuttingIndex];
            pB = lineCoordinates[cuttingIndex + 1];
          } else if (isMultiLine) {
            var simpleLines = line.getCoordinates();
            //Pour chaque simple line de la multiline
            for (
              var lineIndex = 0;
              lineIndex < simpleLines.length;
              lineIndex++
            ) {
              cuttingIndex = getIndexOnSimpleLine(
                simpleLines[lineIndex],
                scope.geomPointCreated.getCoordinates()
              );
              //Si l'index du segement de la simple line a été trouvé
              if (cuttingIndex != undefined) {
                //mémorisation de l'index de la simple line
                cuttinglineIndex = lineIndex;
                break;
              }
            }
            if (cuttingIndex == undefined) {
              console.info(
                'getScdCoordinate() Pas de segment trouvé sous le point'
              );
              return;
            }
            var simpleLine = simpleLines[cuttinglineIndex];
            pA = simpleLine[cuttingIndex];
            pB = simpleLine[cuttingIndex + 1];
          }

          if (pA == undefined || pB == undefined) {
            console.info(
              "distancePlacement: segement sous le premier point du branchement, n'a pas été touvé !"
            );
            return;
          }

          ///// Calcul des coordonnées du second point du branchement à créer.

          //Distance du début du segment jusqu'au premier point du branchement
          var dist = new ol.geom.LineString([
            pA,
            scope.geomPointCreated.getCoordinates(),
          ]).getLength();

          //Longueur du segment pApB sur lequel se trouve le premier point du branchement
          var segmentD = new ol.geom.LineString([pA, pB]).getLength();

          //Longueur du branchement à créer
          var lb = scope.lengthInput;

          var scdCoordX = undefined;
          var scdCoordY = undefined;

          if (scope.angleChoice.value == 'azimut') {
            var azimutRadian = getRadianAzimut();
            scdCoordX =
              scope.geomPointCreated.getCoordinates()[0] +
              lb * Math.cos(azimutRadian);
            scdCoordY =
              scope.geomPointCreated.getCoordinates()[1] +
              lb * Math.sin(azimutRadian);
          } else if (scope.angleChoice.value == 'angle') {
            var angleBranchement = getRadianAngle();

            scdCoordX =
              pA[0] +
              (dist - lb * Math.cos(angleBranchement)) *
                ((pB[0] - pA[0]) / segmentD) -
              lb * Math.sin(angleBranchement) * ((pB[1] - pA[1]) / segmentD);

            scdCoordY =
              pA[1] +
              lb * Math.sin(angleBranchement) * ((pB[0] - pA[0]) / segmentD) +
              (dist - lb * Math.cos(angleBranchement)) *
                ((pB[1] - pA[1]) / segmentD);
          }

          return [scdCoordX, scdCoordY];
        }

        /**
         * Crée l'objet Feature correpondant au branchement.
         * @returns {undefined}
         */
        function createFeatureLine() {
          if (scope.geomPointCreated != undefined) {
            featureLineCreated = new ol.Feature({
              name: 'theLine',
            });

            //Coordonnées du branchement
            var coordinates = [];
            //Première coordonnée
            coordinates.push(scope.geomPointCreated.getCoordinates());
            //Calcul de l'autre extrémité du branchement

            var sndCoordinate = getScdCoordinate();
            coordinates.push(sndCoordinate);

            var branchementGeom = new ol.geom.LineString(coordinates);
            featureLineCreated.setGeometry(branchementGeom);

            //Centrage de la carte sur le point créé
            map.getView().setCenter(scope.geomPointCreated.getCoordinates());

            //Visualisation du résultat
            gclayers
              .getDrawLayer()
              .getSource()
              .addFeature(featureLineCreated);
          }
        }

        //Handler de la demande de visualisation du feature point à créer.
        scope.seeFeature = function() {
          calculateTargetFeature();
        };

        /**
         * Valide et transmet le feature point calculé
         * au composant de création d'objet du widget d'édition.
         * @returns {undefined}
         */
        scope.validateFeature = function() {
          //Si la geométrie de l'objet à céer est nulle
          if (scope.type == 'point') {
            if (featurePointCreated == undefined) {
              calculateTargetFeature();
              return;
            } else {
              //Enregistrement du feature
              scope.editdescription.editedfeature = featurePointCreated;
            }
          } else if (scope.type == 'line') {
            if (featureLineCreated == undefined) {
              calculateTargetFeature();
              return;
            } else {
              //Enregistrement du feature
              scope.editdescription.editedfeature = featureLineCreated;
            }
          }

          gclayers.clearhighLightFeatures();

          //Si mode d'édition normal (non rapide)
          if (!scope.editdescription.fastMode) {
            map.un('click', onClicSelection);
          }
          //Appel de la méthode de fin du composant de création
          scope.onfinish();
        };

        /**
         * Initialise l'outil.
         * @returns {undefined}
         */
        function reset() {
          gclayers.clearhighLightFeatures();

          if (featurePointCreated != undefined) {
            gclayers
              .getDrawLayer()
              .getSource()
              .clear(true);
            featurePointCreated = undefined;
          }
        }

        //Handler de fermeture du present outil.
        scope.onPopupClose = function(e) {
          map.un('click', onClicSelection);
        };
      },
    };
  };

  distancePlacement.$inject = [
    'FeatureTypeFactory',
    'gclayers',
    'ogcFactory',
    'GeometryFactory',
  ];

  return distancePlacement;
});
