'use strict';
define(function() {
  var mapStandarisation = function(
    HpoCarteAppFactory,
    HpoDataVisServices,
    FeatureTypeFactory,
    gaDomUtils,
    $q,
    $rootScope,
    gcMapUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/data/mapStandarisation.html',
      restrict: 'EA',
      link: function(scope) {
        
        let directiveFunction = () => {
          var cfg = HpoCarteAppFactory.getInitProvider().getHpoConfig();
          let defined = false;
          scope.baseMap = cfg.baseMap?cfg.baseMap:'toner-lite';
          scope.portalid = $rootScope.xgos.portal.uid;
          let ftiStat;
          let ftiStatdefail;
          if(scope.objStandardisation){
            defined = true;
            scope.components = {
              uidJeu: HpoCarteAppFactory.getAppFactory().getFeatureTypes(
                'jeu_de_donnee'
              )[0].uid,
              identifiantJeuDonnee: scope.objStandardisation.properties.SELECTED_JEU,
              composant: scope.objStandardisation.properties.COMPOSANT,
              cfg: cfg,
              s3: true,
              type:'standardisation'
            };
            ftiStat
              = FeatureTypeFactory.getFeatureByName(scope.objStandardisation.properties.COMPOSANT);
            ftiStat.visible = true;
            let resource = HpoCarteAppFactory.getAppFactory().getResourceFromUidCana(ftiStat.uid);
            ftiStatdefail = FeatureTypeFactory.getFeatureByUid(resource.defail_uid);
            ftiStatdefail.visible = true;
          }
          else if( cfg.ftiStatuid || cfg.ftiStatdefailuid){
            defined = true;
            scope.components = {
              canalisation: cfg.ftiStatuid,
              defailcanalisation: cfg.ftiStatdefailuid,
              cfg: cfg,
              s3: false
            };
          }
          if (defined){

            let promises = [];
            gaDomUtils.showGlobalLoader();
            if(scope.objStandardisation){
              let promiseGetGeometryFromS3
                = HpoDataVisServices.getGeometryFromS3(scope.components,false).then((res)=>{
                  if (res.data.HTML_MAP_URL) {
                  // -- Une URL de page HTML de carte est fournie
                    scope.loadingIframe = true;
                    scope.mapUrl = res.data.HTML_MAP_URL;
                  }
                  else {
                    let geometriesCana = [];
                    let geometriesdefail = [];
                    let geometriesCanaAbandonDa = [];
                    let layers = [];
                    let source;
                    if(!scope.baseMap || scope.baseMap === 'osm'){
                      source = new ol.source.OSM();
                    }
                    else {
                      source = new ol.source.XYZ({
                        url:'http://{1-4}.basemaps.cartocdn.com/'+scope.baseMap+'/{z}/{x}/{y}.png',
                      });
                    }
                    layers.push(new ol.layer.Tile({
                      source: source,
                    }));
                    res.data.geometryCanalisation.geometry.forEach(function(g) {
                      let feature = gcMapUtils.toGeometry(g);
                      if (feature) geometriesCana.push(feature);
                    });
                    res.data.geometrydefail.geometry.forEach(function(g) {
                      let feature = gcMapUtils.toGeometry(g);
                      if (feature) geometriesdefail.push(feature);
                    });
                    scope.canalisationAbandonDaExist = false;
                    if(res.data.geometryCanalisationAbandonDa
                    && Array.isArray(res.data.geometryCanalisationAbandonDa.geometry) &&
                   res.data.geometryCanalisationAbandonDa.geometry.length>0){
                      res.data.geometryCanalisationAbandonDa.geometry.forEach(function(g) {
                        let feature = gcMapUtils.toGeometry(g);
                        if (feature) geometriesCanaAbandonDa.push(feature);
                      });
                      scope.canalisationAbandonDaExist = true;
                      let ftiAbandon = angular.copy(scope.previewftis[0]);
                      ftiAbandon.visible = true;
                      scope.previewftis.push(ftiAbandon);
                    }
                    let vectorCana = new ol.layer.Vector({
                      source: new ol.source.Vector({
                        features: geometriesCana
                      }),
                      style: new ol.style.Style({
                        stroke: new ol.style.Stroke({color: '#0000ff', width: 1})
                      })
                    });
                    layers.push(vectorCana);
                    let vectorDefail = new ol.layer.Vector({
                      source: new ol.source.Vector({
                        features: geometriesdefail
                      }),
                      style: new ol.style.Style({
                        image: new ol.style.Icon({
                          src: 'img/hpo/redsquare.png',
                          scale: 0.6,
                        })
                      })
                    });
                    layers.push(vectorDefail);
                    let vectorCanaAbandonDa = undefined;
                    if(scope.canalisationAbandonDaExist){
                      vectorCanaAbandonDa = new ol.layer.Vector({
                        source: new ol.source.Vector({
                          features: geometriesCanaAbandonDa
                        }),
                        style: new ol.style.Style({
                          stroke: new ol.style.Stroke({
                            color: '#FF0000',
                            width: 1,
                            lineDash: [4, 8]
                          })
                        })
                      });
                      layers.push(vectorCanaAbandonDa);
                    }
                    let geometriesAll
                      = [...geometriesCana,...geometriesdefail, ...geometriesCanaAbandonDa];

                    var vectorAll = new ol.layer.Vector({
                      source: new ol.source.Vector({
                        features: geometriesAll
                      })
                    });

                    let extent= geometriesAll.length>0?vectorAll.getSource().getExtent():[0,0,0,0];

                    var map = new ol.Map({
                      layers: layers,
                      interactions: ol.interaction.defaults({mouseWheelZoom: false})
                        .extend([gcMapUtils.altZoomInteraction()]),
                      target: 'standardisationMap',
                      view: new ol.View({
                        projection: res.data.srid,
                        center: ol.extent.getCenter(extent),
                        zoom: 13,
                      }),
                      ol3Logo: false,
                    });
                    map.getView().fit(extent,map.getSize());
                    scope.addRemoveLayer=  (position,visible) =>{
                      if(visible){
                        map.addLayer(
                          position===0?vectorCana:(position===1?vectorDefail:vectorCanaAbandonDa));
                      }
                      else {
                        map.removeLayer(
                          position===0?vectorCana:(position===1?vectorDefail:vectorCanaAbandonDa));
                      }
                    };
                    scope.standardisationMap = true;
                  }
                });
              promises.push(promiseGetGeometryFromS3);
            }
            $q.all(promises).then(()=>{
              gaDomUtils.hideGlobalLoader();
            }, () =>{
              gaDomUtils.hideGlobalLoader();
            });
            scope.layerVisibility = (position) => {
              let layer = scope.previewftis[position];
              layer.visible = !layer.visible;
              if(scope.objStandardisation){
                scope.addRemoveLayer(position,layer.visible);
              }
              else{
                $rootScope.$broadcast('changeLayerVisibility',layer);
              }
            };
          }
        };
        directiveFunction();
        // on reload la fonction quand on change la langue en locale
        $rootScope.$on('localeChanged', () => {
          directiveFunction();
        });
      },
    };
  };

  mapStandarisation.$inject = [
    'HpoCarteAppFactory',
    'HpoDataVisServices',
    'FeatureTypeFactory',
    'gaDomUtils',
    '$q',
    '$rootScope',
    'gcMapUtils',
  ];
  return mapStandarisation;
});
