'use strict';
define(() => {
  var dashboardHpoFeedback = (
    HpoCarteAppFactory,
    HpoDataVisServices,
    FeatureTypeFactory,
    HpoAppServices,
    gaDomUtils,
    $q,
    $rootScope,
    $filter,
    gcMapUtils
  ) => {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/data/dashboard_hpo_feedback.html',
      restrict: 'EA',
      link: (scope) => {
        scope.downloadfeedback = () => {
          HpoAppServices.downloadfeedback(scope.objStandardisation.properties.SELECTED_JEU);
        }
        var cfg = HpoCarteAppFactory.getInitProvider().getHpoConfig();
        scope.baseMap = cfg.baseMap?cfg.baseMap:'toner-lite';
        let ftiStat;
        let ftiStatdefail;
        scope.portalid = $rootScope.xgos.portal.uid;
        scope.components = {
          uidJeu: HpoCarteAppFactory.getAppFactory().getFeatureTypes(
            'jeu_de_donnee'
          )[0].uid,
          identifiantJeuDonnee: scope.objStandardisation.properties.SELECTED_JEU,
          composant: scope.objStandardisation.properties.COMPOSANT,
          cfg: cfg,
          s3: true,
          type:'standardisationFeedBack'
        };
        ftiStat = FeatureTypeFactory.getFeatureByName(scope.objStandardisation.properties.COMPOSANT);
        ftiStat.visible = true;
        let resource = HpoCarteAppFactory.getAppFactory().getResourceFromUidCana(ftiStat.uid)
        ftiStatdefail = FeatureTypeFactory.getFeatureByUid(resource.defail_uid);
        ftiStatdefail.visible = true;
        scope.previewftis = [ftiStat, ftiStatdefail];
        const colors = ['#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
        '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
        '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
        '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
        '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
        '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
        '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
        '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
        '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
        '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8']
        let promises = [];
        gaDomUtils.showGlobalLoader();
          let promiseGetGeometryFromS3= HpoDataVisServices.getGeometryFromS3(scope.components,true).then((res)=>{
            let geometriesCana = [];
            let geometriesCanaAbandonDa = [];
            let geometriesdefail = [];
            let layers = [];
            let source;
            scope.layersDefiniton = [];
            if(!scope.baseMap || scope.baseMap === 'osm'){
              source = new ol.source.OSM();
            } else {
              source = new ol.source.XYZ({ 
                url:'http://{1-4}.basemaps.cartocdn.com/'+scope.baseMap+'/{z}/{x}/{y}.png',
              })
            }
            layers.push(new ol.layer.Tile({
              source: source,
            }));
            res.data.geometryCanalisation.geometry.forEach((g) => {
              let feature = gcMapUtils.toGeometry(g)
              if (feature) geometriesCana.push(feature);
            });
            res.data.geometrydefail.geometry.forEach((g) => {
              let feature = gcMapUtils.toGeometry(g)
              if (feature) geometriesdefail.push(feature);
            });
            let vectorCana = new ol.layer.Vector({
              source: new ol.source.Vector({
                  features: geometriesCana
              }),
              style: new ol.style.Style({
                stroke: new ol.style.Stroke({color: '#0000ff', width: 1})
              })
            });
            layers.push(vectorCana);
            scope.layersDefiniton.push({
              "name": $filter('translate')("hpo.admin.dashBoardFeedBack.canalisation.label"),
              "description": $filter('translate')("hpo.admin.dashBoardFeedBack.canalisation.description"),
              "visible": true,
              "point":false,
              "color": "#0000ff",
              "count": res.data.geometryCanalisation.count,
              "length": res.data.geometryCanalisation.length,
              "vector":vectorCana
            });
            if(res.data.geometryCanalisationAbandonDa && Array.isArray(res.data.geometryCanalisationAbandonDa.geometry) && 
                    res.data.geometryCanalisationAbandonDa.geometry.length>0){
              res.data.geometryCanalisationAbandonDa.geometry.forEach((g) => {
                let feature = gcMapUtils.toGeometry(g)
                if (feature) geometriesCanaAbandonDa.push(feature);
              });
              let vectorCanaAbandonDa = new ol.layer.Vector({
                source: new ol.source.Vector({
                    features: geometriesCanaAbandonDa
                }),
                style: new ol.style.Style({
                  stroke: new ol.style.Stroke({
                      color: '#FF0000',
                      width: 1,
                      lineDash: [4, 8]
                  })
                })
              });
              layers.push(vectorCanaAbandonDa);
              scope.layersDefiniton.push({
                "name": $filter('translate')("hpo.admin.dashBoardFeedBack.canalisationAbandonDa.label"),
                "description": $filter('translate')("hpo.admin.dashBoardFeedBack.canalisationAbandonDa.description"),
                "visible": true,
                "point":false,
                "color": "#FF0000",
                "count": res.data.geometryCanalisationAbandonDa.count,
                "length": res.data.geometryCanalisationAbandonDa.length,
                "vector":vectorCanaAbandonDa})
            }
            let vectorDefail = new ol.layer.Vector({
              source: new ol.source.Vector({
                  features: geometriesdefail
              }),
              style: new ol.style.Style({
                image: new ol.style.Circle({
                  radius: 4,
                  fill: new ol.style.Fill({
                      color: '#ff0000'
                  }),
                })
              })
            });
            layers.push(vectorDefail);
            scope.layersDefiniton.push({
              "name": $filter('translate')("hpo.admin.dashBoardFeedBack.defail.label"),
              "description": $filter('translate')("hpo.admin.dashBoardFeedBack.defail.description"),
              "visible": true,
              "point":true,
              "color": "#ff0000",
              "count": res.data.geometrydefail.count,
              "length": "",
              "vector":vectorDefail})
            let count = 0;
            let geometriesAll= [...geometriesCana,...geometriesdefail];
            Object.keys(res.data).forEach(key => {
              if(!["srid","geometryCanalisation", "geometryCanalisationAbandonDa", "geometrydefail","sankey", "HTML_MAP_URL"].includes(key)){
                let geometryTemp = generateGeometry(res.data, key, layers, count, scope.layersDefiniton, true);
                geometriesAll = [...geometryTemp, ...geometriesAll];
                count++;
              }
            });
            let vectorAll = new ol.layer.Vector({
              source: new ol.source.Vector({
                  features: geometriesAll
              })
            });
            let extent = geometriesAll.length>0?vectorAll.getSource().getExtent():[0,0,0,0];
            var map = new ol.Map({
              layers: layers,
              interactions: ol.interaction.defaults({mouseWheelZoom: false}).extend([gcMapUtils.altZoomInteraction()]),
              target: 'standardisationMap',
              view: new ol.View({
                projection: res.data.srid,
                center: ol.extent.getCenter(extent),
                zoom: 13,
              }),
              ol3Logo: false,
            });
            map.getView().fit(extent,map.getSize());
            scope.addRemoveLayer =  (layer) =>{
              if(layer.visible){
                map.addLayer(layer.vector);
              } else {
                map.removeLayer(layer.vector);
              }
            }
            scope.standardisationMap = true;

            scope.sankey = {};

            if(res.data.sankey){
              Object.keys(res.data.sankey).forEach((type) => {
                if(res.data.sankey[type]){
                  let matAfterI = res.data.sankey[type];
                  let matAfterIKey = Object.keys(matAfterI).sort((a,b)=> a-b);
                  let label = angular.copy(matAfterIKey);
                  let color = [];
                  let source= [];
                  let target= [];
                  let value=  [];
                  let i=0;
                  while(i<label.length){
                    color.push(colors[i]);
                    i++;
                  }
                  matAfterIKey.forEach(matSource => {
                    let targetKeys = Object.keys(matAfterI[matSource]);
                    targetKeys.forEach(matTarget=>{
                      if(label.lastIndexOf(matTarget)<matAfterIKey.length){
                        label.push(matTarget);
                        let index = label.indexOf(matTarget);
                        if(index === -1){
                          color.push(colors[i]);
                          i++;
                        } else {
                          color.push(colors[index]);
                        }
                      }
                      source.push(label.indexOf(matSource));
                      target.push(label.lastIndexOf(matTarget));
                      value.push(matAfterI[matSource][matTarget]);
                    })
                  });
                  var data = {
                    type: "sankey",
                    orientation: "h",
                    node: {
                      pad: 15,
                      thickness: 30,
                      line: {
                        color: "black",
                        width: 1
                      },
                      label: label,
                      color: color
                    },
                    link: {
                      source: source,
                      target: target,
                      value:  value
                    }
                  }
                  
                  var data = [data];
                  let height = Object.keys(matAfterI).length *20;
                  
                  var layout = {
                    height: height>35000?35000:(height<400?400:height),
                    title: $filter('translate')("hpo.admin.dashBoardFeedBack.sankey_"+type),
                    font: {
                      size: 10
                    }
                  }

                  scope.sankey['sankey_'+type] = true;
                  
                  Plotly.newPlot('sankey_'+type, data, layout)
                  
                }
              });
            }
          });
          promises.push(promiseGetGeometryFromS3);
          $q.all(promises).then(()=>{
            gaDomUtils.hideGlobalLoader();
          }, () =>{
            gaDomUtils.hideGlobalLoader();
          });
          scope.layerVisibility = (position) => {
            let layer = scope.layersDefiniton[position];
            layer.visible = !layer.visible;
            scope.addRemoveLayer(layer);
          }


          let generateGeometry = (features, name, layers, count, layersDefiniton, visible) => {
            let geometryTemp = [];
            let type = features[name].geometry[0].geometry.type;
            let style;
            let color = colors[count];
            style = generateStyle(type, style, color);
            features[name].geometry.forEach((g) => {
              let feature = gcMapUtils.toGeometry(g);
              if (feature)
                geometryTemp.push(feature);
              type = g.geometry.type;
              if(g.colour){
                style = generateStyle(type, style, g.colour);
                color = g.colour;
              }
              feature.setStyle(style);
            });
            let vectorTemp = new ol.layer.Vector({
              source: new ol.source.Vector({
                features: geometryTemp
              })
            });
            let nameLabel = $filter('translate')("hpo.admin.dashBoardFeedBack."+name+".label");
            let descriptionLabel = $filter('translate')("hpo.admin.dashBoardFeedBack."+name+".description");
            layersDefiniton.push({
              "name": nameLabel.startsWith("hpo.admin.dashBoardFeedBack")?name:nameLabel,
              "description": descriptionLabel.startsWith("hpo.admin.dashBoardFeedBack")?name:descriptionLabel,
              "visible": visible,
              "point": type === 'Point' || type === 'MultiPoint',
              "color": color,
              "count": features[name].count,
              "length": features[name].length === 0 ? "" : features[name].length,
              "vector": vectorTemp
            });
            if(visible){
              layers.push(vectorTemp);
            }
            return geometryTemp;
          }
      },
    };
  };

  dashboardHpoFeedback.$inject = [
    'HpoCarteAppFactory',
    'HpoDataVisServices',
    'FeatureTypeFactory',
    'HpoAppServices',
    'gaDomUtils',
    '$q',
    '$rootScope',
    '$filter',
    'gcMapUtils'
  ];
  return dashboardHpoFeedback;
});
function generateStyle(type, style, color) {
  if (type === 'Point' || type === 'MultiPoint') {
    style = new ol.style.Style({
      image: new ol.style.Circle({
        radius: 3,
        fill: new ol.style.Fill({
          color: color
        }),
      }),
    });
  } else if (type === 'Line' || type === 'MultiLine' ||
    type === 'LineString' || type === 'MultiLineString') {
    style = new ol.style.Style({
      stroke: new ol.style.Stroke({ color: color, width: 1 })
    });
  } else {
    style = new ol.style.Style({
      stroke: new ol.style.Stroke({ color: color}),
      fill: new ol.style.Fill({
        color: color
      })
    });
  }
  return style;
}

