'use strict';
define(function() {
  var multicritereCorrespondanceConfig = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppServices,
    ngProgressFactory,
    $location,
    InitProvider,
    $interval,
    HpoMulticritereServices,
    HpoAppModelServices,
    chartFactory,
    StyleFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/analye_multicritere/views/directives/multicritere_correspondance_config.html',
      restrict: 'EA',
      scope: {
        withDatatable: '=?',
        res: '=?',
        confirm: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        /**
         * Module Config
         * @type {[type]}
         */
        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoCorrespondanceCritereaConfig';

        /**
         * Conf widgets
         * @type {[type]}
         */
        scope.tabs = [
          {
            title: 'hpo.multicritere.correspondance.informations',
          },
        ];
        if (scope.withDatatable)
          scope.tabs.push({
            title: 'hpo.multicritere.correspondance.historic',
          });
        scope.tabs.activeTab = 0;
        scope.loading = false;

        /**
         * Supplements
         * @type {Boolean}
         */
        scope.hasFti = true;
        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;
        /**
         * Get required ftis
         * @type {Array}
         */
        scope.fti_correspondance = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'correspondance'
        )[0];
        scope.fti_correspondanceattributes = scope.fti_correspondance.attributes.filter(
          function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                scope.fti_correspondance.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(scope.fti_correspondance.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  scope.fti_correspondance.name
                ))
            )
              return x;
          }
        );
        var fti_correspondance_item = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'correspondance_items'
        )[0];
        var fti_ponderation = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'ponderation'
        )[0];
        var fti_indicateur = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'indicateur'
        )[0];
        var fti_parametrage = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'parameters'
        )[0];
        var fti_criterea = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'critereas'
        )[0];
        var fticalage = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'calage'
        )[0];
        scope.ftiprevision = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'prevision'
        )[0];
        var ftijeudonnee = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'jeu_de_donnee'
        )[0];
        var ftimodele = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'modal_historic'
        )[0];
        scope.ftiCompare = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'compare'
        )[0];
        scope.ftiChantiers = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'chantiers'
        )[0];
        scope.ftiCompareattributes = scope.ftiCompare.attributes.filter(
          function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                scope.ftiCompare.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(scope.ftiCompare.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  scope.ftiCompare.name
                ))
            )
              return x;
          }
        );
        scope.ftis = HpoCarteAppFactory.getAppFactory().getMulticritereFtis();

        /**
         * Init object
         * @type {Object}
         */
        scope.emptyParameter = function(btn) {
          if (btn) {
            var callback = function(isconfirm) {
              if (isconfirm) {
                scope.currentParameter = scope.res || {
                  ponderation: undefined,
                  result: undefined,
                  seuil: 'lineaire',
                  date: HpoCarteAppFactory.getAppFactory().formatDate(
                    new Date()
                  ),
                  save: true,
                  calcul: 'sum',
                };
                if (scope.currentParameter.featid) {
                  var idx = scope.ftis
                    .map(function(x) {
                      return x.uid;
                    })
                    .indexOf(scope.currentParameter.featid);
                  if (~idx) scope.currentParameter.fti = scope.ftis[idx];
                }
                try {
                  scope.$apply();
                } catch(err) {}
              }
            };
            var message =
              $filter('translate')('hpo.multicritere.parameters.empty') +
              '. ' +
              $filter('translate')('hpo.common.sur');
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              message,
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          } else {
            scope.currentParameter = scope.res || {
              ponderation: undefined,
              result: undefined,
              seuil: 'lineaire',
              date: HpoCarteAppFactory.getAppFactory().formatDate(new Date()),
              save: true,
              calcul: 'sum',
            };
            if (scope.currentParameter.featid) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(scope.currentParameter.featid);
              if (~idx) scope.currentParameter.fti = scope.ftis[idx];
            }
          }
        };
        scope.getAvailableData = function(featuid, fti, data, newscope, type) {
          var filter = '"FEATID" = \'' + fti.uid + "'";
          var promise = QueryFactory.data(
            featuid,
            filter,
            HpoCarteAppFactory.getAppFactory().getSrid(),
            '',
            '',
            ''
          );
          promise.then(
            function(res) {
              if (res && res.data) {
                if (newscope)
                  newscope[data] = res.data.features.map(function(x) {
                    return {
                      type: type,
                      data: x,
                      alias: x.properties.NAME,
                    };
                  });
                else
                  scope[data] = res.data.features.map(function(x) {
                    return {
                      type: type,
                      data: x,
                      alias: x.properties.NAME,
                    };
                  });
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
            }
          );
          return promise;
        };
        scope.AvailableUnexpectedValue = function(valuefti){
          delete scope.unexpectedValue;
          if(scope.createdFtids.length>0 && scope.createdFtids.indexOf(valuefti.uid) == -1){
            HpoMulticritereServices.getParameters(scope.fti_correspondance.uid).then(function(res) {
              if (res && res.data && res.data.length>0) {
                HpoMulticritereServices.getCorrespondance(scope.fti_correspondance.uid,res.data[0].id).then(function(result) {
                   if (result && result.data){
                    var configUnexpected = result.data.config.filter((conf) => conf.name == "hpo.multicritere.correspondance.unexpected")[0];
                    scope.unexpectedValue = configUnexpected.data;
                    initPonderation();
                   }else{
                    initPonderation();
                   }
                });
              }else{
                initPonderation();
              }
            });
          }else{
            initPonderation();
          }
        }
        var initPonderation = function() {
          var promise = QueryFactory.dataattributeCorrectedDate(
            fti_correspondance_item.uid,
            'LABEL',
            '1=1'
          );
          promise.then(
            function(res) {
              if (res && res.data) {
                scope.availablePonderations = res.data.map(function(x) {
                  var obj;
                  if(x == "hpo.multicritere.correspondance.unexpected"){
                    if(scope.unexpectedValue == 0 || scope.unexpectedValue){
                      obj = {
                        label: x,
                        percentage : scope.unexpectedValue,
                      }
                    }else{
                      obj = {
                        label: x,
                      }
                    }
                  }else{
                    obj = {
                    label: x,
                    mapping: undefined,
                    selectComponent: true,
                    selectedItems: {},
                    };
                  }
                  if (
                    scope.currentParameter &&
                    scope.currentParameter.config &&
                    scope.availableCritereas &&
                    scope.availableIndicateur &&
                    scope.currentParameter.fti
                  ) {
                    for (
                      var i = 0;
                      i < scope.currentParameter.config.length;
                      i++
                    ) {
                      var conf = scope.currentParameter.config[i];
                      if (conf.name === x) {
                        switch (conf.type) {
                          case 'attribute':
                            var idx = scope.availableAttributes
                              .map(function(x) {
                                return x.data.name;
                              })
                              .indexOf(conf.data);
                            if (~idx) {
                              obj.mapping = scope.availableAttributes[idx];
                            }
                            obj.calcul = conf.calcul;
                            break;
                          case 'criterea':
                            var idx = scope.availableCritereas
                              .map(function(x) {
                                return x.data.properties.IDENTIFIANT;
                              })
                              .indexOf(conf.data);
                            if (~idx) {
                              obj.mapping = scope.availableCritereas[idx];
                            }
                            obj.calcul = conf.calcul;
                            break;
                          case 'indicateur':
                            var idx = scope.availableIndicateur
                              .map(function(x) {
                                return x.data.properties.IDENTIFIANT;
                              })
                              .indexOf(conf.data);
                            if (~idx) {
                              obj.mapping = scope.availableIndicateur[idx];
                            }
                            obj.calcul = conf.calcul;
                            break;
                          case 'moyenne':
                            obj.selectComponent = false;
                            conf.data.split(',').map(function(x) {
                              obj.selectedItems[x] = {
                                selected: true,
                              };
                            });
                            break;
                          case 'percentage':
                            obj.percentage = conf.data;
                            break;
                        }
                        break;
                      }
                    }
                  }
                  return obj;
                });
                scope.itemsNames = res.data;
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
            }
          );
          return promise;
        };

        scope.postRemove = function() {
          QueryFactory.dataattributeCorrectedDate(
            scope.fti_correspondance.uid,
            'FEATID',
            '1=1'
          ).then(
            function(res) {
              if (res && res.data) {
                scope.createdFtids = res.data;
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };
        scope.postRemove();

        var updateConfig = function(newval) {
          var attributesAuthorised = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
            newval
          );
          scope.availableAttributes = attributesAuthorised.map(function(x) {
            return {
              type: 'attribute',
              data: x,
              alias: x.alias,
            };
          });
          return $q.all([
            scope.getAvailableData(
              fti_indicateur.uid,
              newval,
              'availableIndicateur',
              undefined,
              'indicateur'
            ),
            scope.getAvailableData(
              fti_criterea.uid,
              newval,
              'availableCritereas',
              undefined,
              'criterea'
            ),
          ]);
        };

        scope.$watch('currentParameter.fti', function(newval, oldval) {
          if (newval) {
            updateConfig(newval).then(function() {
              scope.AvailableUnexpectedValue(newval);
            });
          } else {
            scope.availableIndicateur = [];
            scope.availableCritereas = [];
            scope.availableAttributes = [];
            initPonderation();
            scope.postRemove();
          }
        });

        scope.createdFtids = [];
        scope.emptyParameter(false);
        scope.availablePonderations = [];
        scope.availableIndicateurs = [];
        initPonderation();

        /**
         * Selection
         * @type {Array}
         */
        scope.selectOrdeAll = function(bool, availabledata, data) {
          if (bool) {
            availabledata.map(function(x) {
              scope.currentParameter[data][x.properties.IDENTIFIANT] = true;
            });
          } else {
            scope.currentParameter[data] = {};
          }
        };

        scope.traductionAttribute = function(attribute){
          switch(attribute){
            case "criterea" : return $filter('translate')('hpo.common.criterea');break;
            case "attribute" : return $filter('translate')('hpo.common.attribute');break;
            default: return attribute;
          }
        }

        /**
         * Check form correct
         * @type {Array}
         */
        scope.lang = $rootScope.xgos.portal.lang;
        scope.checkInformations = function() {
          if (
            !scope.currentParameter ||
            !scope.currentParameter.fti ||
            !scope.currentParameter.fti.uid
          )
            return true;

          if (!scope.availablePonderations) return true;

          for (var i = 0; i < scope.availablePonderations.length; i++) {
            var ponderation = scope.availablePonderations[i];
            if(ponderation.percentage ==0 || ponderation.percentage){
              return false;
            }

            if (!ponderation.mapping && !ponderation.selectedItems) return true;

            if (
              ponderation.mapping &&
              ponderation.mapping.type !== 'moyenne' &&
              !ponderation.calcul
            )
              return true;

            if (!ponderation.mapping && ponderation.selectedItems) {
              var selected = false;
              for (var key in ponderation.selectedItems) {
                if (
                  key &&
                  ponderation.selectedItems.hasOwnProperty(key) &&
                  ponderation.selectedItems[key] &&
                  ponderation.selectedItems[key].hasOwnProperty('selected') &&
                  ponderation.selectedItems[key].selected
                ) {
                  selected = true;
                  break;
                }
              }
              if (!selected) return true;
            }
          }
          return false;
        };

        scope.supplementAttributes = [
          HpoCarteAppFactory.getAppFactory().getCalcAttribute(),
        ];
        scope.elements = [1, 2, 3];
        scope.saveInfo = function(currentParameter) {
          var sendata = angular.copy(currentParameter);
          sendata.featid = sendata.fti.uid;
          sendata.featname = sendata.fti.name;
          sendata.featalias = sendata.fti.alias;
          delete sendata.fti;
          var configuredElements = scope.availablePonderations.map(function(
            ponderation
          ) {
            if(ponderation.percentage==0 || ponderation.percentage){
              return {
                  name: ponderation.label,
                  type: 'percentage',
                  featid: fti_indicateur.uid,
                  data: ponderation.percentage,
              };
            }else{
              var mapping = angular.copy(ponderation.mapping);
              if (mapping && typeof mapping === 'string')
                mapping = JSON.parse(mapping);
              if (ponderation.selectComponent && mapping && mapping.data) {
                switch (mapping.type) {
                  case 'attribute':
                    return {
                      name: ponderation.label,
                      type: mapping.type,
                      data: mapping.data.name,
                      calcul: ponderation.calcul,
                    };
                    break;
                  case 'criterea':
                    return {
                      name: ponderation.label,
                      type: mapping.type,
                      featid: fti_criterea.uid,
                      data: mapping.data.properties.IDENTIFIANT,
                      calcul: ponderation.calcul,
                    };
                    break;
                  case 'indicateur':
                    return {
                      name: ponderation.label,
                      type: mapping.type,
                      featid: fti_indicateur.uid,
                      data: mapping.data.properties.IDENTIFIANT,
                      calcul: ponderation.calcul,
                    };
                    break;
                }
              } else {
                var identifiants = [];
                for (var k in ponderation.selectedItems) {
                  if (
                    k &&
                    ponderation.selectedItems.hasOwnProperty(k) &&
                    ponderation.selectedItems[k].hasOwnProperty('selected') &&
                    ponderation.selectedItems[k].selected
                  )
                    identifiants.push(k);
                }
                return {
                  name: ponderation.label,
                  type: 'moyenne',
                  featid: fti_indicateur.uid,
                  data: identifiants.join(','),
                };
              }
            }
          });
          sendata.config = configuredElements;
          gaDomUtils.showGlobalLoader();
          HpoMulticritereServices.saveCorrespondance(
            scope.fti_correspondance.uid,
            scope.ftiChantiers.uid,
            sendata
          ).then(
            function(res) {
              try {
                if (res && res.data && res.data.id) {

                  $rootScope.$broadcast(
                    'reloadDatatable',
                    scope.fti_correspondance.uid
                  );
                  scope.currentParameter.fti = undefined;
                  if (scope.confirm) {
                    AlertHpoFactory.successUpdate();
                    scope.confirm();
                  } else {
                    AlertHpoFactory.successAdd();
                  }
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              } catch (e) {
                e.stack;
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
              scope.loading = false;
            }
          );
        };

        scope.editCorrespondance = function(obj) {
          if (obj) {
            gaDomUtils.showGlobalLoader();
            HpoMulticritereServices.getCorrespondance(
              scope.fti_correspondance.uid,
              obj.id
            ).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res && res.data) {
                  var newScope = $rootScope.$new();
                  newScope.res = res.data;
                  var dialog = ngDialog.openConfirm({
                    template:
                      'js/XG/widgets/hpoapp/analye_multicritere/views/dialog/hpo.multicritere.correspondance.info.html',
                    className:
                      'ngdialog-theme-plain width1100 nopadding miniclose',
                    scope: newScope,
                  });
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };

        scope.validName = function(name, attributesNames) {
          if (name && attributesNames && attributesNames.length > 0) {
            var idx = attributesNames.indexOf(name);
            if (~idx) return false;
          }
          return /^[A-Za-z0-9-_\ éèêûùà]+$/.test(name);
        };

        scope.datatableHeightHistoric =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          110 +
          'px';

        scope.refreshData = function() {
          $rootScope.$broadcast(
            'reloadDatatable',
            scope.fti_correspondance.uid
          );
          scope.postRemove();
        };

        scope.buttonEditIcon = [
          {
            type: 'component',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: { name: 'pencil-square-o' },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-default cursorHelp',
              title: 'Editer le dossier',
            },
          },
        ];

        scope.datatableCalageCrudHpo = {
          update: { func: scope.editCorrespondance },
          remove: true,
          extraActions: [
            {
              name: $filter('translate')('hpo.common.refresh'),
              class: 'btn-default margin-left-right pull-left',
              func: scope.refreshData,
              icon: 'fa-refresh',
              special: true,
            },
          ],
        };

        scope.checkCorrectInformations = function(newAttributeInformations) {
          if (newAttributeInformations.update === 'update') {
            if (
              !newAttributeInformations.updatedAttribute ||
              !newAttributeInformations.updatedAttribute.name ||
              !newAttributeInformations.updatedAttribute.type
            )
              return true;
          } else {
            if (
              !newAttributeInformations.newAttribute ||
              !newAttributeInformations.newAttribute.name ||
              !newAttributeInformations.newAttribute.type
            )
              return true;
          }

          if (newAttributeInformations.updateStyle === 'add') {
            if (!newAttributeInformations.newStyleName) return true;
          }

          return false;
        };
      },
    };
  };

  multicritereCorrespondanceConfig.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppServices',
    'ngProgressFactory',
    '$location',
    'InitProvider',
    '$interval',
    'HpoMulticritereServices',
    'HpoAppModelServices',
    'chartFactory',
    'StyleFactory',
  ];
  return multicritereCorrespondanceConfig;
});
