'use strict';

define(function() {
  var DAACTCtrl = function(
    $scope,
    AncAppFactory,
    ngDialog,
    FeatureTypeFactory,
    EditFactory,
    UsersFactory,
    $timeout,
    $filter
  ) {
    $scope.kis_bac_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
      'kis_bac_listes_deroulantes_controles'
    );

    $scope.genereEnvoiCourrier = function(type_courrier) {
      $scope.getDocxControle('rdr_' + type_courrier + '.docx');
    };

    $scope.addAgentUrbanisme = function() {
      $scope.agent_urbanisme = {};
      if (angular.isUndefined($scope.showAdd)) $scope.showAdd = 1;
      else $scope.showAdd = $scope.showAdd == 1 ? 0 : 1;
    };

    $scope.setAgentUrbanisme = function() {
      var agent_urba = {};

      if (!angular.isDefined($scope.cdata.conformite.agent_urbanisme))
        $scope.cdata.conformite.agent_urbanisme = [];

      if (angular.isDefined($scope.agent_urbanisme)) {
        Object.keys($scope.agent_urbanisme).forEach(function(elem) {
          agent_urba[elem] = $scope.agent_urbanisme[elem];
        });

        if (Object.keys(agent_urba).length)
          $scope.cdata.conformite.agent_urbanisme.push(agent_urba);
        else
          require('toastr').warning('Aucune information saisie.', '', {
            positionClass: 'toast-bottom-left',
          });
      }
      delete $scope.showAdd;
    };

    $scope.deleteAgentUrbanisme = function(idx) {
      if (angular.isDefined($scope.cdata.conformite.agent_urbanisme))
        $scope.cdata.conformite.agent_urbanisme.splice(idx, 1);
    };

    $scope.concatPrescriptions = function() {
      $scope.cdata.donnees_instruction.prescriptions = '';
      if (angular.isDefined($scope.cdata.donnees_instruction)) {
        if (angular.isUndefined($scope.cdata.donnees_instruction.prescriptions))
          $scope.cdata.donnees_instruction.prescriptions = '';
        Object.keys($scope.cdata.donnees_instruction).forEach(function(key) {
          if (
            key != 'valeurs' &&
            key != 'prescriptions' &&
            $scope.cdata.donnees_instruction[key] == true
          ) {
            $scope.cdata.donnees_instruction.prescriptions +=
              $scope.cdata.donnees_instruction.valeurs['valeurs_' + key];
            $scope.cdata.donnees_instruction.prescriptions += '\r\n\r\n';
          }
        });
      }
    };

    if (angular.isUndefined($scope.cdata.donnees_instruction)) {
      $scope.cdata.donnees_instruction = {};
      $scope.cdata.donnees_instruction.valeurs = {};
      $scope.cdata.donnees_instruction.prescriptions = '';
    }

    $scope.num_dau = [];
    $scope.getDau = function() {
      console.log($scope.currentControles);
      console.log('getdau');
      $scope.currentControles.forEach(function(ctrl) {
        if (
          ctrl.properties.type === 'DUB' &&
          ctrl.properties.ref_demande_autorisation_urbanisme != null &&
          ctrl.properties.ref_demande_autorisation_urbanisme != ''
        ) {
          $scope.num_dau.push(
            ctrl.properties.ref_demande_autorisation_urbanisme
          );
        }
      });
    };

    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_1 =
      'Les personnes présentes n’étaient pas habilitées à montrer le fonctionnement de l’ensemble des réseaux.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_2 =
      'Aucune personne n’était présente au rendez-vous.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_3 =
      'Le contrôle des réseaux d’eaux usées n’a pas pu être effectué.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_4 =
      'Le contrôle des réseaux d’eaux usées n’a pas pu être effectué en totalité (regards dans jardins privatifs, regards vissés non ouvert, réseau privé sous l’impasse,)';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_5 =
      'Les personnes informées des modalités de collecte et de raccordement des propriétés limitrophes n’étaient pas présentes le jour du rendez-vous, rendant impossible le contrôle des raccordements et des équipements intérieurs.(MH).';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_6 =
      'L’entreprise ou toute autre personne informée des modalités de collecte et de raccordement au réseau d’eaux usées, n’était pas présente le jour du rendez-vous, rendant impossible le contrôle des raccordements et des équipements intérieurs. Les personnes se trouvant sur place n’étaient pas habilitées.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_7 =
      'L’ensemble des modalités de raccordement au réseau public d’eaux usées (partie publique et privée du branchement) doit être réalisé et régularisé, conformément aux prescriptions techniques et administratives du Règlement d’Assainissement Collectif, aux frais du pétitionnaire.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_8 =
      'Le plan de récolement coté des réseaux et ouvrages d’eaux usées n’a pas été remis au Service Instruction de l’Assainissement Collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_9 =
      'Le plan de récolement coté des réseaux et ouvrages d’eaux usées et d’eaux pluviales n’a pas été remis au Service Instruction de l’Assainissement Collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_10 =
      'Le plan de récolement définitif et coté des réseaux et ouvrages d’eaux usées et d’eaux pluviales devra être remis au Service Instruction de l’Assainissement Collectif à la fin des travaux.(MH)';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_11 =
      'Pour votre information, les agents du service Instruction de l’assainissement collectif n’ont pas contrôlé la qualité d’exécution des ouvrages et réseaux d’assainissement situés à l’intérieur de la propriété, pendant les travaux. Un simple contrôle visuel des ouvrages et réseaux a été réalisé lors de la visite.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_12 =
      'Le siphon disconnecteur n’a pas été installé, conformément à l’article 11 du règlement d’Assainissement Collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_13 =
      'Les regards de visite à créer, doivent être équipés de siphon disconnecteur type Ville d’Antibes et munis d’un clapet anti-retour.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_14 =
      'Le clapet anti-retour n’a pas été installé.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_15 =
      'Tampon hermétique étanche à installer, conformément au Règlement du Plan de Prévention des Risques d’Inondation (P.P.R.I).';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_16 =
      'Le regard de branchement n’a pas été réalisé (regard de curage), non conforme à l’article 11 du Règlement d’Assainissement Collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_17 =
      "Toutes dispositions doivent être prises par le pétitionnaire pour s’opposer à tout reflux provenant du collecteur public d'eaux usées (article.Toutes dispositions doivent être prises par le pétitionnaire pour s’opposer à tout reflux provenant du collecteur public d'eaux usées (article 31).";
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_18 =
      'Les cunettes sont à finir dans les regards de visite.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_19 =
      'Des tampons fontes sont à installer et à sceller sur les regards de visite.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_20 =
      'Les tampons des trois regards de visite (clapet, siphon,…) devront être remis à la cote du terrain projeté.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_21 =
      'Le regard de branchement est obturé par des racines.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_22 =
      'La partie publique du branchement est existante et à très faible profondeur (reprise récente de l’enrobé sur chaussée ?).';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_23 =
      'Raccordement de la piscine : L’évacuation des eaux de vidange et de lavage des filtres de la piscine se fera dans le réseau d’eaux usées par l’intermédiaire d’un regard de détente équipé d’un flotteur permettant l’arrêt des pompes et d’un réducteur de diamètre 40mm gravitaire limitant le débit à 2,5 l/s.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_24 =
      'Le bac de détente et le réducteur de débit diamètre 40mm gravitaire n’ont pas été réalisés, conformément à l’article 6 du Règlement d’Assainissement Collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_25 =
      'La piscine n’a pas été raccordée au réseau d’eaux usées, conformément à l’article 6 du règlement d’Assainissement Collectif (rejet sur site).';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_26 =
      'Les eaux de vidange du bassin horticole n’ont pas été raccordées au réseau d’eaux usées.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_27 =
      'La douche extérieure de la piscine n’a pas été raccordée au réseau d’eaux usées.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_28 =
      'Les fontaines n’ont pas été raccordées au réseau d’eaux usées.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_29 =
      'L’évacuation des eaux de vidange et de lavage des filtres de la piscine n’a pas été raccordée, conformément à l’article 6 du règlement d’Assainissement Collectif, (dysfonctionnement du système de régulation installé créant un débordement des eaux du bac de détente en surface [piscine plus haute que le regard de détente]).';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_30 =
      'Un dossier de demande de raccordement devra être déposé, conformément à l’article 9 du règlement d’Assainissement Collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_31 =
      'Le dossier de demande de raccordement déposé le…est incomplet.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_32 =
      "Le dossier de demande de raccordement doit être complété et régularisé en concertation avec le Service Instruction/Réglementation et Taxes de l'Assainissement Collectif, conformément aux prescriptions de l’article 9 du Règlement d’Assainissement Collectif.";
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_33 =
      'Le pétitionnaire devra prendre contact avec le service Instruction de l’Assainissement Collectif au 04.92.90.47.66 pour régulariser le dossier. Direction des Réseaux et des Infrastructures – Instruction/Réglementation et Taxes - Centre Technique Municipal 1750, Chemin des Terriers – 06600 ANTIBES.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_34 =
      'Un arrêté provisoire de raccordement aux réseaux d’assainissement avait été pris dans l’attente des résultats des démarches judiciaires en cours permettant le raccordement de l’ensemble du projet dans les conditions fixées par le dossier d’autorisation d’urbanisme délivré.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_35 =
      'Une convention spéciale de déversement permettant de rejeter des eaux non domestique devra être établie en concertation avec le service (pour plus d’information merci de contacter M. BELTRAMO au 04 92 90 47 64).';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_36 =
      'Le réseau d’eaux usées est partiellement en charge. Un curage général de l’ensemble du réseau devra être effectué par une société privée d’assainissement agrée (vidangeur), avant la prochaine visite.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_37 =
      'Le plan de récolement coté des réseaux et ouvrages d’eaux usées situés dans le parking sous-sol n’a pas été remis au Service Instruction de l’Assainissement Collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_38 =
      'Le plan de récolement coté des réseaux et ouvrages d’eaux usées situés dans le parking sous-sol devra être remis au Service Instruction de l’Assainissement Collectif à la fin des travaux (MH).';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_39 =
      'Présence d’eaux dans les fosses récupérant les eaux résiduaires des aires de stationnement en sous-sol (étanchéité à vérifier). (MH)';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_40 =
      'Les fosses récupérant les eaux résiduaires des aires de stationnement en sous-sol ne semble pas étanches (présence d’eaux claire).';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_41 =
      'Le contrôle et rejet des eaux provenant des cunettes périphériques située dans le parking sous-sol n’a pas pu être effectué en totalité (box fermés).';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_42 =
      'L’enrobé sur la voie publique devra être refait (léger affaissement).';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_43 =
      'L’enrobé sur la tranchée de la voie privée doit être fait.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_44 =
      'Le joint sablé sur la reprise d’enrobé situé sur la partie publique du branchement n’a pas été réalisé.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_45 =
      'Les eaux de drainage du bâtiment et/ou de pompage de la nappe sont rejetées dans le réseau d’eaux usées et/ou d’eaux pluviales.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_46 =
      "L'ancien dispositif d'assainissement autonome devra être mis hors service, la fosse septique devra être vidangée, curée et comblée.";
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_47 =
      "Une inspection télévisée de la canalisation devra être transmise au Service Instruction de l'Assainissement Collectif pour permettre le contrôle.";
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_48 =
      'Le rapport de l’inspection télévisée du réseau privée, situé sous l’impasse FLEURIE, datée de 2010, indiquait la présence de nombreuses racines, des pénétrations importantes dans le réseau et des décalages de canalisations.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_49 =
      "Une nouvelle inspection télévisée de la canalisation devra être réalisé et transmis au Service Instruction de l'Assainissement Collectif pour permettre la prochaine visite de conformité conformément aux attestations d’autorisations fournies.";
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_50 =
      'Le local poubelles n’est pas raccordé au réseau d’eaux usées conformément à l’article 77 du RSD.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_51 =
      'L’évacuation des eaux de lavage du local poubelles n’a pas été réalisé conformément à l’article 77 du RSD.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_52 =
      'Le local poubelles n’ayant pas été couvert, les eaux de pluie qui transitent par le siphon de sol sont raccordées au réseau d’eaux usées.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_53 =
      'Les anciens branchements n’ont pas été supprimés sous domaine public.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_54 =
      'L’ancien branchement n’a pas été repéré et supprimé sous domaine public.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_55 =
      'Des eaux pluviales provenant d’un siphon de sol situé au bas des escaliers niveau rez de chaussé sont raccordées au réseau d’eaux usées.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_56 =
      'Des eaux pluviales provenant des gouttières de la toiture ont été raccordées au réseau d’eaux usées.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_57 =
      'Non conforme à l’article 3 du règlement d’assainissement collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_58 =
      'La buse d’eaux pluviales existante située sur le collecteur, gravitaire d’eaux usées à usage public existant sous domaine privé, en limite est de la propriété, au droit de l’ancien accès, devra être déposée en concertation avec le service des eaux pluviales.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_59 =
      'Un organe de gestion devra être crée afin de définir les divers utilisateurs et les modalités d’entretien et de réparation futures de la canalisation, conformément aux prescriptions de l’article 39 du Règlement d’Assainissement Collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_60 =
      'Le gestionnaire devra régulariser avec les divers utilisateurs, par actes notariés, les servitudes relatives à la canalisation commune de branchement d’eaux usées existante sous la voie privée jusqu’au collecteur public existant sous…';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_61 =
      'Les servitudes de tréfonds indiquant les autorisations de se raccorder sur le réseau privé d’eaux usées et de traverser les parcelles adéquates devront être régularisées par actes notariés conformément…';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_62 =
      'La servitude de passage de canalisation, du collecteur gravitaire d’eaux usées à usage public existant sous domaine privé, en limite est de la propriété, devra être régularisée par acte notarié en concertation avec le service action foncière municipal.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_63 =
      'Le plan du tracé côté de l’ensemble du réseau privé indiquant les différentes propriétés raccordées doit donc être remis au Service Instruction de l’Assainissement Collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_64 =
      'Un dossier de demande de raccordement devra être déposé pour régularisation, conformément aux articles 9 et 39 du règlement d’Assainissement Collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_65 =
      'Le réseau privé d’eaux usées n’a pas été remis en état.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_66 =
      'La demande de dérogation pour l’installation d’un poste de relevage n’a pas été déposée conformément à l’article 42 du R.S.D et à l’article 9 du règlement du Service de l’Assainissement Collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_67 =
      'Les modalités d’assainissement des locaux sanitaires du niveau R-1 (Wc, lavabo, douches,…) n’ont pas été réalisés en concertation et suivant les prescriptions du service instruction de l’assainissement collectif.';
    $scope.cdata.donnees_instruction.valeurs.valeurs_prescriptions_68 =
      'Le poste de relevage n’a pas été réalisé conformément au dossier technique déposé (volume à vérifier, fond plat réalisé, alarme cuve pleine non installée, arrivée des eaux sur platelage, surverse gravitaire sur réseau privé réalisée, …).';
  };

  DAACTCtrl.$inject = [
    '$scope',
    'AncAppFactory',
    'ngDialog',
    'FeatureTypeFactory',
    'EditFactory',
    'UsersFactory',
    '$timeout',
    '$filter',
  ];
  return DAACTCtrl;
});
