'use strict';
define(function() {
  var bacVisite = function(FeatureTypeFactory, ngDialog, $filter) {
    return {
      templateUrl: 'js/XG/widgets/bacapp/main/views/directives/bac_visite.html',
      restrict: 'EA',
      scope: {
        cdata: '=',
        ctrlClos: '=',
        typeVisite: '=',
        labelKey: '=?',
        controleComment: '=?',
        titleVisite: '=?',
        ctrl: '=?',
      },

      link: function(scope, elt, attrs, ctrl) {
        scope.kis_bac_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
          'kis_bac_listes_deroulantes_controles'
        );
        scope.controleCommentConfig = {};
        scope.editVisite = null;
        console.log(scope.ctrl);
        if (
          angular.isDefined(scope.cdata) &&
          angular.isUndefined(scope.cdata.travaux)
        )
          scope.cdata.travaux = {};

        if (
          angular.isDefined(scope.cdata) &&
          angular.isDefined(scope.cdata.travaux)
        ) {
          if (angular.isUndefined(scope.cdata.travaux.visite_publique)) {
            scope.cdata.travaux.visite_publique = [];
          }

          if (angular.isUndefined(scope.cdata.travaux.visite_privee)) {
            scope.cdata.travaux.visite_privee = [];
          }
        }

        var newVisiteDialog;
        scope.preAddVisite = function(editedVisite) {
          scope.controleCommentConfig.commentaires = {};

          if (angular.isUndefined(scope.cdata.travaux))
            scope.cdata.travaux = {};

          if (
            scope.typeVisite &&
            angular.isDefined(scope.controleComment) &&
            Object.keys(scope.controleComment).length > 0
          ) {
            if (
              angular.isDefined(
                scope.controleComment.commentaires[
                  'cdata.travaux.' + scope.typeVisite + '.observations'
                ]
              )
            ) {
              scope.controleCommentConfig.commentaires[
                'newVisite.observations'
              ] =
                scope.controleComment.commentaires[
                  'cdata.travaux.' + scope.typeVisite + '.observations'
                ];
            }
          }

          if (editedVisite) {
            scope.newVisite = editedVisite;
          } else {
            scope.newVisite = {};
          }

          newVisiteDialog = ngDialog.open({
            template:
              'js/XG/widgets/bacapp/main/views/modals/modal.visite.html',
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.addVisite = function() {
          if (angular.isDefined(scope.cdata.travaux)) {
            if (
              angular.isDefined(scope.editVisite) &&
              scope.editedVisiteIndex != null
            ) {
              if (scope.newVisite.observations == '') {
                delete scope.newVisite.observations;
              }

              scope.cdata.travaux[scope.typeVisite][scope.editedVisiteIndex] =
                scope.newVisite;
              scope.editedVisiteIndex = null;
            } else {
              if (angular.isUndefined(scope.cdata.travaux[scope.typeVisite]))
                scope.cdata.travaux[scope.typeVisite] = [];

              scope.cdata.travaux[scope.typeVisite].push(scope.newVisite);
            }
          }

          newVisiteDialog.close();
        };

        scope.editVisite = function(index) {
          scope.editedVisiteIndex = index;
          scope.preAddVisite(scope.cdata.travaux[scope.typeVisite][index]);
        };

        scope.removeVisite = function(index) {
          scope.cdata.travaux[scope.typeVisite].splice(index, 1);
        };

        scope.initDate = function(date) {
          return $filter('date')(date, 'dd/MM/yyyy HH:mm');
        };
      },
    };
  };

  bacVisite.$inject = ['FeatureTypeFactory', 'ngDialog', '$filter'];
  return bacVisite;
});
