'use strict';
define(function() {
  var eft = function(
    AncAppFactory,
    FeatureTypeFactory,
    QueryFactory,
    gaDomUtils,
    ConfigFactory,
    $q,
    $window,
    ancBacTools,
    $filter
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/element_filiere_template.html',
      restrict: 'EA',
      link: function(scope) {
        scope.titleInputActive = {};
        var gfbnd = FeatureTypeFactory.getFeatureByNameAndDatastore;
        scope.typesControle = AncAppFactory.appCfg.main.controleCfg.filter(
          function(x) {
            return (
              x.type != 'FO0' &&
              x.type != 'Ponctuel' &&
              x.type.indexOf('_mutation') == -1
            );
          }
        );

        // retrieve cfg
        var cfg = angular.copy(AncAppFactory.getElementsFiliereTemplates());
        scope.allowToggleElementFiliereTemplateApart = !angular.isDefined(
          AncAppFactory.appCfg.elementsFiliereTemplates
        );

        var setAliasChecked = function() {
          scope.elementsFiliere.forEach(function(ef) {
            ef.alias_checked =
              (ef.templateCfg !== false ? '\u25B6 ' : '') + ef.alias;
          });
        };

        // ----------------------------------------------------
        // retrieve elements filiere
        var typesElementsFiliere = {};
        AncAppFactory.getElementFiliereData('type').then(function(res) {
          // mapping nom-id

          res.data.features.forEach(function(x) {
            typesElementsFiliere[x.id] = x.properties.nom;
          });
          QueryFactory.data(
            gfbnd(
              AncAppFactory.appCfg.main.datastore,
              'kis_anc_element_filiere'
            ).uid
          ).then(function(res) {
            scope.elementsFiliere = res.data.features.map(function(x) {
              var ef = x.properties;
              ef.nom_type = typesElementsFiliere[ef.id_type];
              if (ef.nom_type == 'Tous') ef.nom_type = 'Autres';
              ef.templateCfg = angular.isDefined(cfg[ef.identifiant])
                ? cfg[ef.identifiant]
                : false;

              return ef;
            });

            setAliasChecked();
          });
        });

        /**
         * [getUsedAtts recuperer le tableau des attributs de gauche et droite utilisés]
         * @param  {[type]} type [description]
         * @return {[type]}      [description]
         */
        function getUsedAtts(type) {
          scope.attsUsed = [];
          // also get the attributes used on the right
          scope.attsUsedGauche = [];
          scope.attsUsedDroite = [];

          // scope.template[type] may have length that is > 1 so I am getting those paramaters too
          if (scope.template[type] !== undefined) {
            for (let i = 0; i < scope.template[type].length; i++) {
              if (scope.template[type][i] !== undefined) {
                for (let j = 0; j < scope.template[type][i].items.length; j++) {
                  if (scope.template[type][i].items[j].gauche !== undefined) {
                    scope.attsUsedGauche.push(
                      scope.template[type][i].items[j].gauche
                    );
                  }
                  if (scope.template[type][i].items[j].droite !== undefined) {
                    scope.attsUsedDroite.push(
                      scope.template[type][i].items[j].droite
                    );
                  }
                }
              }
            }
          }

          scope.attsUsed = scope.attsUsedGauche.concat(scope.attsUsedDroite);
        }
        /**
         * [inArray verifier si un element existe dans un tableau]
         * @param  {[type]} needle   [description]
         * @param  {[type]} haystack [description]
         * @return {[type]}          [description]
         */
        function inArray(needle, haystack) {
          var count = haystack.length;
          for (var i = 0; i < count; i++) {
            if (haystack[i] === needle) {
              return true;
            }
          }
          return false;
        }
        scope.changedAtts = [];

        /**
         * canGoBackDroite
         * @param item
         * @returns {number}
         */
        scope.canGoBackDroite = function(item) {
          //    console.log(~scope.template[scope.currentCtrlType][0])
          return ~scope.template[scope.currentCtrlType][0]['testAtts'].indexOf(
            item.gauche
          );
        };

        /**
         * dispatchAttributes
         * @param ctrlType
         */
        scope.dispatchAttributes = function(type) {
          var tabTest = [];

          if (
            scope.template !== undefined &&
            scope.template[type] !== undefined &&
            scope.template[type][0] &&
            scope.template[type][0].testAtts != undefined
          ) {
            tabTest = scope.template[type][0].testAtts;
          }
          scope.currentCtrlType = type;

          scope.descAttributes = [];
          scope.ctrlAttributes = [];

          var toCheck = scope.currentCtrlType.toLowerCase();

          scope.addDefaults();

          scope.currElementFiliere.attributes.forEach(function(att) {
            if (
              new RegExp('^ctrl(.*)_').test(att.name) &&
              !inArray(att.name, tabTest)
            ) {
              // si att.name commence par 'ctrl'+type+'_' (standard) ou type+'_' (pananc)
              if (
                att.name.indexOf('ctrl' + toCheck) === 0 ||
                att.name.indexOf(toCheck) === 0
              ) {
                att.alias2 = att.alias;
                scope.ctrlAttributes.push(att);

                // check if control atributes are among the used attributes
                for (let k = 0; k < scope.ctrlAttributes.length; k++) {
                  if (
                    inArray(scope.ctrlAttributes[k].name, scope.attsUsed) &&
                    scope.ctrlAttributes[k].alias != ' '
                  ) {
                    scope.ctrlAttributes[k].alias2 =
                      '<i class="fa fa-check-square-o"></i>' +
                      ' ' +
                      scope.ctrlAttributes[k].alias;
                  }
                }
              }
            } else {
              if (
                att.name != 'caj_id_raccordement' &&
                att.name != 'caj_id_element_filiere'
              ) {
                scope.descAttributes.push(att);
              }
              scope.descAttributes.forEach(function(x) {
                x['alias2'] = x.alias;
              });
              getUsedAtts(type);

              for (let k = 0; k < scope.descAttributes.length; k++) {
                if (
                  inArray(scope.descAttributes[k].name, scope.attsUsed) &&
                  scope.descAttributes[k].alias != ' '
                ) {
                  scope.descAttributes[k].alias2 =
                    '<i class="fa fa-check-square-o"></i>' +
                    ' ' +
                    scope.descAttributes[k].alias;
                }
              }
            }
          });

          scope.allAttributes = scope.ctrlAttributes.concat(
            scope.descAttributes
          );
          scope.allAttributes.unshift({
            alias: 'Insérer espace blanc',
            alias2: 'Insérer espace blanc',
            name: 0,
          });

          scope.setDisplayMode();
        };

        scope.getDefaultAttributes = () => {
          let attributesToDisplay = [];
          let allControles = AncAppFactory.appCfg.main.controleCfg;

          for (
            let index = 0;
            index < scope.currElementFiliere.attributes.length;
            index++
          ) {
            let attribute = scope.currElementFiliere.attributes[index];

            let attributeIsDisplayed = ancBacTools.attributeDisplayCondition(
              scope.currentCtrlType,
              allControles,
              attribute,
              'element'
            );

            if (
              attributeIsDisplayed &&
              attribute.name !== 'filiere_active' &&
              attribute.name !== 'id_filiere'
            ) {
              attributesToDisplay.push(attribute);
            }
          }
          return attributesToDisplay;
        };

        scope.changeDisplayMode = function(ctrlType) {
          let settings = AncAppFactory.appCfg.main.properties;
          let hasTheSetting = settings.hasOwnProperty(
            'elementsFiliereDisplayMode'
          );

          if (!hasTheSetting) {
            settings.elementsFiliereDisplayMode = {};
          }

          let hasElement = settings.elementsFiliereDisplayMode.hasOwnProperty(
            scope.currElementFiliere.name
          );

          if (!hasElement) {
            settings.elementsFiliereDisplayMode[
              scope.currElementFiliere.name
            ] = {};
          }

          settings.elementsFiliereDisplayMode[scope.currElementFiliere.name][
            ctrlType
          ] = 'oneColumn';
          scope.displayModeSettings =
            settings.elementsFiliereDisplayMode[scope.currElementFiliere.name];
        };

        scope.setDisplayMode = function(revert) {
          let settings = AncAppFactory.appCfg.main.properties;
          let hasTheSetting = settings.hasOwnProperty(
            'elementsFiliereDisplayMode'
          );

          if (!hasTheSetting) {
            scope.displayModeSettings = {};
            return;
          }

          let hasElement = settings.elementsFiliereDisplayMode.hasOwnProperty(
            scope.currElementFiliere.name
          );

          if (!hasElement) {
            scope.displayModeSettings = {};
            return;
          }

          if (revert) {
            delete settings.elementsFiliereDisplayMode[
              scope.currElementFiliere.name
            ][scope.currentCtrlType];
          }
          scope.displayModeSettings =
            settings.elementsFiliereDisplayMode[scope.currElementFiliere.name];
        };

        /**
         * [isEmpty verify if object is empty]
         * @param  {[type]}  obj [description]
         * @return {Boolean}     [description]
         */
        function isEmpty(obj) {
          for (var prop in obj) {
            if (obj.hasOwnProperty(prop)) return false;
          }
          return true;
        }
        /**
         * [initIfExist description]
         * @param  {[type]} tab      [description]
         * @param  {[type]} typesCtl [description]
         * @return {[type]}          [description]
         */
        function initIfExist(tab, typesCtl) {
          for (var i = 0; i < tab.length; i++) {
            if (!isEmpty(tab[i]) && !tab[i].isDefaultModel) {
              typesCtl['exist'] = true;
            }
            delete tab[i].isDefaultModel;
          }
        }
        /**
         * [verifytemplateExist verifie si une filiere contient un template]
         * @return {[type]} [description]
         */
        function verifytemplateExist() {
          var tabTmpl = [];

          AncAppFactory.appCfg.main.controleCfg.forEach(function(c) {
            if (angular.isDefined(scope.template[c.type]))
              tabTmpl.push(scope.template[c.type][0].items);
          });

          for (var j = 0; j < tabTmpl.length; j++) {
            initIfExist(tabTmpl[j], scope.typesControle[j]);
          }
        }

        scope.addDefaults = () => {
          let defaultAttributes = scope.getDefaultAttributes();

          if (angular.isDefined(scope.template[scope.currentCtrlType])) {
            let attributeItems = [];

            let hasOneGroup =
              scope.template[scope.currentCtrlType].length === 1;
            let hasOneItem =
              scope.template[scope.currentCtrlType][0].items.length === 1;
            let firstItemHasAttributes = !isEmpty(
              scope.template[scope.currentCtrlType][0].items[0]
            );

            if (hasOneGroup & hasOneItem && !firstItemHasAttributes) {
              for (let index = 0; index < defaultAttributes.length; index++) {
                if (index % 2 === 0) {
                  let itemProperties = {};

                  itemProperties = {
                    gauche: defaultAttributes[index]
                      ? defaultAttributes[index].name
                      : null,
                    droite: defaultAttributes[index + 1]
                      ? defaultAttributes[index + 1].name
                      : null,
                  };

                  if (itemProperties.gauche === null) {
                    delete itemProperties.gauche;
                  }
                  if (itemProperties.droite === null) {
                    delete itemProperties.droite;
                  }
                  if (!isEmpty(itemProperties)) {
                    itemProperties.isDefaultModel = true;
                    attributeItems.push(itemProperties);
                  }
                }
              }
              scope.template[scope.currentCtrlType][0].items = attributeItems;
            }
          }

          verifytemplateExist();
        };
        /**
         * setEmptyTemplate
         */
        var setEmptyTemplate = function() {
          scope.template = {};
          scope.typesControle.forEach(function(x) {
            scope.template[x.type] = [
              {
                key: 'grp1',
                items: [{}],
              },
            ];
          });
        };
        /**
         * load full ef
         * loadFullEf
         */
        scope.loadFullEf = function() {
          scope.typesControle.forEach(function(x) {
            if (x.exist) {
              x.exist = false;
            }
          });

          if (!scope.c) return;
          scope.currentCtrlType = false;

          scope.currElementFiliere = gfbnd(
            AncAppFactory.appCfg.main.datastore,
            scope.c.ef.identifiant
          );

          // init template
          if (!scope.c.ef.templateCfg) {
            setEmptyTemplate();
          } else {
            // console.log(scope.typesControle);
            scope.template = scope.c.ef.templateCfg;
            verifytemplateExist();
          }
        };

        /**
         * addGroupe
         */
        scope.addGroupe = function() {
          scope.template[scope.currentCtrlType].push({
            key: 'grp',
            items: [{}],
          });
        };

        scope.toggleInput = groupeIndex =>
          (scope.titleInputActive[groupeIndex] = !scope.titleInputActive[
            groupeIndex
          ]);

        scope.toggleBoldTitle = groupe =>
          (groupe.boldTitle = !groupe.boldTitle);

        scope.toggleUnderlinedTitle = groupe =>
          (groupe.underlinedTitle = !groupe.underlinedTitle);

        /**
         * removeGroup
         * @param idx
         */
        scope.removeGroup = function(idx) {
          delete scope.titleInputActive[idx];
          scope.template[scope.currentCtrlType].splice(idx, 1);
        };

        /**
         * removeItemFromGroup
         * @param groupe
         * @param idx
         */
        scope.removeItemFromGroup = function(groupe, idx) {
          groupe.items.splice(idx, 1);
        };
        /**
         * addItemToGroup
         * @param groupe
         * @param idx
         */
        scope.addItemToGroup = function(groupe, idx) {
          groupe.items.splice(idx + 1, 0, {});
        };

        // test dev
        // scope.currElementFiliere = gfbnd(AncAppFactory.appCfg.main.datastore, "kis_anc_ef_ventilation");
        // dispatchAttributes();

        /**
         * saveTemplates cfg
         */
        scope.saveTemplates = function(deleteCurrTemplate) {
          var tpl = angular.copy(scope.template);

          // sauvegarde dans le fichier principal
          var cible = !angular.isDefined(
            AncAppFactory.appCfg.elementsFiliereTemplates
          )
            ? AncAppFactory.appCfg.main.properties.elementsFiliereTemplates
            : AncAppFactory.appCfg.elementsFiliereTemplates;

          if (!deleteCurrTemplate) {
            cible[scope.c.ef.identifiant] = tpl;
          } else {
            cible[scope.c.ef.identifiant];
          }

          // sauvegarde dans un fichier a part
          gaDomUtils.showGlobalLoader();

          var promise = !angular.isDefined(
            AncAppFactory.appCfg.elementsFiliereTemplates
          )
            ? AncAppFactory.updateAppCfg()
            : AncAppFactory.updateElementFiliereAppCfg();

          promise.then(function() {
            scope.currElementFiliere.templateCfg = tpl;

            // update templateCfg dans la liste principale des elements
            for (var i in scope.elementsFiliere) {
              if (
                scope.elementsFiliere[i].identifiant ==
                scope.currElementFiliere.name
              ) {
                scope.elementsFiliere[i].templateCfg = tpl;
              }
            }

            setAliasChecked();
            verifytemplateExist();
            gaDomUtils.hideGlobalLoader();
          });
        };

        /**
         * resetConfigTypeControle
         * @param currentCtrlType
         */
        scope.resetConfigTypeControle = function(currentCtrlType) {
          if (
            confirm(
              'Êtes-vous certain de vouloir supprimer la configuration pour ce type de contrôle ?'
            )
          ) {
            scope.setDisplayMode(true);

            scope.template[currentCtrlType] = [
              {
                key: 'grp1',
                items: [{}],
              },
            ];

            scope.currentCtrlType = false;

            var allReset = true;
            for (var type in scope.typesControle) {
              if (scope.typesControle[type].type == currentCtrlType) {
                console.log('trouve');
                scope.typesControle[type].exist = false;
              }
              if (scope.typesControle[type].exist) {
                allReset = false;
              }
            }

            // reset templates tous controles pour ef en cours
            if (allReset){
              setEmptyTemplate();
            }
            delete scope.c.ef.templateCfg;
            scope.saveTemplates();
            scope.checkIfElementFiliereTemplateCfgEmpty(
              scope.template,
              scope.currElementFiliere.name
            );
          }
        };

        /**
         * moveItem
         * @param _array
         * @param index
         * @param direction
         * @param event
         * @returns {boolean}
         */
        scope.moveItem = function(_array, index, direction, event) {
          // console.log(arguments);

          var newIndex = direction == 'up' ? index - 1 : index + 1;
          if (
            (index == 0 && direction == 'up') ||
            (index == _array.length - 1 && direction == 'down')
          )
            return false;

          _array.splice(index, 0, _array.splice(newIndex, 1)[0]);
          event.stopPropagation();
        };

        /**
         * moveToGroup
         * Move item to group
         * @param index_item
         * @param index_groupe
         * @param direction
         * @param event
         */
        scope.moveToGroup = function(
          index_item,
          index_groupe,
          direction,
          event
        ) {
          var newIndex =
            direction == 'up' ? index_groupe - 1 : index_groupe + 1;
          if (
            (index_groupe == 0 && direction == 'up') ||
            (index_groupe == scope.template[scope.currentCtrlType].length - 1 &&
              direction == 'down')
          )
            return false;

          // copy and remove from first group
          var svg = scope.template[scope.currentCtrlType][
            index_groupe
          ].items.splice(index_item, 1)[0];
          scope.template[scope.currentCtrlType][newIndex].items.push(svg);
          event.stopPropagation();
        };

        scope.updateAllAtributes = function() {
          scope.dispatchAttributes(scope.currentCtrlType);
        };

        // permet de gerer la configuration dans un fichier a part de la config principale
        scope.toggleElementFiliereTemplateApart = function() {
          // toggle
          if (!angular.isDefined(AncAppFactory.appCfg.elementFiliereAPart)) {
            var ans = confirm(
              'Êtes-vous sur ? Action irréversible (sauf intervention admin dans le repo'
            );
            if (ans) {
              gaDomUtils.showGlobalLoader();

              AncAppFactory.appCfg.main.properties.elementFiliereAPart = true;
              AncAppFactory.appCfg.elementsFiliereTemplates = angular.copy(
                AncAppFactory.appCfg.main.properties.elementsFiliereTemplates
              );
              delete AncAppFactory.appCfg.main.properties
                .elementsFiliereTemplates;

              AncAppFactory.updateElementFiliereAppCfg(1).then(function() {
                AncAppFactory.updateAppCfg(1).then(function() {
                  gaDomUtils.hideGlobalLoader();
                  $window.location.reload();
                });
              });
            }

            // annulation, à faire eventuellement
          } else {
            alert('@TODO');
          }
        };
         /**
         * Verification si la template de l'element de filére est vide pour la supprimer 
         * de la configuration de l'application ANC et reoload de configuration
         *
         * @param {*} templates Configuration json des controles sur le element de filiére 
         * @param {*} efName nom element de filiére
         */
        scope.checkIfElementFiliereTemplateCfgEmpty = (templates, efName) => {
           let sizeTemplates = 0;
           if (templates) {
             for (let template in templates) {
               if (templates[template]) {
                 for (let i = 0; i < templates[template].length; i++) {
                   if (
                     templates[template][i].items[0].gauche ||
                     templates[template][i].items[0].droite
                   ) {
                     sizeTemplates = sizeTemplates + 1;
                   }
                 }
               }
             }
             for (var i in scope.elementsFiliere) {
               if (scope.elementsFiliere[i].identifiant === efName) {
                 if (
                   scope.elementsFiliere[i] &&
                   !scope.elementsFiliere[i].templateCfg
                 ) {
                   scope.elementsFiliere[i].templateCfg = {};
                 }
                 if (sizeTemplates === 0) {
                   delete AncAppFactory.appCfg.main.properties
                     .elementsFiliereTemplates[efName];
                   AncAppFactory.updateElementFiliereAppCfg(1)
                     .then(() => {
                       AncAppFactory.updateAppCfg(1)
                         .then(() => {
                           gaDomUtils.hideGlobalLoader();
                           $window.location.reload();
                         })
                         .catch(() => {
                           gaDomUtils.hideGlobalLoader();
                           require('toastr').error(
                             $filter('translate')(
                               'about.configurationSaveErrorMsg'
                             )
                           );
                         });
                     })
                     .catch(() => {
                       gaDomUtils.hideGlobalLoader();
                       require('toastr').error(
                         $filter('translate')('about.configurationSaveErrorMsg')
                       );
                     });
                 }
               }
             }
           }
         };
      },
    };
  };

  eft.$inject = [
    'AncAppFactory',
    'FeatureTypeFactory',
    'QueryFactory',
    'gaDomUtils',
    'ConfigFactory',
    '$q',
    '$window',
    'ancBacTools',
    '$filter'
  ];
  return eft;
});
