'use strict';
define(function() {
  var QueryFactory = function(
    $http,
    $filter,
    gcRestrictionProvider,
    $q
  ) {
    var Query = {};

    /**
     * Class : Query Factory WebServices
     */

    function updateMaintaSave2(data) {
      return $http.post(
        '/services/{portalid}/query/updateMaintaSave2?f=json',data
      );
    }
    /**
     * Function: get
     */
    function get(ftid, featureIDs, targetCrsName) {
      if (targetCrsName === undefined) {
        targetCrsName = '';
      }
      if (typeof queryAndroid !== 'undefined') {
        var defer = $q.defer();
        var int = createDefer(defer);
        queryAndroid.getFeaturesByIds(ftid, featureIDs,
          targetCrsName, int );
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/query/' + ftid + '/getFeaturesByIds?f=json' +
            '&featureIDs=' + featureIDs +
            '&targetCrsName=' + targetCrsName
        );
        promise.then(
          function() {
            // service level logic if any
          },
          function(result) {
            gcRestrictionProvider.showDetailsErrorMessage(result);
          }
        );
        return promise;
      }
    }

    var QueryDataDefers = [];
    /**
     * Function: data
     */
    function data(fid, where, mapCrs, page, count, sort,specialQueryData) {
      var defer = $q.defer();
      if (mapCrs === undefined) mapCrs = '';
      if (page === undefined) page = '';
      if (count === undefined) count = '';
      if (sort === undefined) sort = '';
      // where = gaUrlUtils.encodeUriQuery(where || '');

      if (typeof queryAndroid !== 'undefined') {
        var int = createDefer(defer);
        queryAndroid.data(fid, where, page, count, sort, int);
        return defer.promise;
      } else {
        var postdata = {
          filter: where,
          page: page + '',
          count: count + '',
          sort: sort + '',
          mapCrs: mapCrs + '',
        };
        
        if(specialQueryData){
          postdata.specialQueryData = specialQueryData
        }
        // var promise = $http.get('/services/{portalid}/query/' + fid +
        // '/data?f=json' + '&where=' + where + '&crs=' + mapCrs + '&page=' +
        // page + '&count=' + count+ '&sort=' + sort);
        if (fid) {
          var promise = $http.post(
            '/services/{portalid}/query/' + fid + '/data?f=json',
            postdata
          );
          promise.then(
            function() {
              // service level logic if any
            },
            function(result) {
              gcRestrictionProvider.showDetailsErrorMessage(result);
            }
          );
          return promise;
        }
          
      }
    }

    function createDefer(defer) {
      var int = Math.round(Math.random() * 10e7);
      QueryDataDefers.push({
        idx: int,
        defer: defer,
      });
      return int;
    }

    function dataResultAndroid(res, int) {
      var defer;
      try {
        var index;
        for (var i = 0; i < QueryDataDefers.length; i++) {
          var d = QueryDataDefers[i];
          if (d.idx === int) {
            defer = d.defer;
            index = i;
            break;
          }
        }

        var response = {
          data: res,
        };
        try {
          if (response.data && typeof response.data == 'string') {
            response.data = JSON.parse(response.data);
          }
        } catch (e) {
          console.log(response.data);
          e.stack;
        }
        defer.resolve(response);
      } catch (e) {
        e.stack;
        defer.reject();
      }
      QueryDataDefers.splice(index, 1);
    }

    /**
     * Function: pdata
     */
    function pdata(fid, where, mapCrs, page, count) {
      if (mapCrs === undefined) mapCrs = '';
      if (page === undefined) page = '';
      if (count === undefined) count = '';

      // where = gaUrlUtils.encodeUriQuery (where|| '');
      var promise = $http.post(
        '/services/{portalid}/query/' +
          fid +
          '/pdata?f=json' +
          '&crs=' +
          mapCrs +
          '&page=' +
          page +
          '&count=' +
          count,
        where
      );
      promise.then(
        function() {
          // service level logic if any
        },
        function(result) {
          gcRestrictionProvider.showDetailsErrorMessage(result);
        }
      );
      return promise;
    }


    /**
     * Function: pmultidata
     */
    function pmultidata(fids, where, mapCrs, page, count) {
      if (mapCrs === undefined) mapCrs = '';
      if (page === undefined) page = '';
      if (count === undefined) count = '';

      // where = gaUrlUtils.encodeUriQuery (where|| '');
      var promise = $http.post(
        '/services/{portalid}/query/' + fids + '/pmultidata?f=json' +
          '&crs=' + mapCrs + '&page=' + page + '&count=' + count,
        where
      );
      promise.then(
        () => {
          // service level logic if any
        },
        (result) => {
          gcRestrictionProvider.showDetailsErrorMessage(result);
        }
      );
      return promise;
    }


    /**
     * Function: popupdata
     */
    function popupdata(senddata) {
      return $http.post(
        '/services/{portalid}/query/data/popup?f=json',
        senddata
      );
    }


    /**
     * Function: relation
     */
    function relation(fid, namerelation, idobject, where, ogcobjectid,
      relationogcid,srid) {
      if (relationogcid == undefined) relationogcid = -1;

      var promise = $http.get(
        '/services/{portalid}/query/' + fid + '/relation/' + idobject +
          '?f=json' + '&fid=' + fid + '&namerelation=' + namerelation +
        '&idobject=' + idobject + '&where=' + where +
        '&ogcobjectid=' + ogcobjectid +
        '&relationogcid=' + relationogcid + '&srid=' + srid
      );
      promise.then( (res) => {
        if (res.data && res.data.etat === 'erreur') {
          require('toastr').error($filter('translate')(res.data.errorList[0].message_kis));
        }
      });
      return promise;
    }


    /**
     * Function: relation
     */
    function relationReprojected(fid, namerelation, idobject, where, crs) {
      return $http.get(
        '/services/{portalid}/query/' + fid + '/relationReprojected/'
        + idobject + '?f=json' + '&fid=' + fid
        + '&namerelation=' + namerelation + '&idobject=' + idobject
        + '&where=' + where + '&dstcrs=' + crs
      );
    }


    /**
     * Function: dataattribute
     * @param where clause where qui sera passer dans la requete
     */
    function dataattribute(fid, attribute, where) {
      if (!where) where = '';
      if (typeof queryAndroid !== 'undefined') {
        var defer = $q.defer();
        var response = {
          data: queryAndroid.dataattribute(fid, attribute),
        };
        // console.log(response.data);

        if (response.data) response.data = JSON.parse(response.data);
        defer.resolve(response);
        return defer.promise;
      } else {
        return $http.get(
            '/services/{portalid}/query/' +
            fid +
            '/data/attribute?f=json' +
            '&attribute=' +
            attribute +
            '&where=' +
            where
        ).catch(error => {
          if (typeof error.data === 'object' && error.data !== null) {
            if (error.data.hasOwnProperty('message')) {
              require('toastr').error($filter('translate')(error.data.message));
            }
            if (Array.isArray(error.data.details) && error.data.details.length > 0) {
              console.error('dataattribute : ' + error.data.details[0]);
            }
          }
        });
      }
    }
    /**
     * Function: dataattribute
     */
    function dataattributeCorrectedDate(fid, attribute, where) {
      if (!where) where = '';
      if (typeof queryAndroid !== 'undefined') {
        var defer = $q.defer();
        var response = {
          data: queryAndroid.dataattribute(fid, attribute),
        };
        // console.log(response.data);

        if (response.data) response.data = JSON.parse(response.data);
        defer.resolve(response);
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/query/' +
            fid +
            '/data/attribute/corrected?f=json' +
            '&attribute=' +
            attribute +
            '&where=' +
            where
        );
        return promise;
      }
    }
    /**
     * Function: datamultiquery
     */
    function datamultiquery(senddata, fid) {
      var promise = $http.post(
        '/services/{portalid}/query/' + fid + '/data/multiquery?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Extract id value from id string which looks like "featuretypename.X"
     * where X is the identifier value.
     */
    function getFeatureId(feature) {
      var indPt;

      // -- If widget state is "insert" then there is no object identifier.
      if (feature.id == undefined) return null;
      indPt = ('' + feature.id).indexOf('.');
      if (indPt == -1) return parseInt(feature.id);
      else return parseInt(feature.id.substr(indPt + 1));
    }

    /**
     * Extract name value from id string which looks like "featuretypename.X"
     * where featuretypename is the feature type name.
     */
    function getFeatureName(feature) {
      var indPt;

      // -- If widget state is "insert" then there is no object identifier.
      if (feature == undefined || feature.id == undefined) return null;
      indPt = feature.id.indexOf('.');
      if (indPt == -1) return feature.id;
      else return feature.id.substr(0, indPt);
    }

    function getAttachementAndroid(documentId, ftiname, id) {
      var defer = $q.defer();
      var int = createDefer(defer);
      ancAppAndroid.getAttachement(documentId, ftiname, id, int);
      return defer.promise;
    }

    function getObjectId(obj, fti) {
      if (obj && obj.id && fti && fti.uid) {
        const response = $filter('translate')('features.' + fti.name + '.alias');
        if (!fti.showFid) return response;

        // si esri, on défini attributeFid en fonction de esriIdField

        let attributeFid = fti.attributeFid;
        if (fti.type === 'esri') {
          if (fti.useDifferentFID) {
            attributeFid = fti.attributeFid ? fti.attributeFid : (fti.esriIdField !== null && fti.esriIdField
            !== undefined ? fti.esriIdField : 'objectid');
          } else {
            attributeFid = fti.esriIdField !== null && fti.esriIdField !== undefined ? fti.esriIdField : 'objectid';
          }
        }


        if (fti.showFid && !fti.useDifferentFID) {
          if (fti.type === 'esri' && fti.esriIdField !== 'objectid') {
            const idValue = obj.properties[attributeFid] ? obj.properties[attributeFid] : '';
            return response + ' ' + idValue;
          }else {
            return response + ' ' + obj.id.replace(fti.name + '.', '');
          }
        }

        if (fti.showFid && fti.useDifferentFID) {
          if (attributeFid) {
            const attributeFidValue = obj.properties[attributeFid];
            return attributeFidValue && angular.isDefined(attributeFidValue)
              ? response + ' ' + attributeFidValue
              : response;
          } else {
            return (
              $filter('translate')('model.featuretypes.fid.conferror') +
              ' ' +
              $filter('translate')('features.' + fti.name + '.alias')
            );
          }
        }

        return (
          $filter('translate')('model.featuretypes.fid.conferror') +
          ' ' +
          $filter('translate')('features.' + fti.name + '.alias')
        );
      } else if ((!obj || !obj.id) && fti && fti.uid) {
        return $filter('translate')('features.' + fti.name + '.alias');
      } else if (obj && obj.id && (!fti || !fti.uid)) {
        return obj.id.replace('.', ' ');
      } else {
        return $filter('translate')('model.featuretypes.fid.unknownObject');
      }
    }

    /**
     * Function: listFichSQL
     */
    function listFichSQL() {
      var promise = $http.post(
        '/services/{portalid}/query/data/listFichSQL?f=json'
      );
      return promise;
    }
    /** ** affiche requet** */
    function afficherequet(nomDir, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/afficherequet?f=json' +
          '&nomDir=' +
          nomDir +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }
    /***************************************************************************
     * Permet de mettre a jour un fichier sql
     **************************************************************************/
    function MAJFichSQL(requete, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/MAJFichSQL?f=json' +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget,
        requete
      );
      return promise;
    }
    /***************************************************************************
     * Permet de créer un fichier sql
     **************************************************************************/
    function createFichSQL(requete, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/createFichSQL?f=json' +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget,
        requete
      );
      return promise;
    }

    /***************************************************************************
     * remove fichier sql
     **************************************************************************/

    function removeRequete(newRequeteNameFile, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/removeRequete?f=json' +
          '&newRequeteNameFile=' +
          newRequeteNameFile +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }

    /***************************************************************************
     * Function: execute d'un fichier sql
     **************************************************************************/
    function executFichSQL(storeName, senddata, test) {
      var promise = $http.post(
        '/services/{portalid}/query/data/executFichSQL?f=json' +
          '&storeName=' +
          storeName +
          '&test=' +
          test,
        senddata
      );
      return promise;
    }

    function executeAdvancedFilters(filters, db, test=false) {
      var promise = $http.post(
        '/services/{portalid}/query/data/executeFiltresAvancesQuery?f=json' +
          `&storeName=${db}` +
          `&test=${test}`,
        filters
      );
      return promise;
    }

    function getFilterCategories(nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/getFilterCategories?f=json' +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }

    function addCategorie(titreCat, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/addCategorie?f=json' +
          '&titreCat=' +
          titreCat +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }
    function removeCategorie(uidCategorie, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/removeCategorie?f=json' +
          '&uidCategorie=' +
          uidCategorie +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }

    function editCategorie(nameCategorie, uidCategorie, nomApp, idWidget) {
      var promise = $http.post(
        '/services/{portalid}/query/data/editCategorie?f=json' +
          '&nameCategorie=' +
          nameCategorie +
          '&uidCategorie=' +
          uidCategorie +
          '&nomApp=' +
          nomApp +
          '&idWidget=' +
          idWidget
      );
      return promise;
    }

    function getAllFeatureTypeInfo() {
      var promise = $http.post(
        '/services/{portalid}/query/data/getAllFeatureTypeInfo?f=json'
      );
      return promise;
    }
    function getFeatureByNameAndTable(table) {
      var promise = $http.post(
        '/services/{portalid}/query/data/getFeatureByNameAndTable?f=json' +
          '&table=' +
          table
      );
      return promise;
    }

    /**
     * Function: objectsWithGeomRelation
     *
     * geomRelation: pour l'instant testé uniquement avec WITHIN.
     */
    function objectsWithGeomRelation(
      ftiToLookFor,
      container,
      geomRelation,
      containerSrid
    ) {
      var promise = $http.post(
        '/services/{portalid}/query/objectsWithGeomRelation?f=json' +
          '&fti=' +
          ftiToLookFor +
          '&geomrelation=' +
          geomRelation +
          '&containersrid=' +
          containerSrid,
        container
      );
      return promise;
    }

    function getCount(postdata) {
      return $http.post('/services/{portalid}/query/getCount?f=json', postdata);
    }

    /**
     * Récupère un tableau d'attributs triés par attributeLabel asc
     * Utilisée pour récupérer les tables de restriction
     * @param fid uid du composant ciblé
     * @param attributeLabel attribut à récupérer correspondant au libellé
     * @param attributeKey attribut à récupérer correspondant au code
     * @param whereClause clause where qui sera passer dans la requete
     * @returns {Promise} contenant un geojson où le tableau de features est la liste d'attributs
     * @see attributeRestrictions.selectRestrictedValue
     */
    function dataattributes(fid, attributeLabel, attributeKey, whereClause) {
      if (!whereClause) whereClause = '';
      if (!attributeLabel) attributeLabel = '';
      if (!attributeKey) attributeKey = '';
      if (typeof queryAndroid !== 'undefined') {
        const defer = $q.defer();
        const response = {
          data: queryAndroid.dataattributes(fid, attributeLabel, attributeKey),
        };
        if (response.data){
          response.data = JSON.parse(response.data);
        }
        defer.resolve(response);
        return defer.promise;
      } else {
        return $http.get(
          '/services/{portalid}/query/' +
            fid +
            '/data/attributes?f=json' +
            '&attributeLabel=' +
            attributeLabel +
            '&attributeKey=' +
            attributeKey +
            '&whereClause=' +
            whereClause
        );
      }
    }


    /**
     * Appel api pour récupérer des données dans un thread parallèle
     * Méthode équivalente à data avec utilisation d'un thread parallèle
     * @param fid uid du fti
     * @param where clause/filtre de la requête
     * @param mapCrs éventuelle projection saisie par l'utilisateur
     * @param page éventuel numéro de la page souhaitée
     * @param count éventuel nombre d'enregistrements souhaités
     * @param sort éventuel tri des enregistrement souhaité
     * @return {*} Promise contenant un tableau de features geojson
     * @see data
     * méthode analogue qui a inspiré la rédaction
     */
    function dataByThread(fid, where, mapCrs, page, count, sort) {
      const defer = $q.defer();
      if (mapCrs === undefined){mapCrs = '';}
      if (page === undefined){page = '';}
      if (count === undefined){count = '';}
      if (sort === undefined){sort = '';}

      if (typeof queryAndroid !== 'undefined') {
        const int = createDefer(defer);
        queryAndroid.data(fid, where, page, count, sort, int);
        return defer.promise;
      } else {
        const postdata = {
          filter: where,
          page: page + '',
          count: count + '',
          sort: sort + '',
          mapCrs: mapCrs + '',
        };

        const promise = $http.post(
          '/services/{portalid}/query/' + fid + '/dataByThread?f=json',
          postdata
        );
        promise.then(
          () => {
            // logique
          },
          (error) => {
            gcRestrictionProvider.showDetailsErrorMessage(error);
          }
        );
        return promise;
      }
    }

    /**
     * Récupère le status du processus d'export CSV
     * Utilisé depuis la page d'admin d'un composant
     * @param process processus d'export de fichier
     * @return {Promise} contenant le processus
     */
    function getDataProgression(process) {
      return $http.post(
        '/services/{portalid}/query/getDataProgression?', process
      );
    }


    /**
     *
     * @param {*} ftid uid of the component of the feature. 'fti.uid'
     *             do not use 'attribute.restrictions[0].ftid'
     * @param {*} attributeName
     * @param {*} value
     * @param whereClause
     * @returns an object like { key: "myKey" }. you will get your key in res.data.key
     */
    function getKeyRestrictionTable(ftid, attributeName, value, whereClause) {
      if (typeof queryAndroid !== 'undefined') {
        const defer = $q.defer();
        const response = {
          data: queryAndroid.getKeyRestrictionTable(ftid, attributeName, value),
        };
        if (response.data){
          response.data = JSON.parse(response.data);
        }
        defer.resolve(response);
        return defer.promise;
      } else {
        return $http.get(
          '/services/{portalid}/query/' +
            ftid +
            '/data/getKeyRestrictionTable?f=json' +
            '&attributeName=' +
            (attributeName ? attributeName : null) +
            '&value=' +
            // undefined = "undefined" in Java. it's better to send null.
            (value ? value : null) +
            '&filterCompleted=' + whereClause
        );
      }
    }


    // Je mets seulement 5 seconde de cache car je veux éviter les problèmes de mauvaise
    // valeurs en cache, le but étant juste d'optimiser le chargement d'une liste (gcDatatable ou autre)
    let cacheTableRestrictionValues = [];
    /**
     * @param {string} ftid uid of the component of the feature. 'fti.uid'
     *             do not use 'attribute.restrictions[0].ftid'
     * @param {string} attributeName
     * @param {string} key
     * @returns an object like { value: "myValue" }. you will get your value in res.data.value
     */
    function getValueRestrictionTable(ftid, attributeName, key) {
      if (typeof queryAndroid !== 'undefined') {
        const defer = $q.defer();
        const response = {
          data: queryAndroid.getValueRestrictionTable(ftid, attributeName, key),
        };
        if (response.data){
          response.data = JSON.parse(response.data);
        }
        defer.resolve(response);
        return defer.promise;
      } else {
        //get value in cache if possible
        //remove all cache values older than 5 seconds
        cacheTableRestrictionValues = cacheTableRestrictionValues.filter(it => it.timestamp + 5000 > Date.now());
        const valueObject = cacheTableRestrictionValues.find( it =>
            it.ftid === ftid 
            && it.attributeName === attributeName
            && it.key === key);
        if (valueObject && valueObject.promise) {
          return valueObject.promise
        } else {
          // value is not in cache
          const promise = $http.get(
            '/services/{portalid}/query/' +
              ftid +
              '/data/getValueRestrictionTable?f=json' +
              '&attributeName=' +
              (attributeName ? attributeName : null) +
              '&key=' +
              // undefined = "undefined" in Java. it's better to send null.
              (key ? key : null)
          );
          promise.catch( err => {
            console.error(err.data);
          });

          // cache the promise
          // on retournera la même promesse si on refait la même requete dans les 5 secondes
          cacheTableRestrictionValues.push(
            {
              ftid: ftid,
              attributeName: attributeName,
              key: key,
              promise: promise,
              timestamp: Date.now()
            }
          );

          return promise;
        }
      }
    }


    return {
      Query: Query,
      updateMaintaSave2: updateMaintaSave2,
      get: get,
      data: data,
      pdata: pdata,
      getFeatureId: getFeatureId,
      relation: relation,
      relationReprojected: relationReprojected,
      popupdata: popupdata,
      getFeatureName: getFeatureName,
      datamultiquery: datamultiquery,
      dataattribute: dataattribute,
      dataattributeCorrectedDate: dataattributeCorrectedDate,
      pmultidata: pmultidata,
      dataResultAndroid: dataResultAndroid,
      getAttachementAndroid: getAttachementAndroid,
      getObjectId: getObjectId,
      listFichSQL: listFichSQL,
      afficherequet: afficherequet,
      MAJFichSQL: MAJFichSQL,
      createFichSQL: createFichSQL,
      executFichSQL: executFichSQL,
      executeAdvancedFilters: executeAdvancedFilters,
      getFilterCategories: getFilterCategories,
      addCategorie: addCategorie,
      removeCategorie: removeCategorie,
      removeRequete: removeRequete,
      editCategorie: editCategorie,
      getAllFeatureTypeInfo: getAllFeatureTypeInfo,
      getFeatureByNameAndTable: getFeatureByNameAndTable,
      objectsWithGeomRelation: objectsWithGeomRelation,
      getCount: getCount,
      dataattributes: dataattributes,
      getKeyRestrictionTable: getKeyRestrictionTable,
      getValueRestrictionTable: getValueRestrictionTable,
      dataByThread: dataByThread,
      getDataProgression: getDataProgression
    };
  };

  QueryFactory.$inject = ['$http','$filter','gcRestrictionProvider','$q'];
  return QueryFactory;
});
