'use strict';

/**
 * @ngdoc overview
 * @name modules.authentication
 * @description
 * authentication module
 */
define([
  'angular',
  'modules/process/services/ProcessFactory',
  'modules/process/controllers/ProcessCtrl',
  'modules/process/controllers/GeopackageCtrl',
  'modules/process/controllers/DocxCtrl',
], function(angular, ProcessFactory, ProcessCtrl, GeopackageCtrl, DocxCtrl) {
  // Module
  var mod = angular.module('process', ['ngRoute']);

  // Services
  mod.factory('processFactory', ProcessFactory);

  // Controllers
  mod.controller('ProcessCtrl', ProcessCtrl);
  mod.controller('GeopackageCtrl', GeopackageCtrl);
  mod.controller('DocxCtrl', DocxCtrl);

  mod.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/process/', {
        templateUrl: 'js/XG/modules/process/views/process.html',
        controller: ProcessCtrl,
      });
      $routeProvider.when('/geopackage/', {
        templateUrl: 'js/XG/modules/process/views/geopackage.html',
        controller: GeopackageCtrl,
      });
      $routeProvider.when('/docxprocess/', {
        templateUrl: 'js/XG/modules/process/views/geopackage.html',
        controller: DocxCtrl,
      });
    },
  ]);

  return mod;
});
