/**
 *
 */
'use strict';
if (
  !define(function() {
    /**
     * Builder Ctrl
     * @param $scope
     * @constructor
     * @param $rootScope
     * @param ngDialog
     * @param ApplicationFactory
     * @param ConfigFactory
     * @param $filter
     * @param FeatureTypeFactory
     */
    var ProcessCtrl = function(
      $scope,
      processFactory,
      $rootScope,
      ngDialog,
      $filter,
      gaDomUtils,
      $location,
      gaUrlUtils
    ) {
      var TYPE = 'mbtiles';
      processFactory.getProcessByType(TYPE).then(function(res) {
        $scope.currentResources = res.data;
      });

      $scope.refreshList = function() {
        gaDomUtils.showGlobalLoader();
        processFactory.getProcessByType(TYPE).then(
          function(res) {
            $scope.currentResources = res.data;
            gaDomUtils.hideGlobalLoader();
          },
          function() {
            gaDomUtils.hideGlobalLoader();
          }
        );
      };

      $scope.checkLicenceCorrecte = function() {
        processFactory.CheckLicenceUploaded().then(
          function(res) {
            if (res.data === 'true') {
              processFactory.validerLicence().then(
                function(res) {
                  processFactory.reloadRepository().then(
                    function(res) {
                      processFactory.getAllLicences().then(function(res) {
                        $scope.currentResources = [
                          processFactory.getLicence($rootScope.xgos.portal.uid),
                        ];
                        if (
                          processFactory.getLicence(
                            $rootScope.xgos.portal.uid
                          ) &&
                          processFactory.getLicence($rootScope.xgos.portal.uid)
                            .type !== 'free'
                        )
                          processFactory.checkLicence(
                            processFactory.getLicence(
                              $rootScope.xgos.portal.uid
                            )
                          );
                        $scope.tableParams.reload();
                      });
                    },
                    function() {
                      console.error('erreur de reload');
                    }
                  );
                },
                function() {
                  console.error('erreur de copy');
                }
              );
            } else {
              require('toastr').error(
                $filter('translate')('process.process.processnotavailabe')
              );
            }
          },
          function() {
            require('toastr').error(
              $filter('translate')('process.process.processnotavailabe')
            );
          }
        );
      };

      $scope.showInfo = function() {
        ngDialog.open({
          template: 'js/XG/modules/process/views/info.process.html',
          className: 'ngdialog-theme-plain  width400 height50 miniclose',
          closeByDocument: false,
          scope: $scope,
        });
      };

      $scope.deleteProcess = function() {
        processFactory.deleteProcess($scope.edit_resource).then(
          function(res) {
            var index;
            for (var i = 0; i < $scope.currentResources.length; i++) {
              if ($scope.currentResources[i].uid === $scope.edit_resource.uid) {
                index = i;
                break;
              }
            }
            $scope.currentResources.splice(index, 1);
          },
          function() {
            require('toastr').error(
              $filter('translate')('process.process.processnotavailabe')
            );
          }
        );
      };

      $scope.getQrCode = function() {
        var mobhost =
          $location.protocol() +
          '://' +
          $location.host() +
          ':' +
          $location.port();
        var appname = localStorage.getItem('app');
        if ($location.search().app) {
          appname = $location.search().app;
        }
        $scope.mobqrcode =
          '/services/' +
          $rootScope.xgos.portal.uid +
          '/process/qrcode?name=' +
          appname +
          '&token=' +
          gaUrlUtils.encodeUriQuery(localStorage.getItem('auth_token')) +
          '&url=' +
          mobhost +
          '&uid=' +
          $scope.edit_resource.uid;
        $scope.titleqrcode =
          $filter('translate')('process.process.qrmbtiles') +
          ' ' +
          $scope.edit_resource.file;
        ngDialog.open({
          template: 'js/XG/widgets/mapapp/main/views/barecode.html',
          className: 'ngdialog-theme-plain width300 miniclose',
          closeByDocument: false,
          scope: $scope,
        });
      };

      $scope.getFile = function() {
        if ($scope.edit_resource.type.split('/').length === 1)
          window.open(
            '/services/' +
              $rootScope.xgos.portal.uid +
              '/mbtiles/getFile?f=json&uid=' +
              $scope.edit_resource.uid +
              '&etat=' +
              $scope.edit_resource.etat +
              '&file=' +
              $scope.edit_resource.file +
              '&type=' +
              $scope.edit_resource.type +
              '&token=' +
              encodeURIComponent(localStorage.getItem('auth_token'))
          );
        else {
          window.open(
            '/services/' +
              $rootScope.xgos.portal.uid +
              '/geopackage/getZipFile?f=json&uid=' +
              $scope.edit_resource.uid +
              '&etat=' +
              $scope.edit_resource.etat +
              '&file=' +
              $scope.edit_resource.file +
              '&type=mbtiles&token=' +
              encodeURIComponent(localStorage.getItem('auth_token'))
          );
        }
      };

      $scope.editListCfg = {
        dataModule: 'process',
        resource_type: 'process',
        cols: [
          'uid',
          'etat',
          'progress',
          'file',
          'user',
          'creation',
          'end',
          'total',
          'minZoom',
          'maxZoom',
          'taillembtiles' /* , "both" */,
        ],
        removeFunction: $scope.deleteProcess,
        editFunction: $scope.showInfo,
        addResourceButton: false,
        colsFunction: {
          both: 'booleanToCheck',
          creation: 'datetypetoparse',
          end: 'datetypetoparse',
        },
        extraGlobalActions: [
          {
            icon: "<i class='fa fa-refresh'></i>",
            label: 'common.featuretypes.refresh',
            fn: $scope.refreshList,
          },
        ],
        extraActions: [
          {
            icon: "<i class='fa fa-qrcode'></i>",
            label: 'common.featuretypes.refresh',
            fn: $scope.getQrCode,
            disableCondition: 'download',
          },
          {
            icon: "<i class='fa fa-download'></i>",
            label: 'common.featuretypes.refresh',
            fn: $scope.getFile,
            disableCondition: 'download',
          },
        ],
      };
    };

    ProcessCtrl.$inject = [
      '$scope',
      'processFactory',
      '$rootScope',
      'ngDialog',
      '$filter',
      'gaDomUtils',
      '$location',
      'gaUrlUtils',
    ];
    return ProcessCtrl;
  })
) {
}
