'use strict';
define(function() {
  var ModelGUICtrl = function($scope, PrintModelFactory, SharedFactory,
    $timeout, $window, $http,ConfigFactory, $rootScope, ngDialog) {
    /**
     INIT
      */

    PrintModelFactory.setTextBlockName('');
    $scope.currentJsonModel = { elements: [] };
    $scope.drawMgr = {};

    let image = new Image(),
      imageEurope = new Image();
    image.src = 'img/common/map_4_printfish.png';
    imageEurope.src = 'img/common/map_europe.png';
    image.onload = function() {
      $scope.bmpWorld = new createjs.Bitmap(image);
    };
    imageEurope.onload = function() {
      $scope.bmpEurope = new createjs.Bitmap(imageEurope);
    };
    PrintModelFactory.get().then(function(res) {
      $scope.configPrint = res.data;
    });

    $scope.gridMgr = {};

    $scope.selectMgr = {
      currentlySelected: null,
    };

    /** Resets the selection**/
    $scope.selectMgr.resetSelection = function() {
      if (!angular.isUndefined($scope.currentJsonModel.elements))
        for (var i = 0; i < $scope.currentJsonModel.elements.length; i++) {
          $scope.currentJsonModel.elements[i].$selected = false;
        }
      $scope.selectMgr.currentlySelected = null;
    };

    /** PAGE **/
    $scope.pageMgr = {
      activePage: {
        pageSize: '',
        landscape: '',
        w: '',
        h: '',
        data: {},
      },
    };

    $scope.pageMgr.feattree = {};
    $scope.pageMgr.my_tree_handler = function(branch) {
      if (branch.label == 'page') {
      }
    };

    $scope.pageMgr.readJsonModel = function() {
      if (!angular.isUndefined($scope.currentJsonModel.elements))
        if ($scope.currentJsonModel.elements.length != 0) {
          $scope.currentJsonModel.elements.forEach((element) => {
            if ($scope.pageMgr.ispage(element.id)) {
              $scope.selectMgr.addpageinTree(element);
              $timeout(function() {
                $scope.pageMgr.refresh(element);
              }, 750);
            }
          });

          $scope.currentJsonModel.elements.forEach((element) => {
            if (!$scope.pageMgr.ispage(element.id)) {
              $scope.selectMgr.addelinTree(element);
            }
          });
        }
    };

    $scope.pageMgr.featdata = [
      {
        label: 'Modele',
        children: [],
        expanded: true,
        onSelect: $scope.selectMgr.resetSelection,
      },
    ];
    $scope.pageMgr.readJsonModel();

    const redrawElements = () => {
      $scope.currentJsonModel.elements.forEach((element) => {
        if ($scope.pageMgr.getpage(element.id) === $scope.pageMgr.activePage.id)
        {
          $scope.drawMgr.redraw(element);
        }
      });
    };


    $scope.redrawCanvas = function() {
      if (
        $scope.configPrint == undefined ||
        $scope.configPrint.prLeftMargin == undefined
      ) {
        $timeout(function() {
          $scope.redrawCanvas();
        }, 500);
        return;
      }

      $scope.drawMgr.stage.canvas.width -=
        (($scope.configPrint.prLeftMargin + $scope.configPrint.prRightMargin) /
          2.54) *
        72;
      $scope.drawMgr.stage.canvas.height -=
        (($scope.configPrint.prTopMargin + $scope.configPrint.prBottomMargin) /
          2.54) *
        72;
      redrawElements();
    };

    $scope.setPageSize = function(width, height, canvasWidth, canvasHeight) {
      if ($scope.pageMgr.activePage.data.landscape == 'true') {
        if (width > height) {
          $scope.drawMgr.stage.canvas.width = width;
          $scope.drawMgr.stage.canvas.height = height;
        } else {
          $scope.drawMgr.stage.canvas.width = height;
          $scope.drawMgr.stage.canvas.height = width;
        }

        $scope.drawMgr.stage.canvas.style.maxHeight = canvasHeight + 'px';
        $scope.drawMgr.stage.canvas.style.maxWidth = canvasWidth + 'px';
      } else {
        if (height > width) {
          $scope.drawMgr.stage.canvas.width = width;
          $scope.drawMgr.stage.canvas.height = height;
        } else {
          $scope.drawMgr.stage.canvas.width = height;
          $scope.drawMgr.stage.canvas.height = width;
        }

        $scope.drawMgr.stage.canvas.style.maxHeight = canvasWidth + 'px';
        $scope.drawMgr.stage.canvas.style.maxWidth = canvasHeight + 'px';
      }
      if ($scope.configPrint == undefined)
        PrintModelFactory.get().then(function(res) {
          $scope.configPrint = res.data;
          $scope.redrawCanvas();
        });
      else $scope.redrawCanvas();
    };

    $scope.setPageSizeFromExtraFmt = function(fmts, canvasWidth, canvasHeight) {
      var iFmt, w, h;
      for (iFmt = 0; iFmt < fmts.length; iFmt++) {
        if (fmts[iFmt].name == $scope.pageMgr.activePage.data.pageSize) {
          w = Math.round((fmts[iFmt].width * 72) / 25.4, 0);
          h = Math.round((fmts[iFmt].height * 72) / 25.4, 0);
          $scope.setPageSize(w, h, canvasWidth, canvasHeight);
          break;
        }
      }
      if (iFmt == fmts.length) {
        for (iFmt = 0; iFmt < fmts.length; iFmt++) {
          w = Math.round((fmts[iFmt].width * 72.0) / 25.4);
          h = Math.round((fmts[iFmt].height * 72.0) / 25.4);
          if ('' + w + ' ' + h == $scope.pageMgr.activePage.data.pageSize) {
            $scope.pageMgr.activePage.data.pageSize = fmts[iFmt].name;
            $scope.setPageSize(
              fmts[iFmt].width,
              fmts[iFmt].height,
              canvasWidth,
              canvasHeight
            );
            break;
          }
        }
      }
    };

    $scope.pageMgr.refresh = function(block) {
      var maxiHeight = Math.round(($window.innerHeight * 3) / 5);
      var canvasHeight = 520;

      if (maxiHeight < canvasHeight) {
        canvasHeight = maxiHeight;
      }

      var canvasWidth = Math.round((canvasHeight * 750) / 520);
      console.log('hello');
      if (
        angular.isUndefined($scope.drawMgr.stage) ||
        angular.isUndefined($scope.drawMgr.stage.canvas)
      )
        //angular.isUndefined($scope.drawMgr.stage) || )
        $scope.drawMgr.stage = new createjs.Stage('myCan');

      if (!$scope.drawMgr.stage.canvas) return;

      // Pointer cursor when overmouse rect
      $scope.drawMgr.stage.cursor = 'pointer';
      $scope.drawMgr.stage.enableMouseOver();

      $scope.pageMgr.activePage = block;
      switch ($scope.pageMgr.activePage.data.pageSize) {
        case 'A0':
          $scope.setPageSize(3371, 2383, canvasWidth, canvasHeight);
          break;
        case 'A1':
          $scope.setPageSize(2383, 1685, canvasWidth, canvasHeight);
          break;
        case 'A2':
          $scope.setPageSize(1685, 1190, canvasWidth, canvasHeight);
          break;
        case 'A3':
          $scope.setPageSize(1190, 842, canvasWidth, canvasHeight);
          break;
        case 'A4':
          $scope.setPageSize(842, 595, canvasWidth, canvasHeight);
          break;
        case 'A5':
          $scope.setPageSize(595, 421);
          break;
        default:
          ConfigFactory.get('print', 'formats', 'kis_home').then(function(res) {
            let fmts;
            if (res.data) {
              fmts = res.data;
              $scope.extraFormats = res.data;
            } else fmts = [];
            $scope.setPageSizeFromExtraFmt(fmts, canvasWidth, canvasHeight);
          });
          break;
      }
      redrawElements();
    };

    function isPageElementAdded() {
      if (!angular.isUndefined($scope.currentJsonModel.elements)) {
        for (var i = 0; i < $scope.currentJsonModel.elements.length; i++) {
          var elem = $scope.currentJsonModel.elements[i];
          if (elem.type == 'pageBlock') {
            return true;
          }
        }
      }

      return false;
    }

    $scope.pageMgr.variableExists = function(variableName) {
      if (!angular.isUndefined($scope.currentJsonModel.elements)) {
        for (var i = 0; i < $scope.currentJsonModel.elements.length; i++) {
          var elem = $scope.currentJsonModel.elements[i];
          if (elem.type == 'textBlock') {
            if (elem.data.text.indexOf('{' + variableName + '}') != -1)
              return true;
          }
        }
      }
      return false;
    };

    $scope.pageMgr.newpage = function() {
      // Gestion de abn-treeview sur le treeset

      if (!isPageElementAdded()) {
        var newblock = {
          label: 'page',
          onSelect: function() {
            if (this.element.$selected == true) {
              this.element.$selected = false;
              $scope.selectMgr.currentlySelected = null;
            } else {
              for (
                var i = 0;
                i < $scope.currentJsonModel.elements.length;
                i++
              ) {
                $scope.currentJsonModel.elements[i].$selected = false;
              }
              this.element.$selected = true;
              $scope.selectMgr.currentlySelected = this.element;

              $scope.pageMgr.activePage = this.element;
            }
            $scope.pageMgr.refresh($scope.pageMgr.activePage);
          },
          element: {
            type: 'pageBlock',
            render: {
              w: '',
              h: '',
            },
            id: $scope.selectMgr.nextId(),
            data: {
              pageSize: 'A4',
              landscape: 'true',
              rotation: 'true',
            },
          },
          children: [],
          expanded: true,
        };

        if (angular.isUndefined($scope.currentJsonModel.elements))
          $scope.currentJsonModel.elements = [];

        $scope.currentJsonModel.elements.push(newblock.element);
        $scope.pageMgr.featdata[0].children.push(newblock);
      }
    };

    $scope.pageMgr.ispage = function(id) {
      if (
        !angular.isUndefined($scope.currentJsonModel) &&
        !($scope.currentJsonModel === null)
      )
        if (
          !angular.isUndefined($scope.currentJsonModel.elements) &&
          !($scope.currentJsonModel.elements === null)
        ) {
          let ret = false;
          $scope.currentJsonModel.elements.forEach((element) => {
            if (element.id === id && element.type === 'pageBlock') {
              ret = true;
            }
          });
          return ret;
        }
    };

    $scope.pageMgr.getpage = function(id) {
      if ($scope.pageMgr.ispage(id)) return id;
      else {
        for (var i = 0; i < $scope.currentJsonModel.elements.length; i++) {
          var element = $scope.currentJsonModel.elements[i];
          if (element.id == id) return $scope.pageMgr.getpage(element.idParent);
        }
      }
    };

    /** DRAW **/
    $scope.imagesCreated = [];
    $scope.mapsBlocks = [];


    $scope.loadMaps = (image, bmpIn, blockName, rect) => {
      image.onload = () => {
        $scope.bmp = new createjs.Bitmap(image);
        $scope.mapsBlocks.forEach((mapelement) => {
          if (angular.equals(mapelement.type, blockName)) {
            var bmp = bmpIn.clone();
            bmp.x = mapelement[0].data.absoluteX;
            bmp.y = mapelement[0].data.absoluteY;
            bmp.scaleX = mapelement[2] / bmp.image.width;
            bmp.scaleY = mapelement[3] / bmp.image.height;
            bmp.name = rect.name;
            bmp.model = mapelement[0];
            var indexes = [];
            angular.forEach(mapelement[1].children, function(child, i) {
              if (
                child instanceof createjs.Text ||
                child instanceof createjs.Bitmap
              )
                indexes.push(i);
            });
            indexes.map(function(x) {
              mapelement[1].removeChildAt(x);
            });
            mapelement[1].addChildAt(bmp, 0);
            mapelement[1].addChildAt(rect, 1);
            $scope.shapelisteners(mapelement[1]);

            $scope.drawMgr.stage.removeChildAt(mapelement[0].id);

            $scope.drawMgr.stage.addChildAt(mapelement[1], mapelement[0].id);

            $scope.drawMgr.stage.update();
          }
        });
      };
    };

    $scope.drawMgr.redraw = function(element) {
      if (
        $scope.bmpEurope == undefined ||
        $scope.bmpWorld == undefined ||
        $scope.configPrint == undefined
      ) {
        if (!$scope.watingForRedraw)
          $timeout(function() {
            if ($scope.bmpEurope == undefined)
              $scope.bmpEurope = new createjs.Bitmap(imageEurope);
            if ($scope.bmpWorld == undefined)
              $scope.bmpWorld = new createjs.Bitmap(image);
            $scope.drawMgr.redraw(element);
          }, 500);
        return;
      }

      if (!angular.isUndefined(element)) {
        $scope.drawMgr.stage.removeChildAt(element.id);

        var color = !angular.isUndefined(element.render.color)
          ? element.render.color
          : 'red';
        let textcolor = !angular.isUndefined(element.data.fontColor)
        ? element.data.fontColor
        : color;
        var container = new createjs.Container();
        var rect = new createjs.Shape();

        var width = angular.isUndefined(element.render.w)
          ? element.data.width
          : element.render.w;
        var height = angular.isUndefined(element.render.h)
          ? element.data.height
          : element.render.h;

        rect.graphics
          .setStrokeStyle(8, 'round')
          .beginStroke(color)
          .dr(element.data.absoluteX, element.data.absoluteY, width, height);

        rect.name = element.type + ' ' + element.id;
        rect.model = element;

        if (!angular.equals(element.type, 'pageBlock')) {
          var text = new createjs.Text(
            angular.equals(element.type, 'textBlock')
              ? element.data.text || rect.name
              : rect.name,
            (element.data.fontSize ? element.data.fontSize.toString() : '20') +
              'px Arial',
            textcolor
          );
          if (angular.equals(element.type, 'textBlock')) {
            text.x =
              element.data.absoluteX +
              (element.render.w -
                (element.data.text
                  ? (element.data.fontSize * element.data.text.length) / 2
                  : 0)) /
                2;
            text.y =
              element.data.absoluteY +
              (element.render.h -
                (element.data.text ? element.data.fontSize : 0)) /
                2;
          } else {
            text.x = element.data.absoluteX + 10;
            text.y = element.data.absoluteY + 10;
          }
          text.name = rect.name;
          text.model = element;
          container.addChildAt(text, 0);
        }

        if (
          angular.equals(element.type, 'mapBlock') ||
          angular.equals(element.type, 'overviewBlock')
        ) {
          if (image.complete) {
            //$scope.bmp = new createjs.Bitmap(image);
            var bmp;
            /*
                        if ($scope.bmpEurope==undefined)
                            $scope.bmpEurope = new createjs.Bitmap(imageEurope);
                        if ($scope.bmpWorld==undefined)
                            $scope.bmpWorld = new createjs.Bitmap(image);
*/
            if (angular.equals(element.type, 'mapBlock'))
              bmp = $scope.bmpEurope.clone();
            else bmp = $scope.bmpWorld.clone();
            bmp.x = element.data.absoluteX;
            bmp.y = element.data.absoluteY;
            bmp.scaleX = width / bmp.image.width;
            bmp.scaleY = height / bmp.image.height;
            bmp.name = rect.name;
            bmp.model = element;
            var indexes = [];
            angular.forEach(container.children, function(child, i) {
              if (
                child instanceof createjs.Text ||
                child instanceof createjs.Bitmap
              )
                indexes.push(i);
            });
            indexes.map(function(x) {
              container.removeChildAt(x);
            });

            container.addChildAt(bmp, 0);
            container.addChildAt(rect, 1);
            $scope.shapelisteners(container);
            $scope.drawMgr.stage.addChildAt(container, element.id);

            $scope.drawMgr.stage.update();
            return;
          } else {
            $scope.mapsBlocks.push([element, container, width, height]);
            if (angular.equals(element.type, 'mapBlock')) {
              $scope.loadMaps(imageEurope, $scope.bmpEurope, 'mapBlock', rect);
            }
            else {
              $scope.loadMaps(image, $scope.bmpWorld, 'overviewBlock', rect);
            }
          }
        } else if (angular.equals(element.type, 'imgBlock')) {
          var picNames = $scope.imagesCreated.map(function(x) {
            return x.name;
          });
          if (picNames.indexOf(element.data.url) === -1) {
            $scope.imagesCreated.push({
              name: element.data.url,
            });
            if (element.data.url) {
              let urlOrigin = '';
              if (element.data.url.indexOf('http') === -1) {
                urlOrigin = window.location.origin + '/services/'
                  + $rootScope.xgos.portal.uid
                  + '/files/downloadfile?fileName=';
              }
              const elementUrl = new URL(urlOrigin + element.data.url);
              const appUrl = new URL(window.location.href);

              elementUrl.protocol = appUrl.protocol;
              element.data.url = elementUrl.toString();
              $http
                .get(
                  element.data.url.replace(
                    'downloadfile',
                    'getPictureForVisualisation'
                  )
                )
                .then(
                  function(res) {
                    var picNames = $scope.imagesCreated.map(function(x) {
                      return x.name;
                    });
                    if (
                      picNames.indexOf(element.data.url) !== -1 &&
                      !$scope.imagesCreated[picNames.indexOf(element.data.url)]
                        .image
                    ) {
                      var newImage = new Image();
                      newImage.src =
                        'data:' +
                        res.data.mime_type +
                        ';base64, ' +
                        atob(res.data.img);

                      $scope.imagesCreated[
                        picNames.indexOf(element.data.url)
                      ].image = newImage;

                      var bmp = new createjs.Bitmap(newImage);
                      bmp.x = element.data.absoluteX;
                      bmp.y = element.data.absoluteY;
                      bmp.scaleX = width / newImage.width;
                      bmp.scaleY = height / newImage.height;
                      bmp.name = rect.name;
                      bmp.model = element;

                      var indexes = [];
                      angular.forEach(container.children, function(child, i) {
                        if (
                          child instanceof createjs.Text ||
                          child instanceof createjs.Bitmap
                        )
                          indexes.push(i);
                      });
                      indexes.map(function(x) {
                        container.removeChildAt(x);
                      });

                      container.addChildAt(bmp, 0);
                      container.addChildAt(rect, 1);

                      $scope.shapelisteners(container);

                      $scope.drawMgr.stage.removeChildAt(element.id);

                      $scope.drawMgr.stage.addChildAt(container, element.id);

                      $scope.drawMgr.stage.update();
                    }
                  },
                  function() {
                    console.error('no file');
                  }
                );
            }
          } else if (
            $scope.imagesCreated[picNames.indexOf(element.data.url)].image
          ) {
            var newImage =
              $scope.imagesCreated[picNames.indexOf(element.data.url)].image;
            bmp = new createjs.Bitmap(newImage);
            bmp.x = element.data.absoluteX;
            bmp.y = element.data.absoluteY;
            bmp.scaleX = width / newImage.width;
            bmp.scaleY = height / newImage.height;
            bmp.name = rect.name;
            bmp.model = element;
            indexes = [];
            angular.forEach(container.children, function(child, i) {
              if (
                child instanceof createjs.Text ||
                child instanceof createjs.Bitmap
              )
                indexes.push(i);
            });
            indexes.map(function(x) {
              container.removeChildAt(x);
            });
            container.addChildAt(bmp, 0);
            container.addChildAt(rect, 1);
            $scope.shapelisteners(container);
            $scope.drawMgr.stage.addChildAt(container, element.id);

            $scope.drawMgr.stage.update();
            return;
          }
        }

        container.addChildAt(rect, 1);
        $scope.shapelisteners(container);
        $scope.drawMgr.stage.addChildAt(container, element.id);

        $scope.drawMgr.stage.update();
      }
    };

    var dragOffset = {};

    var resizeTolerance = 10;
    var resizeHitPointDistance = 100;
    var minElementHeight = 20;
    var minElementWidth = 20;

    $scope.checkIsSameTextBlock = function(blockname, block) {
      var textdata;
      if (!PrintModelFactory.isSameTextBlock(blockname)) {
        console.log('Same textBlock');
        PrintModelFactory.setTextBlockName(blockname);
        PrintModelFactory.setTextBlockFlag(false);
        if (block.model != undefined) textdata = block.model.data.text;
        else textdata = block.data.text;
        PrintModelFactory.setLastVariablesText(textdata);
      } else {
        console.log('Other textBlock');
        PrintModelFactory.setTextBlockName(blockname);
        PrintModelFactory.setTextBlockFlag(true);
      }
    };

    $scope.shapelisteners = function(shape) {
      shape.on('click', function(evt) {
        $scope.checkIsSameTextBlock(evt.target.name, evt.target);
        selectTargetMenu(evt);
      });

      shape.on('pressmove', function(evt) {
        selectTargetMenu(evt);

        if ($scope.gridMgr.lock) {
          try {
            $scope.$apply(function() {
              var newx = evt.stageX / 5;
              newx = Math.round(newx) * 5;
              var newy = evt.stageY / 5;
              newy = Math.round(newy) * 5;

              if (resizeHitPointDistance > resizeTolerance) {
                shape.getChildAt(1).model.data.absoluteX = newx + dragOffset.x;
                shape.getChildAt(1).model.data.absoluteY = newy + dragOffset.y;
                $scope.drawMgr.stage.update();
              } else {
                var newWidth = newx - shape.getChildAt(1).model.data.absoluteX;
                var newheight = newy - shape.getChildAt(1).model.data.absoluteY;

                if (newWidth > minElementWidth && newheight > minElementHeight) {
                  shape.getChildAt(1).model.render.w = newWidth;
                  shape.getChildAt(1).model.render.h = newheight;
                  $scope.drawMgr.stage.update();
                }
              }
            });
          } catch(err) {}
        } else {
          if (resizeHitPointDistance > resizeTolerance) {
            shape.getChildAt(1).model.data.absoluteX =
              evt.stageX + dragOffset.x;
            shape.getChildAt(1).model.data.absoluteY =
              evt.stageY + dragOffset.y;
            $scope.drawMgr.stage.update();
            $scope.drawMgr.redraw(shape.model);
          } else {
            var newWidth =
              evt.stageX - shape.getChildAt(1).model.data.absoluteX;
            var newheight =
              evt.stageY - shape.getChildAt(1).model.data.absoluteY;

            if (newWidth > minElementWidth && newheight > minElementHeight) {
              shape.getChildAt(1).model.render.w = newWidth;
              shape.getChildAt(1).model.render.h = newheight;
              $scope.drawMgr.stage.update();
              $scope.drawMgr.redraw(shape.model);
            }
          }
          try {
            $scope.$apply();
          } catch(err) {}
        }
      });

      shape.on('mousedown', function(evt) {
        dragOffset = {
          x: shape.getChildAt(1).model.data.absoluteX - evt.stageX,
          y: shape.getChildAt(1).model.data.absoluteY - evt.stageY,
        };

        var shapeWidth = angular.isUndefined(shape.getChildAt(1).model.render.w)
          ? shape.getChildAt(1).model.data.width
          : shape.getChildAt(1).model.render.w;
        var shapeHeight = angular.isUndefined(
          shape.getChildAt(1).model.render.h
        )
          ? shape.getChildAt(1).model.data.height
          : shape.getChildAt(1).model.render.h;

        var floatShapeWidth = parseFloat(shapeWidth);
        var floatShapeHeight = parseFloat(shapeHeight);

        var downRightPointX =
          floatShapeWidth + shape.getChildAt(1).model.data.absoluteX;
        var downRightPointY =
          floatShapeHeight + shape.getChildAt(1).model.data.absoluteY;

        var distX = downRightPointX - evt.stageX;
        var distY = downRightPointY - evt.stageY;

        var powerDistance = Math.pow(distX, 2) + Math.pow(distY, 2);
        resizeHitPointDistance = Math.sqrt(powerDistance);
      });

      shape.on('dblclick', () => {
        $scope.selectMgr.onSelectFunction(shape.getChildAt(1).model.id);
        $scope.drawMgr.stage.update();
      });
    };

    /** SELECT **/
    $scope.selectMgr.nextId = function() {
      var ret;
      var idMax = (ret = -1);
      if (!angular.isUndefined($scope.currentJsonModel.elements))
        $scope.currentJsonModel.elements.forEach((element) => {
          if (element.id > idMax) idMax = element.id;
        });
      ret = idMax + 1;
      return ret;
    };


    PrintModelFactory.getmodel(SharedFactory.modelName).then(function(res) {
      if (res.data != '') {
        $scope.currentJsonModel = res.data;
        $scope.currentJsonModel.name = SharedFactory.modelName;
        $scope.pageMgr.readJsonModel();
      } else {
        var errorMsg = 'Erreur de lecture, veuillez réactualiser la page.';
        require('toastr').error(errorMsg);
      }
    });

    //$scope.currentJsonModel.elements = [];

    $scope.selectMgr.onSelectFunction = function(id) {
      //require('toastr').info("rrr");

      var indexPage;

      var element = undefined;
      if (angular.isObject(id)) {
        element = id.element;
      } else {
        $scope.currentJsonModel.elements.forEach((elt) => {
          if (elt.id == id) element = elt;
        });
      }
      if (angular.isUndefined(element)) return;

      // To rerest select type text of attribute
      if (angular.equals(element.type, 'textBlock')) {
        $scope.$broadcast('printTextBlockEvent');
      }

      if (element.$selected == true) {
        element.$selected = false;
        $scope.selectMgr.currentlySelected = null;
      }
      else {
        for (let i = 0; i < $scope.currentJsonModel.elements.length; i++) {
          $scope.currentJsonModel.elements[i].$selected = false;
        }
        element.$selected = true;
        $scope.selectMgr.currentlySelected = element;
        for (let i = 0; i < $scope.currentJsonModel.elements.length; i++) {
          if (
            $scope.currentJsonModel.elements[i].id ==
            $scope.pageMgr.getpage(element.id)
          )
            indexPage = i;
        }
        $scope.pageMgr.activePage = $scope.currentJsonModel.elements[indexPage];
        $scope.checkIsSameTextBlock(element.label + '_' + element.id, element);
      }
      try {
        $scope.$apply();
      } catch(err) {}
    };

    $scope.selectMgr.addpageinTree = function(page) {
      var newblock = {
        label: 'page',
        onSelect: function() {
          if (this.element.$selected == true) {
            this.element.$selected = false;
            $scope.selectMgr.currentlySelected = null;
          } else {
            for (var i = 0; i < $scope.currentJsonModel.elements.length; i++) {
              $scope.currentJsonModel.elements[i].$selected = false;
            }
            this.element.$selected = true;
            $scope.selectMgr.currentlySelected = this.element;
            $scope.pageMgr.activePage = this.element;
          }
          $scope.pageMgr.refresh($scope.pageMgr.activePage);
        },
        element: page,
        children: [],
      };
      $scope.pageMgr.featdata[0].children.push(newblock);
    };

    $scope.selectMgr.addelinTree = function(block) {
      $scope.pageMgr.featdata[0].children.forEach((element) => {
        if (element.element.id == block.idParent) {
          const object = {
            label: block.label,
            element: block,
          };
          element.children.push(object);
          object.onSelect = $scope.selectMgr.onSelectFunction;
        }
      });
    };

    $scope.selectMgr.add = function(block) {
      block.id = $scope.selectMgr.nextId();
      block.idParent =
        $scope.pageMgr.activePage.id == null
          ? -1
          : $scope.pageMgr.activePage.id;
      block.data.name = block.type + '_' + block.id;

      $scope.currentJsonModel.elements.push(block);
      //Looking for the right branch
      $scope.selectMgr.addelinTree(block);
      $scope.drawMgr.redraw(block);
    };

    function updateIds(elements) {
      if (elements.length > 0) {
        var id = elements[0].id;
        for (var i = 1; i < elements.length; i++) {
          if (elements[i].id - id === 1) {
            id = elements[i].id;
          } else {
            elements[i].id = ++id;
          }
        }
        /*angular.forEach(elements,function(element){
                    element.id = id ? ++id : element.id;
                });*/
        return elements;
      } else {
        return elements;
      }
    }

    $scope.selectMgr.delete = function(id) {
      var ID;
      if (angular.isUndefined(id)) ID = $scope.selectMgr.currentlySelected.id;
      else ID = id;

      if (angular.isUndefined(ID)) {
        require('toastr').error('You must select something to delete it');
        return;
      }

      var pageID = $scope.pageMgr.getpage(ID);

      //Si c'est une page, suppression de tous ses éléments
      if ($scope.pageMgr.ispage(ID)) {
        // Récupération des éléments
        var childArray = [];
        for (let i = 0; i < $scope.currentJsonModel.elements.length; i++) {
          var element = $scope.currentJsonModel.elements[i];
          if (element.idParent == ID) childArray.push(element.id);
        }
        for (let i = 0; i < childArray.length; i++) {
          $scope.selectMgr.delete(childArray[i]);
        }
      }

      // Suppression dans featData : Cas page
      if ($scope.pageMgr.ispage(ID)) {
        var pageindex;
        for (let i = 0; i < $scope.pageMgr.featdata[0].children.length; i++) {
          element = $scope.pageMgr.featdata[0].children[i];
          if (ID == element.element.id) pageindex = i;
        }
        $scope.pageMgr.featdata[0].children.splice(pageindex, 1);
      } else {
        // Suppression dans featData : Cas objet
        for (let i = 0; i < $scope.pageMgr.featdata[0].children.length; i++) {
          element = $scope.pageMgr.featdata[0].children[i];
          if (pageID == element.element.id) {
            //Si c'est la bonne page, parcours des éléments
            var treeindex;
            for (var j = 0; j < element.children.length; j++) {
              var elementinbranch = element.children[j];
              if (elementinbranch.element.id == ID) treeindex = j;
            }
            //Suppression dans featdata
            element.children.splice(treeindex, 1);
          }
        }
      }

      //Récupération de l'index
      var delindex;
      for (let i = 0; i < $scope.currentJsonModel.elements.length; i++) {
        element = $scope.currentJsonModel.elements[i];
        if (element.id == ID) delindex = i;
      }
      //suppression dans currentJsonModel
      $scope.currentJsonModel.elements.splice(delindex, 1);
      //Remise à Null dans la selection
      $scope.selectMgr.currentlySelected = undefined;
      //Suppression dans le dessin
      // $scope.drawMgr.stage.removeChildAt(ID); ***********NOT WORKING : Duplicates entries seemingly randomly
      //QuickHack
      $scope.drawMgr.stage.removeAllChildren();

      $scope.currentJsonModel.elements = updateIds(
        $scope.currentJsonModel.elements
      );

      for (let i = 0; i < $scope.currentJsonModel.elements.length; i++) {
        $scope.drawMgr.redraw($scope.currentJsonModel.elements[i]);
      }
      $scope.drawMgr.stage.update();
    };
    /**
         Validation du formulaire
         */
    $scope.getOtherPageSize = function(pageSize) {
      var iFmt,
        fmts = $scope.extraFormats;
      var w, h;

      for (iFmt = 0; iFmt < fmts.length; iFmt++) {
        if (fmts[iFmt].name == pageSize) {
          w = Math.round((fmts[iFmt].width * 72) / 25.4, 0);
          h = Math.round((fmts[iFmt].height * 72) / 25.4, 0);
          return '' + w + ' ' + h;
        }
      }
    };


    /**
     * Enregistrement du modèle de carte.
     */
    $scope.commit = () => {
      var outputModel = $scope.currentJsonModel;

      updateModelConfigVariables(outputModel);

      PrintModelFactory.resources.configVariables = [];
      for (let i = 0; i < outputModel.elements.length; i++) {
        const data = outputModel.elements[i].data;
        if (outputModel.elements[i].type === 'imgBlock') {
          //-- Ticket 2283: Ne stocker que le nom du fichier image.
          const ind = data.url.indexOf('fileName=');
          if (ind != -1) {
            data.url = data.url.substr(ind+9);
          }
        }
        else if (outputModel.elements[i].type === 'pageBlock') {
          var regexp = new RegExp(/A[0-5]/);
          if (!data.pageSize.match(regexp))
            data.pageSize = $scope.getOtherPageSize(data.pageSize);
        }
        else if (outputModel.elements[i].type === 'legendBlock') {
          data.iconMaxWidth = 20;
          data.iconMaxHeight = 20;
          data.layerSpace = 0;
          data.classIndentation = 0;
          if (data.overflowPolitic == undefined) {
            data.overflowPolitic = 'shrink';
          }
        }
        else if (outputModel.elements[i].type === 'textBlock') {
          let variable;
          const variables = PrintModelFactory.getDollarVariables(data.text);
          for (var ind = 0; ind < variables.length; ind++) {
            variable
              = PrintModelFactory.getNameFromDollarVariable(variables[ind]);
            if (variable && !PrintModelFactory.isReservedVariable(variable)) {
              PrintModelFactory.resources.configVariables.push(
                PrintModelFactory.buildVariable(variable, '')
              );
            }
          }
        }
      }

      //envoi
      PrintModelFactory.update(outputModel).then(function() {
        // Save variables
        PrintModelFactory.updateVariables(
          PrintModelFactory.resources.configVariables,
          outputModel.name
        ).then(function() {
          console.log('Variables are updated');
        });

        $scope.currentJsonModel = null;
        SharedFactory.closeDialog();
      });
    };

    /**
         Annulation du formulaire
         */
    $scope.rollback = function() {
      $scope.currentJsonModel = null;
      SharedFactory.closeDialog();
    };

    /**
     * Fenêtre d'édition en mode JSON
     */
    let debugDialog;
    $scope.debug_json = () => {
      $scope.editConfig = {
        data: angular.copy($scope.currentJsonModel),
        options: {
          mode: 'tree',
        },
      };
      // Bouton de changement mode texte / json
      $scope.jsonEditionChangeMode = () => {
        $scope.editConfig.options.mode = ($scope.editConfig.options.mode === 'code') ? 'tree' : 'code';
      };
      // Bouton sauvegarder
      $scope.applyDebuggedVersion = () => {
        if (confirm($filter('translate')('common.sure_to_apply_modif'))) {
          $scope.currentJsonModel = angular.copy($scope.editConfig.data);
          debugDialog.close();
        }
      };
      // Fenêtre d'édition JSON
      debugDialog = ngDialog.open({
        template:
            'js/XG/widgets/utilities/form/views/modal/modal.form_debug.html',
        className: 'ngdialog-theme-plain width1000 nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.$watch('pageMgr.activePage', function(newp, old) {
      if (newp != old) {
        $scope.pageMgr.refresh(newp);
      }
    });

    var selectTargetMenu = function(evt) {
      var targetShape = evt.target.model;
      if (!targetShape || !targetShape.id) return;
      // Expanded all the menu
      $scope.pageMgr.featdata[0].expanded = true;
      $scope.pageMgr.featdata[0].children[0].expanded = true;

      // Select the target menu
      for (
        var i = 0;
        i < $scope.pageMgr.featdata[0].children[0].children.length;
        i++
      ) {
        var element = $scope.pageMgr.featdata[0].children[0].children[i];

        if (targetShape.id == element.element.id) {
          element.selected = true;
        } else {
          element.selected = false;
        }
        element.expanded = true;
      }

      // Unselect the json elements
      for (i = 0; i < $scope.currentJsonModel.elements.length; i++) {
        $scope.currentJsonModel.elements[i].$selected = false;
      }

      // Select the page if any
      var indexPage;
      $scope.selectMgr.currentlySelected = targetShape;
      for (i = 0; i < $scope.currentJsonModel.elements.length; i++) {
        if (
          $scope.currentJsonModel.elements[i].id ==
          $scope.pageMgr.getpage(targetShape.id)
        )
          indexPage = i;
      }
      $scope.pageMgr.activePage = $scope.currentJsonModel.elements[indexPage];

      // Apply changes
      try {
        $scope.$apply();
      } catch(err) {}
    };

    var updateModelConfigVariables = function(arrayObjIn) {
      if (!arrayObjIn || !arrayObjIn.elements) {
        return;
      }

      // test
      var variables = PrintModelFactory.resources.deletedVariables;
      console.log('tail : ' + JSON.stringify(variables));

      var arrayObj = arrayObjIn.elements;
      console.log('Size = ' + arrayObj.length);
      for (var i = 0; i < arrayObj.length; i++) {
        if (arrayObj[i].data && arrayObj[i].data.text) {
          var text = arrayObj[i].data.text;

          text = replaceVariable(text, variables);

          arrayObj[i].data.text = text;
          console.log('----> : ' + text);
        }
      }
    };

    var replaceVariable = function(text, variables) {
      if (text) {
        var expReg = /\$\{\w*\W*\d*\}/g;
        var array = expReg.exec(text);

        if (array) {
          var targetVar = array[0];

          var index = searchVariableNameInArray(targetVar, variables);

          console.log('Befor : ' + text);
          if (index > -1) {
            text = replaceAll(text, variables[index].key, '');
          }
          console.log('After : ' + text);

          return text;
        }
      }

      return text;
    };

    var searchVariableNameInArray = function(text, arrayObj) {
      var index = -1;

      if (text && arrayObj) {
        text = PrintModelFactory.getNameFromDollarVariable(text);
        for (var i = 0; i < arrayObj.length; i++) {
          if (arrayObj[i].key == text) {
            index = i;
            break;
          }
        }
      }

      return index;
    };

    var replaceAll = function(text, substring, replacement) {
      var result = '';
      var lastIndex = 0;

      substring = '${' + substring + '}';

      while (true) {
        var index = text.indexOf(substring, lastIndex);
        if (index === -1) break;
        result += text.substring(lastIndex, index) + replacement;
        lastIndex = index + substring.length;
      }

      return result + text.substring(lastIndex);
    };

    /**
     *     Fabrique et retourne la liste des blocks dont le "type" est mapBlock.
     *  On a besoin de la liste des cartes pour raatacher l'overview à une carte.
     *   Cette fonction pourra le cas échéant être généaralisée en mettant le type cherché en paramètre.
     */
    /*--xx--
        $scope.getMapBlocks = function ()
        {
        	var blocks = [];
        	var ind, elts;

        	elts = $scope.currentJsonModel.elements;
        	for (ind=0;ind<elts.length;ind++)
        	    {
        	     if (elts[ind].type=="mapBlock")
        	        {
        	          if (elts[ind].data.name==undefined)
        	              elts[ind].data.name = "mapBlock_"+elts[ind].id;
        	          blocks.push(elts[ind]);
        	        }
        	    }

        	return blocks;
        };
        */

    $scope.legStyles = {};
  };

  ModelGUICtrl.$inject = ['$scope', 'PrintModelFactory', 'SharedFactory',
    '$timeout', '$window', '$http', 'ConfigFactory', '$rootScope', 'ngDialog'
  ];

  return ModelGUICtrl;
});
