'use strict';
define(function() {
  var portalSwitcherAvance = function(
    $window,
    $rootScope,
    PortalsFactory,
    ngDialog,
    $timeout,
    UsersFactory
  ) {
    return {
      restrict: 'EA',
      replace: true,
      link: function($scope) {
        $scope.goCreatePortal = () => {
          $window.location.replace('#/supervision/');
          $window.location.reload();
        }

        $scope.displayPortalSwitcher = function() {
          $scope.listPortApp = [];
          PortalsFactory.getPortalAndApps().then(function(resultat) {
            if($scope.xgos.isroot){
              $scope.listPortApp = resultat.data;
            }else{
              $scope.xgos.user.portails.forEach(portail => {
                $scope.listPortApp.push(resultat.data.find(port=>port.uid ==portail.uid));
              });
            }
          });
          $scope.portalSwitcherDialog = ngDialog.open({
            template:
              'js/XG/modules/portals/views/modals/modal.portals.apps.html',
            className:
              'ngdialog ngdialog-overlay ngdialog-theme-plain width1000 ng-scope',
            closeByDocument: false,
            scope: $scope,
            preCloseCallback: function() {
              $scope.searchText = { value: '' };
            },
          });
        };

        $scope.focusMe = () => {
          $timeout(() => {
            document.getElementById('myInput').focus();
          });
        };


        $scope.searchText = { value: '' };
        $scope.search = function(item) {
          // On verifie sur le titre/uid du portail
          var match = false;
          var vCheck = $scope.searchText.value.toLowerCase();

          if (
            item.name.toLowerCase().indexOf(vCheck) != -1 ||
            item.uid.toLowerCase().indexOf(vCheck) != -1
          ) {
            match = true;
          }

          // on verifie si au moins une des applications a un type
          // correspondant au filtre
          var apps = item.applications.applications;
          const resultType = apps.filter(
            app => app.type.toLowerCase().indexOf(vCheck) != -1
          );
          if (resultType && resultType.length) {
            match = true;
          }
          // on verifie si au moins une des applications a un nom
          // correspondant au filtre
          const resultName = apps.filter(
            app => app.name.toLowerCase().indexOf(vCheck) != -1
          );
          if (resultName && resultName.length) {
            match = true;
          }
          return match;
        };

        /**
         * clearLocalStorageChangeUserAndGoTo
         *
         * @param {*}
         *            goto
         */
        var clearLocalStorageChangeUserAndGoTo = function(goto, portalid) {
          const keepStorageItems = ['auth_token', 'gcDataTableCount',
            'kisusertheme'];
          const storage = keepStorageItems.reduce((obj, item) => {
            obj[item] = localStorage.getItem(item);
            return obj;
          }, {});
          // clear localstorage sauf token
          if(!$rootScope.xgos.isroot){
            // si l'utilisateur n'est pas root on va changer l'utilisateur connecter
            UsersFactory.changeConnectedUser(portalid,$rootScope.xgos.user.login).then((res)=> {
              $rootScope.xgos.user = res.data;
              clearLocalStorageAndGoTo(goto,storage);
            });
          } else {
            clearLocalStorageAndGoTo(goto,storage);
          }
        };

        let clearLocalStorageAndGoTo = (goto,storage) => {
          localStorage.clear();
          let filtredlocalStorage = Object.keys(storage).filter(item => storage[item]);
          filtredlocalStorage.forEach(item => {
            localStorage.setItem(item, storage[item]);
          });
          $window.location.replace(goto);
          $window.location.reload();
        };

        /**
         * Permet d'accéder à une application directement
         *
         */
        $scope.goToApplication = function(app, portal) {
          var appTpl = app.type.replace('App', '').toLowerCase();
          clearLocalStorageChangeUserAndGoTo(
            '#/' + appTpl + '?portal=' + portal.uid + '&app=' + app.name, portal.uid
          );
          if ($scope.portalSwitcherDialog) {
            $scope.portalSwitcherDialog.close();
          }
        };

        /**
         * Permet d'accéder à l'administration d'un portail
         */
        $scope.goToPortail = function(portal) {
          clearLocalStorageChangeUserAndGoTo('#/?portal=' + portal.uid, portal.uid);
          if ($scope.portalSwitcherDialog) {
            $scope.portalSwitcherDialog.close();
          }
        };

        $scope.portalsList = [];

        var setDirectivePortal = function() {
          PortalsFactory.resources.portals.forEach(function(p) {
            if ($scope.xgos.portal && p.uid == $scope.xgos.portal.uid) {
              $scope.selectedPortal = p;
            }
          });
        };

        $scope.$watch(
          function() {
            return PortalsFactory.resources;
          },
          function(res) {
            if (typeof res !== 'undefined') {
              $timeout(() => {
                $scope.portalsList = [];
                if($rootScope.xgos.user && $rootScope.xgos.user.portails && !$rootScope.xgos.isroot){
                  let portalsTemp = [];
                  $rootScope.xgos.user.portails.forEach(portail => {
                    const portalOk
                      = res.portals.find(port => port.uid == portail.uid);
                    if (portalOk !== undefined) {
                      portalsTemp.push(portalOk);
                    }
                  });
                  res.portals = portalsTemp;
                }

                res.portals.forEach(function(p) {
                  $scope.portalsList.push({
                    text: p.name,
                    click: 'setPortal(\'' + p.uid + '\')',
                  });
                  setDirectivePortal();
                });
                $scope.portalsList.sort(dynamicSort('text'));
              },20);
            }
          },
          1
        );

        $scope.$watch(
          'xgos.portal',
          function(portal) {
            setDirectivePortal();
          },
          1
        );

        function dynamicSort(property) {
          var sortOrder = 1;
          if (property[0] === '-') {
            sortOrder = -1;
            property = property.substr(1);
          }
          return function(a, b) {
            var result =
              a[property] < b[property]
                ? -1
                : a[property] > b[property]
                  ? 1
                  : 0;
            return result * sortOrder;
          };
        }
      },
      templateUrl:
        'js/XG/modules/portals/views/directives/portalSwitcherAvance.html',
    };
  };

  portalSwitcherAvance.$inject = [
    '$window',
    '$rootScope',
    'PortalsFactory',
    'ngDialog',
    '$timeout',
    'UsersFactory',
  ];
  return portalSwitcherAvance;
});
