'use strict';

/**
 * @ngdoc service
 * @name modules.model.service:UnitFactory
 * @description
 * UnitFactory
 */
define(function() {
  var UnitFactory = function($http, $q, ConfigFactory, mUnitFactory) {
    var UnitFactory = {};

    var resources = { units: [] };

    function updateUnitConfig(deferred, senddata) {
      mUnitFactory.update(resources.units).then(function(res) {
        deferred.resolve(deferred, senddata);
      });
    }

    /**
     * Function: add
     */
    function add(senddata) {
      var maxId = 0;
      var deferred = $q.defer();

      //-- Get biggest ID in use
      for (var ind = 0; ind < resources.units.length; ind++)
        if (maxId < resources.units[ind].uid) maxId = resources.units[ind].uid;
      //-- New object ID is biggest used ID + 1
      senddata.uid = maxId + 1;
      resources.units.push(senddata);
      updateUnitConfig(deferred, senddata);
      return deferred.promise;
    }

    /**
     * Function: remove
     */
    function remove(name, id) {
      var deferred = $q.defer();
      var deleteIndex = resources.units
        .map(function(x) {
          return x.uid;
        })
        .indexOf(id);
      resources.units.splice(deleteIndex, 1);
      updateUnitConfig(deferred);
      return deferred.promise;
    }

    /**
     *        Best practice is to call this function first at a high level
     *    so that the description of the units be loaded and ready as soon as possible
     *    in order to be accessible for the fields.
     */
    function get() {
      var deferred = $q.defer();

      mUnitFactory.get().then(function(res) {
        if (res.data.push != undefined) resources.units = res.data;
        for (var ind = 0; ind < resources.units.length; ind++)
          resources.units[ind].uid = ind;
        deferred.resolve(resources.units);
      });
      return deferred.promise;
    }

    /**
     * Function: update
     */
    function update(senddata) {
      console.log(senddata);
      var deferred = $q.defer();
      var replaceIndex = resources.units
        .map(function(x) {
          return x.uid;
        })
        .indexOf(senddata.uid);
      resources.units[replaceIndex] = senddata;
      updateUnitConfig(deferred, senddata);
      return deferred.promise;
    }

    return {
      UnitFactory: UnitFactory,
      resources: resources,
      add: add,
      update: update,
      remove: remove,
      get: get,
    };
  };
  UnitFactory.$inject = ['$http', '$q', 'ConfigFactory', 'mUnitFactory'];
  return UnitFactory;
});
