'use strict';
define(function() {
  var AssociationFactory = function($http, $filter) {
    /**
     * Function: getAllAssociation
     */
    function getAll(mainDb) {
      return $http.get('/services/{portalid}/association/getAll?f=json&mainDb='+mainDb);
    }
    /**
     * Function: addOrUpdate association
     */
     function addOrUpdate(mainDb,senddata,isNewResource) {
      return $http.post('/services/{portalid}/association/add?f=json&mainDb='+mainDb+'&isNewResource='+!!isNewResource,senddata);
    }
    /**
     * Function: remove association
     */
     function remove(mainDb,id,deleteObjectRelated) {
      return $http.get('/services/{portalid}/association/remove?f=json&mainDb='+mainDb+'&id='+id+'&deleteObjectRelated='+deleteObjectRelated);
    }
    /**
     * Function: create association table if not exist
     */
     function createAssociationTableIfNotExit(mainDb) {
      return $http.get('/services/{portalid}/association/createTableIfNotExit?f=json&mainDb='+mainDb);
    }
    /**
     * Function: update association list
     */
     function updateAllAssociations(mainDb, featureID, senddata) {
      return $http.post('/services/{portalid}/association/updateAllAssociations?f=json&mainDb='+mainDb+'&featureID='+featureID,senddata);
    }
    /**
     * Function: get All associated feature from the featureID
     */
     function getAllAssociatedValues(mainDb, featureID) {
      return $http.get('/services/{portalid}/association/getAllAssociatedValues?f=json&mainDb='+mainDb+'&featureID='+featureID);
    }
    /**
     * Function: get the associated feature from ftiname and featureID
     */
     function getAssociatedValues(mainDb, associationName, featureID) {
      return $http.get('/services/{portalid}/association/getAssociatedValues?f=json&mainDb='+mainDb+
        '&associationName='+associationName+'&featureID='+featureID);
    }
    /**
     * Function: get the objects cibles from associationsList
     */
     function getListObjectsCibles(mainDb, associationsList, featureID) {
      return $http.post('/services/{portalid}/association/getListObjectsCibles?f=json&mainDb='+mainDb+
        '&featureID='+featureID,associationsList);
    }
    /**
     * Function: remove l'objet cible
     */
     function removeObjectCible(mainDb, associationsList, featureID, objCibleCouche, objCibleId) {
      return $http.post('/services/{portalid}/association/removeObjectCible?f=json&featureID='+featureID+
        '&objCibleCouche='+objCibleCouche+'&objCibleId='+objCibleId+'&mainDb='+mainDb,associationsList);
    }
    /**
     * Function: remove l'objet cible
     */
     function updateObjectCible(mainDb, associationsList, featureID, objCibleCouche, objCibleId, alias) {
      return $http.post('/services/{portalid}/association/updateObjectCible?f=json&featureID='+featureID+
        '&objCibleCouche='+objCibleCouche+'&objCibleId='+objCibleId+'&alias='+alias+'&mainDb='+mainDb,associationsList);
    }
    /**
     * Function: add objects cible from list depend on associationToLoad
     */
     function addObjectsCibles(mainDb, featureID, sendData) {
      return $http.post('/services/{portalid}/association/addObjectsCibles?f=json&featureID='+featureID+'&mainDb='+mainDb,sendData);
    }
    /**
     * Function: get list of object cibles to copy from source to destination
     */
     function getListObjectsCiblesToCopy(mainDb, associationsList, featureIdSource, nameDestination, typePatrimoine) {
      return $http.post('/services/{portalid}/association/getListObjectsCiblesToCopy?f=json&mainDb='+mainDb+
        '&featureIdSource='+featureIdSource+ '&nameDestination='+nameDestination+ '&typePatrimoine='+typePatrimoine,
        associationsList);
    }

    /**
     * Récupère le nom du champ de jointure B d'une association dont on connait l'uid des composants de jointure
     * @param {string} mainDb nom de la datasource principale du portail courant
     * @param {string} aFtiUid uid identifiant du composant de jointure A
     * @param {string} bFtiUid uid identifiant du composant de jointure B
     * @return {Promise} contient une string si la promesse n'a pas échoué
     */
    const getAFieldOrBFieldName = (mainDb, aFtiUid, bFtiUid) => {
       return $http.get('/services/{portalid}/association/getBdatFieldName?f=json'
           + '&maindb=' + mainDb
           + '&aftiuid=' + aFtiUid
           + '&bftiuid=' + bFtiUid)
       .catch((error) => {
         if (error.data.hasOwnProperty('code') && error.data.code !== 204) {
           if (Array.isArray(error.data.details) && error.data.details.length > 0) {
             console.error(error.data.details[0]);
           }
           if (typeof error.data.message === 'string') {
             require('toastr').error($filter('translate')(error.data.message));
           }
         }
       });
    };

    /**
     * Vérifie si tous les fti fournis en paramètre sont référencés dans une association (minimum) du portail
     * KIS-3040: si le composant à copier / de destination ne possède aucune association, la récupération ne doit pas être lancée.
     * Solution demandée pour palier la mauvaise rédaction de la méthode getListObjectsCiblesToCopy:
     * cette méthode possède plusieurs risques de nullPointerException et elle renvoie une erreur serveur lorsque le tableau d'association fourni en paramètre est vide
     * @param mainDb nom de la datasource principale du portail
     * @param ftiNames nom des fti en string séparés par une virgule
     * @return {Promise} contient true ou false ou bien une erreur serveur contenant un message à traduire et un détail technique à afficher en console
     */
    const allFeatureTypesAreAssociated = (mainDb, ftiNames) => {
      return $http.get('/services/{portalid}/association/allFeatureTypesAreAssociated?f=json'
          + '&ftinames=' + ftiNames
          + '&mainDb=' + mainDb)
      .catch((error) => {
        if (error.data.hasOwnProperty('code') && error.data.code !== 204) {
          if (Array.isArray(error.data.details) && error.data.details.length > 0) {
            console.error(error.data.details[0]);
          }
          if (typeof error.data.message === 'string') {
            require('toastr').error($filter('translate')(error.data.message));
          }
        }
      });
    };

    /**
     * Supprime les objets cibles existants et ajoute une liste d'objets cibles
     * @param mainDb nom de la source de données principale du portail
     * @param featureId identifiant de l'objet dont on va remplacer la liste d'objets cibles
     * @param sendData données des objets à supprimer et des objets à ajouter
     * @return {Promise} liste des nouveaux objets associés ou string en cas d'erreur serveur
     */
    const replaceAllObjectCibles = (mainDb, featureId, sendData) => {
      return $http.post('/services/{portalid}/association/replaceAllObjectCibles?f=json'
          + '&mainDb=' + mainDb + '&featureId=' + featureId, sendData)
      .catch((error) => {
        if (typeof error.data === 'string') {
          require('toastr').error(error.data);
        } else if (typeof error.data === 'object' && error.data !== null) {
          if (typeof error.data.message === 'string') {
            require('toastr').error($filter('translate')(error.data.message));
          }
          if (Array.isArray(error.data.details) && error.data.details.length > 0) {
            console.error(error.data.details[0]);
          }
        }
      });
    };

    return {
      remove:remove,
      addOrUpdate:addOrUpdate,
      getAll:getAll,
      createAssociationTableIfNotExit:createAssociationTableIfNotExit,
      updateAllAssociations:updateAllAssociations,
      getAllAssociatedValues:getAllAssociatedValues,
      getAssociatedValues:getAssociatedValues,
      getListObjectsCibles:getListObjectsCibles,
      removeObjectCible:removeObjectCible,
      updateObjectCible:updateObjectCible,
      addObjectsCibles:addObjectsCibles,
      getListObjectsCiblesToCopy:getListObjectsCiblesToCopy,
      getAFieldOrBFieldName: getAFieldOrBFieldName,
      allFeatureTypesAreAssociated: allFeatureTypesAreAssociated,
      replaceAllObjectCibles: replaceAllObjectCibles
    };
  };
  AssociationFactory.$inject = ['$http', '$filter'];
  return AssociationFactory;
});
