/**
 *
 */
'use strict';
define(function() {
  /**
   * Unit Ctrl
   * @param $scope
   * @param UnitFactory
   * @constructor
   */
  var UnitCtrl = function($scope, UnitFactory) {
    /**
     * Create or update the Unit
     */
    $scope.editUnit = function() {
      if ($scope.isNewResource) {
        UnitFactory.add($scope.edit_resource).then(function() {
          $scope.isNewResource = false;
        });
      } else {
        UnitFactory.update($scope.edit_resource);
      }
    };

    /**
     * Unit removal
     */
    $scope.removeUnit = function() {
      UnitFactory.remove($scope.edit_resource.name, $scope.edit_resource.uid);
    };

    /**
     * Units loading
     */
    $scope.currentResources = UnitFactory.resources.units;

    if (UnitFactory.resources.units.length == 0) {
      UnitFactory.get().then(function(res) {
        $scope.currentResources = UnitFactory.resources.units;
      });
    }

    /**
     * Remove a multiple from the Unit
     * @param index
     */
    $scope.removeMultiple = function(index) {
      $scope.edit_resource.multiple.splice(index, 1);
    };

    /**
     * Add a multiple to the Unit
     */
    $scope.addMultiple = function() {
      if (!$scope.edit_resource.hasOwnProperty('multiple'))
        $scope.edit_resource.multiple = [];
      $scope.edit_resource.multiple.push({});
    };

    /**
         EditList Directive configuration
         */
    $scope.editListCfg = {
      dataModule: 'model',
      resource_type: 'units',
      cols: ['unit'],
      removeFunction: $scope.removeUnit,
    };

    $scope.validForm = {};
    $scope.validateUnit = function() {
      var actualUnit = $scope.edit_resource.unit;
      $scope.$watch(
        'edit_resource.unit',
        function(unit) {
          $scope.unitExists =
            $scope.currentResources
              .map(function(r) {
                return r.unit;
              })
              .indexOf(unit) != -1;
          if (!$scope.isNewResource && $scope.edit_resource.unit == actualUnit)
            $scope.unitExists = false;
          $scope.validForm.unit = !$scope.unitExists;
        },
        1
      );
    };
  };

  UnitCtrl.$inject = ['$scope', 'UnitFactory'];
  return UnitCtrl;
});
