"use strict";
define(() => {
  let mustNotSelfIntersectRule = {

    $get: ($q, $filter, GeometryFactory) => {

      /**
       * Vérifie si la géométrie s'intersecte elle-même ou pas
       * @param editdescription objet de l'édition métier
       * @return {Promise} contient la string "mustNotSelfIntersect" si la géométrie n'existe pas ou bien si la géométrie s'intersecte
       */
      const mustNotSelfIntersect = (editdescription) => {
        const defer = $q.defer();
        const geometry = editdescription && editdescription.editedfeature ? editdescription.editedfeature.getGeometry() : null;

        // mustNotSelfIntersect est une règle réservée aux objets linéaire pour l'instant (KIS-2828)
        if (geometry && (geometry.getType() === 'LineString' || geometry.getType() === 'MultiLineString')) {

          // géométrie au format Geojson
          const format = new ol.format.GeoJSON();
          const geometryAsGeojson = format.writeGeometryObject(geometry);

          GeometryFactory.isLineSelfIntersecting(geometryAsGeojson).then(
              res => {
                if (res.data !== undefined && typeof res.data === 'boolean') {
                  if (res.data) {
                    // la ligne s'auto-intersecte
                    require('toastr').error($filter('translate')('rulecfg.mustNotSelfIntersect.error'));
                    defer.reject('mustNotSelfIntersect');
                  } else {
                    // la ligne ne s'auto-intersecte pas
                    defer.resolve();
                  }
                } else {
                  // le retour n'est pas de type boolean
                  // il s'est passé une erreur serveur hors exception interceptée
                  require('toastr').error(
                      $filter('translate')('rulecfg.mustNotSelfIntersect.currentRule')
                      + '\n' + $filter('translate')('rulecfg.mustNotSelfIntersect.serverError')
                  );
                  defer.reject('mustNotSelfIntersect');
                }
              },
              () => {
                // erreur serveur (la factory affiche déjà un toastr)
                defer.reject('mustNotSelfIntersect');
              }
          );
        } else {
          // l'objet en cours d'édition ne contient pas de géométrie linéaire
          require('toastr').error(
              $filter('translate')('rulecfg.mustNotSelfIntersect.currentRule')
              + '\n' + $filter('translate')('rulecfg.mustNotSelfIntersect.noLineError')
          );
          defer.reject('mustNotSelfIntersect');
        }
        return defer.promise;
      };

      return {
        mustNotSelfIntersect: mustNotSelfIntersect
      };
    }
  };

  mustNotSelfIntersectRule.$get.$inject = ['$q', '$filter', 'GeometryFactory'];
  return mustNotSelfIntersectRule;
});