'use strict';
define(() => {
  let gcelement = (EditTypesFactory, RuleCfgFactory) => {
    return {
      templateUrl: 'js/XG/modules/edit/views/rules/cfg/cfg.mustNotSelfOverlap.html',
      restrict: 'E',
      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function (scope) {
        scope.rule.name = 'MustNotSelfOverlap';
        scope.rule.type = 'OnEnd';

        const editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.update,
        ];

        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        //Si phase de creation
        if (!scope.rule.parameters) {
          scope.rule.parameters = {};
        }
      }
    };
  };

  gcelement.$inject = ['EditTypesFactory', 'RuleCfgFactory'];
  return gcelement;
});