'use strict';
define(function() {
  var ObjectsArrayToObjectAttributeArray = function() {
    /**
     * Replaces every object in an array
     * with the name of the @attribute of said object
     *
     * ex: [ {"name":"uno"}, {"name":"dos"}] to ["uno","dos"], when the attribute parameter = name
     */
    return function(array, attribute) {
      array.forEach(function(object, index) {
        array[index] = object[attribute];
      });
      return array;
    };
  };
  ObjectsArrayToObjectAttributeArray.$inject = [];
  return ObjectsArrayToObjectAttributeArray;
});
