'use strict';
define(function() {
  var featureHistoryTable = function(
    $http,
    ngDialog,
    FeatureHistoryFactory,
    ngTableParams,
    $filter,
    $rootScope,
    $q,
    gaDomUtils,
    gaJsUtils
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/feature_history_table.html',
      scope: {
        fid: '=',
        ftid: '=',
        add: '=?',
        remove: '=?',
      },
      restrict: 'E',
      link: function(scope, element, attr) {
        //tableau des actions titles
        scope.action_titles = [''];

        //action title filter
        scope.titleFilter = { x: '' };

        scope.history_active = false;
        if (
          gaJsUtils.checkNestedProperty(
            'parameters.history.active',
            $rootScope.xgos.portal
          )
        ) {
          scope.history_active = true;
        }

        var lengthActions = 0;

        scope.tableFeaturesHistory = new ngTableParams(
          {
            page: 1,
            count: 10,
          },
          {
            total: 0,
            getData: function($defer, params) {
              // ng-class="{ 'disabled ' : disabled }"
              scope.disabled = true;
              var sort, attName;
              attName = Object.keys(params.sorting())[0];
              if (attName == 'Date') {
                attName = 'action_date';
              }
              if (attName && lengthActions != 0) {
                sort =
                  attName +
                  ',' +
                  params.sorting()[Object.keys(params.sorting())[0]];
              }

              console.log('oye');

              //recuperer les actions histories pas count,page et titleFilter
              FeatureHistoryFactory.getactions(
                scope.fid,
                scope.ftid,
                scope.titleFilter.x,
                params.page(),
                params.count(),
                sort
              ).then(function(res) {
                if (!res.data || res.data == '') return false;
                var results = [];
                lengthActions = res.data.features.length;
                for (var i = 0; i < res.data.features.length; i++) {
                  results[i] = res.data.features[i].properties;
                  results[i].id = res.data.features[i].id;
                  results[i].Date = new Date(
                    res.data.features[i].properties.action_date
                  );
                  if (
                    scope.action_titles.indexOf(
                      res.data.features[i].properties.action_title
                    ) == -1
                  ) {
                    scope.action_titles.push(
                      res.data.features[i].properties.action_title
                    );
                  }
                }

                //total
                params.total(res.data.totalFeatures);

                // var orderedData = params.sorting() ? $filter('orderBy')(results, params.orderBy()) : results;
                // scope.histories = orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count());
                //$defer.resolve(orderedData);
                $defer.resolve(results);
                scope.disabled = false;
              });
            },
          }
        );

        scope.$on('$destroy', function(evt) {
          scope.tableFeaturesHistory = null;
        });

        //listen $rootScope $broadcast
        $rootScope.$on('refreshDossierActions', function(event, data) {
          if (data.ftid == scope.ftid && data.fid == scope.fid && scope.tableFeaturesHistory != null) {
            //refresh DossierActions
            scope.tableFeaturesHistory.reload();
          }
        });

        //Refresh DossierAction
        scope.refreshDossierAction = function() {
          scope.tableFeaturesHistory.reload();
        };

        var modal;
        scope.action = {
          date: new Date(),
        };
        scope.openModal = function() {
          modal = ngDialog.open({
            template:
              'js/XG/modules/common/views/modals/modal.featureAction.html',
            className: 'ngdialog-theme-plain width600 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        var formatDate = function(dateSource) {
          var date = moment(dateSource);
          date = date.toISOString();
          date = $filter('date')(date, 'yyyy-MM-ddTHH:mm:ss.sssZ');
          return date;
        };

        scope.addFeatureHistory = function() {
          scope.action.date = formatDate(scope.action.date);

          var sendata = {
            type: 'FeatureCollection',
            features: [
              {
                type: 'Feature',
                properties: {
                  feature_id: scope.fid,
                  feature_uid: scope.ftid,
                  action_title: scope.action.title,
                  action_description:
                    scope.action.detail + ' par ' + $rootScope.xgos.user.name,
                  user_id: $rootScope.xgos.user.name,
                  action_date: scope.action.date,
                },
              },
            ],
          };

          gaDomUtils.showGlobalLoader();
          FeatureHistoryFactory.addactionwithdate(sendata).then(
            function(res) {
              scope.tableFeaturesHistory.reload();
              gaDomUtils.hideGlobalLoader();
              modal.close();
              scope.action = {
                date: new Date(),
              };
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * remove histoty
         * @param history
         */
        scope.removeHistory = function(history) {
          var ans = confirm(
            'Êtes-vous certain de vouloir effectuer cette action ?'
          );

          if (ans) {
            gaDomUtils.showGlobalLoader();
            FeatureHistoryFactory.removeaction(history.id).then(
              function(res) {
                scope.tableFeaturesHistory.reload();
                gaDomUtils.hideGlobalLoader();
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        // Disable removeBoutton
        scope.disabledButtonRemove = () => {
          let disabeBoutton = true;
          if (angular.isArray($rootScope.xgos.user.roles)) {
            $rootScope.xgos.user.roles.forEach((role)=>{
              if (role.name == 'ANC_responsable' || role.name == 'sRootUser' || role.name == 'rootUser') {
                disabeBoutton =  false
              } 
            })
          }
          return disabeBoutton;
        }
      },
    };
  };

  featureHistoryTable.$inject = [
    '$http',
    'ngDialog',
    'FeatureHistoryFactory',
    'ngTableParams',
    '$filter',
    '$rootScope',
    '$q',
    'gaDomUtils',
    'gaJsUtils',
  ];
  return featureHistoryTable;
});
