'use strict';

define(function() {
  var listesDeroulantesCtrl = function(
    $scope,
    FeatureTypeFactory,
    AncAppFactory,
    ngDialog,
    gaDomUtils,
    ParametersFactory,
    $q,
    $rootScope,
    gaJsUtils,
    BacAppFactory
  ) {
    var CurrentAppFactory = $rootScope.xgos.sector == 'bac' ? BacAppFactory : AncAppFactory;
    $scope.listeTabs = { activeTab: 0 };
    $scope.listeDeroulantesTabsMap =
      $scope.listesDeroulantesTab.childrenTabsNames;

    $scope.resetAllVariables = () => {
      $scope.elements = [];
      $scope.listesDeroulantesData = [];
      $scope.listesDeroulantesAttributes = [];
      $scope.selectedAttribute = { model: [] };
      $scope.elementFilter = {};
      $scope.valuesFilter = null;
      $scope.modalEditRestrictValue = null;
      $scope.newValueModel = { name: '' };
      $scope.selectedElement = { model: null };
      $scope.selectedElementValues = [];
      $scope.editingItemsInProgress = {};
      $scope.usage = {};
    };

    $scope.$watch('listeTabs.activeTab', (newTab, oldTab) => {
      $scope.activeTab = $scope.listeDeroulantesTabsMap[newTab];
      $scope.resetAllVariables();

      $scope.featuresToShow = $scope.listeDeroulantesSources[$scope.activeTab];
      $scope.selectedFeature = {
        model: $scope.featuresToShow[0],
      };

      $scope.elements = $scope.selectedFeature.model.value;
      $scope.getElementsData();
    });

    $scope.onFeatureChange = selectedFeature => {
      $scope.resetAllVariables();
      $scope.elements = selectedFeature.model.value;
      $scope.getElementsData();
    };

    $scope.getElementsData = () => {
      for (let index = 0; index < $scope.elements.length; index++) {
        let listeData = FeatureTypeFactory.getFeatureByUid(
          $scope.elements[index]
        );
        $scope.listesDeroulantesData.push(listeData);
      }
    };

    $scope.setAttributes = selectedElement => {
      $scope.listesDeroulantesAttributes = [];
      $scope.selectedElement.model = selectedElement;
      let allAttributes = [];

      if (selectedElement[0].name === 'kis_anc_vidange') {
        allAttributes = selectedElement[0].attributes.filter(
          attribute => attribute.name === 'destination_matieres'
        );
      } else {
        allAttributes = selectedElement[0].attributes.filter(
          attribute => attribute.name !== 'civilite'
        );
      }

      allAttributes = $scope.excludeKisANCMicrostationAttributes(allAttributes);
      allAttributes = $scope.excludeSpecialAttributes(allAttributes);
      allAttributes = $scope.excludeRadioValues(allAttributes);
      $scope.listesDeroulantesAttributes = $scope.excludeValuesWithoutDomainRestriction(
        allAttributes
      );
      $scope.addExtraInformationForDuplicatedValues($scope.listesDeroulantesAttributes);
    };

    $scope.excludeSpecialAttributes = attributes => {
      let attributesToExclude = [];

      if ($rootScope.xgos.sector === 'bac'){
         attributesToExclude = [
          'collecte_eau',
          'conclusion_sondage_1',
          'conclusion_sondage_2',
          'conclusion_sondage_3',
          'destination_eaux_pluviales',
          'destination_eau',
          'dysfonctionnement',
          'defaut_structure',
          'entretien_usure',
          'origine_effluent',
          'pente_terrain',
          'pedologie_nature_1',
          'pedologie_nature_2',
          'pedologie_nature_3',
          'pedologie_nature_4',
          'pedologie_profondeur_1',
          'pedologie_profondeur_2',
          'pedologie_profondeur_3',
          'pedologie_profondeur_4',
          'pedologie_profondeur_5',
          'pedologie_profondeur_6',
          'pedologie_profondeur_7',
          'type_zonage',
        ];
      }
      return attributes.filter(
        attribute => attributesToExclude.indexOf(attribute.name) === -1
      );
    };

    $scope.excludeKisANCMicrostationAttributes = attributes => {
      let attributesToExclude = ['ctrlbf', 'ctrlbc', 'ctrlbe'];

      return attributes.filter(attribute => {
        let startingName = attribute.name.split('_')[0];
        return attributesToExclude.indexOf(startingName) === -1;
      });
    };

    $scope.excludeRadioValues = attributes => {
      return attributes.filter(attribute => {
        if (attribute.restrictions.length) {
          let attributeRestrictions = attribute.restrictions[0];

          if (
            attributeRestrictions.type === 'Domain' &&
            attributeRestrictions.listofValues
          ) {
            let attributeValues = Object.values(
              attributeRestrictions.listofValues
            );
            let radioValues =
              attributeValues.indexOf('Oui') !== -1 &&
              attributeValues.indexOf('Non') !== -1 &&
              attributeValues.indexOf('?') !== -1;

            return !(attributeValues.length === 3 && radioValues);
          } else {
            return true;
          }
        } else {
          return true;
        }
      });
    };

    $scope.excludeValuesWithoutDomainRestriction = allAttributes => {
      return allAttributes.filter(attribute => {
        if (!attribute.restrictions[0]) {
          return false;
        }

        return attribute.restrictions[0].type === 'Domain';
      });
    };

    $scope.addExtraInformationForDuplicatedValues = (attributes) => {
      let attributesToChange = [];
      attributes.forEach(attribute => {
        let duplicateIndex = attributes.findIndex(
            (element) => element !== attribute && element.alias
                === attribute.alias);
        if (duplicateIndex >= 0) {
          attributesToChange.push(attribute);
        }
      });
      attributesToChange.forEach(
          attribute => attribute.alias = attribute.alias + ' ('
              + attribute.name.substring(0, attribute.name.indexOf('_')) + ')');
    };

    $scope.setAttributeValues = selectedAttribute => {
      $scope.selectedAttributesValues = [];
      $scope.selectedAttribute.model = selectedAttribute;

      if(
          selectedAttribute[0] !== undefined &&
          selectedAttribute[0].restrictions[0] !== undefined
      ){
        for (let property in selectedAttribute[0].restrictions[0].listofValues) {
          if (
              selectedAttribute[0].restrictions[0].listofValues.hasOwnProperty(
                  property
              )
          ) {
            let currentValue =
                selectedAttribute[0].restrictions[0].listofValues[property];
            $scope.selectedAttributesValues.push({
              name: currentValue,
              key: property,
            });
          }
        }
      }
      $scope.getValuesUsage(selectedAttribute);
    };

    $scope.isEditMode = value => {
      return $scope.editingItemsInProgress[value];
    };

    $scope.addToEditing = value => {
      $scope.editingItemsInProgress[value] = true;
    };

    $scope.cancelEdit = (value, index) => {
      let previousAttributeValues =
        $scope.selectedAttribute.model[0].restrictions[0].listofValues;
      $scope.selectedAttributesValues[index].name =
        previousAttributeValues[value.key];

      delete $scope.editingItemsInProgress[value.key];
    };

    $scope.saveEditedValue = (value, index) => {
      if (!value.name.length) {
        require('toastr').error('Valeur manquante');
        return;
      }

      let alreadyExists = false;
      let selectedAttributeValues =
        $scope.selectedAttribute.model[0].restrictions[0].listofValues;

      for (let property in selectedAttributeValues) {
        if (selectedAttributeValues.hasOwnProperty(property)) {
          let currentValue = selectedAttributeValues[property];
          if (value.name === currentValue && value.key !== property) {
            alreadyExists = true;
            value.name = currentValue;
            break;
          }
        }
      }

      if (alreadyExists) {
        require('toastr').error('La valeur introduite existe déjà');
      } else {
        selectedAttributeValues[value.key] =
          $scope.selectedAttributesValues[index].name;
        $scope.performSave('Valeur changée').then(() => {
          $rootScope.$broadcast('modelValueChanged');
          delete $scope.editingItemsInProgress[value.key];
        });
      }
    };

    $scope.getValuesUsage = selectedAttribute => {
      let element = $scope.selectedElement.model[0].name;
      if(selectedAttribute[0] !== undefined){
        CurrentAppFactory.checkrestrictiononcomponent(
            element,
            selectedAttribute[0].name
        ).then(response => {
          let valuesUsage = response.data;
          let currentValues =
              $scope.selectedAttribute.model[0].restrictions[0].listofValues;

          for (let index in currentValues) {
            if (valuesUsage[index]) {
              $scope.usage[index] = valuesUsage[index];
            } else {
              $scope.usage[index] = 0;
            }
          }
        });
      }

    };

    $scope.addValueToFeature = valueToAdd => {
      if (!valueToAdd.length) {
        require('toastr').error('Valeur manquante');
        return;
      }

      let alreadyExists = false;
      let restrictions = $scope.selectedAttribute.model[0].restrictions;
      let selectedAttributesValues;

      if (!restrictions[0].listofValues) {
        restrictions[0].listofValues = {};
      }

      selectedAttributesValues = angular.copy(restrictions[0].listofValues);

      for (let property in selectedAttributesValues) {
        let currentValue = selectedAttributesValues[property];

        if (valueToAdd === currentValue) {
          alreadyExists = true;
          break;
        }
      }

      if (alreadyExists) {
        require('toastr').error('La valeur introduite existe déjà');
      } else {
        $scope.addKeyAndValue(selectedAttributesValues, valueToAdd);

        $scope.performSave('Valeur ajoutée').then(() => {
          $rootScope.$broadcast('modelValueChanged');
          $scope.setAttributeValues($scope.selectedAttribute.model);
          $scope.newValueModel.name = '';
        });
      }
    };

    $scope.addKeyAndValue = (selectedAttributesValues, valueToAdd) => {
      let keyToAdd = generateUniqueId();
      selectedAttributesValues[keyToAdd] = valueToAdd;
      $scope.selectedAttribute.model[0].restrictions[0].listofValues = selectedAttributesValues;
    };

    function generateUniqueId() {
      const date = new Date();
      const random = Math.floor(Math.random() * 1000);
      return date.getTime() + '' + random;
    }

    $scope.performSave = successMessage => {
      let deferred = $q.defer();

      FeatureTypeFactory.update($scope.selectedElement.model[0]).then(() => {
        require('toastr').success(successMessage);
        ParametersFactory.publish($scope.selectedElement.model[0].uid).then(
          () => {
            require('toastr').success('Composant mis à jour');
            deferred.resolve();
          }
        );
      });

      return deferred.promise;
    };

    $scope.prepareValuesToRemove = (value, index) => {
      $scope.listOfValues = angular.copy($scope.selectedAttributesValues);
      $scope.listOfValues.splice(index, 1);

      let valueToRemove = {
        id: value.key,
        used: $scope.usage[value.key],
        value: value.name,
      };

      return valueToRemove;
    };

    $scope.prepareRemoveAndUpdate = (element, attribute, key) => {
      $scope.descElem = {
        elemName: element[0].name,
        attrName: attribute[0].name,
        attrKey: key.id,
        attrAlias: attribute[0].alias,
        attrValueAlias: key.value,
        attrUsedTimes: key.used,
        fti: element[0],
      };

      $scope.modalEditRestrictValue = ngDialog.open({
        template:
          'js/XG/widgets/ancapp/main/views/modals/modal.editAttributeRestriction.html',
        className: 'ngdialog-theme-plain width800 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
        onclose: () => {
          delete $scope.descElem;
        },
      });
    };

    $scope.replaceValue = () => {
      var ans = confirm(
        "Êtes-vous sur de changer la valeur de l'attribut ? \n Cette opération peut être longue en fonction du nombre d'éléments concernés."
      );
      if (ans) {
        gaDomUtils.showGlobalLoader();
        CurrentAppFactory.updaterestrictionvalueoncomponent(
          $scope.descElem.elemName,
          $scope.descElem.attrName,
          $scope.descElem.attrKey,
          $scope.descElem.newValue
        ).then(res => {
          $scope.setAttributeValues($scope.selectedAttribute.model);
          $scope.modalEditRestrictValue.close();
          gaDomUtils.hideGlobalLoader();
          require('toastr').success('Valeur changée');
        });
      }
    };

    $scope.resetValuesUsage = () => {
      gaDomUtils.showGlobalLoader();
      $scope.updateComponentValues().then(() => {
        gaDomUtils.hideGlobalLoader();
        require('toastr').success('Réinitialisation effectuée');
        $scope.setAttributeValues($scope.selectedAttribute.model);
        $scope.modalEditRestrictValue.close();
      });
    };

    $scope.updateComponentValues = () => {
      return CurrentAppFactory.updaterestrictionvalueoncomponent(
        $scope.descElem.elemName,
        $scope.descElem.attrName,
        $scope.descElem.attrKey,
        null
      );
    };

    $scope.deleteValues = () => {
      gaDomUtils.showGlobalLoader();
      $scope.updateComponentValues().then(() => {
        delete $scope.selectedAttribute.model[0].restrictions[0].listofValues[
          $scope.descElem.attrKey
        ];
        $scope.setAttributeValues($scope.selectedAttribute.model);

        FeatureTypeFactory.update($scope.selectedElement.model[0]).then(() => {
          require('toastr').success('Valeur supprimée');
          ParametersFactory.publish($scope.selectedElement.model[0].uid).then(
            () => {
              gaDomUtils.hideGlobalLoader();
              require('toastr').success('Composant mis à jour');
            }
          );
          $scope.modalEditRestrictValue.close();
        });
      });
    };

    $scope.cancelUpdateValues = () => {
      delete $scope.descElem;
      $scope.modalEditRestrictValue.close();
    };

    $scope.reaffectationAllowed = () => {
      return (
        $scope.selectedFeature.model.value[0] !==
          'kis_anc_listes_deroulantes_controles' &&
        $scope.selectedFeature.model.value[0] !==
          'kis_bac_listes_deroulantes_controles'
      );
    };
  };

  listesDeroulantesCtrl.$inject = [
    '$scope',
    'FeatureTypeFactory',
    'AncAppFactory',
    'ngDialog',
    'gaDomUtils',
    'ParametersFactory',
    '$q',
    '$rootScope',
    'gaJsUtils',
    'BacAppFactory'
  ];
  return listesDeroulantesCtrl;
});
