'use strict';
define(function() {
  var taskManager = function(
    TaskFactory,
    gaDomUtils,
    ngDialog,
    EditFactory,
    $timeout,
    CalendarFactory,
    ParametersFactory,
    $filter,
    $q,
    gaJsUtils
  ) {
    return {
      templateUrl: 'js/XG/containers/views/taskmanager.html',
      restrict: 'EA',
      scope: {
        fuid: '=', // featureuid
        fid: '=', // featureid
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.filter = {
          tasks: '',
          displayCanceled: false,
        };

        scope.tasks = [];
        scope.tasksEvents = [];
        scope.loadingTasks = true;

        // get eventTypes
        scope.eventTypes = [];
        /**
         * getEventTypes
         */
        var getEventTypes = function() {
          CalendarFactory.geteventtypes().then(function(res) {
            scope.eventTypes = CalendarFactory.resources.event_types;
          });
        };
        getEventTypes();

        scope.taskTemplates = [];
        /**
         * getTaskTemplates
         */
        var getTaskTemplates = function() {
          ParametersFactory.getbytype('TaskTemplate').then(function(res) {
            if (angular.isArray(res.data)) scope.taskTemplates = res.data;
          });
        };
        getTaskTemplates();

        scope.taskStatuses = {};
        /**
         * refreshTaskStatuses
         */
        var refreshTaskStatuses = function() {
          scope.taskStatuses.normal = 0;
          scope.taskStatuses.cloture = 0;
          scope.taskStatuses.annule = 0;

          scope.tasks.forEach(function(t) {
            scope.taskStatuses[t.properties.status] += 1;
          });
        };

        /**
         * task
         * @param task
         */
        var refreshTaskEvents = function(task) {
          TaskFactory.gettaskevents(task.id).then(function(res) {
            $timeout(function() {
              scope.tasksEvents[task.id] = $filter('orderBy')(
                res.data.features,
                'properties.start',
                false
              );
            }, 500);
          });
        };
        /**
         * getTasks
         */
        var getTasks = function() {
          TaskFactory.gettasks(scope.fuid, scope.fid).then(function() {
            scope.tasks = TaskFactory.resources.tasks;
            scope.tasks.forEach(function(task) {
              refreshTaskEvents(task);
            });
            refreshTaskStatuses();
            scope.loadingTasks = false;
          });
        };

        scope.$watch('fid', function(fid) {
          if (angular.isDefined(fid)) {
            getTasks();
          }
        });

        /* -************************************
         *  Tasks
         * ***********************************/

        /**
         * addTask dialog
         */
        var _addTaskDialog;
        scope.addTaskDialog = function() {
          scope.newTaskDateMin = $filter('date')(
            new Date(),
            'yyyy-MM-ddTHH:mm:ss.sssZ'
          );
          scope.newTask = {
            type: 'Feature',
            properties: {
              title: '',
              description: '',
              status: 'normal',
              fuid: scope.fuid,
              fid: scope.fid,
            },
          };
          scope.selectedTemplate = {};

          _addTaskDialog = ngDialog.open({
            template: 'js/XG/containers/views/modals/taskmanager.add.task.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };
        /**
         * check whether user can add a new task
         */
        scope.canAddNewTask = function() {
          var canAdd = true;
          if (
            scope.newTask.properties.title == '' ||
            scope.newTask.properties.description == ''
          )
            canAdd = false;
          if (
            angular.isDefined(scope.selectedTemplate.tpl) &&
            !angular.isDefined(scope.selectedTemplate.first_date)
          ) {
            canAdd = false;
          }

          return canAdd;
        };

        /**
         * updateDateStringAndFormat
         * @param dateString
         * @param duration
         */
        var updateDateStringAndFormat = function(dateString, duration) {
          return $filter('date')(
            moment(moment(dateString))
              .add(duration, 'seconds')
              .toDate(),
            'yyyy-MM-ddTHH:mm:ss.sssZ'
          );
        };

        /**
         * tplToTask
         * @param taskid
         * @param tpl
         * @param base_date
         */
        var tplToTask = function(taskid, tpl, base_date) {
          var def = $q.defer();

          var newEvents = [];
          var newEvent = {};

          tpl.events.forEach(function(event, idx) {
            newEvent = {
              type: 'Feature',
              properties: angular.copy(event),
            };

            base_date = updateDateStringAndFormat(base_date, event.delai);
            newEvent.properties.start = base_date;
            newEvent.properties.end = updateDateStringAndFormat(
              base_date,
              event.duration
            );

            console.log(base_date);

            // remove extra data
            delete newEvent.properties.duration;
            delete newEvent.properties.delai;
            newEvents.push(newEvent);
          });

          CalendarFactory.addevent({
            type: 'FeatureCollection',
            features: newEvents,
          }).then(
            function(res) {
              var toLink = [];
              res.data.forEach(function(x) {
                toLink.push({
                  task: taskid,
                  event: x.id,
                });
              });
              TaskFactory.addeventtotask(toLink).then(
                function(res) {
                  def.resolve();
                },
                function() {
                  def.reject();
                }
              );
            },
            function(res) {
              def.reject();
            }
          );

          return def.promise;
        };

        /**
         * addTask
         */
        scope.addTask = function() {
          gaDomUtils.showGlobalLoader();

          TaskFactory.addtask({
            type: 'FeatureCollection',
            features: [scope.newTask],
          }).then(
            function(res) {
              // from template
              if (angular.isDefined(scope.selectedTemplate.tpl)) {
                tplToTask(
                  res.data[0].id,
                  scope.selectedTemplate.tpl.data,
                  scope.selectedTemplate.first_date
                ).then(
                  function() {
                    getTasks();
                    gaDomUtils.hideGlobalLoader();
                  },
                  function() {
                    gaDomUtils.hideGlobalLoader();
                  }
                );
              } else {
                getTasks();
                gaDomUtils.hideGlobalLoader();
              }
            },
            function() {
              gaDomUtils.hideGlobalLoader();
            }
          );

          _addTaskDialog.close();
        };

        /**
         * pre_editTaskMetaData
         * @param event
         */
        scope.pre_editTaskMetaData = function(task) {
          scope.editTaskMetaData = task;
          scope.tmpeditTaskMetaData = angular.copy(task);
        };
        /**
         * pre_editTaskGeneral
         * @param event
         */
        scope.pre_editTaskGeneral = function(task) {
          scope.editTaskGeneral = task;
          scope.tmpeditTaskGeneral = angular.copy(task);
        };

        scope.doEditTaskGeneral = function() {
          gaDomUtils.showGlobalLoader();
          TaskFactory.updatetask({
            type: 'FeatureCollection',
            features: [scope.tmpeditTaskGeneral],
          }).then(function() {
            scope.editTaskGeneral.properties =
              scope.tmpeditTaskGeneral.properties;
            gaDomUtils.hideGlobalLoader();
            $('.popover-content')
              .parent()
              .remove();
          });
        };

        /**
         * editTaskMetaData
         */
        scope.doEditTaskMetaData = function() {
          // edit status
          if (
            scope.tmpeditTaskMetaData.properties.status !=
            scope.editTaskMetaData.properties.status
          ) {
            gaDomUtils.showGlobalLoader();
            TaskFactory.updatetaskstatus({
              task_id: scope.tmpeditTaskMetaData.id,
              status: scope.tmpeditTaskMetaData.properties.status,
            }).then(
              function(res) {
                scope.editTaskMetaData.properties.status =
                  scope.tmpeditTaskMetaData.properties.status;
                refreshTaskEvents(scope.editTaskMetaData);
                refreshTaskStatuses();
                gaDomUtils.hideGlobalLoader();
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        /* -************************************
         *  Task Events
         * ***********************************/

        var _editEventTaskDialog;
        var currentTask;
        /**
         * editEventTaskDialog
         * @param task
         * @param event
         */
        var svgEvent;
        scope.editEventTaskDialog = function(task, event, index) {
          currentTask = task;
          scope.currentEvent = event ? angular.copy(event) : {};
          scope.isNewEvent = !angular.isDefined(event);

          if (!scope.isNewEvent) {
            svgEvent = angular.copy(event);
            scope.eventInTaskIndex = index;
          } else {
            scope.newEventExtraData = {
              currentEventRelations: gaJsUtils.setNewFeatureCollection({
                feature_uid: scope.fuid,
                feature_id: scope.fid,
              }),
            };
          }

          _editEventTaskDialog = ngDialog.open({
            template:
              'js/XG/containers/views/modals/taskmanager.add.event.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * Decalage des dates de début des events selectionnes
         * addEventToTask
         * @param eventData
         */
        var _decaleEventsDialog;
        var deregWatchDecalages;
        scope.addEventToTask = function(insertedEvents, eventData, isNewEvent) {
          $timeout(function() {
            if (!isNewEvent) {
              // allow user to move other events too
              if (
                scope.eventInTaskIndex <
                scope.tasksEvents[currentTask.id].length - 1
              ) {
                var prevstart = moment(svgEvent.properties.start),
                  newstart = moment(eventData.properties.start),
                  decalage = moment
                    .duration(newstart.diff(prevstart))
                    .asSeconds();

                if (decalage != 0) {
                  scope.decalageEvent = decalage;
                  scope.decalageEvent_display = ' ';

                  var absdecalage = Math.abs(decalage);

                  if (absdecalage >= 86400) {
                    var nbdays = Math.round(
                      moment.duration(newstart.diff(prevstart)).asDays()
                    );
                    absdecalage = absdecalage - nbdays * 86400;
                    scope.decalageEvent_display +=
                      nbdays + $filter('translate')('date.day_short');
                  }
                  if (absdecalage > 0) {
                    scope.decalageEvent_display +=
                      ' ' + moment.utc(absdecalage * 1000).format('HH[h]mm');
                  }

                  scope.currentEvents = angular.copy(
                    scope.tasksEvents[currentTask.id]
                  );

                  scope.currentEvents.forEach(function(x, i) {
                    if (i == scope.eventInTaskIndex) {
                      scope.currentEvents[i].properties.newstart = newstart;
                    } else {
                      scope.currentEvents[i].properties.newstart =
                        scope.currentEvents[i].properties.start;
                    }
                  });

                  scope.toggleDecalages = {};

                  deregWatchDecalages = scope.$watch(
                    'toggleDecalages',
                    function(t) {
                      scope.nbDecalages = 0;
                      for (var idx in t) {
                        var base = scope.currentEvents[idx].properties.start;
                        if (t[idx]) {
                          scope.currentEvents[idx].properties.newstart = moment(
                            moment(base)
                          )
                            .add(decalage, 'seconds')
                            .toDate();
                          scope.nbDecalages++;
                        } else {
                          scope.currentEvents[idx].properties.newstart = base;
                        }
                      }
                    },
                    1
                  );

                  _decaleEventsDialog = ngDialog.open({
                    template:
                      'js/XG/containers/views/modals/taskmanager.decal.events.html',
                    className:
                      'ngdialog-theme-plain width1000 nopadding miniclose',
                    closeByDocument: false,
                    scope: scope,
                  });
                }

                refreshTaskEvents(currentTask);
              } else {
                refreshTaskEvents(currentTask);
              }
            } else {
              TaskFactory.addeventtotask({
                task: currentTask.id,
                event: insertedEvents[0].id,
              }).then(function(res) {
                refreshTaskEvents(currentTask);
              });
            }
            _editEventTaskDialog.close();
          });
        };

        /**
         * validDecalages
         */
        scope.validDecalages = function() {
          // set new start
          var indexesToRemove = [scope.eventInTaskIndex];
          scope.currentEvents.forEach(function(e, i) {
            // changed date
            if (i != scope.eventInTaskIndex) {
              if (
                scope.currentEvents[i].properties.start !=
                scope.currentEvents[i].properties.newstart
              ) {
                scope.currentEvents[i].properties.start = $filter('date')(
                  scope.currentEvents[i].properties.newstart,
                  'yyyy-MM-ddTHH:mm:ss.sssZ'
                );
              } else {
                indexesToRemove.push(i);
              }
            }
            delete scope.currentEvents[i].properties.newstart;
          });

          indexesToRemove.forEach(function(idx) {
            scope.currentEvents.splice(idx, 1);
          });

          gaDomUtils.showGlobalLoader();
          CalendarFactory.updateevent({
            collection: {
              type: 'FeatureCollection',
              features: [scope.currentEvents],
            },
          }).then(
            function() {
              refreshTaskEvents(currentTask);
              gaDomUtils.hideGlobalLoader();
              _decaleEventsDialog.close();
              deregWatchDecalages();
            },
            function() {
              gaDomUtils.hideGlobalLoader();
              _decaleEventsDialog.close();
              deregWatchDecalages();
            }
          );
        };

        /**
         * pre_editEventMetaData
         * @param event
         */

        scope.pre_editEventMetaData = function(event, task, taskIndex) {
          scope.isLastTaskEvent =
            taskIndex == scope.tasksEvents[task.id].length - 1;
          scope.forceCloseTask = { v: false };
          currentTask = task;
          scope.editEventMetaData = event;
          scope.tmpeditEventMetaData = angular.copy(event);
        };

        /**
         * editEventMetaData
         */
        scope.doEditEventMetaData = function() {
          $('.popover-content')
            .parent()
            .remove();

          // edit status
          if (
            scope.editEventMetaData.properties.status !=
            scope.tmpeditEventMetaData.properties.status
          ) {
            gaDomUtils.showGlobalLoader();
            CalendarFactory.updateeventstatus({
              event_id: scope.editEventMetaData.id,
              status: scope.tmpeditEventMetaData.properties.status,
            }).then(
              function(res) {
                scope.editEventMetaData.properties.status =
                  scope.tmpeditEventMetaData.properties.status;

                if (scope.forceCloseTask.v) {
                  TaskFactory.updatetaskstatus({
                    task_id: currentTask.id,
                    status: 'cloture',
                  }).then(
                    function(res) {
                      currentTask.properties.status = 'cloture';
                      gaDomUtils.hideGlobalLoader();
                    },
                    function() {
                      gaDomUtils.hideGlobalLoader();
                    }
                  );
                } else {
                  gaDomUtils.hideGlobalLoader();
                }
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        /* -************************************
         *  Task to template
         * ***********************************/
        /**
         *
         */
        var _taskToTemplateDialog;
        scope.taskToTemplateDialog = function(task) {
          var tplEvents = angular.copy(scope.tasksEvents[task.id]);
          tplEvents.forEach(function(tplEvent, idx) {
            var date1 = moment(tplEvent.properties.start),
              date2 = moment(tplEvent.properties.end);

            tplEvents[idx].properties.duration = moment
              .duration(date2.diff(date1))
              .asSeconds();
            tplEvents[idx].properties.duration_display = moment
              .utc(tplEvents[idx].properties.duration * 1000)
              .format('HH[h]mm');
          });

          scope.taskTemplate = {
            title: task.properties.title,
            description: task.properties.description,
            events: $filter('orderBy')(tplEvents, 'properties.start', false),
          };

          _taskToTemplateDialog = ngDialog.open({
            template:
              'js/XG/containers/views/modals/taskmanager.task.to.template.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * caculDelaiEntreEvents
         * @param index
         */
        scope.caculDelaiEntreEvents = function(index) {
          var date1 = moment(
              scope.taskTemplate.events[index - 1].properties.start
            ),
            date2 = moment(scope.taskTemplate.events[index].properties.start),
            duration = moment.duration(date2.diff(date1));

          scope.taskTemplate.events[index].delai = duration.asSeconds();
          scope.taskTemplate.events[index].delai_display = Math.round(
            duration.asDays()
          );
        };

        /**
         * canSaveTemplate
         * @returns {boolean}
         */
        scope.canSaveTemplate = function() {
          return (
            scope.taskTemplate.tile != '' &&
            scope.taskTemplate.description != ''
          );
        };

        /**
         * saveTaskTemplate
         */
        scope.saveTaskTemplate = function() {
          var toSave = {
            title: scope.taskTemplate.title,
            description: scope.taskTemplate.description,
            events: [],
          };

          scope.taskTemplate.events.forEach(function(event) {
            toSave.events.push({
              title: event.properties.title,
              description: event.properties.description,
              type_evenement: event.properties.type_evenement,
              color: event.properties.color,
              delai: event.delai ? event.delai_display * 24 * 3600 : 0,
              duration: event.properties.duration,
            });
          });

          console.log(toSave);
          gaDomUtils.showGlobalLoader();

          ParametersFactory.add(
            toSave,
            'TaskTemplate',
            toSave.title.replace(/ /g, '_')
          ).then(function(res) {
            if (
              res.data ==
              'Ajout impossible: un paramètre avec le même nom existe déjà.'
            ) {
              require('toastr').error(res.data);
              gaDomUtils.hideGlobalLoader();
              return false;
            }
            _taskToTemplateDialog.close();
            gaDomUtils.hideGlobalLoader();
            require('toastr').success($filter('translate')('common.saved'));
            getTaskTemplates();
          });
        };

        /**
         * getEventRGBAColor
         * @param color
         * @returns {string}
         */
        scope.getEventRGBAColor = function(color) {
          var r = parseInt(color.substring(0, 2), 16);
          var g = parseInt(color.substring(2, 4), 16);
          var b = parseInt(color.substring(4, 6), 16);

          return 'rgba(' + r + ',' + g + ',' + b + ',.65)';
        };
      },
    };
  };
  taskManager.$inject = [
    'TaskFactory',
    'gaDomUtils',
    'ngDialog',
    'EditFactory',
    '$timeout',
    'CalendarFactory',
    'ParametersFactory',
    '$filter',
    '$q',
    'gaJsUtils',
  ];
  return taskManager;
});
