/**
 *
 */
'use strict';
define(function() {
  var ffpl2Ctrl = function(
    $scope,
    FeatureTypeFactory,
    QueryFactory,
    GlobalServices
  ) {
    var fieldDesc, fieldValue, featureName;
    var objectFields, specialFields, excludedFields;
    var fieldOrder;
    var panelFields;
    var relations;
    var relMainFields;
    var ind0 = 0;
    var ind1;
    var ind2 = 0;
    var ind3;
    var indFD;
    var fieldList = [];
    var fieldGroups = [];
    var panel, config, inlineConfigs;

    $scope.g2c_widname = 'ffpl2';
    if ($scope.$parent.panel != undefined) panel = $scope.$parent.panel;
    else if ($scope.$parent.tab != undefined) panel = $scope.$parent.tab;
    else if ($scope.theStep != undefined) panel = $scope.theStep;
    else if ($scope.$parent.theStep != undefined)
      panel = $scope.$parent.theStep;

    if (panel == null) panel = $scope.panel;
    if (panel != null) {
      fieldDesc = panel.fieldDesc;
      objectFields = panel.objectFields;
      fieldOrder = panel.fieldOrder;
      panelFields = panel.panelFields;
      relMainFields = panel.tableMainFields;
      specialFields = panel.specialFields;
      excludedFields = panel.excludedFields;
      config = panel.config;
    } else {
      if ($scope.$parent != null) {
        fieldDesc = $scope.$parent.descField;
        objectFields = $scope.$parent.objectFields;
        config = $scope.$parent.config;
        fieldOrder = config.fieldOrder;
        panelFields = config.panelFields;
        specialFields = config.specialFields;
        relMainFields = config.tableMainFields;
        //-- useless relationsCfg = config.relations;
        inlineConfigs = config.inlineConfig;
        //-- useless fieldActions = config.fieldActions;
        excludedFields = config.excludedFields;
        /* useless
                if (config.inlineInput!=null) 
                    inlineInput = $scope.$parent.config.inlineInput; 
                    */
      }
    }
    relations = fieldDesc.relations;
    featureName = fieldDesc.name;
    fieldDesc = fieldDesc.attributes;
    if (relations == null) relations = [];
    if (specialFields == null) specialFields = [];
    if (relMainFields == null) relMainFields = [];
    if (inlineConfigs === undefined) inlineConfigs = [];

    $scope.getDataStoreNameForField = function(field, inlineConfig) {
      var datastoreName;

      if (field.inlineConfig != null)
        datastoreName = inlineConfig.datastoreName;
      else if (config != undefined) {
        datastoreName = config.datastoreName;
        field.featureName = config.featureName;
      }
      if (datastoreName === undefined)
        datastoreName = $scope.theField01.datastoreName;

      return datastoreName;
    };

    // No panel field list defined so we use all the fields of the table description.
    if (panelFields == null) {
      panelFields = [];
      for (; ind2 < fieldDesc.length; ind2++) {
        panelFields[ind2] = {};
        panelFields[ind2].field = fieldDesc[ind2].name;
      }
      // Add relations (at the end by default)
      for (ind1 = 0; ind1 < relations.length; ind1++) {
        panelFields[ind2] = {};
        panelFields[ind2].field = relations[ind1].name;
        panelFields[ind2].datastoreName = $scope.getDataStoreNameForField(
          panelFields[ind2],
          inlineConfigs[0]
        );
        ind2++;
      }
    }

    // No field ordering defined so we build it from panel field list.
    if (fieldOrder == null || fieldOrder.length == 0) {
      fieldOrder = [];
      for (ind2 = 0; ind2 < panelFields.length; ind2++)
        //-- When the field is a group there is no "field" attribute
        if (panelFields[ind2].field != undefined)
          fieldOrder[ind2] = panelFields[ind2].field;
    }

    //-- Remove excluded fields
    //--   In case there is one excluded field given as a string, put it into an array.
    //--   Look for each excluded field in the panel field list
    //--   when found remove it.
    if (excludedFields.trim != undefined) {
      var theField = excludedFields;
      excludedFields = [];
      excludedFields.push(theField);
    }
    for (ind1 = 0; ind1 < excludedFields.length; ind1++)
      for (ind2 = 0; ind2 < panelFields.length; ind2++)
        if (excludedFields[ind1] == panelFields[ind2].field) {
          panelFields.splice(ind2, 1);
          break;
        }

    /**
     * TODO
     */
    $scope.getIndFieldDescriptorFor = function(fieldName) {
      var indFD;

      for (indFD = 0; indFD < fieldDesc.length; indFD++) {
        if (fieldDesc[indFD].name == fieldName) {
          fieldList[ind0].fieldDesc = fieldDesc[indFD];
          break;
        }
      }
      if (indFD == fieldDesc.length) return -1;
      else return indFD;
    };

    $scope.manageSpecialFields = function(ind1, ind0) {
      var sf = specialFields[fieldOrder[ind1]];

      //-- visibility conditions
      if (sf.visibleCondition != undefined) {
        if (fieldList[ind0].fieldDesc == undefined)
          fieldList[ind0].fieldDesc = {};
        fieldList[ind0].fieldDesc.visibilityDependsOn = sf.visibleCondition;
      }
      if (sf.dependentFields != undefined) {
        fieldList[ind0].fieldDesc.dependentFields = sf.dependentFields;
      }

      if (sf.rows != null) fieldList[ind0].rows = sf.rows;
      if (sf.type != null)
        if (sf.type == 'comment') {
          if (fieldList[ind0].fieldDesc != null) {
            fieldList[ind0].fieldDesc.fieldTypeIsComment = true;
            fieldList[ind0].fieldDesc.fieldTypeIsString = false;
          }
        }
      //-- Specific alias
      if (sf.alias != undefined) {
        if (fieldList[ind0].fieldDesc == undefined)
          fieldList[ind0].fieldDesc = {};
        fieldList[ind0].fieldDesc.alias = sf.alias;
      }

      //--
      if (sf.selectWithForm != undefined) {
        if (fieldList[ind0].fieldDesc == undefined)
          fieldList[ind0].fieldDesc = {};
        fieldList[ind0].fieldDesc.fieldTypeIsRelationWithForm =
          sf.selectWithForm;
      }

      if (sf.configName != undefined)
        fieldList[ind0].configName = sf.configName;

      if (sf.storeAs != undefined) fieldList[ind0].storeAs = sf.storeAs;
    };

    $scope.manageReportOrRelationThrough = function(
      fieldOrder,
      ind1,
      fieldList,
      ind0,
      relations,
      objectFields,
      config,
      panelFields
    ) {
      //-- The field is not a modelized relation, is it an access to an attribute through relations ?
      if (fieldOrder[ind1].indexOf('.') != -1) {
        //-- In such a case, get the field description and value
        var tableDesc = $scope.getRelatedDesc(
          fieldOrder[ind1],
          config.datastoreName
        );
        fieldList[ind0].fieldDesc = $scope.getRelatedDescForFieldList(
          tableDesc,
          fieldOrder[ind1]
        );
        if (fieldList[ind0].fieldDesc == null)
          fieldList[ind0] = $scope.getRelatedDescForRelation(
            tableDesc,
            fieldOrder[ind1],
            fieldList[ind0],
            objectFields
          );
        $scope.getRelatedFieldInformation(
          fieldOrder[ind1],
          fieldOrder[ind1],
          relations,
          objectFields,
          config.datastoreName,
          null
        );
      } else if (fieldOrder[ind1] == '__==report==__') {
        fieldList[ind0].fieldDesc = {};
        fieldList[ind0].fieldDesc.alias = panelFields[ind2].report.alias;
        fieldList[ind0].report = panelFields[ind2].report.reportName;
        fieldList[ind0].fieldDesc.fieldTypeIsReport = true;
      }
    };

    /**
     *        Create field description in order to correctly manage it,
     *    whether it is for displaying information or creating/updating
     *    an object.
     */
    $scope.describeField = function(ind1) {
      var ind2, indFD, ind3;

      for (ind2 = 0; ind2 < panelFields.length; ind2++) {
        //			 if (panelFields[ind1].field!=null && panelFields[ind1].field==fieldOrder[ind1])
        // Simple field
        if (panelFields[ind2].field == fieldOrder[ind1]) {
          fieldList[ind0] = angular.copy(panelFields[ind2]);
          if (panel.objectId != undefined)
            fieldList[ind0].objectId = panel.objectId;
          indFD = $scope.getIndFieldDescriptorFor(fieldOrder[ind1]);
          if (indFD == -1)
            //-- Field is not in the attribute list so it may be a relation
            for (indFD = 0; indFD < relations.length; indFD++) {
              if (relations[indFD].name == fieldOrder[ind1]) {
                //-- The field is a relation
                fieldList[ind0].relation = relations[indFD];
                fieldList[ind0].fieldDesc = {};
                fieldList[ind0].fieldDesc.fieldTypeIsRelation = true;
                for (ind3 = 0; ind3 < relMainFields.length; ind3++) {
                  if (
                    relMainFields[ind3].table ==
                      relations[indFD].componentEnd ||
                    relMainFields[ind3].table == relations[indFD].componentStart
                  ) {
                    fieldList[ind0].relatedObjectField =
                      relMainFields[ind3].fields[0];
                    fieldList[ind0].relatedObjectFields =
                      relMainFields[ind3].fields;
                  }
                }
                if (panelFields[ind2].lineNumber == null)
                  fieldList[ind0].lineNumber = 5;
                else fieldList[ind0].lineNumber = panelFields[ind2].lineNumber;
                if (panelFields[ind2].width == null)
                  fieldList[ind0].width = '200px';
                else fieldList[ind0].width = panelFields[ind2].width;

                // Store relation start field value in order to be able
                // to get objects already in relation with this one.
                fieldList[ind0].objectId =
                  objectFields[relations[indFD].fieldStart];

                if (fieldList[ind0].datastoreName === undefined)
                  fieldList[
                    ind0
                  ].datastoreName = $scope.getDataStoreNameForField(
                    fieldList[ind0],
                    inlineConfigs[0]
                  );
                break;
              }
            }
          if (indFD == relations.length) {
            $scope.manageReportOrRelationThrough(
              fieldOrder,
              ind1,
              fieldList,
              ind0,
              relations,
              objectFields,
              config,
              panelFields
            );
          }

          if (
            specialFields != null &&
            specialFields[fieldOrder[ind1]] != null
          ) {
            $scope.manageSpecialFields(ind1, ind0);
          }
          if ($scope.theField01 != undefined) {
            var fa;
            //-- cas normal de recup des fieldActions
            if (
              $scope.theField01.inlineConfig != undefined &&
              $scope.theField01.inlineConfig.fieldActions != undefined
            )
              fa = $scope.theField01.inlineConfig.fieldActions;
            //-- Cas des field=Actions sur un champ d'une étape de rpocédure
            if (fa == undefined && $scope.theField01.config != undefined)
              fa = $scope.theField01.config.fieldActions;
            if (fa != undefined && fa[fieldOrder[ind1]] != null)
              fieldList[ind0].fieldDesc.fieldActions = fa[fieldOrder[ind1]];
            if (fieldList[ind0].datastoreName == undefined)
              fieldList[ind0].datastoreName = $scope.theField01.datastoreName;
          }
          if (objectFields == null || objectFields[fieldOrder[ind1]] == null) {
            fieldValue = '';
          } else fieldValue = objectFields[fieldOrder[ind1]];
          if (panel.mode == 'readonly')
            fieldList[ind0].disabledFromParent = true;
          fieldList[ind0++].objectField = {
            name: fieldOrder[ind1],
            value: fieldValue,
          };
          if (
            (config != undefined && config.state == 'view') ||
            panel.mode == 'readonly'
          )
            fieldList[ind0 - 1].mode = 'readonly';
          break;
        }
      }
    };

    $scope.getConfigOfMoreInput = function(fieldName) {
      var indCfg, len;

      //-- fieldName is like __moreInputs__0__
      //-- moreInputConfig is an array of configurations.
      if (panel.moreInputsConfig != undefined) {
        //-- Calculate the length of the index
        len = 1;
        while (fieldName.substr(14 + len, 1) != '_') len++;
        //-- Get the index from the field name
        indCfg = parseInt(fieldName.substr(14, len));
        //-- If the index is in the bounds of the array, return the matching configuration.
        if (indCfg < panel.moreInputsConfig.length)
          return panel.moreInputsConfig[indCfg].moreInputConfig;
      }
      //-- Could not get the configuration so return NULL.
      return null;
    };

    $scope.getGeometryField = function(fieldOrder, ind1, panel) {
      var field, typeInfo;

      field = {};
      field.field = fieldOrder[ind1];
      if (panel.objectId != undefined) field.objectId = panel.objectId;
      field.fieldDesc = {};
      field.fieldDesc.fieldTypeIsGeometry = true;
      field.fieldDesc.type = 'geometry';
      if (panel.fieldDesc != undefined) {
        field.geomEpsg = panel.fieldDesc.srid;
        field.featureTypeName = panel.fieldDesc.name;
        field.datastoreName = panel.fieldDesc.storeName;
        typeInfo = panel.fieldDesc.typeInfo;
      } else if (panel.descField != undefined) {
        field.geomEpsg = panel.descField.srid;
        field.featureTypeName = panel.descField.name;
        field.datastoreName = panel.descField.storeName;
        typeInfo = panel.descField.typeInfo;
      }
      field.objectField = {};
      if ($scope.objectGeometry != undefined) {
        field.objectField.value = $scope.objectGeometry;
        if ($scope.objectGeometry.type.indexOf('olygon') != -1)
          field.fieldDesc.alias = 'Contour';
        else if ($scope.objectGeometry.type.indexOf('ine') != -1)
          field.fieldDesc.alias = 'Ligne';
        else field.fieldDesc.alias = 'Localisation';
      } else {
        field.objectField.value = {};
        switch (typeInfo) {
          case 'POINT':
            field.objectField.value.type = 'Point';
            field.fieldDesc.alias = 'Localisation';
            break;
          case 'LINE':
            field.objectField.value.type = 'LineString';
            field.fieldDesc.alias = 'Ligne';
            break;
          case 'POLYGON':
            field.objectField.value.type = 'Polygon';
            field.fieldDesc.alias = 'Contour';
            break;
        }
      }
      field.objectField.name = '__geom__';
      return field;
    };

    $scope.prepareStepContainer = function(ind1) {
      $scope.stepContainer = true;
      $scope.stepConfig = panelFields[ind1];
      $scope.stepDescField = panel.fieldDesc;
      //-- ComponentEnd is useful for step container
      for (var ind2 = 0; ind2 < panel.fieldDesc.relations.length; ind2++) {
        var ftinforel = FeatureTypeFactory.getFeatureTypeDesc(
          panel.fieldDesc.storeName,
          panel.fieldDesc.relations[ind2].componentEnd
        );
        panel.fieldDesc.relations[ind2].componentEndDescField = ftinforel;
      }
      //-- Called from relation form field so parent is probably not known
      if ($scope.relatedObjects.features.length == 0)
        $scope.objectId = undefined;
      else
        $scope.objectId = QueryFactory.getFeatureId(
          $scope.relatedObjects.features[0]
        );
    };

    $scope.checkReportFieldsForContainer = function(config) {
      if (config != undefined && config.reportFields != undefined) {
        for (var indRf = 0; indRf < config.reportFields.length; indRf++) {
          for (var indF = 0; indF < $scope.fieldList.length; indF++) {
            if (
              $scope.fieldList[indF].fieldDesc != undefined &&
              $scope.fieldList[indF].fieldDesc.name ==
                config.reportFields[indRf].field
            ) {
              $scope.fieldList[indF].config = config.reportFields[indRf].config;
              break;
            }
          }
        }
      }
    };

    for (ind1 = 0; ind1 < fieldOrder.length; ind1++) {
      if (fieldOrder[ind1].substr(0, 14) == '__moreInputs__') {
        fieldList[ind0] = {};
        fieldList[ind0].field = fieldOrder[ind1];
        fieldList[ind0].relations = relations;
        fieldList[ind0].config = $scope.getConfigOfMoreInput(fieldOrder[ind1]);
        if (panel.objectId != undefined)
          fieldList[ind0].objectId = panel.objectId;
        if (panel.mode == 'readonly') fieldList[ind0].disabledFromParent = true;
        ind0++;
      } else if (fieldOrder[ind1] == '__geom__') {
        fieldList[ind0] = $scope.getGeometryField(fieldOrder, ind1, panel);
        ind0++;
      } else $scope.describeField(ind1);
    }

    ind0 = 0;
    for (ind1 = 0; ind1 < panelFields.length; ind1++) {
      if (panelFields[ind1].group != null) {
        fieldGroups[ind0] = panelFields[ind1];
        if ($scope.tab != undefined && $scope.tab.inlineConfigs != undefined)
          for (var ii = 0; ii < $scope.tab.inlineConfigs.length; ii++)
            if (
              $scope.tab.inlineConfigs[ii].featureName == featureName &&
              $scope.tab.inlineConfigs[ii].state == 'view'
            )
              fieldGroups[ind0].mode = 'readonly';
        fieldGroups[ind0].fieldDesc = fieldDesc;
        fieldGroups[ind0].fieldOrder = panelFields[ind1].group.fieldOrder;
        fieldGroups[ind0].panelFields = panelFields[ind1].group.panelFields;
        fieldGroups[ind0].title = panelFields[ind1].group.title;
        fieldGroups[ind0].moreInputs = panelFields[ind1].group.moreInputs;
        fieldGroups[ind0].relations = relations;
        fieldGroups[ind0++].objectFields = objectFields;
      } else if (panelFields[ind1].stepsConfig != undefined) {
        $scope.prepareStepContainer(ind1);
      }
    }

    $scope.fieldList = fieldList;
    $scope.fieldGroups = fieldGroups;

    $scope.checkReportFieldsForContainer(config);

    /**yyyyyyyyyyy commenter  TODO
     *
     */
    $scope.setDate = function(ind) {
      var strDate, dDate, ms;

      if (
        $scope.fieldList[ind].objectField.value != null &&
        $scope.fieldList[ind].objectField.value.trim != undefined
      ) {
        //-- Actually the date is a string ...
        //-- Betting the date has the expected JAVA GEoJSson format
        //-- convert it into a Date (format example: 2015-02-03T23:00:00.000+0000)
        strDate = $scope.fieldList[ind].objectField.value;
        dDate = new Date();
        dDate.setFullYear(strDate.substr(0, 4));
        dDate.setMonth(strDate.substr(5, 2) - 1);
        dDate.setDate(strDate.substr(8, 2));
        dDate.setHours(strDate.substr(11, 2));
        dDate.setMinutes(strDate.substr(14, 2));
        dDate.setSeconds(strDate.substr(17, 2));
        //----- TODO Modify server side after better DATE managemen
        //-- Date returned is day-1 23H00 so we add 2 hours
        //-- (one should be enough ...) to display correct date.
        //-- In the DB the displayed date is OK.
        //-- When date will be better managed we'll get rid of this.
        ms = dDate.getTime() + 7200000; //  = 60 secondes x 1000 x 60 minutes x 2 heures
        dDate.setTime(ms);
        $scope.fieldList[ind].objectField.value = dDate;
      }
    };

    /**
     *       RelationFormField got the related objects and send a message
     *   to inform children amongst them this panel form field.
     *   This panel form field catches the message
     *   in order to store the existing/current value in the objectField.value attribute.
     */
    $scope.$on('gotRelatedObjects', function(event, data) {
      var ind1, attName;
      if (
        data.etapeId == $scope.theField01.objectId ||
        ($scope.idOfDirectParentScope == data.scopeId &&
          data.scopeId != undefined)
      ) {
        for (ind1 = 0; ind1 < $scope.fieldList.length; ind1++) {
          //-- In case of a "moreInputs" field objectField is not defined.
          //-- Moreover the fields and their values are managed in another
          //-- field container and nothing has to be displayed here.
          if ($scope.fieldList[ind1].objectField != undefined) {
            attName = $scope.fieldList[ind1].objectField.name;
            if (data.objects.features[0].properties.hasOwnProperty(attName)) {
              if (
                $scope.fieldList[ind1].fieldDesc != undefined &&
                $scope.fieldList[ind1].fieldDesc.fieldTypeIsBoolean
              ) {
                if (data.objects.features[0].properties[attName])
                  $scope.fieldList[ind1].objectField.value = '1';
                else $scope.fieldList[ind1].objectField.value = '0';
              } else
                $scope.fieldList[ind1].objectField.value =
                  data.objects.features[0].properties[attName];
              if ($scope.fieldList[ind1].fieldDesc.fieldTypeIsDate)
                $scope.setDate(ind1);
            } else if (attName == '__geom__') {
              $scope.fieldList[ind1].objectField.value.coordinates =
                data.objects.features[0].geometry.coordinates;
            }
          }
        }
        if ($scope.fieldGroups != undefined)
          for (ind1 = 0; ind1 < $scope.fieldGroups.length; ind1++)
            $scope.fieldGroups[ind1].objectFields =
              data.objects.features[0].properties;
        if (data.setFieldMode !== undefined)
          $scope.$broadcast('setFieldMode', data);
      }
    });

    $scope.$on('logicalDependencyParentChangedTriggered', function(
      event,
      data
    ) {
      $scope.$broadcast('logicalDependencyParentChangedDispatched', data);
    });

    $scope.getFieldValue = function(fieldName) {
      return $scope.theStep.objectFields[fieldName];
    };

    $scope.controlFields = function(params) {
      var theField,
        fullFieldName,
        objFields,
        controls,
        theStep,
        theConfig,
        ret = {};

      if (params.theField01 != undefined) theField = params.theField01;
      if (config != undefined && config.controls != undefined) {
        theConfig = config;
      }
      if (
        params.theStep != undefined &&
        params.theStep.config != undefined &&
        params.theStep.config.controls != undefined
      ) {
        theStep = params.theStep;
        theConfig = params.theStep.config;
      }
      if (theConfig != undefined) controls = theConfig.controls;
      if (controls != undefined) {
        objFields = objectFields;
        fullFieldName = theField.field;

        if (theStep != undefined) {
          objFields = {};
          for (var iStep = 0; iStep < $scope.steps.length; iStep++)
            for (var prop in $scope.steps[iStep].objectFields)
              if (
                $scope.steps[iStep].featureName + '.' + prop !=
                theStep.featureName + '.' + theField.field
              )
                objFields[$scope.steps[iStep].featureName + '.' + prop] =
                  $scope.steps[iStep].objectFields[prop];
          objFields[theStep.featureName + '.' + theField.field] = undefined;
          //delete objFields[theStep.featureName+"."+theField.field];
          fullFieldName = theStep.featureName + '.' + theField.field;
          objFields[fullFieldName] = theField.objectField.value;
          objFields[theStep.featureName + '.a' + theField.field] =
            theField.objectField.value;
        }

        if (
          !GlobalServices.controlsOk(objFields, theConfig, ret, fullFieldName)
        ) {
          var fn, featName;
          for (var iField = 0; iField < $scope.fieldList.length; iField++) {
            fn = ret.nameOfWrongAttribute;
            if (fn.indexOf('.') != -1) {
              fn = ret.nameOfWrongAttribute.split('.');
              fn = fn[1];
            }
            if ($scope.fieldList[iField].field == fn) {
              $scope.fieldList[iField].objectField.value =
                objFields[ret.nameOfWrongAttribute];
              if (theStep != undefined)
                $scope.steps[theStep.index].objectFields[fn] =
                  objFields[ret.nameOfWrongAttribute];
            }
          }
          return false;
        }
      }

      return true;
    };

    /**
     *
     */
    // When a value has been changed we get all values from lower components
    $scope.valueChangedFunction = true;
    $scope.valueChanged = function(param) {
      var fn;

      for (ind0 = 0; ind0 < $scope.fieldList.length; ind0++) {
        if ($scope.fieldList[ind0].objectField != undefined) {
          fn = $scope.fieldList[ind0].objectField.name;
          //-- Cas du "moreinputs" : pas dobjectField.
          if ($scope.fieldList[ind0].objectField != undefined)
            objectFields[fn] = $scope.fieldList[ind0].objectField.value;
          //-- Cas de l'étape de procédure
          if ($scope.theStep != undefined)
            $scope.theStep.objectFields[fn] =
              $scope.fieldList[ind0].objectField.value;
        }
      }
      for (ind0 = 0; ind0 < fieldGroups.length; ind0++) {
        for (
          ind1 = 0;
          ind1 < $scope.fieldGroups[ind0].fieldOrder.length;
          ind1++
        ) {
          fn = $scope.fieldGroups[ind0].fieldOrder[ind1];
          objectFields[fn] = $scope.fieldGroups[ind0].objectFields[fn];
        }
      }
      if ($scope.$parent.valueChangedFunction === true) {
        $scope.$parent.valueChanged();
      }
      if (param != undefined && param.fieldName != undefined)
        $scope.$broadcast('oneFieldHasChanged', {
          modifiedFieldname: param.fieldName,
        });
    };

    $scope.getRelatedFieldInformation = function(
      fieldName0,
      fieldName,
      relations,
      object,
      storeName,
      inTableDesc
    ) {
      var tableName, tableDesc, where, theField;
      var fn, val;
      var indPt = fieldName.indexOf('.');

      if (indPt == -1) {
        //-- The parent who does the update into the database
        //-- must know the id of the related object, so we send it now.
        if (object.id != undefined)
          $scope.$emit('gotRecordIdOfRelatedField', object.id);
        //-- No point in the field name so we reached the field name.
        for (var ind0 = 0; ind0 < $scope.fieldList.length; ind0++) {
          //-- When the field name is found we set its value and description.
          if ($scope.fieldList[ind0].objectField == undefined) {
            fn = $scope.fieldList[ind0].field;
            $scope.fieldList[ind0].objectField = {};
            $scope.fieldList[ind0].objectField.name = fn;
          } else {
            fn = $scope.fieldList[ind0].objectField.name;
            if (fn != fieldName0) fn = $scope.fieldList[ind0].field;
          }
          if (fn == fieldName0) {
            $scope.fieldList[ind0].objectField.value = $scope.getValueFrom(
              object,
              fieldName,
              $scope.fieldList[ind0].objectField.name
            );
            $scope.$broadcast('gotFieldValue', {});
            //-- In case we caome here after field controller has already been
            //-- let the fieldDesc as it is, else we're gonna loose its configuration.
            //-- So only set fieldDesc when not already set.
            if ($scope.fieldList[ind0].fieldDesc == undefined)
              for (
                var indFd = 0;
                indFd < inTableDesc.attributes.length;
                indFd++
              )
                if (inTableDesc.attributes[indFd].name == fieldName) {
                  $scope.fieldList[ind0].fieldDesc =
                    inTableDesc.attributes[indFd];
                  break;
                }
            if ($scope.relFieldsInfo == undefined) $scope.relFieldsInfo = [];
            if (object.properties != undefined) {
              $scope.relFieldsInfo.push({
                updatedFromPanel: '',
                fieldName: fieldName,
                feature: object,
              });
              setTimeout($scope.sendFieldsInfo, 500);
            }
            break;
          }
        }
      } else {
        //-- Still a point in the field name so we've got to find a related object.
        tableName = fieldName.substr(0, indPt);
        for (var indRel = 0; indRel < relations.length; indRel++) {
          if (relations[indRel].componentEnd == tableName) {
            theField = relations[indRel].fieldStart;
            where = relations[indRel].fieldEnd + '=';
            break;
          }
          if (relations[indRel].componentStart == tableName) {
            theField = relations[indRel].fieldEnd;
            where = relations[indRel].fieldStart + '=';
            break;
          }
        }
        if (indRel < relations.length) {
          tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
            storeName,
            tableName
          );
          val = $scope.getValueFrom(object, theField);
          if (val == undefined)
            $scope.getRelatedFieldInformation(
              fieldName0,
              fieldName.substr(indPt + 1),
              tableDesc.relations,
              {},
              storeName,
              tableDesc
            );
          else {
            where += $scope.getValueFrom(object, theField);
            QueryFactory.data(tableDesc.uid, where).then(function(res) {
              if (res.data.features.length == 0)
                $scope.getRelatedFieldInformation(
                  fieldName0,
                  fieldName.substr(indPt + 1),
                  tableDesc.relations,
                  {},
                  storeName,
                  tableDesc
                );
              else
                for (
                  var indFeat = 0;
                  indFeat < res.data.features.length;
                  indFeat++
                ) {
                  $scope.getRelatedFieldInformation(
                    fieldName0,
                    fieldName.substr(indPt + 1),
                    tableDesc.relations,
                    res.data.features[indFeat],
                    storeName,
                    tableDesc
                  );
                }
            });
          }
        }
      }
    };
  };
  ffpl2Ctrl.$inject = [
    '$scope',
    'FeatureTypeFactory',
    'QueryFactory',
    'GlobalServices',
  ];
  return ffpl2Ctrl;
});
