'use strict';
define(() =>{
  let gcdataDictionary = (
    DataDictionaryFactory,
    $rootScope,
    RegionalFactory,
    $filter,
    FeatureTypeFactory
  ) => {
    return {
      templateUrl: 'js/XG/widgets/utilities/model/views/gcdataDictionary.html',
      restrict: 'E',
      link: (scope) => {
        scope.geocatalogueNotFromApplication = true;
        scope.edit_resource = {rightFeatures:[]};
        let portalId = $rootScope.xgos.portal.uid;
        DataDictionaryFactory.getConfig().then((res)=>{
          if(res && Array.isArray(res.data)){
            // KIS-3377 BONUS: actualise la liste des composants mémorisés en retirant ceux n’existant plus
            scope.edit_resource.rightFeatures = removeDeletedFeatureTypes(res.data);
          }
        });
        scope.exporter = () => {
          // récupère l'encodage de texte du portail. Le séparateur CSV est défini ici dans le widget
          const textEncoding = RegionalFactory.getPortalTextEncoding($rootScope.xgos.portal);

          // Puisque la sauvegarde est uniquement effectuée lors de l'export
          // saveConfig est exécutée côté serveur pour éviter d'envoyer un 2nd appel API
          DataDictionaryFactory.exportCSV(scope.edit_resource.rightFeatures, textEncoding).then(res => {
            if(res && res.data){
              let win;
              if(res.data.structure){
                win = window.open(
                  '/services/' +portalId+
                  '/files/getgeneratedzip?filename='+
                  res.data.structure
                );
              }
              if(res.data.properties){
                // le timeout est juste pour attendre le close de l'autre téléchargement
                var timer = setInterval(()=> { 
                  if(angular.isUndefined(win) || win.closed) {
                      clearInterval(timer);
                      window.open(
                        '/services/' +portalId+
                        '/files/getgeneratedzip?filename='+
                        res.data.properties
                      );
                  }
                });
              }
            }
          });
        };

        /**
         * Filtre les fti qui auraient été supprimés depuis la dernière ouverture
         * @param {string[] }rightFeatures uid des composants sélectionnés
         */
        const removeDeletedFeatureTypes = (rightFeatures) => {
          if (FeatureTypeFactory.resources.featuretypes.length > 0) {
            const existingFtiUids = FeatureTypeFactory.resources.featuretypes.map(fti => fti.uid);
            rightFeatures = rightFeatures.filter(feature => existingFtiUids.includes(feature));
          }
          return rightFeatures;
        };

        scope.widget = ($filter('translate')('model.featuretypes.dataDictionary.title')).toLowerCase();
      },
    };
  };
  gcdataDictionary.$inject = [
    'DataDictionaryFactory',
    '$rootScope',
    'RegionalFactory',
    '$filter',
    'FeatureTypeFactory'
  ];
  return gcdataDictionary;
});
