'use strict';
define(function() {
  const itvvisualisation = function(
    $rootScope,
    $http,
    $filter,
    itvSoumFactory,
    itvVisuFactory,
    gclayers,
    SelectManager,
    gcStyleFactory,
    extendedNgDialog,
    QueryFactory,
    $timeout,
    gcInteractions,
    FeatureAttachmentFactory,
    $q,
    gaJsUtils,
    itvUtilsFactory,
    gaDomUtils,
    PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/itv/views/visualisation/itvVisualisation.html',
      restrict: 'A',

      link: function (scope) {
        scope.work = {};
        scope.detailKeys = [
          'color',
          'ref_photo',
          '_code_principal',
          '_emplct_lng_vert',
          '_car1',
          '_car2',
          'quant1',
          'quant2',
          'devices',
          'emplct_circ_1',
          'emplct_circ_2',
          'assemblage',
        ];
        var portalid = angular.module('gcMain').portalid;
        if (portalid == undefined || portalid == '') {
          portalid = PortalsFactory.getPortalId();
        }
        var app = angular.module('gcMain').app;
        if (app == undefined || app == '') {
          app = localStorage.getItem('app');
        }

        var map = scope.map;

        const getConfFromParents = (theScope) => {
          if (theScope.ConfigName) {
            scope.ConfigName = theScope.ConfigName;
            if (theScope.apptype === 'indigau') {
              scope.conf = theScope.conf;
            }
          }else{
            getConfFromParents(theScope.$parent);
          }
        };

        getConfFromParents(scope);

        itvSoumFactory.getConf(scope.ConfigName).then(function (conf) {
          scope.config = {
            network: conf.config.network,
            datastore: conf.config.datastore,
          };
        });

        let EVT_Inspection_Layer;
        if (scope.conf && scope.conf.arcgiscomponent
          && scope.conf.arcgiscomponent.EVT_Inspection) {
          EVT_Inspection_Layer=gclayers.getOperationalLayerByLayerName(
            scope.conf.arcgiscomponent.EVT_Inspection.name
          );
        }
        else {
          EVT_Inspection_Layer= gclayers.getOperationalLayerByLayerName(
            'EVT_Inspection'
          );
        }

        scope.visualisation = {
          selection: {
            point: {
              active: false,
              featureCollection: undefined,
            },
            polygon: {
              active: false,
              featureCollection: undefined,
            },
            courante: {
              featureCollection: undefined,
            },
            tovalidate: false,
            used: null,
          },
          inspections: {
            list: [],
            activePanel: null,
          },
        };

        scope.pointer = new ol.interaction.Draw({
          type: 'Point',
          style: new ol.style.Style({
            image: new ol.style.Circle({
              radius: 6,
              fill: new ol.style.Fill({
                color: 'rgba(0, 128, 255, 1)',
              }),
              stroke: new ol.style.Stroke({
                width: 2,
                color: 'rgba(255, 255, 255, 1)',
              }),
            }),
          }),
        });

        scope.pointer.set('gctype', 'kis');
        scope.pointer.set('interaction', 'Draw');
        scope.pointer.set('widget', 'itvVisualisation');
        scope.pointer.setActive(false);
        scope.pointer.on('drawend', function(evt) {
          try {
            var filter = gclayers.getSelectFilterasStringuid(map);
            console.log(filter);
            if (filter != '') {
              var format = new ol.format.GeoJSON();
              var feature = format.writeFeatureObject(evt.feature);

              var x = feature.geometry.coordinates[0];
              var y = feature.geometry.coordinates[1];
              var view = map.getView();
              var resolution = view.getResolution();

              // var pointExtent = [x, y , x, y];
              if (resolution != 'undefined') {
                var leftX = x - 5 * resolution;
                var rightX = x + 5 * resolution;
                var bottomY = y - 5 * resolution;
                var topY = y + 5 * resolution;
              }
              else {
                leftX = x - 5;
                rightX = x + 5;
                bottomY = y - 5;
                topY = y + 5;
              }

              var catchments_url = '/services/' + portalid +
                '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' + filter +
                '&outputformat=json&srsName=' +
                map.getView().getProjection().getCode() +
                '&cql_filter=INTERSECTS(geom, POLYGON((' +
                leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY +
                ',' + rightX + ' ' + topY + ',' + leftX + ' ' + topY +
                ',' + leftX + ' ' + bottomY + ')))';

              var promise = $http.get(catchments_url);
              promise.then(function(res) {
                if (res.data.totalFeatures !== 0) {
                  scope.visualisation.selection.point.featureCollection =
                    res.data;
                  scope.visualisation.selection.point.id = filter;
                  SelectManager.addFeaturesFromGeojson(
                    scope.visualisation.selection.point.featureCollection
                  );
                  require('toastr').success(
                    $filter('translate')('itv.correspondance.featureselected')
                  );
                  scope.visualisation.selection.tovalidate = true;
                }
                else {
                  scope.visualisation.selection.point.featureCollection = undefined;
                  require('toastr').error(
                    $filter('translate')('itv.correspondance.nofeatureselected')
                  );
                }
              });
            }
            else {
              require('toastr').error(
                $filter('translate')('itv.correspondance.nolayerselected')
              );
            }
          }
          catch (e) {
            require('toastr').error(
              $filter('translate')('itv.correspondance.nofeatureselected')
            );
          }
        });


        var dragBoxStyle = gcStyleFactory.getStyle('selectrectangle');
        scope.dragBox = new ol.interaction.DragBox({
          type: 'Polygon',
          style: dragBoxStyle,
        });

        scope.dragBox.set('gctype', 'kis');
        scope.dragBox.set('interaction', 'Select');
        scope.dragBox.set('widget', 'itvVisualisation');
        scope.dragBox.setActive(false);
        scope.dragBox.on('boxend', () => {
          try {
            var filter = gclayers.getSelectFilterasStringuid(map);
            if (filter != '') {
              var geometryExtent = scope.dragBox.getGeometry().getExtent();

              var leftX = geometryExtent[0];
              var bottomY = geometryExtent[1];

              var rightX = geometryExtent[2];
              var topY = geometryExtent[3];

              //var catchments_url = '/geoserver/'+PortalsFactory.getPortalId()+'/ows?service=WFS&version=1.0.0&request=GetFeature&typeName='+ filter +'&outputformat=json&srsName='+map.getView().getProjection().getCode()+'&bbox=' + scope.dragBox.getGeometry().getExtent() +','+map.getView().getProjection().getCode();

              var catchments_url =
                '/services/' +
                PortalsFactory.getPortalId() +
                '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' +
                filter + '&outputformat=json&srsName=' + map.getView().getProjection().getCode() +
                '&cql_filter=INTERSECTS(geom, POLYGON((' +
                leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' +
                rightX + ' ' + topY + ',' + leftX + ' ' + topY + ',' + leftX +
                ' ' + bottomY + ')))';

              var promise = $http.get(catchments_url);
              promise.then(function(res) {
                if (res.data.totalFeatures !== 0) {
                  scope.visualisation.selection.polygon.featureCollection =
                    res.data;
                  scope.visualisation.selection.polygon.id = filter;
                  SelectManager.addFeaturesFromGeojson(
                    scope.visualisation.selection.polygon.featureCollection
                  );
                  require('toastr').success(
                    $filter('translate')('itv.correspondance.featureselected')
                  );
                  scope.visualisation.selection.tovalidate = true;
                }
                else {
                  scope.visualisation.selection.polygon.featureCollection = undefined;
                  require('toastr').error(
                    $filter('translate')('itv.correspondance.nofeatureselected')
                  );
                }
              });
            }
          }
          catch (e) {
            require('toastr').error(
              $filter('translate')('itv.correspondance.nofeatureselected')
            );
          }
        });

        scope.selectbypoint = function() {
          SelectManager.clear();
          if (
            angular.isDefined(
              scope.visualisation.selection.point.featureCollection
            )
          )
            scope.visualisation.selection.point.featureCollection = undefined;
          if (
            angular.isDefined(
              scope.visualisation.selection.polygon.featureCollection
            )
          )
            scope.visualisation.selection.polygon.featureCollection = undefined;
          if (
            angular.isDefined(
              scope.visualisation.selection.courante.featureCollection
            )
          )
            scope.visualisation.selection.courante.featureCollection = undefined;

          if (scope.visualisation.selection.polygon.active) {
            scope.visualisation.selection.polygon.active = false;
            scope.visualisation.selection.tovalidate = false;
            scope.dragBox.setActive(false);
            map.removeInteraction(scope.dragBox);
          }

          var modif = false;
          gclayers.getOperationalLayer().forEach(function(layer) {
            if (EVT_Inspection_Layer.get('fti').uid === layer.get('fti').uid) {
              if (!layer.getVisible()) {
                modif = true;
                layer.setVisible(true);
              }
              if (!layer.selected) {
                layer.selected = true;
                gclayers.addToSelectFilter(layer);
              }
            }
            else {
              if (layer.selected) {
                layer.selected = false;
                gclayers.removeSelectFilter(layer);
              }
            }
          });
          if (modif) {
            $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
          }

          if (!scope.visualisation.selection.point.active) {
            scope.visualisation.selection.point.active = true;
            scope.pointer.setActive(true);
            gcInteractions.setCurrentToolBar(scope.toolBarWidget);
            map.addInteraction(scope.pointer);
          }
          else {
            scope.visualisation.selection.point.active = false;
            scope.visualisation.selection.tovalidate = false;
            scope.pointer.setActive(false);
            map.removeInteraction(scope.pointer);
            SelectManager.clear();
          }
        };

        scope.selectbypolygon = function() {
          SelectManager.clear();
          if (
            angular.isDefined(
              scope.visualisation.selection.point.featureCollection
            )
          )
            scope.visualisation.selection.point.featureCollection = undefined;
          if (
            angular.isDefined(
              scope.visualisation.selection.polygon.featureCollection
            )
          )
            scope.visualisation.selection.polygon.featureCollection = undefined;
          if (
            angular.isDefined(
              scope.visualisation.selection.courante.featureCollection
            )
          )
            scope.visualisation.selection.courante.featureCollection = undefined;

          if (scope.visualisation.selection.point.active) {
            scope.visualisation.selection.point.active = false;
            scope.visualisation.selection.tovalidate = false;
            scope.pointer.setActive(false);
            map.removeInteraction(scope.pointer);
          }
          var modif = false;
          gclayers.getOperationalLayer().forEach(function(layer) {
            if (EVT_Inspection_Layer.get('fti').uid === layer.get('fti').uid) {
              if (!layer.getVisible()) {
                modif = true;
                layer.setVisible(true);
              }
              if (!layer.selected) {
                layer.selected = true;
                gclayers.addToSelectFilter(layer);
              }
            }
            else {
              if (layer.selected) {
                layer.selected = false;
                gclayers.removeSelectFilter(layer);
              }
            }
          });
          if (modif) {
            $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
          }

          if (!scope.visualisation.selection.polygon.active) {
            scope.visualisation.selection.polygon.active = true;
            gcInteractions.setCurrentToolBar(scope.toolBarWidget);
            scope.dragBox.setActive(true);
            map.addInteraction(scope.dragBox);
          }
          else {
            scope.visualisation.selection.polygon.active = false;
            scope.dragBox.setActive(false);
            map.removeInteraction(scope.dragBox);
            SelectManager.clear();
            scope.visualisation.selection.tovalidate = false;
          }
        };

        scope.selectionCourante = function() {
          if (
            angular.isDefined(
              scope.visualisation.selection.point.featureCollection
            )
          )
            scope.visualisation.selection.point.featureCollection = undefined;
          if (
            angular.isDefined(
              scope.visualisation.selection.polygon.featureCollection
            )
          )
            scope.visualisation.selection.polygon.featureCollection = undefined;
          if (
            angular.isDefined(
              scope.visualisation.selection.courante.featureCollection
            )
          )
            scope.visualisation.selection.courante.featureCollection = undefined;

          var featuresinselectmgr = SelectManager.getfeatures();
          if (
            !angular.isUndefined(featuresinselectmgr.totalFeatures) &&
            featuresinselectmgr.totalFeatures > 0
          ) {
            featuresinselectmgr.features.forEach(function(f) {
              if (f.id.indexOf(EVT_Inspection_Layer.get('fti').name) !== -1) {
                if (
                  angular.isUndefined(
                    scope.visualisation.selection.courante.featureCollection
                  )
                ) {
                  scope.visualisation.selection.courante.featureCollection = {
                    crs: featuresinselectmgr.crs,
                    type: 'FeatureCollection',
                    totalFeatures: 1,
                    features: [],
                  };
                }
                scope.visualisation.selection.courante.featureCollection.features.push(
                  f
                );
                scope.visualisation.selection.courante.featureCollection.totalFeatures =
                  scope.visualisation.selection.courante.featureCollection.features.length;
                scope.visualisation.selection.used = 'courante';
                getInspections();
              }
            });
          }
          else {
            require('toastr').error(
              $filter('translate')('itv.correspondance.nofeatureselected')
            );
          }
        };

        scope.validerSelection = function() {
          if (scope.visualisation.selection.point.active) {
            scope.visualisation.selection.point.active = false;
            scope.visualisation.selection.tovalidate = false;
            scope.pointer.setActive(false);
            scope.map.removeInteraction(scope.pointer);
            scope.visualisation.selection.used = 'point';
          }
          else if (scope.visualisation.selection.polygon.active) {
            scope.visualisation.selection.polygon.active = false;
            scope.visualisation.selection.tovalidate = false;
            scope.dragBox.setActive(false);
            scope.map.removeInteraction(scope.dragBox);
            scope.visualisation.selection.used = 'polygon';
          }
          SelectManager.clear();
          getInspections();
        };

        scope.removeSelection = function() {
          if (scope.visualisation.selection.point.active) {
            scope.visualisation.selection.point.active = false;
            scope.visualisation.selection.tovalidate = false;
            scope.pointer.setActive(false);
            map.removeInteraction(scope.pointer);
            SelectManager.clear();
          }
          else if (scope.visualisation.selection.polygon.active) {
            scope.visualisation.selection.polygon.active = false;
            scope.visualisation.selection.tovalidate = false;
            scope.dragBox.setActive(false);
            map.removeInteraction(scope.dragBox);
            SelectManager.clear();
          }
        };
        if(scope.featureToOpenWith) {
          scope.visualisation.selection.point.featureCollection =
              scope.featureToOpenWith;
          scope.visualisation.selection.point.id = gclayers.getSelectFilterasStringuid(scope.map);
          scope.visualisation.selection.used = 'point';
          itvSoumFactory.getConf(scope.ConfigName).then((conf) => {
            scope.conf = conf;
            if (scope.conf.arcgiscomponent) {
              EVT_Inspection_Layer = gclayers.getOperationalLayerByLayerName(
                scope.conf.arcgiscomponent.EVT_Inspection.name
              );
            }
            getInspections();
          });
        }


        const extractitvids = (str) => {
          var resultat = '';
          if (str) {
            angular.forEach(
              scope.visualisation.selection[str].featureCollection.features,
              function (feature, i) {
                let id = gaJsUtils.getIdInCaseEsriId(feature, EVT_Inspection_Layer.get('fti'));
                i == 0
                  ? (resultat += id.split('.')[1])
                  : (resultat += ',' + id.split('.')[1]);
              }
            );
          }
          return resultat;
        };


        const getArcGisLayers4Url = () => {
          return itvSoumFactory.arcgisConfToUrl(scope.conf);
        };


        /**
         * Mise en place du local loader sur les n premières parties
         * du widget de visualisation.
         *
         * @param {*} lastPartNumber : indice de la dernière partie concernée
         *                              du widget
         */
        const wait = (lastPartNumber) => {
          $timeout(() => {
            for (let ind = 1; ind <= lastPartNumber; ind++) {
              gaDomUtils.showLocalLoader('itv-visu-for-waiting-area' + ind);
            }
          });
        };

        /**
         * Enlever le local loader sur les n premières parties
         * du widget de visualisation.
         *
         * @param {*} lastPartNumber : indice de la dernière partie concernée
         *                              du widget
         */
        const doNotWaitAnymore = (lastPartNumber) => {
          for (let ind = 1; ind <= lastPartNumber; ind++) {
            gaDomUtils.removeLocalLoader('itv-visu-for-waiting-area'+ind);
          }
        };


        /**
         * vérifie si une correspondance avec un élément du réseau a été faite
         * pour la portion.
         *
         * @param {*} part Portion à vérifier
         * @returns VRAI si la portion a des éléments en correspondance,
         *          FAUX sinon
         */
        const partHasMapping = (part) => {
          //-- Liste des codes auxquels un élément du réseau peut être associé
          const codes = part.branchement
            ? ['@01',  'AAT', 'AAU'] : ['AAA', 'CAA', 'AAD', 'AAF'];
          //-- Recherche d'un header associé à un élément du réseau
          for (let code of codes) {
            let header = part.headers.find(header => header._code === code);
            if (header && header.featUid && header.featUid!=='null') {
              return true;
            }
          }
          return false;
        };


        /**
         * Pour chaque portion, récupération de l'adresse inspectée,
         * positionnement de l'indicateur sur les observations de type départ
         * de branchement qui proprose le branchement à la création et
         * positionnement de l'indicateur d'objet en correspondance existant
         * pour la portion.
         */
        const configureParts = (parts) => {
          for (const part of parts) {
            for (const detail of part.details.filter(
              detail => detail._code_principal === 'BCA')) {
              //-- Par défaut on crée les branchements, dans le cas
              //-- du mode "creationBranchement", on pourra décocher
              //- la case correspondante.
              detail.toCreate = true;
            }
            //-- Adresse inspectée
            const header
            = part.headers.find(header => header._code === 'AAJ');
            if (header != undefined) part.adress = header.value;
            //-- Indicateur d'objet en correspondance existant
            part.hasMapping = partHasMapping(part);
          }
        };


        const getInspections = () => {
          wait(3);
          let str = scope.visualisation.selection.used;
          itvVisuFactory.getItvFromBdd(extractitvids(str),
            scope.conf.config.datastore, scope.conf.config.network,
            getArcGisLayers4Url(), scope.ConfigName
          ).then(function (res) {
            if (res.data.objValeur) {
              if (res.data.objValeur.inspections.length > 0) {
                angular.forEach(res.data.objValeur.inspections, (inspection, i) => {
                  if (inspection.properties
                    && Object.prototype.hasOwnProperty.call(inspection.properties, 'brchtnums')
                    && inspection.properties.brchtnums.length > 0) {
                    inspection.title = inspection.properties.brchtnums;
                  }
                  else {
                    inspection.title =
                      $filter('translate')('itv.correspondance.inspection') +
                      ' ' + (i + 1);
                  }
                });
                res.data.objValeur.inspections.map(function (ins) {
                  ins.parts.map(function (p) {
                    p.partvisible = false;
                  });
                });
                scope.visualisation.inspections.list = angular.copy(
                  res.data.objValeur.inspections
                );
                for (const inspection of scope.visualisation.inspections.list) {
                  loadAttachedPdfs(inspection, 'inspection', true);
                  configureParts(inspection.parts);
                }
              }
              else {
                require('toastr').error(
                  $filter('translate')('itv.visualisation.noinspections')
                );
              }
            }
            else {
              require('toastr').error(
                $filter('translate')('itv.visualisation.problemserver')
              );
            }
            doNotWaitAnymore(3);
          },
          () => {
            doNotWaitAnymore(3);
          });
        };


        const colors = [
          {
            type: 'inventaire',
            color: '#5a89ad',
          },
          {
            type: 'structurel',
            color: '#eaf903',
          },
          {
            type: 'fonctionnel',
            color: '#d87047',
          },
          {
            type: 'autre',
            color: '#62e515',
          },
        ];


        scope.openImage = (picname, index, partdetail) => {
          scope.partdetails = scope.partClicked.details;
          if (scope.mode === 'creationBranchement') {
            scope.partdetails = scope.partdetails.filter(
              detail => detail._code_principal === 'BCA');
          }
          scope.partdetail = partdetail;
          scope.picname = picname;
          //scope.map = scope.map.getView().getProjection().getCode();
          createRapport();
        };


        const createRapport = () => {
          try {
            if (scope.dialog) scope.dialog.close(scope.dialog.id);
          }
          catch (e) {
            console.info(e.message);
          }
          scope.dialog = extendedNgDialog.open({
            template:
              'js/XG/widgets/utilities/itv/views/visualisation/itvVisualisationImageRapport.html',
            className:
              'ngdialog-theme-plain width400 nopadding miniclose itv-soumission-rapport',
            closeByDocument: false,
            scope,
            title: $filter('translate')('itv.correspondance.obsDetails'),
            draggable: true,
            minWidth: '400px',
            minHeight: '550px',
            doNotForcePopupHeightToMinHeight: true,
            preCloseCallback: function () {
              scope.map.getLayers().forEach(function (l) {
                if (l.getProperties().name === 'detail') {
                  scope.map.removeLayer(l);
                }
              });
            }
          });
        };


        const getTypeObservation = (code) => {
          switch (code.trim().substring(0, 2)) {
            case 'BA':
            case 'DA':
              return 'structurel';
            case 'BB':
            case 'DB':
              return 'fonctionnel';
            case 'BC':
            case 'DC':
              return 'inventaire';
            case 'BD':
            case 'DD':
              return 'autre';
            default:
              return 'autre';
          }
        };


        var lastPart = {};
        scope.getDetails = (part) => {
          if (!angular.equals(part, lastPart)) {

            part.details.map((x) => {
              x.type = getTypeObservation(x._code_principal);
              x.color = colors.find((color) => color.type === x.type).color;
            });

            if (scope.mode === 'creationBranchement') {
              scope.currentDetails
                = part.details.filter(
                  detail => detail._code_principal === 'BCA');
            }
            else {
              scope.currentDetails = part.details;
            }

            if (angular.isUndefined(part.createdDetails) ||
              !part.createdDetails
            ) {
              var itvids = part.properties.id_inspection;
              var itvparts = part.partId;
              var itvpartsDetails = part.details
                .map(function(detail) {
                  return detail.id;
                })
                .join(',');
              itvVisuFactory.createGeometryOfDetails(itvids, itvparts,
                scope.conf.config.datastore, scope.conf.config.network,
                getArcGisLayers4Url(), scope.ConfigName
              ).then((res) => {
                if (res.data !== null) {
                  part.detailsvisible = false;
                  scope.partClicked = part;
                  let layer = gclayers.getOperationalLayerByLayerName(
                    itvpartsDetails.split(',')[0].split('.')[0]
                  );
                    //-- Une inspection (portion) peut ne pas avoir de détails.
                  if (layer != null) {
                    layer.cql_filter = '1=1';
                    layer.visible = false;
                    $rootScope.$broadcast('gcOperationalLayerChange',
                      layer, 'visibility');
                  }
                }
                if (scope.partClicked.partId === part.partId) {
                  //-- Si on n'a pas recliqué sur une autre portion
                  //-- entre le moment où le service a été appelé
                  //-- et celui où on reçoit la réponse.
                  scope.partClicked.createdDetails = true;
                }
              });
            }
            lastPart = part;
            scope.partClicked = part;
          }
        };


        /**
         * Zoomer sur les features mises dans les layers de travail.
        */
        const zoomToExtent = (extent) => {
          if (extent[0] !== Infinity && extent[1] !== Infinity
            || extent[2] !== -Infinity && extent[3] !== -Infinity) {
            let geom = ol.geom.Polygon.fromExtent(extent);
            geom.scale(2);
            map.getView().fit(geom, map.getSize());
          }
        };


        /**
         * Zoomer sur les features mises dans les layers de travail.
         */
        const gotoLayersExtent = () => {
          let extent = new ol.extent.createEmpty();

          const layers = itvUtilsFactory.getitvoperationalLayers();
          for (const layer of layers) {
            extent = new ol.extent.extend(extent,
              layer.getSource().getExtent()
            );
          }
          //-- Prendre une marge autour de l'emprise calculée.
          //-- Ne pas mettre de marge peut empecher le zoom dans le cas où
          //-- il n'y qu'un point et que donc l'étendu est un point .
          extent[0] -= 10;
          extent[1] -= 10;
          extent[2] += 10;
          extent[3] += 10;
          map.getView().fit(extent, map.getSize());
        };


        scope.zoomOn = (part) => {
          scope.zoomonFeature = true;
          part.partvisible = true;
          scope.partClicked = part;
          if (itvUtilsFactory.getitvoperationalLayers().length > 0) {
            gotoLayersExtent();
          }
          else {
            itvUtilsFactory.clearitvoperationalLayers();
            itvVisuFactory.drawFeature(part,
              map.getView().getProjection().getCode()).then(() => {
              gotoLayersExtent();
            });
          }
        };


        scope.zoomOnInspection = (inspection) => {
          var uid = inspection.parts[0].properties.id_inspection;
          let featuid, promise;
          if (uid.indexOf('.') !== -1) {
            featuid = gclayers.getOperationalLayerByName(uid.split('.')[0])
              .uid;
            promise = QueryFactory.get(featuid, uid,
              map.getView().getProjection().getCode());
          }
          else {
            const fti = EVT_Inspection_Layer.getProperties().fti;
            let query;
            if (fti.type === 'esri' && fti.esriIdField !== 'objectid') {
              query = fti.esriIdField + '=' + uid;
              promise = QueryFactory.data(fti.uid, query, '', '', '', '',
                map.getView().getProjection().getCode());
            }
            else {
              promise = QueryFactory.get(fti.uid, uid,
                map.getView().getProjection().getCode());
            }
          }
          promise.then((res) => {
            var format = new ol.format.GeoJSON();
            var featuref = format.readFeatures(res.data);
            var extend = new ol.extent.createEmpty();
            featuref.forEach(function(ft) {
              extend = new ol.extent.extend(
                extend,
                ft.getGeometry().getExtent()
              );
            });
            zoomToExtent(extend);
          });
        };


        function getInspIndex(inspection) {
          return scope.visualisation.inspections.list
            .map(function(x) {
              return x.title;
            })
            .indexOf(inspection.title);
        }


        const deleteInspection = (ins) => {
          let theInsId;
          const l = scope.visualisation.inspections.list;
          const index = getInspIndex(ins);
          if (l[index].parts[0]) {
            //-- Version utilisée juqu'au 07/03/2022.
            theInsId = l[index].parts[0].properties.id_inspection;
          }
          else {
            //-- version depuis le 07/03/2022 pour le cas où
            //-- une inspection reste sans portion rattachée.
            if (scope.conf.arcgiscomponent
              && scope.conf.arcgiscomponent.EVT_Inspection) {
              theInsId = gaJsUtils.getIdInCaseEsriId(l[index],
                EVT_Inspection_Layer.get('fti'));
              if (theInsId.indexOf('.') != -1) {
                theInsId = theInsId.split('.')[1];
              }
            }
          }
          removeItvs(theInsId, index, false);
        };


        scope.supprimerInspection = function(inspection) {
          var indexes = parseInt(inspection.title.split(' ')[1]);
          var index = getInspIndex(inspection);
          scope.visualisation.inspections.list.splice(index, 1);
          scope.visualisation.inspections.list.forEach(function(item) {
            if (indexes < parseInt(item.title.split(' ')[1]))
              item.title = item.title.replace(
                parseInt(item.title.split(' ')[1]),
                parseInt(item.title.split(' ')[1]) - 1
              );
          });
        };

        scope.showHeaders = function(headers) {
          scope.headers = angular.copy(headers);

          try {
            if (scope.dialogHeader)
              scope.dialogHeader.close(scope.dialogHeader.id);
          }
          catch (e) {
            console.info(e.message);
          }

          scope.dialogHeader = extendedNgDialog.open({
            template:
              'js/XG/widgets/utilities/itv/views/visualisation/itvVisualisationHeadersDirect.html',
            className:
              'ngdialog-theme-plain width400 height600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('itv.visualisation.header'),
            draggable: true,
          });
        };

        scope.attachedfiles = [];
        function loadAttachedPdfs(obj, typobj, addToInspection) {
          var defer;
          if (addToInspection) defer = $q.defer();

          var ftiname = EVT_Inspection_Layer.get('fti').name;
          let insid;
          if (typobj === 'inspection') {
            if (obj.parts.length !== 0) {
              insid = obj.parts[0].properties.id_inspection;
            }
          }
          else {
            insid = obj.properties.id_inspection;
          }
          if (insid && !insid.includes('.')) {
            insid = ftiname + '.' + insid;
          }
          if (insid) {
            if (!insid.includes('.')) {
              insid = ftiname + '.' + insid;
            }
            FeatureAttachmentFactory.list(ftiname, insid).then(function (res) {
              var pdf, files;
              scope.attachedfiles.splice(0, scope.attachedfiles.length);
              files = $filter('filter')(res.data, '.pdf');
              for (var ind = 0; ind < files.length; ind++) {
                pdf = {};
                pdf.ftiname = ftiname;
                pdf.objid = insid;
                pdf.filename = files[ind];
                if (addToInspection) obj.pdfs.push(pdf);
                else scope.attachedfiles.push(pdf);
              }
              if (addToInspection) {
                defer.resolve();
              }
              else {
                //-- Pour que l evenement ne soit pas envoyé trop tôt.
                //-- Si on imbrique avec valeur plus faible de timeout,
                //-- le timing est moins bon.
                $timeout(() => {
                  $timeout(() => {
                    scope.$broadcast('attachedFiles', scope.attachedfiles);
                  });
                },1000);
              }
            });
            if (addToInspection) {
              obj.pdfs = [];
              return defer.promise;
            }
          }
        }

        scope.downloadAttachment = function(pdf, ftiname, objid) {
          FeatureAttachmentFactory.getdownloadurl(pdf, ftiname, objid).then(
            function(res) {
              window.open(res.data);
              scope.wait = false;
            }
          );
        };

        scope.vueEclate = function(obj, str) {
          if (str == 'inspection')
            obj.parts.map(function(part) {
              part.details.map(function(x) {
                switch (x._code_principal.trim().substring(0, 2)) {
                  case 'BA':
                  case 'DA':
                    x.type = 'structurel';
                    x.color = colors
                      .map(function (y) {
                        if (y.type == 'structurel') return y.color;
                      })
                      .filter(function (y) {
                        if (y !== undefined) return y;
                      })[0];
                    break;
                  case 'BB':
                  case 'DB':
                    x.type = 'fonctionnel';
                    x.color = colors
                      .map(function (y) {
                        if (y.type == 'fonctionnel') return y.color;
                      })
                      .filter(function (y) {
                        if (y !== undefined) return y;
                      })[0];
                    break;
                  case 'BC':
                  case 'DC':
                    x.type = 'inventaire';
                    x.color = colors
                      .map(function (y) {
                        if (y.type == 'inventaire') return y.color;
                      })
                      .filter(function (y) {
                        if (y !== undefined) return y;
                      })[0];
                    break;
                  case 'BD':
                  case 'DD':
                    x.type = 'autre';
                    x.color = colors
                      .map(function (y) {
                        if (y.type == 'autre') return y.color;
                      })
                      .filter(function (y) {
                        if (y !== undefined) return y;
                      })[0];
                    break;
                  default:
                    x.type = 'autre';
                    x.color = colors
                      .map(function (y) {
                        if (y.type == 'autre') return y.color;
                      })
                      .filter(function (y) {
                        if (y !== undefined) return y;
                      })[0];
                }
              });
            });
          scope.object = {
            type: str,
            obj: obj,
            map: scope.map,
            attachedfiles: scope.attachedfiles,
          };
          try {
            if (scope.dialogVue) {
              scope.dialogVue.close(scope.dialogVue.id);
              $timeout(function() {
                scope.dialogVue.closePromise.then(function() {
                  scope.dialogVue = extendedNgDialog.open({
                    template:
                      'js/XG/widgets/utilities/itv/views/visualisation/itvVisualisationVueEclateDirect.html',
                    className:
                      'ngdialog-theme-plain width800 height600 nopadding miniclose',
                    closeByDocument: false,
                    scope: scope,
                    title: $filter('translate')('itv.visualisation.eclate'),
                    draggable: true,
                  });
                });
              }, 1000);
            }
            else {
              scope.dialogVue = extendedNgDialog.open({
                template:
                  'js/XG/widgets/utilities/itv/views/visualisation/itvVisualisationVueEclateDirect.html',
                className:
                  'ngdialog-theme-plain width800 height600 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                title: $filter('translate')('itv.visualisation.eclate'),
                draggable: true,
              });
            }
            loadAttachedPdfs(obj, str, false);
            // attache les vidéos à Evt_Intervention_Part
            loadAttachedVideos(obj, str);
          }
          catch (e) {
            console.info(e.message);
          }
        };


        const getExtent = (featureLayer) => {
          let flExtent = featureLayer.getSource().getExtent();
          if (Math.abs(flExtent[2] - flExtent[0]) < 0.01
            || Math.abs(flExtent[3] - flExtent[1]) < 0.01) {
            flExtent[0] -= 10;
            flExtent[1] -= 10;
            flExtent[2] += 10;
            flExtent[3] += 10;
          }
          return flExtent;
        };


        scope.visible = (part, zoomOnPart) => {
          scope.visualisation.inspections.list.map(function(inspect) {
            inspect.parts.map(function(p) {
              if (!angular.equals(part, p) && p.partvisible) {
                p.partvisible = false;
              }
            });
          });

          itvUtilsFactory.clearoriginsourcecanal();
          itvUtilsFactory.clearitvoperationalLayers();
          if (part.partvisible) {
            itvVisuFactory.drawFeature(part,
              map.getView().getProjection().getCode()).then(() => {
              let extent;
              extent = new ol.extent.createEmpty();
              itvUtilsFactory.getitvoperationalLayers()
                .forEach((featureLayer) => {
                  scope.map.getLayers().insertAt(10, featureLayer);
                  if (scope.zoomonFeature || zoomOnPart) {
                    ol.extent.extend(extent, getExtent(featureLayer));
                  }
                });
              if (scope.zoomonFeature || zoomOnPart) {
                zoomToExtent(extent);
              }
              scope.zoomonFeature = false;
            });
          }
          else {
            itvUtilsFactory.getitvoperationalLayers().forEach(function(layer) {
              map.removeLayer(layer);
            });
            itvUtilsFactory.clearitvoperationalLayers();
          }
        };


        scope.visibleDetails = (part) => {
          const itvparts = part.partId;
          const details = part.details.map(detail => detail.id).join(',');
          let layer = gclayers.getOperationalLayerByLayerName(
            details.split(',')[0].split('.')[0]
          );
          if (part.detailsvisible) {
            if (scope.conf.arcgiscomponent
              && scope.conf.arcgiscomponent.EVT_Inspection_Part_Detail
            && scope.conf.arcgiscomponent.EVT_Inspection_Part_Detail.fti.type === 'esri') {
              layer.cql_filter = 'id_part = ' + itvparts.split('.')[1];
            }
            else {
              layer.cql_filter = 'id_part = \'' + itvparts + '\'';
            }
            layer.setVisible(true);
            const index = gclayers.getOperationalLayerg2cCollection()
              .getArray().indexOf(layer);
            gclayers.getOperationalLayerg2cCollection().removeAt(index);
            gclayers.getOperationalLayerg2cCollection().insertAt(15, layer);
            $rootScope.$broadcast('gcOperationalLayerChange', layer,
              'cql_filter');
          }
          else {
            layer.cql_filter = '1=1';
            layer.visible = false;
          }
          $rootScope.$broadcast('gcOperationalLayerChange', layer,
            'cql_filter');
        };


        const removeItvs = (strIdList, ind, contentOnly) => {
          scope.removing = true;
          wait(3);
          itvVisuFactory.removeItvs(strIdList, scope.conf.config.datastore,
            getArcGisLayers4Url(), contentOnly, scope.ConfigName).then((res) => {
            scope.removing = false;
            if (res.data.errorList == undefined
                || res.data.errorList.length == 0) {
              let l = scope.visualisation.inspections.list;
              if (ind == -1) {
                //-- Les ITVs sélectionnées ont été supprimées.
                //-- On vide donc la liste des ITVs sélectionnées
                //-- car elles n'existent plus.
                l.splice(0, l.length);
              }
              else {
                //-- L'ITV a été supprimée, on l'enlève donc
                //-- de la liste des ITVs sélectionnées
                //-- car elle n'existe plus.
                l.splice(ind, 1);
              }
              gclayers.refreshlayerByid(EVT_Inspection_Layer.get('fti').uid,
                map);
              require('toastr').success(
                $filter('translate')('itv.visualisation.removalOk')
              );
            }
            else {
              require('toastr').error(
                $filter('translate')('itv.visualisation.removalFailed') + ': '
                  + res.data.errorList[0].composant + '.'
                  + res.data.errorList[0].fonction + ': '
                  + res.data.errorList[0].exception);
            }
            doNotWaitAnymore(3);
          },
          () => {
            scope.removing = false;
            doNotWaitAnymore(3);
          }
          );
        };


        const getIdListOfItvToRemove = () => {
          let ind,
            strIdList = '';
          const ins = scope.visualisation.inspections.list;

          for (ind = 0; ind < ins.length; ind++) {
            if (ins[ind].parts.length !== 0) {
              if (ind != 0) strIdList += ',';
              strIdList += ins[ind].parts[0].properties.id_inspection;
            }
          }
          if (strIdList === '' && ins.length !== 0) {
            require('toastr').error(
              $filter('translate')('itv.correspondance.inspectionWithoutPart')
            );
          }
          return strIdList;
        };


        /**
         * Suppresion compléte des ITVs sélectionnées dans le widget
         * de visualisation.
         */
        const removeSelectionOk = () => {
          const strIdList = getIdListOfItvToRemove();
          if (strIdList.length != 0) removeItvs(strIdList, -1, false);
        };


        /**
         * Suppression uniquement du contenu des ITVs sélectionnées.
         * Il s'agit du cas des inspections programmées. Dans ce cas,
         * on garde la partie programmation qui est dans la table inspection et
         * on ne supprime que les informations des portions inspectées avec
         * les entêtes et les observations.
         */
        const removeSelectionContentOk = () => {
          const strIdList = getIdListOfItvToRemove();
          if (strIdList.length != 0) removeItvs(strIdList, -1, true);
        };


        scope.removeItvSelection = (all, insp) => {
          let messId = 'itv.visualisation.removalConfirmation';
          let okCallback;
          if (all === 'all/full') {
            // -- Pour confirmation de suppression compléte.
            okCallback = removeSelectionOk;
          }
          else if (all === 'all/content') {
            // -- Pour confirmation de suppression partielle.
            messId += '3';
            okCallback = removeSelectionContentOk;
          }
          else {
            // -- Pour confirmation de l'inspection sur laquelle
            // -- est la commande de suppression.
            messId += '2';
            okCallback = deleteInspection;
          }

          swal({
            title: $filter('translate')(messId),
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#5cb85c',
            confirmButtonText: $filter('translate')('common.yes'),
            cancelButtonText: $filter('translate')('common.no'),
            closeOnConfirm: true,
            closeOnCancel: true,
          },
          () => {
            okCallback(insp);
          }
          );
        };


        /**
         * Charge la vidéo attachée à l'intervention.
         * Transmet la liste des fichiers attachées de la vue éclatée
         * @param obj objet itv
         * @param typobj string représentant le nom du type de l'objet ("part")
         */
        const loadAttachedVideos = (obj, typobj) => {
          let layername;
          let featureId;
          if (typobj && typobj === 'part') {
            layername = obj && obj.hasOwnProperty('partId')
              && obj.partId ? obj.partId.split('.').slice(0,-1) : null;
            featureId = obj && obj.hasOwnProperty('partId')
              && obj.partId ? obj.partId : null;
          }

          if (featureId && layername) {
            FeatureAttachmentFactory.list(layername, featureId).then(
              res => {
                let video;
                scope.attachedfiles.splice(0, scope.attachedfiles.length);
                const files = res.data.filter(filename => gaJsUtils.isVideoFile(filename));
                for (const file of files) {
                  video = {};
                  video.ftiname = layername;
                  video.objid = featureId;
                  video.filename = file;
                  scope.attachedfiles.push(video);
                }
                $timeout(() => {
                  // transmet les fichiers attachés à la directive de la vue éclatée
                  scope.$broadcast('attachedFiles', scope.attachedfiles);
                }, 1000);
              });
          }
        };


        /**
         * Ouvre la popup de la vidéo attachée à la portion d'inspection ITV
         * @param part
         */
        scope.openAttachedVideo = (part) => {

          // récupère le header de portion contenant le nom du fichier de la vidéo de la portion
          let videoHeader = part.headers.find(header => header._code === 'ABS');
          if (!videoHeader || !videoHeader.value || videoHeader.value.length === 0) {
            videoHeader = part.headers.find(header => header._code === 'CBS');
          }

          if (videoHeader.value != null && videoHeader.value.length > 0) {

            // les vidéos sont disponibles en MP4 dans le repo et en HTML5 on ne peut pas lire MPEG-1
            const dotIndex = videoHeader.value.lastIndexOf('.');
            const videoFilename = videoHeader.value.substring(0, dotIndex + 1) + 'mp4';

            // récupère le nom du composant des portions d'ITV
            const itvPartComponentName = getPartComponentName();

            // récupère l'id en base de la portion d'ITV
            const featureId = part.hasOwnProperty('partId') ? part.partId : null;

            if (featureId) {
              // copie la vidéo dans le dossier temp de tomcat et renvoie son url
              FeatureAttachmentFactory.getdownloadurl(videoFilename, itvPartComponentName, part.partId, 'contenu').then(
                  res => {

                    // titre de la popup du lecteur vidéo
                    const title = $filter('translate')('itv.correspondance.' + (part.branchement ? 'connectionpipe' : 'portion'))
                        + ' ' + (part.indTroncon+1) + (part.adress ? ' : ' + part.adress : '') + ' - ' + videoFilename;

                    // assigne l'URL de la vidéo
                    scope.videoSourceFile = window.location.origin + res.data;

                    // assigne la portion ITV qui sera envoyée à la directive enfant du lecteur vidéo
                    scope.videoPart = part;

                    // masque la popup de visualisation ITV
                    toggleVisalisationPopup();

                    // sauvegarde temporairement l'état de visibilité de la portion avant ouverture du lecteur vidéo
                    let isPartVisibleBeforeVideo;
                    if (part.partvisible) {
                      part.partvisible = false;
                      isPartVisibleBeforeVideo = true;
                     scope.visible(part, false);
                    }

                    // boolean qui permet d'éviter d'exécuter 2x preCloseCallback (défaut de ngDialog)
                    let isPopupRestored = false;

                    extendedNgDialog.open({
                      template:
                          'js/XG/widgets/utilities/itv/views/visualisation/itvVisualisationVideoLoader.html',
                      className:
                          'ngdialog-theme-plain width600 nopadding miniclose itv-visu-video',
                      closeByDocument: false,
                      scope: scope,
                      title: title,
                      draggable: true,
                      preCloseCallback: () => {
                        scope.videoSourceFile = null;
                        $timeout(() => {
                          if (!isPopupRestored) {

                            // restaure l'état de visibilité de la portion avant ouverture du lecteur vidéo
                            if (isPartVisibleBeforeVideo) {
                              part.partvisible = true;
                              scope.visible(part, false);
                            }

                            // affiche la popup de visualisation ITV
                            toggleVisalisationPopup();

                            // empêche une 2nde exécution de preCloseCallback
                            isPopupRestored = true;
                          }
                        },400);
                      }
                    });
                  }
              )
            }
          }
        };

        /**
         * Retrouve le nom du composant des portions ITV que l'on soit dans le cas ArcGIS ou Postgis
         * @return {string} nom du composant des portions d'inspection ITV
         */
        const getPartComponentName = () => {
          let evt_Inspection_partLayerName;
          if (scope.conf && scope.conf.arcgiscomponent && scope.conf.arcgiscomponent.hasOwnProperty('EVT_Inspection_Part')
              && scope.conf.arcgiscomponent.EVT_Inspection_Part) {
            evt_Inspection_partLayerName = scope.conf.arcgiscomponent.EVT_Inspection_Part.name
          } else {
            evt_Inspection_partLayerName = 'EVT_Inspection_Part';
          }
          return evt_Inspection_partLayerName;
        };

        /**
         * A l'ouverture/fermeture du viewer vidéo de l'inspection,
         * masque/affiche la popup parent de visualisation ITV pour faire de la place sur la carte
         */
        const toggleVisalisationPopup = () => {
          const popupContainer = document.querySelector('.popupContainer.itvvisua');
          if (popupContainer.style.display === 'flex' || popupContainer.style.display === '') {
            popupContainer.style.display = 'none';
          } else {
            popupContainer.style.display = 'flex';
          }
        };

        // texte des tooltips des boutons d'action sur les ITV
        const buttonTooltipData = {
          delete_itv_full_button: {
            tootipText: $filter('translate')('itv.visualisation.deleteItvFully')
          },
          delete_itv_content_button: {
            tootipText: $filter('translate')('itv.visualisation.deleteItvContent')
          },
          create_connection_pipes_button: {
            tootipText: $filter('translate')('itv.visualisation.createConnectionPipes')
          }
        };

        /**
         * Créé une tooltip sur un élément HTML (bouton, etc...)
         * @param hastooltip est un objet du tableau d'attribut du bouton
         * @param idButton id de la balise button
         */
        scope.displayActionBtnTooltip = (idButton, hastooltip) => {
          if (!hastooltip) {
            const button = document.getElementById(idButton);
            if (button && buttonTooltipData.hasOwnProperty(idButton)) {
              const tooltipId = idButton + '_tooltip';
              if (!button.querySelector('#'+ tooltipId)) {
                const tooltip = document.createElement('span');
                tooltip.classList.add('tooltiptext');
                tooltip.id = tooltipId;
                tooltip.innerHTML = buttonTooltipData[idButton].tootipText;
                button.appendChild(tooltip);
                button.setAttribute('hastooltip', String(true));
              }
            }
          }
        };


        /**
         * Ouvrir la fenêtre de configuration de la création des branchements.
         */
        scope.openConnectionPipeConfiguration = () => {
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/LITV/views/itvConnectionPipeConfig.html',
            className: 'ngdialog-theme-plain overflowY miniclose',
            closeByDocument: false,
            scope,
            minWidth: '600px',
            minHeight: '450px',
            doNotForcePopupHeightToMinHeight: true,
            title: $filter('translate')('geolocalisation.OpenConfig'),
            preCloseCallback: () => {
            }
          });
        };


        /**
         * Enregistrement de la configuration de la création des branchements.
         */
        scope.saveConnectionPipeConfig = () => {
          itvSoumFactory.saveconf(scope.connectionPipeConfig,
            'creationBranchement');
        };


        /**
         * Ajouter dans la confiuration de la création des branchments
         * un nom d'attribut avec sa valeur par défaut.
         * Ceci est utilse dnas le cas ou un seul composant
         * pour les collecteurs et les brnchements
         * et qu'un attribut distingue les 2.
         */
        scope.addAttributeWithDefaultValue = () => {
          if (!scope.connectionPipeConfig.attributesWithDefaultValue) {
            scope.connectionPipeConfig.attributesWithDefaultValue = [];
          }
          scope.connectionPipeConfig.attributesWithDefaultValue.push(
            {
              name: scope.work.attrNameToAdd,
              value: scope.work.attrValueToAdd
            });
        };


        /**
         * Enlever un attribute de la liste des attributs avec valeur pa défaut.
         * @param {*} attributeIndex
         */
        scope.removeAttributeWithDefaultValue = (attributeIndex) => {
          scope.connectionPipeConfig.attributesWithDefaultValue
            .splice(attributeIndex, 1);
        };


        /**
         * Vérifie si une portion contient des observation de racordement.
         *
         * @param {*} part Portion à tester
         * @returns VRAI si la portion contient au moins une observation
         *          de branchement, FAUX sinon
         */
        scope.partHasBCA = (part) => {
          return part.details.find(detail => detail._code_principal === 'BCA');
        };


        /**
         * Fabrication de la liste des branchements à ne pas créer.
         * Il s'agit des détails dont la acse a été décochée
         * dans l'interface utilisateur.
         *
         * @param {*} parts Liste des portions pour laquelle établir la liste
         * @returns Liste des détails dont on ne doit pas créer le branchement
         */
        const getDetailsOfItv = (parts) => {
          const detailList = [];
          for (const part of parts) {
            for (const detail of part.details.filter(
              detail => detail._code_principal === 'BCA')) {
              if (!detail.toCreate) {
                detailList.push(detail.id);
              }
            }
          }
          return detailList;
        };


        /**
         *  Construire la liste des identifiants des ITVs pour lesquelles
         * il faudra créer les branchements.
         * On accompagne cette liste de celle des details à ignorer,
         * c'est à dire ceux porlesquels on ne veut pas créer un branchement.
         *
         * @returns Objets avec 2 listes celles des identifiants des ITVs et
         *          celle des identifiants des détails à ignorer.
         */
        const getIdListOfItv4ConnectionPipe = () => {
          let ind;
          let detailsToAvoid = [];
          const itvList = {};
          itvList.ids = [];
          const ins = scope.visualisation.inspections.list;

          for (ind = 0; ind < ins.length; ind++) {
            if (ins[ind].parts.length !== 0) {
              const itvId = ins[ind].parts[0].properties.id_inspection;
              itvList.ids.push(itvId);
              detailsToAvoid
                = detailsToAvoid.concat(getDetailsOfItv(ins[ind].parts, itvId));
            }
          }
          itvList.detailsToAvoid = detailsToAvoid;
          return itvList;
        };


        /**
         * Affichage ds messages contenus dans un objet de type ItvRet
         * (en cas d'erreur).
         *
         * @param {*} messages Liste des messages  à afficher
         */
        const displayMessages = (messages) => {
          let ind, mess;

          if (messages === undefined) return;
          for (ind = 0; ind < messages.length; ind++) {
            mess = messages[ind].fonction + ' ';
            mess += messages[ind].composant + ' ';
            mess += messages[ind].composant_id + ' ';
            mess += messages[ind].exception + ' ';
            mess += messages[ind].message_kis;
            require('toastr').error(mess);
          }
        };

        /**
         * Mettre à FALSE les 3 propriétés du scope qui refléte
         * l'état en fin de création des branchements.
         */
        scope.initCpStates = () => {
          scope.cpCreationSuccess
            = scope.cpErrorOccured = scope.cpInterrupted = false;
        };


        /**
         * Suivre la progression du processus de création des branchments et
         * gérer la bonne ou la mauvaise fin.
         */
        const checkBranchementProgression = () => {
          itvSoumFactory.getItvLoadingStatus(scope.creationBranchementThreadId)
            .then((res) => {
              if (res.data.etat !== 'RUNNING') {
                if (res.data.etat === 'FAILED') {
                  scope.cpErrorOccured = true;
                  require('toastr').error(res.data.errorMessage);
                }
                else if (res.data.etat === 'INTERRUPTED') {
                  scope.cpInterrupted = true;
                }
                else {
                  scope.cpCreationSuccess = true;
                }
                scope.resCreationBranchement = res.data;
                scope.creationBranchementThreadId = undefined;
              }
              else {
                scope.creationBranchementProcId = res.data.uid;
                scope.creationBranchementProgress = res.data.progress;
                $timeout(checkBranchementProgression, 1000);
              }
            });
        };


        /**
         * Lancement de la création des branchements.
         */
        scope.createConnectionPipes = () => {
          const itvIds = {};
          scope.initCpStates();
          if (scope.visualisation.allItvs) {
            itvIds.all = 'true';
          }
          else {
            itvIds.all = 'false';
            itvIds.lists = getIdListOfItv4ConnectionPipe();
          }
          itvSoumFactory.createConnectionPipes(itvIds,
            scope.conf.config.datastore, scope.conf.config.network,
            getArcGisLayers4Url(), scope.ConfigName).then((res) => {
            if (res.data.errorList.length > 0) {
              displayMessages(res.errorList);
            }
            else {
              scope.creationBranchementThreadId = res.data.objValeur.threadId;
              checkBranchementProgression();
            }
          });
        };


        /**
         * Interrompre la création en cours
         */
        scope.stopConnectionPipes = () => {
          itvSoumFactory.interruptRefresh(scope.creationBranchementProcId);
        };
      },
    };
  };

  itvvisualisation.$inject = [
    '$rootScope',
    '$http',
    '$filter',
    'itvSoumFactory',
    'itvVisuFactory',
    'gclayers',
    'SelectManager',
    'gcStyleFactory',
    'extendedNgDialog',
    'QueryFactory',
    '$timeout',
    'gcInteractions',
    'FeatureAttachmentFactory',
    '$q',
    'gaJsUtils',
    'itvUtilsFactory',
    'gaDomUtils',
    'PortalsFactory'
  ];
  return itvvisualisation;
});
