/**
 * intersection entre une geometry (qui pourra être en format featureCollection, feature ou bien geometry) 
 * avec une liste des composant (passer en paramétre), la geometry pourra être Point ou line ou polygon
 * cette classe est partagé entre getFeaturesIntersectingPoint, getFeaturesIntersectingLine et getFeaturesIntersectingPolygon
 * Auteur : @RSE
 * Date: 26/04/2022
 */
'use strict';
define(function () {
  class getFeaturesIntersectingFunction {
    constructor() {
      this.$get = function (
        $q,
        $rootScope,
        $filter,
        ogcFactory
      ) {

        // transforme le point en petit polygon puis envoyer la clause spatial d'intersection
        let intersectPoint = (geometry) => {
          let coordinates = geometry.coordinates;
          const firstCoordinate = geometry.type==='Point'?coordinates[0]:coordinates[0][0];
          const lastCoordinate = geometry.type==='Point'?coordinates[1]:coordinates[0][1];
          const leftX = firstCoordinate - 0.05;
          const bottomY = lastCoordinate - 0.05;
          const rightX = firstCoordinate + 0.05;
          const topY = lastCoordinate + 0.05;
          const geometryPolygon = {
            coordinates: [[[leftX,bottomY], [rightX,bottomY], [rightX,topY], [leftX,topY], [leftX,bottomY]]],
            type: 'Polygon'
          };
          return intersectPolygon(geometryPolygon, 'INTERSECTS');
        }

        // retourne la clause spatiale d'intersection avec une line
        const intersectLine = (geometry) => {
          let coordinates = geometry.coordinates;
          const wktObj = new ol.format.WKT();
          let geom = geometry.type === 'LineString'?new ol.geom.LineString(coordinates):new ol.geom.MultiLineString(coordinates)
          let wktStr = wktObj.writeGeometry(geom);
          return 'INTERSECTS(geom, ' + wktStr + ')';
          
        }

        //retourne la clause spatiale d'intersection avec un polygon
        const intersectPolygon = (geometry, operator) => {
          let coordinates = geometry.coordinates;
          const wktObj = new ol.format.WKT();
          let geom = geometry.type === 'Polygon'?new ol.geom.Polygon(coordinates):new ol.geom.MultiPolygon(coordinates)
          const wktStr = wktObj.writeGeometry(geom);
          return operator+'(geom, ' + wktStr + ')';
        }

        // recupére le resultat de l'intersection des extremités et l'intialise dans la variable destination
        const intersectLineExtremity = (geometry) =>{
          let coordinates = geometry.coordinates;
          const firstPointCoordiante = geometry.type === 'LineString'?coordinates[0]:coordinates[0][0];
          const lastPointCoordiante = geometry.type === 'LineString'?coordinates[coordinates.length-1]:coordinates[0][coordinates.length-1];
          const spatialClauseFirst = intersectPoint({coordinates:firstPointCoordiante,type:'Point'});
          const spatialClauseLast = intersectPoint({coordinates:lastPointCoordiante,type:'Point'});
          return [spatialClauseFirst, spatialClauseLast];
        }
        return {
          
          // les differents paramètre des fonctions getFeaturesIntersectingPoint,
          // getFeaturesIntersectingLine et getFeaturesIntersectingPolygon
          getParametersDesc: (type) => {
            const paramByType = {
              'Point': [
                [0, 'variable'],
                [1, 'componentSelector'],
                [2, 'boolean'],
                [3, 'variable']
              ],
              'Line': [
                [0, 'variable'],
                [1, 'componentSelector'],
                [2, 'boolean'],
                [3, 'boolean'],
                [4, 'variable']
              ],
              'Polygon': [
                [0, 'variable'],
                [1, 'componentSelector'],
                [2, 'boolean'],
                [3, 'select', [
                  {
                    id: '0',
                    label: $filter('translate')(
                      'functions_browser.functions.generateUnion.INTERSECTS'),
                    operator: 'INTERSECTS'
                  }, {
                    id: '1',
                    label: $filter('translate')(
                      'functions_browser.functions.generateUnion.WITHIN'),
                    operator: 'WITHIN'
                  }
                ]],
                [4, 'variable']
              ]
            };
          
            return paramByType[type] || [];
          },

          // les actions des fonctions getFeaturesIntersectingPoint, getFeaturesIntersectingLine et getFeaturesIntersectingPolygon
          getFeaturesIntersecting: (variables, source, component, isFC, extremityOnly, destination, typeGeometry, geometricPredicates) => {
            const def = $q.defer();
            let srid = 'EPSG:3857';
            component = component.replaceAll('/',',');
            //recupération de srid
            if ($rootScope.xgos && $rootScope.xgos.mouseposition && $rootScope.xgos.mouseposition.srid) {
              srid = $rootScope.xgos.mouseposition.srid.name;
            }
            let geometriesList= [];

            // verification, validation et recupération de la geometry (featureCollection, feature ou bien geometry)
            if(isFC && variables[source] && variables[source].features && variables[source].features.length>0) {
              variables[source].features.map(feature => {
                if(feature.geometry && 
                  (feature.geometry.type.endsWith(typeGeometry))){
                    geometriesList.push(feature.geometry);
                }
              })
            }else if(variables[source] && variables[source].features && variables[source].features.length>0 &&
               variables[source].features[0].geometry && 
               variables[source].features[0].geometry.type.endsWith(typeGeometry)) {
                geometriesList.push(variables[source].features[0].geometry);
            }else if(variables[source] && variables[source].geometry &&
                     variables[source].geometry.type.endsWith(typeGeometry)){
                      geometriesList.push(variables[source].geometry)
            }else if(variables[source] &&
                     variables[source].type.endsWith(typeGeometry)){
                      geometriesList.push(variables[source]);
            }
            if(geometriesList.length>0){
              let promises = [];
              variables[destination] = {};
              geometriesList.map(geometry => {
                if(typeGeometry == 'LineString' && extremityOnly){
                  const [spatialClauseFirst, spatialClauseLast] = intersectLineExtremity(geometry);
                  const promiseFirst = ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0',
                                                      component, 'json', srid, spatialClauseFirst);
                  promises.push(promiseFirst);
                  const promiseLast = ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0',
                                                              component, 'json', srid, spatialClauseLast);
                  promises.push(promiseLast);
                }else{
                  let spatialClause = '';
                  switch(typeGeometry){
                    case 'Point': spatialClause = intersectPoint(geometry);break;
                    case 'LineString': spatialClause = intersectLine(geometry,extremityOnly);break;
                    case 'Polygon': spatialClause = intersectPolygon(geometry,geometricPredicates.operator);break;
                  }
                  

                  const promise = ogcFactory.getfeatures(
                    'GetFeature',
                    'WFS',
                    '1.0.0',
                    component,
                    'json',
                    srid,
                    spatialClause);

                  promises.push(promise);
                }
                $q.all(promises).then(resList => {
                  resList.map(res => {
                    if(res.data.totalFeatures){
                      if(Object.keys(variables[destination]).length === 0){
                        variables[destination] = res.data;
                      }else{
                        const toAdd = res.data.features.filter(feat => !variables[destination].features.some(f => f.id === feat.id));
                        toAdd.map(feat => {
                            variables[destination].totalFeatures++;
                            if(variables[destination].realTotalFeatures[feat.id.split(".")[0]]){
                              variables[destination].realTotalFeatures[feat.id.split(".")[0]]++;
                            }else{
                              variables[destination].realTotalFeatures[feat.id.split(".")[0]] = 1;
                            }
                            variables[destination].features.push(feat);
                        });
                      }
                    }
                  })
                  def.resolve();
                }, ()=> {
                  def.resolve();
                });
              });
            }else{
              require('toastr').error($filter('translate')(
                'functions_browser.functions.getFeaturesIntersectingLine.error'));
              def.resolve();
            }
            return def.promise;
          },
        };
      };

      this.$get.$inject = [
        '$q',
        '$rootScope',
        '$filter',
        'ogcFactory'
      ];
    }
  }
  return getFeaturesIntersectingFunction;
});
