'use strict';
define(function() {
  var gcelement = function(FeatureTypeFactory,$rootScope, $filter) {
    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/formField.html',
      restrict: 'A',
      scope: {
        map: '=map',
        fti: '=?fti',
        ftid: '=?ftid',
        fieldData: '=?fieldData',
        attname: '=attname',
        initvalue: '=initvalue',
        // res contains the value (it's actually the key in case of attribute restrictions)
        res: '=res',
        // data used in table restrictions
        elasticFilterValues: '=?',
        activelabel: '=activelabel',
        current: '=current',
        uploadfile: '=uploadfile',
        removedfile: '=removedfile',
        attributeData: '=?',
        setAttr: '=?',
        missingMandatoryAttributes: '=missingmandatoryattributes',
        fieldsApplyCurrentDate: '=?', // objet contenant les noms de champs sur lesquels on veut appliquer la date courante système (KIS-3212)
        fieldDataExtra: '=?' // pour eviter de faire les assign partout, je passe les fieldDataExtra
      },
      link: function(scope) {
        if(scope.fieldDataExtra){
          scope.fieldData = Object.assign(scope.fieldData || {}, scope.fieldDataExtra)
        }
        if (angular.isUndefined(scope.ftid) && scope.fti && scope.fti.uid) {
          scope.ftid = scope.fti.uid;
        }
        // get fti if undefined
        if (
          angular.isUndefined(scope.fti) ||
          scope.fti == null ||
          scope.fti.uid === ''
        ) {
          updateFtiUsingFtid();
        }

        if (angular.isUndefined(scope.res)){
          scope.res = {};
        }
        scope.att = null;

        if (!angular.isUndefined(scope.initvalue) && scope.initvalue != '') {
          scope.res = scope.initvalue;
        }

        const getTriggerType = (trigger) => {
          const translate = $filter('translate');
          let type = translate('model.featuretypes.triggers.before');
          const insertText = trigger.insert ? ` ${translate('model.featuretypes.triggers.insert')}` : '';
          const updateText = trigger.update ? ` ${translate('model.featuretypes.triggers.update')}` : '';
          const orText = (trigger.insert && trigger.update) ? ` ${translate('model.featuretypes.triggers.or')}` : '';
        
          return `${type}${insertText}${orText}${updateText}`.trim();
        }     

        const getAttributesTriggers =  () => {
          if(scope.fti && Array.isArray(scope.fti.triggers) && scope.fti.triggers.length>0){
            scope.attTriggers = scope.fti.triggers.filter(trigger => trigger.targetField === scope.attname && trigger.enabled);
            if(scope.attTriggers.length>0){
              if(scope.attTriggers.length === 1){
                scope.attTriggersMsg = 
                            $filter('translate')('model.featuretypes.triggers.warningTriggerExist').
                            replace('$1',scope.attTriggers[0].name).
                            replace('$2',getTriggerType(scope.attTriggers[0]));
              }else{
                scope.attTriggersMsg = 
                            $filter('translate')('model.featuretypes.triggers.warningTriggersExist').
                            replace('$1',scope.attTriggers.map(trigger => trigger.name).join(","));
              }
            }
          }
        } 

        if (scope.fti != null) {
          updateAttributeUsingFti();
        }

        if (
          scope.fieldData &&
          scope.fieldData.saveincache &&
          scope.fieldData.saveincache == true
        ) {
          if (!scope.res[scope.attname]) scope.res[scope.attname] = undefined;
        }

        if (
          scope.res[0] != undefined &&
          scope.res[0][scope.attname] != undefined
        ) {
          scope.res[scope.attname] = scope.res[0][scope.attname];
        }


        /**
         * Attention fonction sensible !
         * La version précédente de ces lignes entrainait un blocage
         * dans la popup de l'édition métier.
         * Le FormField est utilisé dans beaucoup e contexte.
         */
        scope.$watch('attname', (newval, oldval) => {
          if (scope.fti != null && newval && newval != oldval) {
            if (!scope.fti.isFakeFti) {
              updateFtiUsingFtid();
            }
            updateAttributeUsingFti();
          }
        });


        /**
         * BAC - Contrôle de conformité
         * Détecte lorsque une div possède un attribut 'setAttr' différent de son attribut 'attname'
         * Permet le mappage dans le cas où plusieurs contrôles utilisent une liste déroulante unique
         * (ex. localisation_eu et localisation_ep)
         * @see listeDossiersBac.js#replaceAttName()
         */
        function replaceAttName() {
          if (scope.fti && scope.fti.name == 'kis_bac_listes_deroulantes_controles'
            && angular.isDefined(scope.attname) && angular.isDefined(scope.setAttr)
            && scope.attname != scope.setAttr) {
            const distinctAttrObj = { setAttr: scope.setAttr, attname: scope.attname };
            $rootScope.$broadcast('differenceBetweenSetAttrAndAttName',distinctAttrObj);
          }
        }
        replaceAttName();

        function updateAttributeUsingFti() {
          if (scope.fti && Array.isArray(scope.fti.attributes)) {
            for (var i = 0; i < scope.fti.attributes.length; i++) {
              if (scope.fti.attributes[i].name == scope.attname) {
                scope.att = angular.copy(scope.fti.attributes[i]);
                getAttributesTriggers();
                break;
              }
            }
          }
        }

        function updateFtiUsingFtid() {
          let newFti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
          if(newFti.uid !== ''){
            scope.fti = newFti;
            scope.ftid = scope.fti.uid;
          }
        }

        /**
         * Quand on efface une valeur par défaut dans un mapping de champ
         * la valeur par défaut devient null au lieu de se supprimer de l'objet scope.currentConfig.configByLayer[0].defaultValues
         */
        scope.deleteNullDefaultValues = () => {
          if (scope.res !== undefined && scope.res.hasOwnProperty(scope.attname) && scope.res[scope.attname] === null) {
            delete scope.res[scope.attname];
          }
        };

        /**
         * Cette fonction permet de mettre la date du jour ou bien l'enlever dans la variable scope.res[scope.attname]
         *
         */
        scope.fieldsApplyCurrentDateChange = (switchValue) => {
          if(switchValue){
            scope.fieldsApplyCurrentDate[scope.attname]=!scope.fieldsApplyCurrentDate[scope.attname];
          }
          if(scope.fieldsApplyCurrentDate[scope.attname]){
            scope.res[scope.attname] = new Date();
          }else if(switchValue){
            delete scope.res[scope.attname];
          }
        };

        if(scope.fieldsApplyCurrentDate && scope.fieldsApplyCurrentDate){
          scope.fieldsApplyCurrentDateChange();
        }
      },
    };
  };

  gcelement.$inject = ['FeatureTypeFactory','$rootScope', '$filter'];
  return gcelement;
});
