'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    $timeout,
    gcRestrictionProvider,
    gcInteractions,
    FeatureTypeFactory,
    gcWFS
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/edit/views/gceditpolygon.html',
      restrict: 'A',
      scope: {
        map: '=map',
        res: '=res',
        onclick: '&?onclick',
        onfinish: '&?onfinish',
        drawinteraction: '=?drawinteraction',
        snaptolerance: '=snaptolerance',
        isActive: '=?isactive',
        ftid: '=ftid',
        toolbarwidget: '=?toolbarwidget',
        shape: '@?',
        disabled: '=disabled',
        // -- Etat du travail dans cette directive : '', 'drawstart' ou 'restriction_out_of_bounds'
        status: '=?',
        usemode: '=usemode'
      },
      link: function(scope, element, attrs) {
        scope.status = '';
        scope.isActive = false;
        scope.editpolygoninfo = { active: scope.isActive };
        scope.geom = {};
        // scope.drawinteraction = {};
        scope.feature = '';
        if(angular.isUndefined(scope.onfinish)){
          scope.onfinish = function () {
            return;
          };
        }


        // -- Définition de la fonction à utiliser pour savoir si des restrictions
        //-- s'appliquent et ce en fonction du type d'usage de cette directive.
        let hasRestrictionFn;

        switch(scope.usemode) {
          case 'query':
            hasRestrictionFn = gcRestrictionProvider.hasRestrictionQuery;
            break;
          case 'edition':
            hasRestrictionFn = gcRestrictionProvider.hasRestrictionEdition;
            break;
          case 'viewer':
            hasRestrictionFn = gcRestrictionProvider.hasRestrictionViewer;
            break;
        }


        function updateEditpolygonInfo(newvalue, oldvalue, scope) {
          scope.editpolygoninfo.active = scope.isActive;
          if (scope.drawinteraction) {
            scope.drawinteraction.setActive(scope.isActive);
          }
        }

        scope.$watch('isActive', updateEditpolygonInfo);

        /**
         * [removeFeatures description]
         * @return {No} [description]
         */
        const removeFeatures = () => {
          gclayers.getDrawLayer().getSource().clear();
          scope.features = {};
        };
        scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        // Functions snap interaction
        function getSnapRule() {
          var ruleSnap = undefined;
          if (scope.fti && scope.fti.rules) {
            var rules = scope.fti.rules;
            for (var i = 0; i < rules.length; i++) {
              if (rules[i].name == 'SnapOn') {
                ruleSnap = rules[i];
              }
            }
          }
          return ruleSnap;
        }
        function snapOn(ruleConf) {
          //var ruleConf = getSnapRule();
          var layersToLoad = [];
          var layers = gclayers.getOperationalLayer();
          var layerNames = ruleConf.parameters['layers'];
          //Pour chaque nom de layer en config de cette règle
          for (var j = 0; j < layerNames.length; j++) {
            var name = layerNames[j].name;
            //Pour chaque layer opérationelle
            for (var i = 0; i < layers.length; i++) {
              var l = layers[i];
              if (l.name == undefined) continue;
              if (name == l.name) {
                var fti = l.fti;
                layersToLoad.push(fti);
                break;
              }
            }
          }
          //Chargement des objets des couches sur lesquelles s'accrocher
          var wfsLayer = gcWFS.getOlLayerFromFeaturetypeInfoArray(layersToLoad,scope.map);
          //map.addLayer(wfsLayer);
          gclayers.addSnapLayer(wfsLayer);
          var srcDrawedDXF = gclayers.getImportLayer().getSource();
          wfsLayer.getSource().addFeatures(srcDrawedDXF.getFeatures());
          if (scope.snaptolerance == undefined) {
            scope.snaptolerance = 20;
          }
          scope.snap = new ol.interaction.Snap({
            source: wfsLayer.getSource(),
            edge: true,
            vertex: true,
            pixelTolerance: scope.snaptolerance,
          });
        }

        function removeWfsLayers() {
          var layersToRemove = [];
          var layers = scope.map.getLayers().getArray();
          for (var i = 0; i < layers.length; i++) {
            var l = layers[i];
            if (l.type == 'wfs') {
              layersToRemove.push(l);
            }
          }
          for (var j = 0; j < layersToRemove.length; j++) {
            scope.map.removeLayer(layersToRemove[j]);
          }
        }

        /**
         * [add description]
         */
        scope.add = function() {
          const map = scope.map;
          map.removeInteraction(scope.drawinteraction);
          scope.status = '';
          var ruleConf = getSnapRule();
          if (ruleConf != undefined) {
            scope.map.removeInteraction(scope.snap);
            map.dispatchEvent({ type: 'snapRemovedEvent' });
            removeWfsLayers();
          }
          removeFeatures();

          if (
            scope.isActive &&
            scope.drawinteraction &&
            scope.drawinteraction.getActive()
          ) {
            //btnElt.removeClass('btn-info')
            //btnElt.addClass("btn-default");
            if (
              scope.drawinteraction &&
              scope.drawinteraction instanceof ol.interaction.Draw
            )
              scope.drawinteraction.setActive(false);
            map.removeInteraction(scope.drawinteraction);
            removeFeatures();
            scope.isActive = false;
            let ruleConf = getSnapRule();
            if (ruleConf != undefined) {
              scope.map.removeInteraction(scope.snap);
              map.dispatchEvent({ type: 'snapRemovedEvent' });
              removeWfsLayers();
            }
          } else {
            //btnElt.removeClass('btn-default')
            //btnElt.addClass("btn-info");
            scope.isActive = true;
          }

          //var sketchFeature;
          //
          if (scope.isActive) {
            //var sketchFeature;
            //
            console.log('POLYGON EDIT');
            scope.drawinteraction = getDrawInteraction(scope.shape);

            scope.drawinteraction.set('gctype', 'kis');
            scope.drawinteraction.set('interaction', 'Draw');
            scope.drawinteraction.set('widget', 'editionoutil' + Math.random());
            scope.drawinteraction.setActive(true);
            gcInteractions.setCurrentToolBar(scope.toolbarwidget);
            map.addInteraction(scope.drawinteraction);
            let ruleConf = getSnapRule();
            if (ruleConf != undefined) {
              snapOn(ruleConf);
              scope.map.addInteraction(scope.snap);
              if (
                map
                  .getInteractions()
                  .getArray()
                  .indexOf(scope.snap) !== -1
              ) {
                //Envoi de l'information de l'interaction ajoutée.
                map.dispatchEvent({ type: 'snapAddedEvent' });
              }
            }
            //on start
            scope.drawinteraction.on('drawstart', () => {
              console.log('drawstart');
              scope.status = 'drawstart';
              removeFeatures();

              try {
                scope.$apply(scope);
              } catch(err) {}
            });

            // on end
            scope.drawinteraction.on('drawend', (evt) => {
              const format = new ol.format.GeoJSON();
              const feature = format.writeFeatureObject(evt.feature);
              removeDblClickZoom();

              if (hasRestrictionFn()) {
const srid = map.getView().getProjection().getCode();
                gcRestrictionProvider.GeometryInRestriction(feature.geometry, srid).then(
                  (res) => {
                  if (JSON.parse(res.data)) {
                      setResultThenRemoveInteraction(feature);
                  } else {
                    gcRestrictionProvider.showErrorMessage();
                    scope.isActive = false;
                    scope.onfinish();
                    scope.status = 'restriction_out_of_bounds';
                  }
                },
                  (error) => {
                    console.error(error.data);
                }
                );
              } else {
                setResultThenRemoveInteraction(feature);
              }
            });

            try {
              if (attrs.onclick != undefined) {
                scope.onclick();
              }
            } catch (e) {
              console.error(e);
            }
          }
        };
        /**
         * La fin de ligne est un double click.
         * On enleve le zoom par double click, sinon,
         * en même temps que l'on termine la ligne,
         * on fait un zoom et c'est désagréable.
         */
        let removeDblClickZoom = () => {
          scope.dblClickInteraction = undefined;
          // find DoubleClickZoom interaction
          scope.map.getInteractions().getArray().forEach(function(interaction) {
            if (interaction instanceof ol.interaction.DoubleClickZoom) {
              scope.dblClickInteraction = interaction;
              // remove from map
              scope.map.removeInteraction(interaction);
            }
          });
        };

        function getDrawInteraction(shape) {
          const source = gclayers.getDrawLayer().getSource();
          let type = !shape ? 'Polygon': 'Circle'; // Circle must be used for custom shapes to work
          let geometryFunction; // With this multiple type of shapes can be defined
          if (shape === 'rectangular') {
            // https://openlayers.org/en/latest/examples/draw-shapes.html For multiple shapes
            geometryFunction = ol.interaction.Draw.createBox();
          }
          return new ol.interaction.Draw({source, type, geometryFunction});
        }

        /**
         * Code formaté exécuté au double-clic de clôture du dessin d'un polygone de sélection
         * Ôte les intéraction snap et draw de la map
         * Renvoie la géométrie du polygone de sélection dans la variable du parent
         * Exécute la méthode onfinish du parent
         * @param {object} feature feature openlayers convertie en Json du polygone de sélection
         */
        const setResultThenRemoveInteraction = (feature) => {
          scope.isActive = false;
          const ruleConf = getSnapRule();
          if (ruleConf !== undefined) {
            scope.map.removeInteraction(scope.snap);
            scope.map.dispatchEvent({
              type: 'snapRemovedEvent',
            });
            removeWfsLayers();
          }
          $timeout(() => {
            scope.res = feature.geometry;

            // l'intéraction doit être désactivée après transmission de la géométrie au parent
            scope.drawinteraction.setActive(false);
            scope.map.removeInteraction(scope.drawinteraction);

            // la méthode du parent doit être exécutée après transmission de la géométrie au parent
            $timeout(() => {
              scope.onfinish();
            });
          });
        }
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    '$timeout',
    'gcRestrictionProvider',
    'gcInteractions',
    'FeatureTypeFactory',
    'gcWFS',
  ];
  return gcelement;
});
