'use strict';
define(function() {
  var element = function(ConfigFactory, gcPopup, $rootScope) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/calculateurExpression/views/calcexpression.html',

      restrict: 'A',
      scope: {
        fti: '=fti',
        res: '=res',
      },
      controller: [
        '$scope',
        '$element',
        '$attrs',
        '$filter',
        function($scope, $element, $attrs, $filter) {
          $scope.expression = '';
          $scope.feattree = {};
          // data de l'arbre

          $scope.featdata = [
            {
              label: $filter('translate')('expression_calculator.operators'),
              helptemplate:
                'js/XG/widgets/utilities/calculateurExpression/views/help/operateur.html',
              value: '',
              children: [
                {
                  label: '+',
                  value: '+',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/plus.html',
                },
                {
                  label: '-',
                  value: '-',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/moins.html',
                },
                {
                  label: '/',
                  value: '/',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/divise.html',
                },
                {
                  label: '%',
                  value: '%',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/modulo.html',
                },
                {
                  label: '=',
                  value: '=',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/egale.html',
                },
                {
                  label: '>',
                  value: '>',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/sup.html',
                },
                {
                  label: '<',
                  value: '<',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/inf.html',
                },
                {
                  label: '<>',
                  value: '<>',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/diff.html',
                },
                {
                  label: '>=',
                  value: '>=',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/supegale.html',
                },
                {
                  label: '<=',
                  value: '<=',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/infegale.html',
                },
                {
                  label: 'LIKE',
                  value: 'LIKE',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/LIKE.html',
                },
                {
                  label: 'OR',
                  value: 'OR',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/infegale.html',
                },
                {
                  label: 'AND',
                  value: 'AND',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/infegale.html',
                },
              ],
            },
            {
              label: $filter('translate')('expression_calculator.geometry'),
              helptemplate:
                'js/XG/widgets/utilities/calculateurExpression/views/help/geometrie.html',
              children: [
                {
                  label: 'Area',
                  value: '#{$area}',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/infegale.html',
                },
                {
                  label: 'Perimeter|Length',
                  value: '#{$perimeter}',
                  helptemplate:
                    'js/XG/widgets/utilities/calculateurExpression/views/help/operateur/infegale.html',
                },
              ],
            },
            {
              label: $filter('translate')('expression_calculator.text'),
              children: [
                {
                  label: 'concat',
                  value: 'concat()'
                }
              ]
            }
            /*,
                        {
                          label: 'Conditions',
                          helptemplate: 'js/XG/widgets/utilities/calculateurExpression/views/help/conditions.html',
                          children: []
                        },
                        {
                          label: 'Math',
                          helptemplate: 'js/XG/widgets/utilities/calculateurExpression/views/help/math.html',
                          children: []
                        },
                        {
                          label: 'Conversion',
                          helptemplate: 'js/XG/widgets/utilities/calculateurExpression/views/help/converstion.html',
                          children: []
                        },
                        {
                          label: 'Date',
                          helptemplate: 'js/XG/widgets/utilities/calculateurExpression/views/help/date.html',
                          children: []
                        },
                        {
                          label: 'Chaine',
                          helptemplate: 'js/XG/widgets/utilities/calculateurExpression/views/help/chaine.html',
                          children: []
                        },
                        {
                          label: 'Couleur',
                          helptemplate: 'js/XG/widgets/utilities/calculateurExpression/views/help/couleur.html',
                          children: []
                        },
*/
          ];
          if (!angular.isUndefined($scope.fti)) {
            var champs = {
              label: $filter('translate')('expression_calculator.fields'),
              helptemplate:
                'js/XG/widgets/utilities/calculateurExpression/views/help/geometrie.html',
              children: [],
            };
            $scope.fti.attributes.forEach(function(att) {
              champs.children.push({
                label: att.alias,
                value: '"' + att.name + '"',
              });
            });
            // ajoute fid dans la liste des champs
            if ($scope.fti.type === 'g2c') {
              champs.children.push({
                label: 'fid',
                value: `"fid"`,
              });
            }
            $scope.featdata.push(champs);
          }
        },
      ],

      link: function(scope, element, attrs, ctrl) {
        scope.preValue = '';
        scope.dbl = function() {
          console.log(
            'sdoubleclick' + scope.feattree.get_selected_branch().value
          );
          if (scope.expression.endsWith('))')) {
            scope.expression = scope.expression.slice(0, -2) + scope.feattree.get_selected_branch().value + "))";
          } else if (scope.expression.endsWith(')')) {
            scope.expression = scope.expression.slice(0, -1) + scope.feattree.get_selected_branch().value + ")";
          } else {
            scope.expression += ' ' + scope.feattree.get_selected_branch().value;
          }
        };

        scope.setExpression = function() {
          scope.res.filter = scope.expression;
          console.log(scope.res);
          if (
            $rootScope.xgos &&
            $rootScope.xgos.sector === 'hpo' &&
            $rootScope.xgos.hpo
          ) {
            //require('toastr').info($filter('translate')('hpo.common.utilisercefilter'));
            $rootScope.xgos.hpo.clauseWhere = scope.expression;
            if (scope.map && scope.map.getView)
              $rootScope.xgos.hpo.srid = scope.map
                .getView()
                .getProjection()
                .getCode();
          }

          //scope.$apply();
        };
        scope.tree_handler = function(branch) {
          console.log(scope.preValue);
          if (scope.preValue !== undefined && scope.preValue === branch.value) {
            //console.log("sdoubleclick");
            scope.expression += branch.value;
          }
          scope.preValue = branch.value;

          //console.log(scope.res);
        };
      },
    };
  };

  element.$inject = ['ConfigFactory', 'gcPopup', '$filter', '$rootScope'];
  return element;
});
