'use strict';
define(function() {
  var basemapwidget = function(
    gclayers,
    gcPopup,
    QueryFactory,
    SelectManager,
    ParametersFactory,
    GeometryFactory,
    $filter,
    FeatureTypeFactory,
    $rootScope,
    RightsFactory,
    gaJsUtils,
    QueryService
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/query/views/querywidget.html',
      restrict: 'A',

      link: function(scope) {
        const formatGeoJson = new ol.format.GeoJSON();
        scope.editPolygonStatus = '';
        scope.buffersize = 0;
        //translations.query.tabSearch
        scope.tabsq = [
          { title: 'query.tabSearch' },
          { title: 'query.tabFavoris' },
        ];

        scope.tabsq.activeTab = 0;
        ///Composant
        scope.selectedcomponent = '';
        scope.component = [];

        //Attribut
        scope.selectedattribut = null;
        scope.attributs = [];

        //values
        scope.selectedattvalue = '';
        scope.attvalues = [];
        //operand
        scope.operands = ['=', '<>', '>', '>=', '<', '<=', 'LIKE'];
        scope.operandText = {
          '=': $filter('translate')('query.equals'),
          '<>': $filter('translate')('query.distinct'),
          '>': $filter('translate')('query.superior'),
          '>=': $filter('translate')('query.superiorEquals'),
          '<': $filter('translate')('query.inferior'),
          '<=': $filter('translate')('query.inferiorEquals'),
        };
        scope.combin = ['AND', 'OR'];

        scope.currentSelectionClause = '';

        //scope where clause
        scope.whereClause = '';

        //geographic limitation
        scope.geoLimit = {value: 'BD'};

        //parameters
        scope.parameterAddPopup = null;
        scope.parameterValuePopup = null;
        scope.queryParam = {};
        scope.currtParamName = '';

        /// Initialisation
        var setFavoris = function() {
          scope.favoris = [];
          scope.names = [];
          scope.minwidth = 24;
          scope.style = {
            width: '200 px',
          };
          ParametersFactory.getbytype('Request').then(
            res => {
              scope.favoris.push(...gaJsUtils.sortByKey(res.data, 'name'));
            }
          );
        };
        setFavoris();

        /**
         * Au changement ou au clic sur la croix de l'autocomplete des composants/tables : <ul><li>
         * Initialise le tableau des attributs, l'attribut courant sélectionné et la clause where
         * de la requête</li><li>
         * Construit le tableau d'attributs en fonction des attributs
         * du composant sélectionné</li><li>
         * Ajoute l'attribut fid dans le cas postgis</li></ul>
         */
        scope.selectcomponetchange = () => {
          if (Array.isArray(scope.attributs)) {
            scope.attributs.length = 0;
          } else {
            scope.attributs = [];
          }
          scope.selectedattribut = {};
          scope.whereClause = '';

          if (scope.selectedcomponent) {
            scope.selectedcomponent.fti.attributes.forEach(function(att) {
              scope.attributs.push({
                value: att.name,
                label: att.alias,
                att: att,
              });
            });
          }

          // permet de requêter sur fid dans le cas de postgis
          if (scope.selectedcomponent && scope.selectedcomponent.fti
            && scope.selectedcomponent.fti.type !== 'esri') {
            scope.attributs.push({
              value: 'fid',
              label: 'fid',
              att: undefined,
            });
          }
        };

        /**
         * Au changement ou au clic sur la croix de l'autocomplete des attributs : <ul><li>
         * Implémente la clause where de la requête <code>whereClause</code></li><li>
         * Ré-initialise la liste des valeurs d'attributs si aucun attribut n'est
         * sélectionné</li></ul>
         */
        scope.selectattributchange = function() {
          if (scope.selectedattribut) {
            scope.whereClause = scope.whereClause + scope.selectedattribut.value + ' ';
            scope.chooseOperand = true;
          } else {
            scope.selectedattvalue = '';
            scope.attvalues.splice(0, scope.attvalues.length);
            scope.chooseOperand = false;
          }
        };

        /**
         * Au clic sur le bouton d'ajout de favoris (étoile):<ul><li>
         *   au 1er clic, affiche l'input pour saisir le nom du favori à sauvegarder</li><li>
         *   au 2nd clic enregistre effectivement le favoris puis masque l'input</li></ul>
         */
        scope.addfavoris = () => {
          if (!scope.showBookmarkInput) {
            scope.showBookmarkInput = true;
          } else {
            const request = {
              where: scope.whereClause,
              fti: scope.selectedcomponent.uid,
              geoLimit: scope.geoLimit.value
            };

            if (scope.selectedattribut) {
              request.attribut = scope.selectedattribut;
            }

            // already exist ?
            const optionalExistingFav = scope.favoris.find(fav => fav.name === scope.request_name);

            if (!optionalExistingFav) {
              console.log(request);
              ParametersFactory.add(request, 'Request', scope.request_name).then(
                res => {
                  scope.favoris.push(res.data);
                  gaJsUtils.sortByKey(scope.favoris);
                  require('toastr').success($filter('translate')('common.saved'));
                }
              ).finally(()=> scope.showBookmarkInput = false);
            } else {
              const ans = confirm(
                $filter('translate')('selectfeaturetree.confirm_update')
              );
              if (ans) {
                ParametersFactory.getbyid(optionalExistingFav.id).then(
                  param => {
                    const newFav = param.data;
                    newFav.data = request;
                    ParametersFactory.update(newFav, optionalExistingFav.id).then(
                      () => {
                        require('toastr').success($filter('translate')('common.saved'));
                        setFavoris();
                      },
                      reason => {
                        console.log(reason);
                      }
                    );
                  })
                  .finally(()=> scope.showBookmarkInput = false);
              }
            }
          }
        };
        scope.deletefavoris = function(fav) {
          var ans = confirm($filter('translate')('common.confirm_action'));
          if (ans) {
            ParametersFactory.remove(fav.id).then(function() {
              var deleteIndex = scope.favoris
                .map(function(x) {
                  return x.id;
                })
                .indexOf(fav.id);
              scope.favoris.splice(deleteIndex, 1);
            });
          }
        };

        scope.attributvaluechangeTest = function(selectedValue) {
          scope.queryParam.value = selectedValue.value;
        };

        /**
         * Après sélection d'une date dans le datepicker
         * lors de l'éxécution d'une requête paramétrée avec un paramètre de type date
         *
         * @param {Date} d date sélectionnée dans le datepicker
         */
        scope.dateChanged = function(d) {
          if (d.getTime() > 0) {
            const months = d.getMonth() + 1 < 10 ? '0' + (d.getMonth() + 1) : d.getMonth() + 1;
            const days = d.getDate() < 10 ? '0' + d.getDate() : d.getDate();
            scope.queryParam.value = d.getFullYear() + '-' + months + '-' + days;
          }
        };


        scope.loadedFav = false;
        scope.gofavoris = function(fav, name) {
          QueryService.gofavoris(fav, name, scope);
        };

        /**
         * Ré-initialise la clause where (textarea).
         * Purge la sélection en cours et la couche de dessin temporaire.
         */
        scope.clearwhere = function() {

          scope.whereClause = '';
          scope.currentSelectionClause = '';
          //KIS-2559: "Effacer" doit aussi supprimer l'attribut sélectionné
          scope.selectedattribut = null;

          if ($rootScope.xgos && $rootScope.xgos.sector === 'hpo' && $rootScope.xgos.hpo) {
            //require('toastr').info($filter('translate')('hpo.common.utilisercefilter'));
            $rootScope.xgos.hpo.clauseWhere = '1=1';
            if (scope.map && scope.map.getView)
              $rootScope.xgos.hpo.srid = scope.map.getView().getProjection().getCode();
          }

          SelectManager.clear();
          gclayers.getDrawLayer().getSource().clear();
        };


        scope.attributvaluechange = function() {
          if (scope.selectedattribut.value != 'fid'
            && scope.selectedattribut.att.type == 'java.lang.String') {
            scope.whereClause =
              scope.whereClause + "'" + scope.selectedattvalue.value + "' ";
          }
          else {
            scope.whereClause =
              scope.whereClause + '' + scope.selectedattvalue.value + ' ';
          }
        };

        scope.currentAttributeIsDate = false;

        scope.attributeunique = function() {
          scope.retrievingAttValues = true;
          QueryFactory.dataattribute(
            scope.selectedcomponent.uid,
            scope.selectedattribut.value
          ).then(function(res) {
            if ((scope.selectedattribut && scope.selectedattribut.value !== 'fid') &&
                QueryService.DATE_TYPES.includes(scope.selectedattribut.att.type)) {
              scope.currentAttributeIsDate = true;
            }

            if (
              res.data.length === 0 ||
              (res.data.length === 1 && res.data[0] === '')
            ) {
              require('toastr').info(
                $filter('translate')('model.featuretypes.attributes.no_values')
              );
            }
            else {
              scope.selectedattvalue = '';
              scope.attvalues = [];
              res.data.forEach(function(att) {
                if (att !== '') {
                  let aDate = { value: att, label: att};
                  if (scope.currentAttributeIsDate && att !== null) {
                    var d = new Date(att);
                    // valid date
                    if (d.getTime() > 0) {
                      aDate = QueryService.readDate(d);
                    }
                  }

                  scope.attvalues.push(aDate);
                }
              });
            }
          }).finally(() => {
            scope.retrievingAttValues = false;
          });
        };
        scope.addwhereclause = function(wd) {
          scope.whereClause = scope.whereClause + ' ' + wd + ' ';
        };


        /**
         * Construit le tableau de composants à partir des composants de FeatureTypeFactory
         * pour remplir l'autocomplete des composants
         * @param isGeographic est true pour limiter la liste aux composants spatiaux.
         *                  False limite la liste aux tables
         */
        scope.loadLayers = (isGeographic = true) => {
          scope.component.splice(0, scope.component.length);
          FeatureTypeFactory.get(false).then(
            (layers)=> {
              const user = $rootScope.xgos && $rootScope.xgos.user ? $rootScope.xgos.user : null;
              const isAdmin = $rootScope.xgos
                && ($rootScope.xgos.isroot || $rootScope.xgos.isadmin);
              for (const layer of layers) {
                // ajoute les composants ou tables dont l'utilisateur a le droit en lecture
                if (layer.geographic === isGeographic
                  && RightsFactory.isAllowedToReadOrWriteFeatureType(layer, isAdmin, user, true)) {
                  scope.component.push({
                    value: layer.id ? layer.id : null,
                    label: layer.name,
                    alias: layer.alias,
                    type: layer.typeInfo,
                    uid: layer.uid,
                    fti: layer,
                  });
                }
              }
            }
          );
        };


        scope.showhideform = function(){
          scope.formBuffer=false;
        };

        scope.ctrlbuufer = function(){

          if( scope.buffersize > 500 ){
            require('toastr').warning(
              $filter('translate')(
                'layermanager.limite_taille_buffer'
              )
            );
            scope.buffersize = 0;
          }
          else{
            if(scope.buffersize < 0){
              require('toastr').warning(
                $filter('translate')(
                  'layermanager.taille_buffer_neg'
                )
              );
              scope.buffersize = 0;
            }
          }
        };
        scope.appliqueBuffer = function(){

          gclayers
            .getDrawLayer()
            .getSource()
            .clear();
          scope.limitZoneGeometry = null;
          var selectedFeaturesObj = SelectManager.getfeatures();
          var selectedFeatures = selectedFeaturesObj.features;
          if (selectedFeatures !== undefined) {
            var selectedGeoms = [];
            selectedFeatures.forEach(function(f) {
              selectedGeoms.push(f.geometry);
            });

            GeometryFactory.unionandbuffer(
              selectedGeoms, 'ROUND', scope.buffersize > 0 ? scope.buffersize : 0.1).then(
              function(res) {
                var resultGeometry = res.data;
                scope.currentSelectionClause = '';
                var wktObj = new ol.format.WKT();
                var coords = resultGeometry.coordinates;
                var polyCoords = resultGeometry.type == 'Polygon'
                  ? new ol.geom.Polygon(coords, 'XY') : new ol.geom.MultiPolygon(coords, 'XY');

                var highLightFeature = new ol.Feature({
                  geometry: polyCoords,
                });

                highLightFeature.setStyle(
                  new ol.style.Style({
                    stroke: new ol.style.Stroke({
                      color: 'rgba(240, 240, 174, 1)',
                      width: 5,
                    }),
                    fill: new ol.style.Fill({
                      color: 'rgba(0, 0, 255, 0.1)',
                    }),
                  })
                );

                gclayers
                  .getDrawLayer()
                  .getSource()
                  .addFeatures([highLightFeature]);
                var wktStr = wktObj.writeGeometry(polyCoords);
                scope.currentSelectionClause =
                  scope.selectedGeomOperand + '(geom, ' + wktStr + ')';
              });
          }

        };

        scope.useCurrentSelection = function() {
          scope.formBuffer=scope.formBuffer===false?true:false;
          //clear drawed limit zones
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();
          scope.limitZoneGeometry = null;
          var selectedFeaturesObj = SelectManager.getfeatures();
          var selectedFeatures = selectedFeaturesObj.features;
          if (selectedFeatures !== undefined) {
            var selectedGeoms = [];
            selectedFeatures.forEach(function(f) {
              selectedGeoms.push(f.geometry);
            });
            if(selectedFeaturesObj.totalFeatures > 5000){
              require('toastr').warning(
                $filter('translate')(
                  'layermanager.selection_tres_importante'
                )
              );
              scope.bufferclose = true;
            }
            else{
              scope.bufferclose = false;
              GeometryFactory.unionandbuffer(selectedGeoms, 'ROUND', 0.1).then(
                function(res) {
                  var resultGeometry = res.data;
                  scope.currentSelectionClause = '';
                  var wktObj = new ol.format.WKT();
                  if (resultGeometry.type == 'Polygon') {
                    var coords = resultGeometry.coordinates;
                    var polyCoords = new ol.geom.Polygon(coords, 'XY');

                    var highLightFeature = new ol.Feature({
                      geometry: polyCoords,
                    });

                    highLightFeature.setStyle(
                      new ol.style.Style({
                        stroke: new ol.style.Stroke({
                          color: 'rgba(240, 240, 174, 1)',
                          width: 5,
                        }),
                        fill: new ol.style.Fill({
                          color: 'rgba(0, 0, 255, 0.1)',
                        }),
                      })
                    );

                    gclayers
                      .getDrawLayer()
                      .getSource()
                      .addFeatures([highLightFeature]);

                    var wktStr = wktObj.writeGeometry(polyCoords);

                    scope.currentSelectionClause =
                    scope.selectedGeomOperand + '(geom, ' + wktStr + ')';
                  }
                  else if (resultGeometry.type == 'MultiPolygon') {
                    coords = resultGeometry.coordinates;
                    polyCoords = new ol.geom.MultiPolygon(coords, 'XY');

                    highLightFeature = new ol.Feature({
                      geometry: polyCoords,
                    });

                    highLightFeature.setStyle(
                      new ol.style.Style({
                        stroke: new ol.style.Stroke({
                          color: 'rgba(240, 240, 174, 1)',
                          width: 5,
                        }),
                        fill: new ol.style.Fill({
                          color: 'rgba(0, 0, 255, 0.1)',
                        }),
                      })
                    );

                    gclayers
                      .getDrawLayer()
                      .getSource()
                      .addFeatures([highLightFeature]);

                    wktStr = wktObj.writeGeometry(polyCoords);

                    scope.currentSelectionClause =
                    scope.selectedGeomOperand + '(geom, ' + wktStr + ')';
                  }
                }
              );
            }
          }
        };

        scope.addQueryParameter = function() {
          console.log(scope.selectedattribut);

          if (scope.parameterAddPopup == null) {
            scope.queryParam = {};

            scope.parameterAddPopup = gcPopup.open({
              scope: scope,
              title: 'Ajouter un attribut en paramètre',
              className: 'query-add-parameter query-parameter',
              noResizeTitlebar: true,
              template:
                'js/XG/widgets/mapapp/query/views/queryAddParameter.html',
              showClose: false,
              position: { top: '40vh', left: '40vw'}
            });
          }
        };

        scope.addParamToQuery = function() {
          if (
            scope.queryParam &&
            scope.queryParam.name != '' &&
            !(scope.queryParam.name === undefined)
          ) {
            if (scope.selectedattribut
              && scope.selectedattribut.att
              && scope.selectedattribut.att.type === 'java.lang.String') {
              scope.whereClause =
                scope.whereClause + "'#" + scope.queryParam.name + "#' ";
            }
            else {
              scope.whereClause =
                scope.whereClause + '#' + scope.queryParam.name + '# ';
            }
          }

          scope.parameterAddPopup.close();

          scope.parameterAddPopup = null;
        };

        scope.replaceParamInQuery = function() {
          QueryService.replaceParamInQuery(scope);
        };

        scope.$on('gcOperationalLayerChange', function( ) {
          scope.loadLayers();
        });

        scope.loadLayers();

        // model de la case à cocher "Interroger des composants non géographiques"
        scope.tablesOnly = false;

        /**
         * Au clic sur la case à cocher "Interroger des composants non géographiques"<ul><li>
         *   Vide l'autocomplete des attributs</li><li>
         *   Vide le select des valeurs de l'attribut sélectionné</li><li>
         *   Re-initialise l'attribut sélectionné et la variable <code>whereClause</code></li><li>
         *   Exécute le vidage et la reconstruction du tableau de composants/tables</li></ul>
         */
        scope.onTablesOnlyChange = () => {
          // vide l'autocomplete des attributs et supprime l'attribut sélectionné
          if (Array.isArray(scope.attributs)) {
            scope.attributs.length = 0;
          } else {
            scope.attributs = [];
          }

          // supprime le composant(la table) sélectionné(e)
          // re-initialise l'attribut sélectionné
          scope.selectedcomponent = null;
          scope.selectedattribut = {};


          // vide la valeur sélectionnée de l'ancien attribut sélectionné
          // vide la liste des valeurs de l'ancien attribut sélectionné
          scope.selectedattvalue = '';
          scope.attvalues.splice(0, scope.attvalues.length);

          // vide la clause where de la requête
          scope.whereClause = '';

          // coche le bouton radio "Base de Données" de la zone de recherche
          scope.geoLimit.value = 'BD';

          // exécute le vidage et la construction du tableau de composants/tables
          scope.loadLayers(!scope.tablesOnly);
        };

        /**
         * Vérifie si le contenu de la clause where de la requête (textarea) contient
         * un opérateur.<br>
         * Active/désactive le sélect des valeurs d'attribut.
         * @return {boolean} true si la variable <code>whereClause</code> contient
         * un élement du tableau <code>operands</code>
         */
        scope.whereClausehasOperator = () => {
          if (typeof scope.whereClause === 'string' && scope.whereClause.length > 0
              && Array.isArray(scope.operands)) {
            return scope.operands.some(
              operator => scope.whereClause.toLowerCase().includes(operator.toLowerCase()));
          }
        };

        scope.cancelBookmark = () => {
          scope.request_name = '';
          scope.showBookmarkInput = false;
        };

        scope.executeQuery = (isTable) => {
          QueryService.executeQuery(isTable, scope);
        }
        scope.$on('openTools_querywidget', (event, arg) => {
          if (arg.directive === 'querywidget') {
            scope.chooseOperand = false;
          }
        });
      },
    };
  };

  basemapwidget.$inject = [
    'gclayers',
    'gcPopup',
    'QueryFactory',
    'SelectManager',
    'ParametersFactory',
    'GeometryFactory',
    '$filter',
    'FeatureTypeFactory',
    '$rootScope',
    'RightsFactory',
    'gaJsUtils',
    'QueryService'
  ];
  return basemapwidget;
});
