'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    gcStyleFactory,
    $timeout,
    ngDialog,
    QueryFactory,
    FeatureTypeFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/network/views/networkFormField.html',

      restrict: 'A',
      scope: {
        map: '=map',
        fti: '=fti',
        ftid: '=ftid',
        required: '=required',
        attname: '=attname',
        initvalue: '=initvalue',
        res: '=res',
        activelabel: '=activelabel',
      },
      link: function(scope, element, attrs, ctrl) {
        if (!angular.isUndefined(scope.ftid)) {
          scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        }
        if (angular.isUndefined(scope.fti)) {
          scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        }
        if (angular.isUndefined(scope.res)) scope.res = {};
        /*scope.res ={};*/
        scope.att = null;
        scope.listofValues = [];
        /*console.log(scope.initvalue);*/

        if (!angular.isUndefined(scope.initvalue) && scope.initvalue != '') {
          scope.res = scope.initvalue;
        }

        scope.restrictions = false;

        var tableRestrictionData = {};

        /**
         * Handling restrictions
         */
        var handleRestrictions = function() {
          if (scope.att.restrictions.length == 0) return;
          // restriction Type
          scope.restrictions = [];

          scope.att.restrictions.forEach(function(r) {
            scope.restrictions.push(r.type);
          });

          // TODO: only handle first restriction for the moment
          var _rest = scope.att.restrictions[0];
          if (_rest.type == 'Interval') {
            scope.intervalmin = _rest.interval.min;
            scope.intervalmax = _rest.interval.max;
            if (_rest.interval.mininclus == false) scope.intervalmin += 1;
            if (_rest.interval.maxinclus == false) scope.intervalmax -= 1;
            // force default value for the parameter
            // have to use that timeout 0 "hack" or the default value for the slider wont be set
            $timeout(function() {
              scope.res[scope.att.name] = parseInt(scope.intervalmin, 10);
            }, 0);
          }

          if (_rest.type == 'inputSize') {
            scope.pattern = '.{' + _rest.minocc + ',' + _rest.maxocc + '}';
            scope.patternDetail =
              'from ' + _rest.minocc + ' to ' + _rest.maxocc + ' caracters';
            scope.typeInput = 'text';
            if (scope.att.type == 'java.lang.Integer')
              scope.typeInput = 'number';
          }

          if (_rest.type == 'Domain') {
            angular.forEach(_rest.listofValues, function(value, key) {
              scope.listofValues.push({
                val: key,
                translationKey:
                  'features.' +
                  scope.fti.name +
                  '.domaine.' +
                  scope.att.name +
                  '.' +
                  key,
              });
            });
            //scope.listofValues = _rest.listofValues;
          }

          if (_rest.type == 'Tables') {
            // get the id of the related table
            FeatureTypeFactory.get().then(function(res) {
              var fts = FeatureTypeFactory.resources.featuretypes;
              for (var i in fts) {
                if (fts[i].name == _rest.table) {
                  tableRestrictionData.uid = fts[i].uid;
                }
              }
            });
            tableRestrictionData.restriction = _rest;
          }
        };

        /**
         * Select a value from the restricted table
         * @param relatedFtuid
         */
        scope.selectRestrictedValue = function() {
          QueryFactory.data(scope.att.restrictions[0].ftid).then(
            function(res) {
              scope.pickChoices = [];
              /*var    features = res.data.features;

                            for(var j in features){
                                scope.pickChoices.push(features[j].properties[tableRestrictionData.restriction.keyField]);
                            }*/

              scope.pickChoices = res.data.features;
              scope.pickField = tableRestrictionData.restriction.keyField;

              var restrictedDialog = ngDialog.open({
                template:
                  'js/XG/modules/model/views/modals/modal.pickfromtable.html',
                className: 'width800 ngdialog-theme-plain miniclose',
                closeByDocument: false,
                scope: scope,
              });

              scope.pickRestrictedValue = function(value) {
                restrictedDialog.close();
                scope.res[scope.att.name] = value;
              };
            },
            function(err) {
              require('toastr').error('Cant reach the table');
            }
          );
        };

        //scope.res[scope.attname] = '';
        if (angular.isUndefined(scope.required)) {
          scope.required = false;
        }
        /*  console.log(scope.fti);*/
        for (var i = 0; i < scope.fti.attributes.length; i++) {
          if (scope.fti.attributes[i].name == scope.attname) {
            scope.att = angular.copy(scope.fti.attributes[i]);
            handleRestrictions();
            break;
          }
        }
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    'gcStyleFactory',
    '$timeout',
    'ngDialog',
    'QueryFactory',
    'FeatureTypeFactory',
  ];
  return gcelement;
});
