function getWsFromUrl(url) {
  var ws, iPos;
  ws = url.replace('/geoserver/', '');
  iPos = ws.indexOf('/');
  if (iPos==0) {
    iPos = url.indexOf('/services');
    ws = url.substr(iPos+10);
    iPos = ws.indexOf('/');
    //ws = ws.substr(0,iPos);
  }
  return ws.substr(0, iPos);
}

/**
 *     Transformation de la requete HTTP enregquete POST.
 * -1- Lecture des paramètres de l'URL pour les écrires
 *     dans la liste des paramètres de typePOST.
 * -2- Envoi de la requête en POST
 * -3- Récupération et mise en place de l'image résultante
 *
 * @param {[[type]]} tile [[Description]]
 * @param {[[type]]} src [[Description]]
 */
function customLoader(tile, src) {
  var client = new XMLHttpRequest();

  //-- GET ALL THE PARAMETERS OUT OF THE SOURCE URL
  var dataEntries = src.split('&');
  var url;
  var params = '';
  var ws;
  for (var i = 0; i < dataEntries.length; i++) {
    if (i === 0) {
      url = dataEntries[i];
      ws = getWsFromUrl(url);
      url = url.replace('/' + ws, '');
    } else {
      if (dataEntries[i].substr(0, 7).toLowerCase() == 'layers=') {
        dataEntries[i] =
          dataEntries[i].substr(0, 7) + ws + ':' + dataEntries[i].substr(7);
        dataEntries[i] = dataEntries[i].replace('%2C', '%2C' + ws + ':');
      }
      if (params != '') params += '&';
      params = params + dataEntries[i];
    }
  }

  client.open('POST', url, true);
  client.responseType = 'blob';

  client.onload = function() {
    var reader = new FileReader();
    reader.onloadend = function() {
      tile.getImage().src = reader.result;
    };
    reader.readAsDataURL(client.response);
  };
  //client.setRequestHeader("Connection", "close");
  client.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
  //client.setRequestHeader("Content-length", params.length);
  client.send(params);
}

if (!olkis) var olkis = {};

olkis.KISTileArcGISRest = function(opt_options) {
  ol.source.TileArcGISRest.call(this, opt_options);
  this._baseTileUrlFunction = this.getTileUrlFunction();
  this.setTileUrlFunction(this.restFixedTileUrlFunction);
  this.setTileLoadFunction(customLoader);
};

olkis.KISImageArcGISRest = function(opt_options) {
  ol.source.ImageArcGISRest.call(this, opt_options);
  this._baseImageLoadFunction = this.getImageLoadFunction();
  this.setImageLoadFunction(this.restImageLoadFunction);
};

olkis.KISTileWMSRest = function(opt_options) {
  ol.source.TileWMS.call(this, opt_options);
  this.setTileLoadFunction(opt_options.gaJsUtils.customLoader);
};

olkis.KISImageWMSRest = function(opt_options) {
  ol.source.ImageWMS.call(this, opt_options);
  this._baseImageLoadFunction = this.getImageLoadFunction();
  this.setImageLoadFunction(this.restImageLoadFunction);
  olkis.gaJsUtils = opt_options.gaJsUtils;
};

olkis.deployInherits = function() {
  ol.inherits(olkis.KISTileArcGISRest, ol.source.TileArcGISRest);
  /**
   * @inheritDoc
   */
  olkis.KISTileArcGISRest.prototype.restFixedTileUrlFunction = function(
    tileCoord,
    pixelRatio,
    projection
  ) {
    var processURL = this._baseTileUrlFunction.call(
      this,
      tileCoord,
      pixelRatio,
      projection
    );
    processURL = processURL.replace(/BBOXSR.*&/, '').replace(/IMAGESR.*&/, '');
    return processURL;
  };

  ol.inherits(olkis.KISTileWMSRest, ol.source.TileWMS);
  /**
   * @inheritDoc
   */
  olkis.KISTileArcGISRest.prototype.restFixedTileUrlFunction = function(
    tileCoord,
    pixelRatio,
    projection
  ) {
    var processURL = this._baseTileUrlFunction.call(
      this,
      tileCoord,
      pixelRatio,
      projection
    );
    processURL = processURL.replace(/BBOXSR.*&/, '').replace(/IMAGESR.*&/, '');
    return processURL;
  };

  ol.inherits(olkis.KISImageArcGISRest, ol.source.ImageArcGISRest);
  /**
   * @inheritDoc
   */
  olkis.KISImageArcGISRest.prototype.restImageLoadFunction = function(
    image,
    src
  ) {
    src = src.replace(/BBOXSR.*&/, '').replace(/IMAGESR.*&/, '');
    customLoader(image, src);
    //image.getImage().src = src;
  };

  ol.inherits(olkis.KISImageWMSRest, ol.source.ImageWMS);
  /**
   * @inheritDoc
   */
  olkis.KISImageWMSRest.prototype.restImageLoadFunction = function(image, src) {
    src = src.replace(/BBOXSR.*&/, '').replace(/IMAGESR.*&/, '');
    olkis.gaJsUtils.customLoader(image, src);
    //image.getImage().src = src;
  };
};
