'use strict';
define(function() {
  var majicSearch = function($rootScope, MajicFactory, $filter, ngTableParams, gaJsUtils) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/majic/views/majicSearch.html',
      restrict: 'E',

      //scope commun

      //methode executée au chargement de la page
      link: function(scope, element, attrs, ctrl) {
        // Initialize tabs
        scope.tabs = [
          { title: 'Parcelle' },
          { title: 'Propriétaires' },
          { title: 'Adresse' },
        ];
        scope.tabs.activeTab = 0;

        function getParcFromQueryParc(resultObject) {
          return {
            Commune: resultObject.idCompte,
            Section: resultObject.section,
            numParcelle: resultObject.numParcelle,
          };
        }

        function getParcFromQueryProp(resultObject) {
          return {
            Nom: resultObject.nomProp,
            Prenom: resultObject.preProp,
            Parcelle: resultObject.com,
          };
        }

        function getParcFromQueryAddress(resultObject) {
          var adress =
            resultObject.numRue != undefined ? resultObject.numRue : '';
          adress += resultObject.btq != undefined ? ' ' + resultObject.btq : '';
          adress +=
            resultObject.nomRue != undefined ? ' ' + resultObject.nomRue : '';

          return {
            Adresse: adress,
            Ville: resultObject.idCompte,
            Parcelle: resultObject.numParcelle,
          };
        }

        function showQueryRes(
          res,
          parcelleObjects,
          searchType,
          getParcFromResult
        ) {
          parcelleObjects.splice(0);
          var resultObject = res.data;
          for (var i = 0; i < resultObject.length; i++) {
            parcelleObjects.push(getParcFromResult(resultObject[i]));
          }
          if (parcelleObjects.length == 0) {
            scope.resultMsg2 = 'Aucun résultats';
          }
          scope['isSearching' + searchType] = false;

          //--Rafraichissement du tableau ng-table
          let tableParamsId;
          if (searchType == 'Parc') {
            tableParamsId = 'tableParams';
          } else {
            tableParamsId = searchType.toLowerCase() + 'TableParams';
          }
          scope[tableParamsId].reload();
          //-- Se positionner sur la première page, sinon,
          //-- on reste sur la page courante, et si la page courante
          //-- la 2 par exemple est désormais vide suite à la nouvelle
          //-- recherche, almors on ne voit aucun résultat et on ne peut pas
          //-- aller sur la page 1 pour voir les résultats ...
          scope[tableParamsId].page(1);
        }

        ////////////////////////////////////////////////
        //
        // Recherche de Parcelles
        //
        ////////////////////////////////////////////////

        scope.communes = [];
        scope.sections = [];
        scope.parcelles = [];

        scope.parcelleObjects = [];

        scope.allParcellesSelected = false;
        scope.allProprietairesSelected = false;
        scope.allAdressesSelected = false;

        /*   scope.parcelleObjects = [
                       {Commune : 'comm1',Section : 'sec1',numParcelle :'num1'},
                       {Commune : 'comm2',Section : 'sec2',numParcelle :'num2'},
                       {Commune : 'comm3',Section : 'sec3',numParcelle :'num3'},
                       {Commune : 'comm1',Section : 'sec1',numParcelle :'num1'},
                       {Commune : 'comm2',Section : 'sec2',numParcelle :'num2'},
                       {Commune : 'comm3',Section : 'sec3',numParcelle :'num3'},
                       {Commune : 'comm1',Section : 'sec1',numParcelle :'num1'},
                       {Commune : 'comm2',Section : 'sec2',numParcelle :'num2'},
                       {Commune : 'comm3',Section : 'sec3',numParcelle :'num3'},
                       {Commune : 'comm1',Section : 'sec1',numParcelle :'num1'},
                       {Commune : 'comm2',Section : 'sec2',numParcelle :'num2'},
                       {Commune : 'comm3',Section : 'sec3',numParcelle :'num3'}
                   ]; */
        scope.selectedParcelles = [];

        scope.ManageError = function(reason, origin) {
          var resultObject = reason,
            mess,
            iMess;
          if (
            resultObject.data != undefined &&
            resultObject.data.details != undefined
          ) {
            mess = origin + ' echec : ';
            for (iMess = 0; iMess < resultObject.data.details.length; iMess++)
              mess += resultObject.data.details[iMess] + '<br>';
          } else {
            mess = origin + ' echec : ' + resultObject;
          }
          require('toastr').error(mess);
        };
        /**
         *
         * @returns {undefined}
         * Uses ECQL language to format condition var.
         */
        scope.InitCommune = function() {
          var condition = '';
          var idsect = scope.idsect;
          var idparc = scope.idparc;
          if (idsect != '' && idsect != undefined) {
            condition =
              "strSubstring(idparcelle,0,strLength(idparcelle)-4) = '" +
              idsect +
              "'";
          }
          if (idparc != '' && idparc != undefined) {
            if (idsect != '' && idsect != undefined) {
              condition =
                condition +
                " and strSubstringStart(idparcelle,strLength(idparcelle)-4) = '" +
                idparc +
                "'";
            } else {
              condition =
                " strSubstringStart(idparcelle,strLength(idparcelle)-4) = '" +
                idparc +
                "'";
            }
          }

          MajicFactory.getcommunes(condition).then(
            function(res) {
              scope.communes.splice(0);
              var resultObject = res.data;
              const userHasMajicResctriction = $rootScope.xgos && $rootScope.xgos.user
                  && $rootScope.xgos.user.communes && Array.isArray($rootScope.xgos.user.communes)
                  && $rootScope.xgos.user.communes.length > 0;

              for (var i = 0; i < resultObject.length; i++) {
                const userHasCommune = userHasMajicResctriction && $rootScope.xgos.user.communes.includes(resultObject[i].idcommune);
                if (!userHasMajicResctriction || userHasCommune){
                  scope.communes.push({
                    idcommune: resultObject[i].idcommune,
                    libcom: resultObject[i].libcom,
                  });
                }
              }
              scope.communes = gaJsUtils.sortByKey(scope.communes,'libcom');
              //-- La première recherche des communes pour initialiser le widget
              //-- est sans filtre, on peut donc copier la liste dans celle
              //-- destinée à la rehcerche par propriétaire.
              if (scope.propCommunes==undefined) {
                scope.propCommunes = angular.copy(scope.communes);
              }
            },
            function(reason) {
              scope.ManageError(reason, 'InitCommune');
            }
          );
        };
        scope.InitSection = function() {
          var condition = '';
          var idcomm = scope.idcomm;
          var idparc = scope.idparc;
          if (idcomm != '' && idcomm != undefined) {
            condition = " idcommune = '" + idcomm + "'";
          }
          if (idparc != '' && idparc != undefined) {
            if (idcomm != '' && idcomm != undefined) {
              condition =
                condition +
                " and strSubstringStart(idparcelle,strLength(idparcelle)-4) = '" +
                idparc +
                "'";
            } else {
              condition =
                " strSubstringStart(idparcelle,strLength(idparcelle)-4) = '" +
                idparc +
                "'";
            }
          }
          MajicFactory.getparcellaire('idparcelle', condition).then(
            function(res) {
              scope.sections.splice(0);
              var resultObject = res.data;

              for (var i = 0; i < resultObject.length; i++) {
                //Récupération à partir du premier caractère sur une longeur de resultObject[i].length)-4
                var value = resultObject[i].substr(
                  0,
                  resultObject[i].length - 4
                );
                //Insertion de la valeur si celle-ci n'existe pas déjà
                if (scope.sections.indexOf(value) == -1) {
                  scope.sections.push(value);
                }
              }
            },
            function(reason) {
              scope.ManageError(reason, 'InitSection');
            }
          );
        };

        scope.InitParcelle = function() {
          var condition = '';
          var idcomm = scope.idcomm;
          var idsect = scope.idsect;
          if (idcomm != '' && idcomm != undefined) {
            condition = " idcommune = '" + idcomm + "'";
          }
          if (idsect != '' && idsect != undefined) {
            if (idcomm != '' && idcomm != undefined) {
              condition =
                condition +
                " and strSubstring(idparcelle,0,strLength(idparcelle)-4) = '" +
                idsect +
                "'";
            } else {
              condition =
                " strSubstring(idparcelle,0,strLength(idparcelle)-4) = '" +
                idsect +
                "'";
            }
          }
          MajicFactory.getparcellaire('idparcelle', condition).then(
            function(res) {
              scope.parcelles.splice(0);
              var resultObject = res.data;

              for (var i = 0; i < resultObject.length; i++) {
                //substr args: start index, length to get
                var value = resultObject[i].substr(
                  resultObject[i].length - 4,
                  4
                );
                scope.parcelles.push(value);
              }
            },
            function(reason) {
              scope.ManageError(reason, 'InitParcelle');
            }
          );
        };

        scope.isSearchingParc = false;
        scope.resultMsg = '';
        /**
         * Handler du bouton de recherche de parcelle (bouton icon loupe)
         * @returns {undefined}
         */
        scope.RechParc = function() {
          scope.selectedParcelles.splice(0);
          scope.allParcellesSelected = false;

          var condition = '';

          var idsect = scope.idsect;
          var idparc = scope.idparc;
          var idcomm = scope.idcomm;

          if (idcomm != '' && idcomm != undefined) {
            condition = " idcommune = '" + idcomm + "'";
          }
          if (idsect != '' && idsect != undefined) {
            if (condition != '') {
              condition =
                condition +
                " and strSubstring(idparcelle,0,strLength(idparcelle)-4) = '" +
                idsect +
                "'";
            } else {
              condition =
                " strSubstring(idparcelle,0,strLength(idparcelle)-4) = '" +
                idsect +
                "'";
            }
          }
          if (idparc != '' && idparc != undefined) {
            if (condition != '') {
              condition =
                condition +
                " and strSubstringStart(idparcelle,strLength(idparcelle)-4) = '" +
                idparc +
                "'";
            } else {
              condition =
                " strSubstringStart(idparcelle,strLength(idparcelle)-4) = '" +
                idparc +
                "'";
            }
          }
          scope.resultMsg = '';
          scope.isSearchingParc = true;
          MajicFactory.getlisteparcelle(condition).then(
            function(res) {
              showQueryRes(
                res,
                scope.parcelleObjects,
                'Parc',
                getParcFromQueryParc
              );
            },
            function(reason) {
              scope.isSearchingParc = false;
              scope.ManageError(reason, 'getlisteparcelle');
            }
          );
        };

        scope.InitCommune();
        scope.InitSection();
        scope.InitParcelle();

        scope.tableParams = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
            //                        ,filter: {
            //                            //name: 'M'       // initial filter
            //                        },
            //                        sorting: {
            //                            //idCompte: 'asc'     // initial sorting
            //                        }
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              // use build-in angular filter
              //                            var filteredData = params.filter() ?
              //                                    $filter('filter')(scope.parcelleObjects, params.filter()) :
              //                                    scope.parcelleObjects;
              //                            var orderedData = params.sorting() ?
              //                                    $filter('orderBy')(filteredData, params.orderBy()) :
              //                                    scope.parcelleObjects;
              var displayedTab = scope.parcelleObjects.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              params.total(scope.parcelleObjects.length); // set total for recalc pagination
              $defer.resolve(displayedTab);
            },
          }
        );

        scope.changeParcSelection = function(object) {
          if (object.$selected) {
            scope.selectedParcelles.push(object);
          } else {
            let copyParcelleObjects = scope.parcelleObjects;
            scope.selectedParcelles.splice(
              scope.selectedParcelles.indexOf(object),
              1
            );
            scope.parcelleObjects = copyParcelleObjects;
          }
        };

        scope.toggleSelectionParcelles = () => {
          scope.allParcellesSelected = !scope.allParcellesSelected;
          if(scope.allParcellesSelected){
            scope.selectedParcelles = scope.parcelleObjects.slice();
            scope.selectedParcelles.forEach((parcelle) =>{
              parcelle.$selected = true;
            });
          } else {
            scope.selectedParcelles.forEach((parcelle) =>{
              parcelle.$selected = false;
            });
            scope.selectedParcelles = [];
          }
        };

        scope.toggleSelectionProprietaires = () => {
          scope.allProprietairesSelected = !scope.allProprietairesSelected;
          if(scope.allProprietairesSelected){
            scope.proprioSelectedParcelles = scope.proprioParcelleObjects.slice();
            scope.proprioSelectedParcelles.forEach((parcelle) =>{
              parcelle.$selected = true;
            });
          } else {
            scope.proprioSelectedParcelles.forEach((parcelle) =>{
              parcelle.$selected = false;
            });
            scope.proprioSelectedParcelles = [];
          }
        };

        scope.toggleSelectionAdresses = () => {
          scope.allAdressesSelected = !scope.allAdressesSelected;
          if(scope.allAdressesSelected){
            scope.adressSelectedParcelles = scope.adressParcelleObjects.slice();
            scope.adressSelectedParcelles.forEach((parcelle) =>{
              parcelle.$selected = true;
            });
          } else {
            scope.adressSelectedParcelles.forEach((parcelle) =>{
              parcelle.$selected = false;
            });
            scope.adressSelectedParcelles = [];
          }
        };

        /**
         * Handler du bouton "consulter"
         * @returns {undefined}
         */
        scope.AjoutParc = function() {
          if (scope.parcelleObjects.length == 0) {
            alert('Veullez effectuer une recherche de parcelles.');
            return;
          }
          if (scope.selectedParcelles.length == 0) {
            alert(
              'Veullez sélectionner des parcelles dans la liste pour les consulter.'
            );
            return;
          }

          scope.listeParcelles.splice(0);
          for (let i = 0; i < scope.selectedParcelles.length; i++) {
            let object = scope.selectedParcelles[i];
            scope.listeParcelles.push({
              Parcelle: object.Commune + object.Section + object.numParcelle,
              idcommune: object.Commune,
              idparcelle: object.Section + object.numParcelle,
            });
          }

          scope.selectedParc = scope.listeParcelles[0];
          scope.SwitchToConsult();

          scope.SelectParcelle();
          scope.searchCoprops();
        };

        scope.resetParc = function() {
          scope.parcelleObjects.splice(0);
          scope.selectedParcelles.splice(0);
          scope.resultMsg = '';
        };

        ////////////////////////////////////////////////
        //
        // Recherche Propriétaires
        //
        ////////////////////////////////////////////////

        scope.proprioParcelleObjects = [];
        scope.proprioSelectedParcelles = [];

        /**
         * Handler du bouton de recherche de parcelle (bouton icon loupe)
         * @returns {undefined}
         */
        scope.isSearchingProprio = false;
        scope.resultMsg2 = '';

        scope.RechProprio = function() {
          scope.proprioParcelleObjects.splice(0);
          scope.proprioSelectedParcelles.splice(0);
          scope.allProprietairesSelected = false;

          var condition = '';
          var condition2 = '';

          var nomProp = scope.nomInput;
          const usageNomProp = scope.usageNomInput;
          var preProp = scope.prenomInput;
          var codParc = scope.idcomm;

          if (nomProp != '' && nomProp != undefined) {
            condition =
              " strToUpperCase(dnomlp) like '%" + nomProp.toUpperCase() + "%'"; // or ddenom like '%" + nomProp + "%')";
          }
          if (usageNomProp && usageNomProp.length>0) {
            const clause = " strToUpperCase(dnomus) like '%" + usageNomProp.toUpperCase() + "%'";
            condition = condition.length>0 ? " and"+ clause : clause;
          }
          if (preProp != '' && preProp != undefined) {
            if (condition != '') {
              condition =
                condition +
                " and strToUpperCase(dprnlp) like '%" +
                preProp.toUpperCase() +
                "%'"; // or ddenom like '%" + preProp + "%')";
            } else {
              condition =
                " strToUpperCase(dprnlp) like '%" +
                preProp.toUpperCase() +
                "%'"; // or ddenom like '%" + preProp + "%')";
            }
          }
          if (codParc != '' && codParc != undefined) {
            var idcommune = codParc.substr(0, 6);
            var idparcelle = codParc.substr(6);
            //L'utilisateur doit rentrer le code Parcelle Entier:  IdCommuneIdParcelle
            condition2 =
              " idcommune like '%" +
              idcommune +
              "%'" +
              " and idparcelle like '%" +
              idparcelle +
              "%'";
          }
          scope.isSearchingProprio = true;
          scope.resultMsg2 = '';
          MajicFactory.getlisteproprio(condition, condition2).then(
            function(res) {
              showQueryRes(
                res,
                scope.proprioParcelleObjects,
                'Proprio',
                getParcFromQueryProp
              );
            },
            function(reason) {
              scope.isSearchingProprio = false;
              scope.ManageError(reason, 'getlisteproprio');
            }
          );
        };

        scope.proprioTableParams = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
            //                        ,filter: {
            //                            //name: 'M'       // initial filter
            //                        },
            //                        sorting: {
            //                            //idCompte: 'asc'     // initial sorting
            //                        }
          },
          {
            total: scope.proprioParcelleObjects.length, // length of data
            getData: function($defer, params) {
              // use build-in angular filter
              //                            var filteredData = params.filter() ?
              //                                    $filter('filter')(scope.parcelleObjects, params.filter()) :
              //                                    scope.parcelleObjects;
              //                            var orderedData = params.sorting() ?
              //                                    $filter('orderBy')(filteredData, params.orderBy()) :
              //                                    scope.parcelleObjects;

              params.total(scope.proprioParcelleObjects.length); // set total for recalc pagination
              $defer.resolve(
                scope.proprioParcelleObjects.slice(
                  (params.page() - 1) * params.count(),
                  params.page() * params.count()
                )
              );
            },
          }
        );

        scope.changeProprioParcSelection = function(object) {
          if (object.$selected) {
            scope.proprioSelectedParcelles.push(object);
          } else {
            scope.proprioSelectedParcelles.splice(
              scope.proprioSelectedParcelles.indexOf(object),
              1
            );
          }
        };

        /**
         * Handler du bouton "consulter"
         * @returns {undefined}
         */
        scope.AjoutProprioParc = function() {
          if (scope.proprioParcelleObjects.length == 0) {
            alert('Veullez effectuer une recherche de parcelles.');
            return;
          }
          if (scope.proprioSelectedParcelles.length == 0) {
            alert(
              'Veullez sélectionner des parcelles dans la liste pour les consulter.'
            );
            return;
          }
          scope.listeParcelles.splice(0);
          for (var i = 0; i < scope.proprioSelectedParcelles.length; i++) {
            var object = scope.proprioSelectedParcelles[i];
            scope.listeParcelles.push({
              Parcelle: object.Parcelle,
              idcommune: object.Parcelle.substr(0, 6),
              idparcelle: object.Parcelle.substr(6),
            });
          }

          scope.SwitchToConsult();

          scope.selectedParc = scope.listeParcelles[0];

          scope.SelectParcelle();
        };

        scope.resetProprioParc = function() {
          scope.proprioParcelleObjects.splice(0);
          scope.proprioSelectedParcelles.splice(0);
          scope.resultMsg2 = '';
        };

        ////////////////////////////////////////////////
        //
        // Recherche par Adresses
        //
        ////////////////////////////////////////////////
        scope.villes = [];

        scope.InitVille = function() {
          MajicFactory.getville().then(
            function(res) {
              scope.villes.splice(0);
              var resultObject = res.data;
              for (var i = 0; i < resultObject.length; i++) {
                scope.villes.push(resultObject[i]);
              }
              // filtre les villes suivant les communes autorisées par les restrictions majic de l'utilisateur
              if (scope.communes && scope.communes.length > 0) {
                scope.villes = scope.communes.filter(com => scope.villes.includes(com.libcom)).map(com => com.libcom);
              }
              scope.villes.sort();
            },
            function(reason) {
              scope.ManageError(reason, 'InitVille');
            }
          );
        };
        scope.InitVille();

        scope.adressParcelleObjects = [];
        scope.adressSelectedParcelles = [];

        /**
         * Handler du bouton de recherche de parcelle (bouton icon loupe)
         * @returns {undefined}
         */
        scope.isSearchingAdress = false;
        scope.resultMsg3 = '';

        scope.RechAdress = function() {
          scope.adressParcelleObjects.splice(0);
          scope.adressSelectedParcelles.splice(0);
          scope.allAdressesSelected = false;

          var nb_10_condition = '';
          var f_commune_condition = '';
          var f_voie_condition = '';

          if (scope.numRueInput != undefined) {
          var numRue = '' + scope.numRueInput;
          }
          var btq = scope.repetitionInput;
          var nomrue = scope.nomRueInput;
          var sVille = scope.villeInput;

          if (numRue != undefined && numRue != '') {
            nb_10_condition =
              "strToUpperCase(dnvoiri) like '%" + numRue.toUpperCase() + "%'";
          }

          if (btq != '' && btq != undefined) {
            if (nb_10_condition != '') {
              nb_10_condition =
                nb_10_condition +
                " and strToUpperCase(dindic) like '%" +
                btq.toUpperCase() +
                "%'";
            } else {
              nb_10_condition =
                "strToUpperCase(dindic) like '%" + btq.toUpperCase() + "%'";
            }
          }

          if (nomrue != '' && nomrue != undefined) {
            f_voie_condition =
              "strToUpperCase(libelle_voie) like '%" +
              nomrue.toUpperCase() +
              "%'";
          }

          if (sVille != '' && sVille != undefined) {
            f_commune_condition = "libcom = '" + sVille + "'";
          }

          scope.isSearchingAdress = true;
          scope.resultMsg3 = '';
          MajicFactory.getlisteadresse(
            nb_10_condition,
            f_commune_condition,
            f_voie_condition
          ).then(
            function(res) {
              showQueryRes(
                res,
                scope.adressParcelleObjects,
                'Adress',
                getParcFromQueryAddress
              );
            },
            function(reason) {
              scope.isSearchingAdress = false;
              scope.ManageError(reason, 'getlisteproprio');
            }
          );
        };

        scope.adressTableParams = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
            //                        ,filter: {
            //                            //name: 'M'       // initial filter
            //                        },
            //                        sorting: {
            //                            //idCompte: 'asc'     // initial sorting
            //                        }
          },
          {
            total: scope.adressParcelleObjects.length, // length of data
            getData: function($defer, params) {
              // use build-in angular filter
              //                            var filteredData = params.filter() ?
              //                                    $filter('filter')(scope.parcelleObjects, params.filter()) :
              //                                    scope.parcelleObjects;
              //                            var orderedData = params.sorting() ?
              //                                    $filter('orderBy')(filteredData, params.orderBy()) :
              //                                    scope.parcelleObjects;

              params.total(scope.adressParcelleObjects.length); // set total for recalc pagination
              $defer.resolve(
                scope.adressParcelleObjects.slice(
                  (params.page() - 1) * params.count(),
                  params.page() * params.count()
                )
              );
            },
          }
        );

        scope.changeAdressParcSelection = function(object) {
          if (object.$selected) {
            scope.adressSelectedParcelles.push(object);
          } else {
            scope.adressSelectedParcelles.splice(
              scope.adressSelectedParcelles.indexOf(object),
              1
            );
          }
        };

        /**
         * Handler du bouton "consulter"
         * @returns {undefined}
         */
        scope.AjoutAdressParc = function() {
          if (scope.adressParcelleObjects.length == 0) {
            alert('Veullez effectuer une recherche de parcelles.');
            return;
          }
          if (scope.adressSelectedParcelles.length == 0) {
            alert(
              'Veullez sélectionner des parcelles dans la liste pour les consulter.'
            );
            return;
          }
          scope.listeParcelles.splice(0);
          for (var i = 0; i < scope.adressSelectedParcelles.length; i++) {
            var object = scope.adressSelectedParcelles[i];
            scope.listeParcelles.push({
              Parcelle: object.Parcelle,
              idcommune: object.Parcelle.substr(0, 6),
              idparcelle: object.Parcelle.substr(6),
            });
          }

          scope.SwitchToConsult();

          scope.selectedParc = scope.listeParcelles[0];

          scope.SelectParcelle();
        };

        scope.resetAdressParc = function() {
          scope.adressParcelleObjects.splice(0);
          scope.adressSelectedParcelles.splice(0);
          scope.resultMsg3 = '';
        };
      },
    };
  };
  majicSearch.$inject = ['$rootScope', 'MajicFactory', '$filter', 'ngTableParams', 'gaJsUtils'];
  return majicSearch;
});
