'use strict';
define(function() {
  var toolbarmapmodelDirective = function($filter) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/layerManager/views/mapModelMgtCmdWidget.html',

      restrict: 'A',

      link: function(scope, element, attrs, ctrl) {
        scope.isActive = false;

        var btnElt = $(element.children()[0]);
        btnElt.bind('click', function() {
          if (scope.isActive) {
            scope.isActive = false;
          } else {
            scope.isActive = true;
          }
        });

        scope.$on('closeToolsBar_toolbarmapmodeldirective', function(event) {
          if (scope.isActive)
            $('#toolbar_toolbarmapmodeldirective_popover').click();
          btnElt.removeClass('btn-info');
          btnElt.addClass('btn-default');
          scope.isActive = false;
        });

        /**
         * [fct description]
         * @param  {[type]} evt [description]
         * @return {[type]}     [description]
         */
        var fct = function(evt) {
          if (evt.dragging) {
            return;
          }
          /** @type {string} */
          var helpMsg = $filter('translate')('mapmodeldirective.helpMessage');
          /** @type {ol.Coordinate|undefined} */

          scope.helpTooltipElement.innerHTML = helpMsg;
          scope.helpTooltip.setPosition(evt.coordinate);
        };
      },
    };
  };

  toolbarmapmodelDirective.$inject = ['$filter'];
  return toolbarmapmodelDirective;
});
