'use strict';
define(function() {
  var basemapwidget = function(
    ngDialog,
    extendedNgDialog,
    gclayers,
    FeatureTypeFactory,
    ConfigFactory,
    QueryFactory,
    $location,
    gaDomUtils,
    SelectManager,
    $filter,
    intervflowwidgetservice,
    $rootScope,
    ReportIndicatorFactory,
    $timeout,
    isUtils,
    gaJsUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/interventionflow/views/intervflowwidget.html',
      restrict: 'A',
      link: function (scope) {
        // define constants
        scope.TYPE_FORM = 'Form';
        scope.TYPE_FORMTABLE = 'FormTable';
        scope.TYPE_DATATABLE = 'DataTable';
        scope.TYPE_TITLE = 'Title';
        //init
        let preCloseCallbackDone = false;
        var map = scope.map;
        scope.fti = {};
        scope.ftid = '';
        scope.currentlink = {};
        scope.mode = $location.search().mode;

        if (angular.isUndefined(scope.fti)) {
          scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        }

        scope.selectedtypelinks = {};
        scope.links = [
          //{"title":"Nouvelles Anomalies", "type":"Form" , "config":{ "templatedir" :"intervform" ,"templateform":"ANC" } },
          //{"title":"Tous les Objets", "type":"DataTable" , "config":{ "where":"1=1", "actions":{} , "attributes" :['no_de_comm','no_de_sect','no_de_parc']} },
        ];
        //Pour l'arbre de la new
        //select; edit ; attribute;divers, model
        scope.newobj = {};
        scope.closepanel = function() {
          //mark all panels to 'closed'
          intervflowwidgetservice.setPanelFormToClosed();
          //close the panel
          scope.panelsManager.removePanel('intervention');
          SelectManager.clear();
        };
        /**
         * add action for a datatable
         * @param  {[type]} lks [description]
         * @return {[type]}     [description]
         */
        scope.param = {};
        scope.addaction = function(lks, typeaction, param) {

          if (angular.isUndefined(lks.config.actions)) {
            lks.config.actions = [];
          }

          switch (typeaction) {
            case 'openform':
              lks.config.actions.push({
                name: 'test',
                icone: param.icone ? param.icone : 'glyphicon glyphicon-pencil',
                form: param.form,
                form_title: param.form_title ? param.form_title : '',
                callFunction: function(obj) {
                  var form = this.form;
                  var form_title = this.form_title;
                  var formData = form.split('.');

                  ConfigFactory.get(
                    formData[0],
                    formData[1] + '.' + formData[2]
                  ).then(
                    function(res) {
                      scope.currentlink.template = res.data;
                      scope.newobj = {};
                      scope.newobj.current = obj;

                      extendedNgDialog.open({
                        template:
                          'js/XG/widgets/mapapp/interventionflow/views/formulaire.html',
                        className:
                          'ngdialog-theme-plain width800 nopadding miniclose interventionRenderWrapper close-form-class',
                        closeByDocument: false,
                        scope: scope,
                        minimizeMaximize: true,
                        scrollable: true,
                        resizable: true,
                        title: form_title,
                        draggable: true,
                      });
                    },
                    function() {
                      console.log('form does not exist');
                    }
                  );
                },
              });
              break;

            case 'printdocxTemplate':
              lks.config.actions.push({
                name: 'print',
                icone: 'glyphicon  glyphicon-print',
                form: param.form,
                callFunction: function(obj) {
                  console.log('jamais cable ?');
                },
              });
              break;
            case 'datatable':
              var newelement = {
                title: 'titre',
                type: 'DataTable',
                config: {},
              };
              break;
          }
          scope.param = {};
        };

        /**
         * add links
         * @param type
         */
        scope.addlinks = function(type) {
          let newElement;
          switch (type) {
            case scope.TYPE_FORM:
              newElement = {
                title: 'titre',
                type: scope.TYPE_FORM,
                config: { templatedir: '', templateform: '' },
              };
              break;
            case scope.TYPE_FORMTABLE:
              newElement = {
                title: 'titre',
                type: scope.TYPE_FORMTABLE,
                config: { templatedir: '', templateform: '' },
              };
              break;
            case scope.TYPE_DATATABLE:
              newElement = {
                title: 'titre',
                type: scope.TYPE_DATATABLE,
                config: {},
              };
              break;
            case scope.TYPE_TITLE:
              newElement = {
                title: 'titre',
                type: scope.TYPE_TITLE
              };
              break;
          }
          if (scope.links == undefined) scope.links = [];
          scope.links.push(newElement);
        };

        /**
         * Open the config menu
         */
        scope.openFlowConfig = () => {
          // get all forms in config
          for(let link of scope.links) {
            if (link.config && link.config.templateform) {
              ConfigFactory.get(
                link.config.templatedir,
                link.config.templateform)
                .then( res => {
                  link.template = res.data;
                });
            }
          }

          // actually open config
          extendedNgDialog.open({
            template: 'js/XG/widgets/mapapp/interventionflow/views/config.html',
            className: 'ngdialog-theme-plain width1100 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: true,
            title: 'Config',
          });
        };

        /**
         * Set the link form data when selected from the config browser
         * @param openData
         */
        scope.openForm = function(openData) {
          if (openData.name.indexOf('.form') == -1) {
            openData.name += '.form';
          }

          // get form content
          ConfigFactory.get(
            openData.type,
            openData.name)
            .then( res => {
              scope.links[scope.browsefor].template = res.data;
            });

          scope.links[scope.browsefor].config.templatedir = openData.type;
          scope.links[scope.browsefor].config.templateform = openData.name;
        };

        /**
         * Open Config Browser
         * @param $index
         */
        scope.openConfigBrowser = function($index) {
          scope.browsefor = $index;
          ngDialog.open({
            template:
              'js/XG/widgets/utilities/form/views/modal/builderOpen.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * Save config
         */
        scope.saveconfig = function() {
          const config = {};
          config.links = angular.copy(scope.links);
          // we should not save the content of the form in the config of the widget.
          // let's delete it
          config.links.map(form => {
            delete form.template;
            return form;
          });
          ConfigFactory.add(config, 'interventionflow', scope.ConfigName).then(
            () => {
              scope.getconfig(true);
            }
          );
        };

        /**
         * Delete config
         * @param deleteIndex
         */
        scope.delconfig = function(deleteIndex) {
          scope.links.splice(deleteIndex, 1);
        };

        /**
         * Lecture de la configuration dans le json du repo
         * APPS/{appname}/CONFIG/widgets/ConfigName
         * @param hasSaved est true quand getConfig est lancée depuis saveConfig
         * pour afficher le message après récupération de la config
         */
        scope.getconfig = (hasSaved) => {
          let config = {};
          ConfigFactory.get('interventionflow', scope.ConfigName).then(
            (res) => {
              config = res.data;
              if (config !== '') {
                if (scope.links && Array.isArray(scope.links) && scope.links.length > 0) {
                  for(let index in scope.links) {
                    const template = scope.links[index].template;
                    scope.links[index] = config.links[index];
                    scope.links[index].template = template;
                  }
                } else {
                  scope.links = config.links;
                }
                filterByRole();
              }
              if (hasSaved){
                require('toastr').success($filter('translate')('formapp.config_saved'));
              }
            },
            (reason) => {
              console.error($filter('translate')('formapp.confignotlaunched') + reason);
            }
          );
        };

        scope.newobj = {};
        scope.newObjects = {};
        scope.open = (link) => {

          if (intervflowwidgetservice.isFormOpened(link)){
            // si le formulaire est déjà ouvert, aucune action
            console.log('le formulaire "' + link.title + '" est déjà ouvert');
          } else {
            //open the form
            switch(link.type) {
              case 'DataTable':
                scope.openDataTable(link);
                break;
              case 'FormTable':
                scope.openFormTable(link);
                break;
              case 'Form':
              case undefined:
                scope.openAFormDialog(link);
                break;
              default:
                console.error('unknow type: ' + link.type
                + '. should be \'DataTable\', \'FormTable\' or \'Form\'');
                break;
            }
          }
        };

        scope.openDataTable = (link) => {
          scope.currentDataTablelink = {};
          let lks = { config: {} };
          if (link.config.actions) {
            link.config.actions.forEach(function(act) {
              scope.addaction(lks, 'openform', {
                form: act.form,
                icone: act.icone,
                form_title: act.form_title
              });
            });
          }

          link.config.actions = lks.config.actions;

          scope.currentDataTablelink = link;
          scope.currlayer = link.fti;
          scope.wheretab = link.where;
          scope.currTabName = link.title;

          scope.closepanel();
          intervflowwidgetservice.setFormState(link,true);
          scope.panelsManager.addPanel({
            id: 'intervention',
            stickToRight: true,
            templateUrl:
              'js/XG/widgets/mapapp/interventionflow/views/dataTable.html',
            scope: scope,
            stickToBorder: true,
            visible: true,
          });
        };

        scope.openFormTable = (link) => {
          scope.currentFormTablelink = {};
          ConfigFactory.get(
            link.config.templatedir,
            link.config.templateform
          ).then((res) => {
            link.template = res.data;
            scope.currentFormTablelink = link;
            scope.newTableobj = {};
            scope.currTabName = link.title;

            scope.closepanel();
            intervflowwidgetservice.setFormState(link, true);
            scope.panelsManager.addPanel({
              id: 'intervention',
              stickToRight: true,
              templateUrl:
                'js/XG/widgets/mapapp/interventionflow/views/formTable.html',
              scope: scope,
              stickToBorder: true,
              visible: true,
            });
          });
        };

        /**
         * actually open a form
         * @param {*} link
         */
        scope.openAFormDialog = (link) => {
          scope.currentlink = {};
          // Thibaud-23/05/22: I don't know why but
          // we store new objects in scope.newObjects
          // each object contains all the variables of the form
          let newObjectKey = 'key' + Object.keys(scope.newObjects).length;
          scope.newObjects[newObjectKey] = {};

          scope.getLastObjectIndex = () => {
            const keys = Object.keys(scope.newObjects),
              lastKey = keys[keys.length - 1];
            return lastKey;
          };

          if (link.config) {
            ConfigFactory.get(
              link.config.templatedir,
              link.config.templateform
            ).then((res) => {
              link.template = res.data;
              intervflowwidgetservice.setFormState(link, true);

              // KIS-3079: mauvais dimensionnement de la popup.
              // Les boutons Fermer/Enregistrer masquent la liste des objets sélectionnés
              // La popup prend la hauteur du contenu (minHeight+44 par défaut)
              let height = link.config.height ? link.config.height : '';

              let newScope = scope.$new();
              newScope.currentlink = link;
              newScope.fti = scope.fti;
              newScope.map = scope.map;
              newScope.interventionSimpleWithoutSearchTab = link.config.modeWithoutSearchTab;
              if (newScope.interventionSimpleWithoutSearchTab) {
                // init the variable 'current'
                newScope.res = {current: {}};
              }

              const scrollable = link.template.formtype !== 'intervention_simple';

              //-- Dans le cas où on ouvre une autre popup depuis cette dialog
              //-- grâce à cette propriété, la popup créée pourra connaître
              //-- quel est sa dialog parent. Ainsi, à l'affichage
              //-- de la fenêtre fille, on peut cacher la fenêtre parent, et
              //-- à la fermeture de la fenêtre fille la rendre
              //-- de nouveau visible.
              const opts = {
                template:
                  'js/XG/widgets/mapapp/interventionflow/views/formulaire_new.html',
                className:
                  'ngdialog-theme-default ' +
                  height +
                  ' nopadding miniclose interventionRenderWrapper close-form-class',
                formOptions: res.data.options,
                closeByDocument: false,
                scope: newScope,
                minimizeMaximize: true,
                scrollable: scrollable,
                resizable: true,
                title: link.title,
                draggable: true,
                minWidth: '640px',
                minHeight: '400px',
                preCloseCallback: () => {
                  // preCloseCallbackDone prevent 2nd exec when $destroy
                  if (!preCloseCallbackDone) {
                    const idDialog = newScope.dlgPopup.dialog[0].getAttribute('dialog-id');
                    const isDirty = gaJsUtils.notNullAndDefined(newScope.res, 'current.id')
                      && isUtils.isForm[idDialog].isDirty;

                    let hasConfirmed = true;
                    if (link.template.formtype !== 'intervention_simple'
                        || (link.template.formtype === 'intervention_simple'
                        && (isUtils.hasSelectedFeatures || isDirty))) {
                      hasConfirmed = confirm($filter('translate')('common.sure_to_close_modal'));
                    }
                    if (!hasConfirmed) {
                      return false;
                    } else {
                      gclayers.getDrawLayer().getSource().clear();
                      gclayers.clearhighLightFeatures();
                      SelectManager.clear();
                      if (link.template.formtype === 'intervention_simple') {
                        isUtils.clearFormListenersAndObservers(idDialog);
                      }
                      intervflowwidgetservice.setFormState(link, false);
                    }
                  }
                  preCloseCallbackDone = !preCloseCallbackDone;
                },
              };

              if (height && height.includes('height')) {
                // -- KIS-3526 RETOUR
                // -- Il faut mettre la hauteur demandée sinon,
                // -- le calcul de la hauteur pour la datatable
                // -- ne se base pas sur la bonne hauteur.
                // -- La bonne hauteur étantcelle du fond blanc de la popup qui apparaît.
                opts.height = height.replace('height', '')+'px';
              }
              opts.broadcastHeightChanged = 'updateGcDataTableHeight';
              newScope.dlgPopup = extendedNgDialog.open(opts);
            });
          }
        };



        scope.getconfig();
        scope.zoomOndata = function() {
          gaDomUtils.showGlobalLoader();
          SelectManager.clear();
          QueryFactory.data(
            scope.currentlink.config.fti,
            scope.currentlink.config.fullfilter,
            map
              .getView()
              .getProjection()
              .getCode(),
            '',
            '',
            ''
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              SelectManager.addFeaturesFromGeojson(res.data);
              map.getView().fit(SelectManager.getExtent(), scope.map.getSize());
            },
            function() {
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.removeFlowAction = (lks, idx) => {
          if (
            confirm('Êtes-vous certain de vouloir supprimer cette action ?')
          ) {
            lks.config.actions.splice(idx, 1);
          }
        };

        /**
         * Filtre les formulaires en fonction des rôles de celui-ci
         * Le formulaire doit avoir un rôle correspondant à un rôle de l'utilisateur connecté
         * Si le formulaire n'a pas de rôle alors tout utilisateur peut le voir
         * Exécutée à la récupération et à la sauvegarde de la config
         */
        const filterByRole = () => {
          const login = $rootScope.xgos.user.login;
          scope.filteredLinks = [];
          ReportIndicatorFactory.getRolesByUser(login).then(
            res => {
              if (res.data){
                const userRoles = res.data;

                if (userRoles && userRoles.length > 0){

                  for (const form of scope.links){

                    if (form.roles && form.roles.length > 0){

                      // le formulaire doit avoir un rôle en commun avec l'utilisateur pour que celui-ci soit affiché dans la liste du widget
                      for (const formRole of form.roles){
                        if (userRoles.includes(formRole)){
                          scope.filteredLinks.push(form);
                          break;
                        }
                      }
                    }else{
                      // si le formulaire n'a pas de rôle alors on l'ajoute à la liste des indicateurs du widget
                      scope.filteredLinks.push(form);
                    }
                  }
                }else{
                  // si l'utilisateur n'a pas de rôle alors il récupère tous les formulaires (cas impossible)
                  scope.filteredLinks = scope.links;
                }
                hideUselessTitles();
              }
            },
            () => {
              require('toastr').error($filter('translate')('dashboard.configuration.rolesretrieveerror'));
              scope.filteredLinks = scope.links;
            }
          );
        };

        /**
         * A cause des restriction d'accès, certains formulaires peuvent être masqués.
         * Il faut donc masquer les titres associés à des formulaires masqués.
         * Si il y a plusieurs titres consécutifs dans le widget
         *  alors on garde que le dernier.
         */
        const hideUselessTitles = () => {
          let titlesToDelete = [];
          for (const [indexCurrent, element] of scope.filteredLinks.entries()) {
            if (scope.filteredLinks[indexCurrent].type===scope.TYPE_TITLE) {
              // remove lastTitle si il est juste au dessus d'un titre ou si c'est le dernier element de la liste
              if (scope.filteredLinks[indexCurrent+1] == undefined || scope.filteredLinks[indexCurrent+1].type===scope.TYPE_TITLE) {
                titlesToDelete.push(scope.filteredLinks[indexCurrent]);
              }
            }
          }
          scope.filteredLinks = scope.filteredLinks.filter(
            (element) => !titlesToDelete.includes(element));
        };

        /**
         * Move the @index item in @direction
         * @param index
         * @param direction 'up' or 'down'
         */
        scope.moveItem = function(index, direction) {
          if (!((index === 0 && direction === 'up') ||
            (index === scope.links.length-1 && direction === 'down'))) {
            var newIndex = direction == 'up' ? index - 1 : index + 1;
            scope.links.splice(
              index,
              0,
              scope.links.splice(newIndex, 1)[0]
            );
          }
        };
      },
    };
  };

  basemapwidget.$inject = [
    'ngDialog',
    'extendedNgDialog',
    'gclayers',
    'FeatureTypeFactory',
    'ConfigFactory',
    'QueryFactory',
    '$location',
    'gaDomUtils',
    'SelectManager',
    '$filter',
    'intervflowwidgetservice',
    '$rootScope',
    'ReportIndicatorFactory',
    '$timeout',
    'isUtils',
    'gaJsUtils'
  ];
  return basemapwidget;
});
