'use strict';
define(() => {
  class importdxftwidget {
    constructor(
      ImportExportFactory,
      gclayers,
      $filter,
      extendedNgDialog,
      $timeout,
      EditFactory,
      $rootScope,
      gaDomUtils,
      gcStyleFactory,
      SelectManager,
      gcPopup,
      gcRestrictionProvider,
      gcInteractions,
      SridFactory,
      importdxfservice,
      gaJsUtils,
      mapJsUtils
    ) {
      return {
        templateUrl:
            'js/XG/widgets/mapapp/importdxf/views/importdxfwidget.html',
        restrict: 'AE',
        link: function(scope) {
          // enable importFile() to filter between dwg and dxf
          if (!scope.dwgdxfExtension) {
            scope.dwgdxfExtension = '.dxf';
          }

          // taille de l'extent quand la layer ne contient qu'un seul point (évite plantage openlayers)
          // modifier cette valeur pour modifier la taille de l'extent
          const DISTANCE = 50;

          scope.srids = SridFactory.sridsList;
          scope.srid = {
            inputsrid: scope.map.getView().getProjection().getCode()
          };
          scope.dzMemShare = {};

          scope.srid = {
            inputsrid: scope.map.getView().getProjection().getCode()
          };

          scope.waitImport = false;

          // couleur de l'input color global du DXF
          scope.importLayerColor = '#000000';

          /**
           * Création de l'objet contenant les onglets et leur propriétés<br><ul><li>
           * title: nom de l'onglet affiché</li><li>
           * disabled: état courant de l'onglet</li></ul>
           */
          const setTabs = () => {
            scope.tabs = [
              {
                title: $filter('translate')('importexportwidget.import'),
              },
              {
                title: $filter('translate')('importexportwidget.dataset'),
              },
            ];
          };

          // fonction détachée pour pouvoir être exécutée après navigation
          // @see resetViewAfterNavigation
          setTabs();

          scope.dxftabs = {
            activeTab: 0,
          };

          const parser = new ol.format.GeoJSON();

          /**
           * Envoie le processId avec le srid au serveur
           * Une fois le dxf converti en geojson retourné
           * Construit les layers temporaires
           * Active le second onglet "filter" et zoome sur tous les objets
           */
          scope.importFile = () => {
            if (scope.srid.inputsrid && scope.srids.includes(scope.srid.inputsrid)) {
              // si un srid est défini
              scope.waitImport = true;
              if (scope.dzMemShare.dropzoneComponent.files.length > 0) {

                // Quand on fait deux imports dxf de suite,
                // si on n'a pas tout supprimé du premier import
                // alors dans la carte le chargement du second dxf s'ajoute aux précédents
                gclayers.getImportLayer().getSource().clear();
                if (scope.layers && Array.isArray(scope.layers)) {
                  scope.layers.splice(0, scope.layers.length);
                }

                scope.waitImport = true;
                ImportExportFactory.getGeoJson(
                  scope.dzMemShare.processId,
                  scope.srid.inputsrid,
                  scope.dwgdxfExtension.substring(1),
                  undefined,
                  undefined,
                  undefined,
                  undefined,
                  undefined,
                  undefined,
                  scope.map
                    .getView()
                    .getProjection()
                    .getCode()
                ).then(geoJsonResults => {
                  if (!Array.isArray(geoJsonResults.data)) {
                    require('toastr').error($filter('translate')('importdxfwidget.importError'));
                    if (scope.dwgdxfExtension && scope.dwgdxfExtension === '.dwg') {
                      // si DWG, le problème peut venir de la configuration de libreDWG
                      require('toastr').warning(
                        $filter('translate')('importdwgwidget.libreDwgConfig'));
                    } else {
                      // si DXF, le fichier est corrompu
                      require('toastr').warning(
                        $filter('translate')('importdxfwidget.corruptedFile'));
                    }
                    scope.waitImport = false;
                  } else {
                    scope.layers = [];
                    geoJsonResults.data.map(x => {
                      let layersNames = Object.keys(x);
                      angular.forEach(layersNames, key => {

                        // remplace par un caractère sans accent les symboles générés (ex. Ã©)
                        // par un mauvais encodage des caractères accentués
                        // lors de la transformation du dxf en geojson par gdal
                        const layerName = gaJsUtils.restaureAccentCharacters(key);

                        scope.layers.push({
                          name: layerName,
                          geojson: x[key],
                          color: '#000000'
                        });
                      });
                    });
                    scope.dxftabs.activeTab = 1;

                    // couleur de l'input color global du DXF
                    scope.importLayerColor = '#000000';

                    // re-initialise la couleur du DXF (si des imports ont déjà été fait avant)
                    setImportLayerStyleColor(null);

                    for (let i = 0; i < scope.layers.length; i++) {
                      let obj = scope.layers[i];
                      let features = parser.readFeatures(obj.geojson);
                      scope.layers[i].features = features;

                      // détermine le type de géométrie du calque
                      if (Array.isArray(features) && features.length > 0) {
                        const featureGeomType = features[0].getGeometry().getType();
                        let layerGeomType = 'point';
                        if (featureGeomType.includes('Line')) {
                          layerGeomType = 'line';
                        }
                        else if (featureGeomType.includes('Polygon')) {
                          layerGeomType = 'polygon';
                        }
                        scope.layers[i].geomType = layerGeomType;
                      }

                      // ajoute le nom du layer dxf comme propriété aux objets de la couche d'import
                      // cela permettra de filtrer les objets par layer dxf
                      for (const feature of features) {
                        feature.set('dxflayer', scope.layers[i].name);
                      }

                      gclayers.getImportLayer().getSource().addFeatures(features);
                      scope.layers[i].visible = true;
                    }
                    // place la couche d'import sur le dessus
                    const zIndex = gaJsUtils.getZIndexMax(scope.map) + 1;
                    gclayers.getImportLayer().setZIndex(zIndex);
                    // zoom sur les données temporaires
                    scope.zoomAll();
                    // supprime les items de la dropzone
                    scope.dzMemShare.dropzoneComponent.removeAllFiles();
                    // enlève le spinner
                    scope.waitImport = false;
                    scope.dragBox.setActive(false);
                    scope.map.removeInteraction(scope.dragBox);
                    scope.allv = true;
                    importdxfservice.layers = scope.layers;
                    importdxfservice.processId = scope.dzMemShare.processId;
                    importdxfservice.inputsrid = scope.srid.inputsrid;
                    importdxfservice.allv = scope.allv;
                  }
                },
                (info) => {
                  // masque le spinner
                  scope.waitImport = false;
                  require('toastr').error($filter('translate')('importdxfwidget.importerror'));
                  require('toastr').error(info.data);
                });
              }
            } else {
              // si aucun srid sélectionné
              require('toastr').warning($filter('translate')('importdxfwidget.noSridSelected'));
            }
          };

          scope.selectionisactive = false;
          scope.dragBox = new ol.interaction.DragBox({
            condition: function(evt) {
              //MacEnvironments don't get here because the event is not
              //recognized as mouseEvent on Mac by the google closure.
              //We have to use the apple key on those devices
              return (
                evt.originalEvent.ctrlKey || scope.selectionisactive
              ); /* ||
                              (gaBrowserSniffer.mac && evt.originalEvent.metaKey);*/
            },
            style: gcStyleFactory.getStyle('selectrectangle'),
          });
          scope.dragBox.set('gctype', 'kis');
          scope.dragBox.set('interaction', 'Select');
          scope.dragBox.set('widget', 'ImportDXF');
          scope.allvisible = function() {
            scope.layers.map(function(x) {
              x.visible = scope.allv;
            });
          };
          scope.dragBox.setActive(false);
          scope.dragBox.on('boxend', function(event) {
            const hasClickOnCtrl = event && event.hasOwnProperty('mapBrowserEvent')
                && event.mapBrowserEvent.hasOwnProperty('originalEvent')
                && event.mapBrowserEvent.originalEvent.ctrlKey;
            if (!hasClickOnCtrl){
              scope.selectedfeatures = [];
            }
            var i = 0;
            gclayers
              .getImportLayer()
              .getSource()
              .forEachFeatureIntersectingExtent(
                scope.dragBox.getGeometry().getExtent(),
                function(feature) {
                  feature.set('index', ++i);
                  scope.selectedfeatures.push(feature);
                }
              );
            SelectManager.clear();
            try {
              SelectManager.addFeaturesFromGeojson(
                JSON.parse(parser.writeFeatures(scope.selectedfeatures))
              );
            } catch (e) {
              console.info('features n\'ont pas d\'IDs normal');
            }
            boutonDroit();
          });
          scope.selectElementOnMap = () => {
            scope.selectionisactive = !scope.selectionisactive;
            if (!scope.selectionisactive) {
              SelectManager.clear();
              scope.dragBox.setActive(false);
              scope.map.removeInteraction(scope.dragBox);
              scope.selectedfeatures = [];
            } else {
              scope.dragBox.setActive(true);
              gcInteractions.setCurrentToolBar(scope.toolBarWidget);
              scope.map.addInteraction(scope.dragBox);
            }
          };
          const boutonDroit = () => {
            const Supprimer = [
              $filter('translate')('importdxfwidget.remove'),
              function() {
                scope.removeFeatures();
              },
            ];
            const clear = [
              $filter('translate')('importdxfwidget.abandon'),
              function() {
                clearFeatures();
              },
            ];
            const menu = scope.menuContext;
            if (scope.menuContext) {
              if (scope.menuContext.length >= 3) {
                scope.menuContext.splice(0, scope.menuContext.length - 2);
              }
              menu.unshift(clear);
              menu.unshift(Supprimer);
            }
          };

          scope.removeFeatures = () => {
            if (scope.selectedfeatures.length > 0) {
              const ans = window.confirm(
                $filter('translate')('common.confirm_action')
              );
              if (ans) {
                const olcol = new ol.Collection(
                  gclayers
                    .getImportLayer()
                    .getSource()
                    .getFeatures()
                );
                angular.forEach(scope.selectedfeatures, (ft) => {
                  olcol.remove(ft);
                });
                gclayers
                  .getImportLayer()
                  .getSource()
                  .clear();
                gclayers
                  .getImportLayer()
                  .getSource()
                  .addFeatures(olcol.getArray());
                var idxx = [];
                for (var i = 0; i < scope.layers.length; i++) {
                  var layer = scope.layers[i];
                  var col = new ol.Collection(layer.features);
                  angular.forEach(scope.selectedfeatures, function(ft) {
                    col.remove(ft);
                  });
                  layer.features = col.getArray();
                  layer.geojson = JSON.parse(
                    parser.writeFeatures(layer.features)
                  );
                  layer.geojson.totalFeatures = layer.geojson.features.length;
                  if (layer.geojson.totalFeatures === 0) idxx.push(i);
                }
                if (idxx.length > 0) {
                  idxx = idxx.reverse();
                  idxx.map(function(x) {
                    scope.layers.splice(x, 1);
                  });
                }
                // supprime les données sélectionnées sans désactiver le bouton de sélection
                clearFeatures();
                scope.selectElementOnMap();
                // màj des layers dans le service
                importdxfservice.layers = scope.layers;
              }
            } else {
              require('toastr').info(
                $filter('translate')('importdxfwidget.selectObjectfirst')
              );
            }
          };

          /**
           * Supprime le jeu de sélection
           * @param preserveInteraction est true pour garder le bouton de sélection actif
           */
          const clearFeatures = () => {
            const idx = [];
            if (scope.menuContext) {
              for (let i = 0; i < scope.menuContext.length; i++) {
                if (
                  scope.menuContext[i][0] ===
                    $filter('translate')('importdxfwidget.remove') ||
                    scope.menuContext[i][0] ===
                    $filter('translate')('importdxfwidget.abandon')
                ) {
                  idx.push(i);
                }
              }
              idx.reverse().map((x) => {
                scope.menuContext.splice(x, 1);
              });
            }
            scope.selectedfeatures = [];
            SelectManager.clear();
            scope.selectionisactive = false;
            scope.dragBox.setActive(false);
            scope.map.removeInteraction(scope.dragBox);
          };

          let pop;
          scope.listFeatures = () => {
            if (SelectManager.getpop()) {
              try {
                if (SelectManager.getpop().element) {
                  SelectManager.getpop().destroy();
                }
                if (SelectManager.getpop().scope) {
                  SelectManager.getpop().scope.$broadcast('$destroy');
                }
              } catch (e) {
                SelectManager.setpop(null);
              }
            }
            pop = gcPopup.open({
              scope: scope,
              title:
                  $filter('translate')('importdxfwidget.features') +
                  ` <label class="label label-default dxfSelectedFeaturesLength">${scope.selectedfeatures.length}</label>`,
              template:
                  'js/XG/widgets/mapapp/importdxf/views/importdxffeatures.html',
              showClose: true,
            });
            SelectManager.setpop(pop);
          };

          scope.highLightFeature = (f) => {
            gclayers.addhighLightFeature(f);
          };

          scope.removehighLightFeature = (f) => {
            $('.dxfSelectedFeaturesLength').text('' + scope.selectedfeatures.length);
            gclayers.removehighLightFeatures(f);
          };

          /**
           * Zoom sur une feature d'une couche du DXF
           * Attention! Il faut modifier l'extent en cas de point
           * car fit() sur un extent de point plante (error 32)
           * @param feature feature dont on récupère l'extent
           */
          scope.zoomOnFeature = (feature) => {
            const extent = feature.getGeometry().getExtent();
            if (isExtentAPoint(extent)) {
              fitMapToPoint(extent);
            } else {
              scope.map
                .getView()
                .fit(extent, scope.map.getSize());
            }
          };

          /**
           *
           * @param idx
           */
          scope.removeFeature = (idx) => {
            scope.selectedfeatures.splice(idx, 1);
            SelectManager.clear();
            try {
              SelectManager.addFeaturesFromGeojson(
                JSON.parse(parser.writeFeatures(scope.selectedfeatures))
              );
            } catch (e) {
              console.info('features n\'ont pas d\'IDs normal');
            }
          };

          /**
           * Après conversion du dxf en geojson (import)
           * ou bien au clic sur le bouton loupe de l'onglet "Filtrer" du widget:
           * zoom sur tous les éléments de la couche d'import
           * @see scope.importFile
           */
          scope.zoomAll = () => {
            const extent = gclayers
              .getImportLayer()
              .getSource()
              .getExtent();
            scope.map.getView().fit(extent, scope.map.getSize());
          };

          /**
           * [clearDropzone description]
           * @return {[type]} [description]
           */
          scope.clearDropzone = () => {
            const { dropzoneComponent } = scope.dzMemShare;
            if (dropzoneComponent.files.length > 0) {
              dropzoneComponent.removeAllFiles();
            }
            gclayers
              .getImportLayer()
              .getSource()
              .clear();
            scope.layers.splice(0,scope.layers.length);
            importdxfservice.layers = undefined;
            importdxfservice.processId = undefined;
            importdxfservice.inputsrid = undefined;
          };

          /**
           * Ajoute les layers visibles dans la couche temporaire
           */
          scope.visible = () => {
            gclayers
              .getImportLayer()
              .getSource()
              .clear();
            let layersVisibleCount = 0;
            for (let i = 0; i < scope.layers.length; i++) {
              if (scope.layers[i].visible) {
                gclayers
                  .getImportLayer()
                  .getSource()
                  .addFeatures(scope.layers[i].features);
                scope.layers[i].visible = true;
                layersVisibleCount++;
              }
            }

            scope.allv = layersVisibleCount === scope.layers.length;
            importdxfservice.allv = scope.allv;
            // màj des layers dans le service
            importdxfservice.layers = undefined;
            importdxfservice.processId = undefined;
          };


          /**
           * Création du filtre pour les composants éligibles
           * à être destinataire de la couche DXF en fonction
           * du type de géométrie.
           *
           * @param {*} layer : description de la couche DXF
           * @returns le filtre ou undefined s'il ne fat pas en appliquer
           */
          const getGeometryTypeFilter = (layer) => {
            let geomType = '';
            switch (layer.features[0].getGeometry().getType()) {
              case 'LineString':
              case 'LinearRing':
              case 'MultiLineString':
              case 'Circle':
                return (component) => component.typeInfo === 'LINE'
                  || component.typeInfo === 'POLYGON';

              case 'Polygon':
              case 'MultiPolygon':
                geomType = 'POLYGON';
                break;

              case 'Point':
              case 'MultiPoint':
                geomType = 'POINT';
                break;

              default:
                //-- L'autre valeur possible est 'GeometryCollection'
                //-- => Pas de filtre
                return undefined ;
            }
            return (component) => component.typeInfo === geomType;
          };


          let dialog;
          scope.copyIn = (layer) => {
            if (dialog) dialog.close();
            scope.selectedLayer = layer;
            if (!scope.selectedLayer.importcfg)
              scope.selectedLayer.importcfg = {
                liaisons: {},
                values: {},
              };
            scope.layerAttributes = Object.keys(
              layer.geojson.features[0].properties
            );
            scope.hasFtiListFilter = true;
            scope.ftiListFilter = getGeometryTypeFilter(layer);
            dialog = extendedNgDialog.open({
              template:
                  'js/XG/widgets/mapapp/importdxf/views/importdxftemplate.html',
              className:
                  'ngdialog-theme-plain overflowY width600 max-height500 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
              title:
                  $filter('translate')('importdxfwidget.copytitle') + layer.name,
              draggable: true,
            });
          };
          scope.save = function() {
            $timeout(function() {
              addFeaturesToFtid(scope.selectedLayer);
              dialog.close();
            });
          };
          function addFeaturesToFtid(layer) {
            gaDomUtils.showGlobalLoader();
            try {
              var geojson = layer.geojson;
              var defaultLayer = angular.copy(geojson);
              angular.forEach(geojson.features, function(feature) {
                var propnew = {};
                var values = Object.keys(layer.importcfg.values);
                var liaisons = Object.keys(layer.importcfg.liaisons);
                if (liaisons.length === 0 && values.length === 0) {
                  propnew = {};
                } else if (liaisons.length > 0 && values.length === 0) {
                  for (const [key, value] of Object.entries(layer.importcfg.liaisons)) {
                    propnew[value] = feature.properties[key];
                  }
                } else if (liaisons.length === 0 && values.length > 0) {
                  propnew = layer.importcfg.values;
                } else {
                  propnew = layer.importcfg.values;
                  for (const [key, value] of Object.entries(layer.importcfg.liaisons)) {
                    if (Object.keys(propnew).indexOf(key) === -1){
                      propnew[value] = feature.properties[key];
                    }
                  }
                }
                feature.properties = propnew;
              });
              EditFactory.add(
                layer.importcfg.ftid,
                geojson,
                scope.map
                  .getView()
                  .getProjection()
                  .getCode(),
                'false'
              ).then(
                function(res) {
                  if (
                    res.data.errors.length === 0 ||
                        res.data.create.length === layer.geojson.features.length
                  ) {
                    for (var i = 0; i < scope.layers.length; i++) {
                      if (scope.layers[i].name === layer.name) {
                        scope.layers.splice(i, 1);
                        break;
                      }
                    }
                    scope.visible();
                    $rootScope.$broadcast(
                      'gcOperationalLayerChange',
                      '',
                      'applyall'
                    );
                    gaDomUtils.hideGlobalLoader();
                    require('toastr').success(
                      $filter('translate')('importdxfwidget.copysuccess') +
                          layer.name
                    );
                  } else {
                    layer.geojson = angular.copy(defaultLayer);
                    gaDomUtils.hideGlobalLoader();
                    require('toastr').error(
                      $filter('translate')('importdxfwidget.copyerror') +
                          layer.name
                    );
                  }
                },
                function(result) {
                  gaDomUtils.hideGlobalLoader();
                  if (
                    result.data &&
                        result.data.code === 403 &&
                        result.data.CLASSTYPE === 'Error' &&
                        result.data.message &&
                        result.data.details
                  ) {
                    gcRestrictionProvider.showDetailsErrorMessage(result);
                  } else {
                    require('toastr').error(
                      $filter('translate')('importdxfwidget.copyerror') +
                          layer.name
                    );
                  }
                }
              );
            } catch (e) {
              console.error(e.message);
              layer.geojson = angular.copy(defaultLayer);
              gaDomUtils.hideGlobalLoader();
              require('toastr').error(
                $filter('translate')('importdxfwidget.copyerror') + layer.name
              );
            }
          }

          scope.$on('closeTools_importdxfwidget', function(event, arg) {
            if (arg.directive === 'importdxfwidget') {
              clearFeatures();
              scope.dragBox.setActive(false);
              scope.map.removeInteraction(scope.dragBox);
              // restaure la couleur par défaut de la couche d'import
              setImportLayerStyleColor(null);
            }
          });
          scope.$on('openCloseTools_importdxfwidget', function(event, arg) {
            if (arg.directive === 'importdxfwidget') {
              if (!arg.active) {
                clearFeatures();
                scope.dragBox.setActive(false);
                scope.map.removeInteraction(scope.dragBox);
              } else {
                scope.dragBox.setActive(true);
                gcInteractions.setCurrentToolBar(scope.toolBarWidget);
                scope.map.addInteraction(scope.dragBox);
              }
            }
          });

          /**
           * Gère l'état commun de la visibilité de chaque couche
           * Si false, vide la couche d'importation KIS
           * Si true, ajoute les layers GPX à la couche d'importation KIS
           */
          scope.toggleAllvisible = () => {
            scope.allv = !scope.allv;
            importdxfservice.allv = scope.allv;
            for (const layer of scope.layers) {
              layer.visible = scope.allv;
            }
            gclayers
              .getImportLayer()
              .getSource()
              .clear();
            if (scope.allv) {
              for (const layer of scope.layers) {
                gclayers
                  .getImportLayer()
                  .getSource()
                  .addFeatures(layer.features);
              }
            }
          };

          /**
           * Centre la carte sur un point
           * Utile dans le cas où l'extent est un point (layer ne contenant qu'un seul point)
           * @param extent étendue courante de la carte (Xmin,Ymin,Xmax,Ymax)
           * @see zoomOnGpx
           * @see zoomOnObject
           */
          const fitMapToPoint = (extent) => {
            if (Array.isArray(extent) && extent.length === 4) {
              const pointExtent = [extent[0] - (DISTANCE / 2),
                extent[1] - (DISTANCE / 2), extent[2] + (DISTANCE / 2),
                extent[3] + (DISTANCE / 2)];
              scope.map.getView().fit(pointExtent, scope.map.getSize());
            }
          };

          /**
           * Vérifie si extent est un point
           * @param extent étendue courante de la carte (Xmin, Ymin, Xmax, Ymax)
           * @returns {boolean} true si l'extent est un point
           */
          const isExtentAPoint = (extent) => {
            if (Array.isArray(extent) && extent.length === 4) {
              return extent[0] === extent[2] && extent[1] === extent[3];
            }
          };

          /**
           * Récupère la liste des calques du DXF
           * lors d'une ré-ouverture du widget
           * après navigation dans les autres catégories de widgets
           */
          const resetViewAfterNavigation = () => {
            if (importdxfservice.layers && importdxfservice.processId){
              scope.dzMemShare.processId = importdxfservice.processId;
              scope.layers = importdxfservice.layers;
              scope.dxftabs = {
                activeTab: 1,
              };
              scope.tabs[1].disabled = false;
              const extent = gclayers
                .getImportLayer()
                .getSource()
                .getExtent();
              if (isExtentAPoint(extent)) {
                fitMapToPoint(extent);
              } else {
                scope.map.getView().fit(extent, scope.map.getSize());
              }
              scope.selectionisactive = true;
              scope.selectElementOnMap();
            }
            if (importdxfservice.allv) {
              scope.allv = importdxfservice.allv;
            }
            if (importdxfservice.inputsrid) {
              scope.srid.inputsrid = importdxfservice.inputsrid;
            }
          };

          /**
           * Modifie la couleur de la couche technique d'Import.<br>
           * Cette couche a déjà un style défini lors de sa création.
           * On ne fait que modifier la couleur des contours.
           */
          scope.changeImportLayerColor = () => {
            if (typeof scope.importLayerColor === 'string') {
              const rgbColor = gaJsUtils.hexToRGB(scope.importLayerColor, null, null);
              if (rgbColor) {
                const olColor = mapJsUtils.rgbToOlColor(rgbColor);
                if (Array.isArray(olColor) && olColor.length > 2) {
                  setImportLayerStyleColor(null, olColor);
                }
              }
            }
          };

          /**
           * Modifie la couleur des features d'un seul layer dxf.<br>
           * On ne traite pas directement les features de l'objet layer ce qui serait sans effet visuel.<br>
           * On traite les objets de la couche d'import ayant une propriété portant le nom du layer dxf
           * @param layerName nom du layer dxf dont on veut modifier les objets.
           */
          scope.changeDxfLayerColor = (layerName) => {
            if (Array.isArray(scope.layers) && scope.layers.length > 0) {
              const layer = scope.layers.find(layer => layer.name === layerName);
              if (layer && Array.isArray(layer.features) && layer.features.length > 0) {
                const color = gaJsUtils.hexToRGB(layer.color, null, null);
                setImportLayerStyleColor(layer.name, color);
              }
            }
          };

          /**
           * Modifie la couleur des objets d'une seule ou de toutes les layers dxf.<br>
           * En l'absence de features, modifie la couleur de tous les élements du style de la couche technique d'import
           * La couche dans laquelle sont situées les layers temporaires du dxf.<br>
           * Si aucune couleur n'est fournie en paramètre alors la méthode restaure la couleur du style d'origine.
           * @see kisreb/js/XG/widgets/mapapp/gcstyles/mod.js
           * @param {string|null} layername nom du layer dxf
           * @param {ol.color|number[]} color couleur sous la forme d'un tableau de 3 ou 4 éléments (4 si alpha)
           */
          const setImportLayerStyleColor = (layername, color = null) => {
            if (!color) {
              color = [0, 0, 0, 0.75];
            }

            const layerStyle = new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: color,
                width: 1,
              }),
              image: new ol.style.Circle({
                radius: 2,
                stroke: new ol.style.Stroke({
                  color: color,
                  width: 1,
                })
              })
            });

            if (typeof layername === 'string' && layername.length > 0) {
              // changement de couleur d'un layer dxf
              const layerFeature = gclayers.getImportLayer().getSource().getFeatures().filter(
                  feat => feat.get('dxflayer') === layername);
              for (const feature of layerFeature) {
                feature.setStyle(layerStyle);
              }
            } else {
              // changement de couleur de toutes les layers dxf
              // suppression du style propre à la feature
              for (const feature of gclayers.getImportLayer().getSource().getFeatures()) {
                feature.setStyle(null);
              }
              for (const layer of scope.layers) {
                if (color.length > 2) {
                  layer.color = gaJsUtils.rgbToHex(color[0], color[1], color[2]);
                }
              }
              gclayers.getImportLayer().setStyle(layerStyle);
            }
          };

          // restaure la liste des couches après navigation
          if (importdxfservice.layers && importdxfservice.layers.length > 0) {
            resetViewAfterNavigation();
          }
        },
      };
    }
  }

  importdxftwidget.$inject = [
    'ImportExportFactory',
    'gclayers',
    '$filter',
    'extendedNgDialog',
    '$timeout',
    'EditFactory',
    '$rootScope',
    'gaDomUtils',
    'gcStyleFactory',
    'SelectManager',
    'gcPopup',
    'gcRestrictionProvider',
    'gcInteractions',
    'SridFactory',
    'importdxfservice',
    'gaJsUtils',
    'mapJsUtils'
  ];
  return importdxftwidget;
});
