'use strict';
define(function() {
  var geolocalisationcoords = function(ConfigFactory, kisGeocodageFactory, $filter) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/geolocalisation/views/geolocalisationcoords.html',
      restrict: 'AE',

      //methode executée au chargement de la page
      link: function(scope, element, attrs, ctrl) {
        //////////////////////// Gestion de la configuration //////////////////////////////

        scope.currentsrid = {
          name: 'EPSG:3857',
          description:
            '+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs',
        };
        scope.selectedsrid = scope.currentsrid;
        ConfigFactory.get('main', 'coordinate').then(function(res) {
          //console.log(res.data)   ;
          if (res.data != '') {
            scope.currentsrid = res.data;
            scope.selectedsrid = res.data;
          }
        });

        //////////////////////// Fin Gestion de la configuration //////////////////////////////

        var map = scope.map;
        var projection = map.getView().getProjection();
        if (!scope.geocodageGMarkerLayerLoaded) {
          scope.vectorLayer = kisGeocodageFactory.getMarkerLayer();
          map.addLayer(scope.vectorLayer);
          scope.vectorSource = scope.vectorLayer.getSource();
        }

        //scope.inputAdress = "";
        scope.wait = false;
        scope.adress = {};

        scope.cleargps = function() {
          scope.searchPosition = { x: '', y: '' };
        };

        scope.markerSet = false;
        scope.selectedsrid = {};

        /**
         * Recherche du point par coordonnées.
         */
        if (attrs.gpsoption == 'onlysrid') {
          scope.gpsOption = {
            value: 'srid',
          };
        } else {
          scope.gpsOption = {
            value: 'degrees',
            currentSrid: projection.getCode(),
          };
        }

        scope.$watch(
          'gpsOption.value',
          function() {
            // reset x/y when switching mode
            scope.searchPosition = { x: '', y: '' };
          },
          1
        );

        scope.searchPosition = { x: '', y: '' };
        scope.searchPoint = function() {
          var myLong = Number(scope.searchPosition.x);
          var lat = Number(scope.searchPosition.y);
          var projetedCoord;

          var mapCode = projection.getCode();
          //Projection des coordonnées du lieu dans le systeme de la carte
          if (scope.gpsOption.value == 'degrees') {
            projetedCoord = ol.proj.transform(
              [myLong, lat],
              'EPSG:4326',
              mapCode
            );
            if (isNaN(projetedCoord[0]) || isNaN(projetedCoord[1])) {
              require('toastr').error(
                $filter('translate')('geolocalisation.invalid_coordinates')
              );
              return;
            }
          } else {
            if (!angular.isUndefined(scope.currentsrid.description)) {
              myLong = Math.round(scope.searchPosition.x * 1000) / 1000;
              lat = Math.round(scope.searchPosition.y * 1000) / 1000;
            }

            if (isNaN(myLong) || isNaN(lat)) {
              require('toastr').error($filter('translate')('geolocalisation.invalid_coordinates'));
              return;
            }
            projetedCoord = [myLong, lat];
          }

          console.log(projetedCoord);
          //Centrage de la carte sur le lieu
          map.getView().setCenter(projetedCoord);
          scope.markerSet = true;

          //Visualisation du lieu sur la carte
          scope.vectorSource.clear(true);
          //Visualisation du centre du lieu
          var centerFeature = new ol.Feature({ name: '' });
          centerFeature.setGeometry(new ol.geom.Point(projetedCoord));

          scope.vectorSource.addFeature(centerFeature);
        };

        /**
         * [clearMarker description]
         * @return {[type]} [description]
         */
        scope.clearMarker = function() {
          scope.markerSet = false;
          scope.vectorSource.clear(true);
        };
      },
    };
  };

  geolocalisationcoords.$inject = ['ConfigFactory', 'kisGeocodageFactory', '$filter'];
  return geolocalisationcoords;
});
