'use strict';
define(() => {
  class exportxlsxwidgetconfig {
    constructor(
        FeatureTypeFactory,
        FeatureAttachmentFactory,
        ConfigFactory,
        ParametersFactory,
        ngDialog,
        $filter
    ) {
      return {
        templateUrl:
            'js/XG/widgets/mapapp/exportxlsx/views/exportxlsxwidgetconfig.html',
        restrict: 'AE',
        link: function (scope) {

          const initConfig = () => {
            const MAP_MODEL_CONFIGURATION_NAME = 'MAP_MODELS_USERS';

            // Récupération de la configuration sauvegardée
            scope.configTemp = angular.copy(scope.config);
            scope.newSheetModelFile = false;

            // Génère les ftis pour l'autocomplétion des champs components
            if (!scope.ftis) {
              FeatureTypeFactory.get().then(
                  res => {
                    scope.ftis = res;
                    reloadAttributeList();
                  });
            } else {
              reloadAttributeList();
            }
          };


          /**
           *  Chargement de la liste des attribut pour le gcautocomplete
           *  s'execute à l'ouverture de la configuration et au changement de choix de composant
           */
          const reloadAttributeList = () => {
            const component = scope.ftis.find(fti => fti.uid === scope.configTemp.territoryComponentUid);
            if (component) {
              scope.attributes = component.attributes;
            }
          };


          /**
           * Vide l'attribut selectionné lors du changement de composant
           */
          scope.onTerritoryPick = () => {
            scope.configTemp.territoryAttributeName = undefined;
            reloadAttributeList();
          }

          /**
           * Upload du modèle xlsx
           * @param fileContainer
           */
          scope.uploadSheetModelFile = fileContainer => {
            scope.sheetModelFile = fileContainer.files[0];
            scope.oldFileName = scope.configTemp.sheetModelFileName;
            scope.configTemp.sheetModelFileName = scope.sheetModelFile.name;
            scope.newSheetModelFile = true;
            // Le nom du fichier ne se met pas à jour dans l'interface sans $apply()
            scope.$apply();
          };

          /**
           * Download du modèle xlsx
           */
          scope.downloadSheetModelFile = () => {
            if(scope.newSheetModelFile) {
              // Retour depuis le fichier déjà présent en front
              // Dans ce cas, le fichier n'a pas par défault son vrai nom
              // TODO: cas peu important mais intéressant à trouver
              const myFileUrlToDownload = URL.createObjectURL(scope.sheetModelFile)
              window.open(myFileUrlToDownload);

              // Solution trouvée pour avoir le vrai nom mais ne fonctionne pas
              // const dlLink = document.createElement("dlLink");
              // dlLink.href = URL.createObjectURL(scope.sheetModelFile);
              // dlLink.setAttribute("download", scope.configTemp.sheetModelFileName);

              // document.body.appendChild(dlLink);
              // dlLink.click();
              // document.body.removeChild(dlLink);
            } else {
              window.open(ConfigFactory.getFileUrl('widgets', scope.ConfigName, scope.configTemp.sheetModelFileName));
            }
          };

          /**
           * Récupération du fichier JSON de configuration
           * @param fileContainer
           */
          scope.uploadJsonConfigFile = fileContainer => {
            const file = fileContainer.files[0];
            if(file) {
              file.text().then(res => {
                try {
                  scope.configTemp.jsonFileData = JSON.parse(res);
                  scope.configTemp.jsonFileName = file.name;
                  // Le nom du fichier ne se met pas à jour dans l'interface sans $apply()
                  scope.$apply();
                } catch (e) {
                  require('toastr').error($filter('translate')('importxlsxwidget.errorParsingJson'));
                  console.error(e);
                }
              });
            }
          };

          let jsonDialog;
          /**
           * Ouvre le mode d'édition du JSON
           */
          scope.editJson = () => {
            scope.editConfig = {
              data: angular.copy(scope.configTemp.jsonFileData),
              options: {
                mode: 'tree',
              },
            };
            // Bouton de changement mode texte / json
            scope.jsonEditionChangeMode = () => {
              scope.editConfig.options.mode = (scope.editConfig.options.mode === 'code') ? 'tree' : 'code';
            }
            // Bouton sauvegarder
            scope.applyDebuggedVersion = () => {
              if (confirm($filter('translate')('common.sure_to_apply_modif'))) {
                scope.configTemp.jsonFileData = angular.copy(scope.editConfig.data);
                jsonDialog.close();
              }
            };
            // Fenêtre d'édition JSON
            jsonDialog = ngDialog.open({
              template:
                  'js/XG/widgets/utilities/form/views/modal/modal.form_debug.html',
              className: 'ngdialog-theme-plain width1000 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
            });
          };

          /**
           * Sauvegarde du fichier de configuration
           */
          const saveConfigFile = () => {
            // Suppression de champs d'une ancienne configuration
            delete scope.configTemp.territoryComponent;
            delete scope.configTemp.territoryAttribute;
            // Sauvegarde configuration
            ConfigFactory.add(scope.configTemp, 'widgets', scope.ConfigName).then(res => {
              if (res.data === true) {
                scope.checkConfigAndGetTerritoryValues(scope.configTemp);
                require('toastr').success($filter('translate')('importexportwidget.config.SaveSuccessMsg'));
              } else {
                require('toastr').error($filter('translate')('importexportwidget.config.SaveErrorMsg'));
              }
            });
          };

          /**
           * Sauvegarde du fichier modele + fichier configuration
           */
          scope.saveAllConfig = () => {
            // Si on a un nouveau fichier modele à importer,
            // On l'importe puis on sauvegarde la configuration
            if (scope.newSheetModelFile) {
              // Ajout du fichier modele xlsx
              const reader = new FileReader();
              reader.onload = (fileReader) => {
                ConfigFactory.addFile(fileReader.target.result, 'widgets',
                    scope.ConfigName, scope.configTemp.sheetModelFileName, scope.oldFileName).then(
                    () => {
                      saveConfigFile();
                    },
                    () => {
                      require('toastr').error($filter('translate')('exportxlsxwidget.errorSavingSheetModel'));
                    });
              }
              reader.readAsDataURL(scope.sheetModelFile);
            // Sinon, on ne fait que sauvegarde la configuration
            } else {
              saveConfigFile();
            }
          };

          initConfig();
        }
      }
    }
  }

  exportxlsxwidgetconfig.$inject = [
    'FeatureTypeFactory',
    'FeatureAttachmentFactory',
    'ConfigFactory',
    'ParametersFactory',
    'ngDialog',
    '$filter'
  ];
  return exportxlsxwidgetconfig;
});