'use strict';
define(() => {
  class filterdeactivate {
        constructor(defaultFiltersFactory, $rootScope) {
            return {
                templateUrl: 'js/XG/widgets/mapapp/defaultfilters/views/filterdeactivate.html',

                restrict: 'A',

                link: (scope, element) => {
                    scope.isActive = true;
                    element.bind('click', () => {
                        defaultFiltersFactory.removeActivatedFilter(scope.isActive);
                        scope.isActive = !scope.isActive;
                    });
                    $rootScope.$on('removeFilterToolBarAction', () => {
                        scope.isActive = true;
                    });
                },
            };
        }
    }

  filterdeactivate.$inject = ['defaultFiltersFactory', '$rootScope'];
  return filterdeactivate;
});
