'use strict';
define([
  'angular',

  /**
   * directives
   */
  'widgets/indigauapp/home_admin_data/directives/listeDataCarte',
  'widgets/indigauapp/home_admin_data/directives/addComponentConfigIndigau',

  'widgets/indigauapp/home_admin_data/directives/adminIndigau',
  'widgets/indigauapp/home_admin_data/directives/adminNetworkIndigau',
  'widgets/indigauapp/home_admin_data/directives/indigauChoixDensiteRegle',
  'widgets/indigauapp/home_admin_data/directives/dataOfComponent',
  'widgets/indigauapp/home_admin_data/directives/refreshRerau',

  /**
   * utilities
   */
  'widgets/indigauapp/home_admin_data/directives/utilities/data/dashboardIndigau',

  /**
   * Services
   */
  'widgets/indigauapp/home_admin_data/services/CarteAppServices',

  /**
   * dependencies
   */
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'ngDragDrop',
], function(
  angular,
  listeDataCarte,
  addComponentConfigIndigau,
  adminIndigau,
  adminNetworkIndigau,
  indigauChoixDensiteRegle,
  dataOfComponent,
  refreshRerau,
  dashboardIndigau,
  CarteAppServices
) {
  // generation du module
  var gcMain = angular.module('gcMainCarteHomeAdminData', [
    'model',
    'ga_urlutils_service',
    'ngRoute',
    'ngDragDrop',
  ]);

  /**
   * Directives
   */
  gcMain.directive('listeDataCarte', listeDataCarte);
  gcMain.directive('addComponentConfigIndigau', addComponentConfigIndigau);
  gcMain.directive('adminIndigau', adminIndigau);
  gcMain.directive('adminNetworkIndigau', adminNetworkIndigau);
  gcMain.directive('indigauChoixDensiteRegle', indigauChoixDensiteRegle);
  gcMain.directive('dataofcomponent', dataOfComponent);
  gcMain.directive('refreshRerau', refreshRerau);

  /**
   * utilities
   */
  gcMain.directive('dashboardIndigau', dashboardIndigau);

  /**
   * Services
   */
  gcMain.factory('CarteAppServices', CarteAppServices);

  return gcMain;
});
