'use strict';
define(function () {
  var hpoNavigation = function (
    $location,
    $rootScope,
    AlertHpoFactory,
    $timeout,
    $filter,
    HpoUserAppFactory,
    gaDomUtils,
    IndIndigauUserAppFactory,
    ApplicationFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/main/views/directives/hpo_navigation.html',
      restrict: 'EA',
      scope: {},
      link: function (scope, elt, attrs) {
        /*
                Navbar groups definition
                */
        scope.apptype = $rootScope.xgos.sector;
        if (attrs.menuType == 'indigau')
          scope.navigations = IndIndigauUserAppFactory.getNavigationHpo();
        else
          scope.navigations = HpoUserAppFactory.getNavigationHpo()
        ApplicationFactory.getbyname(scope.$parent.$parent.app).then(function (res) {
          scope.hpoSimplifyVisualize = res.data.hpoSimplifyVisualize == "yes"
        });
        if (scope.navigations) {
          scope.actual_branch = scope.navigations[0];
          $rootScope.xgos.page = scope.actual_branch.label;

          scope.setBranch = function (item) {
            scope.branch = item;
          };

          /**
           * Returns if the current page is the one selected in the nav bar
           *
           * @param path
           * @returns {boolean}
           */
          scope.isCurrentPath = function (path) {
            if (typeof path == 'string') {
              return $location.path() == path;
            } else {
              return path.indexOf($location.path()) !== -1;
            }
          };

          scope.onlyOneCollapsed = function (m, b) {
            scope.navigations.map(function (x) {
              if (
                x.main_title !== m &&
                angular.isDefined(x.isCollapsed) &&
                angular.isDefined(x.activeSub)
              ) {
                x.isCollapsed = true;
              }
            });
          };

          var message;
          scope.setbranch = function (branch, m) {
            if (checkSpecificBranch(scope.actual_branch, m))
              changeBranch(branch, m);
            else {
              var callback = function (isconfirm) {
                if (isconfirm) {
                  changeBranch(branch, m);
                  scope.$digest();
                }
              };
              AlertHpoFactory.alertConfirmCallback(
                $filter('translate')('hpo.common.warning'),
                message,
                'warning',
                true,
                undefined,
                '#F50072',
                true,
                undefined,
                undefined,
                true,
                true,
                callback
              );
            }
          };

          $rootScope.$on('inititaliseApplicationBranch', function (evt, arg) {
            if (scope.actual_branch) {
              gaDomUtils.showGlobalLoader();
              var branch = angular.copy(scope.actual_branch);
              scope.actual_branch = angular.copy({
                label: 'init',
                template: '<div></div>',
                main_title: 'init',
              });
              try {
                scope.$apply();
              } catch (err) { }
              $timeout(function () {
                scope.actual_branch = branch;
                changeBranch(branch, undefined);
                gaDomUtils.hideGlobalLoader();
                $rootScope.$broadcast('localeChanged');
                try {
                  scope.$apply();
                } catch (err) { }
              }, 100);
            }
          });

          function doOnEndBranchActions() {
            if (scope.actual_branch.toCallOnClose != undefined)
              scope.actual_branch.toCallOnClose();
            if (scope.actual_branch.scopeParameters) {
              scope.actual_branch.scopeParameters.forEach(
                function (param) {
                  delete (scope[param.name]);
                }
              );
            }
          }

          function doOnStartBranchActions(branch) {
            if (branch.initialActions != undefined) {
              for (var iAction = 0; iAction < branch.initialActions.length; iAction++) {
                branch.initialActions[iAction](scope);
              }
            }

            if (branch.scopeParameters) {
              branch.scopeParameters.forEach(
                function (param) {
                  scope[param.name] = param.value;
                }
              );
            }
          }

          var changeBranch = function (branch, m) {
            doOnEndBranchActions();
            scope.actual_branch = branch;
            $rootScope.xgos.page = branch.label;
            scope.navigations.map(function (x) {
              if (
                x.main_title !== m &&
                angular.isDefined(x.isCollapsed) &&
                angular.isDefined(x.activeSub)
              ) {
                x.activeSub = false;
              }
            });
            if (
              scope.actual_branch.label === 'hpo.chantiers.creation.title' ||
              scope.actual_branch.label === 'mapv2.carte.title'
            ) {
              angular.element('.xgos_content').css('overflow-y', 'hidden');
              angular.element('.xgos_content').css('left', '50px');
              angular
                .element('.xgos_content')
                .css('width', 'calc(100% - 50px)');
            } else {
              if (scope.actual_branch.withMap)
                angular.element('.xgos_content').css('overflow-y', 'hidden');
              else
                angular.element('.xgos_content').css('overflow-y', 'auto');
              angular.element('.xgos_content').css('left', '60px');
              angular
                .element('.xgos_content')
                .css('width', 'calc(100% - 60px)');
            }
            doOnStartBranchActions(branch);
          };

          var checkSpecificBranch = function (branch, m) {
            var response = true;
            switch (scope.actual_branch.label) {
              case 'hpo.data.exchange.title':
                var sdirective = angular
                  .element(document.querySelector('#import-mapping-hpo'))
                  .scope();
                if (
                  sdirective.hpo &&
                  sdirective.hpo.importedFeatures &&
                  sdirective.hpo.importedFeatures.length > 0
                ) {
                  response = false;
                  message =
                    $filter('translate')('hpo.data.exchange.currentmapping') +
                    ' ' +
                    $filter('translate')('hpo.common.sur');
                }
                break;
              case 'hpo.data.analyse.title':
                $rootScope.$broadcast('changedBranchStatistics');
                break;
            }
            return response;
          };
        } else {
          $('.xgos_side').css('display', 'none');
          $('.reload-button-hpo').css('display', 'none');
          $('#xgos_main').append(
            '<div id="xgos_503"> ' +
            '<i class="fa fa-times"></i>' +
            '<p>' +
            '  <translate>' +
            $filter('translate')('503.title') +
            '</translate>' +
            '</p>' +
            '</div>'
          );
        }
      },
    };
  };

  hpoNavigation.$inject = [
    '$location',
    '$rootScope',
    'AlertHpoFactory',
    '$timeout',
    '$filter',
    'HpoUserAppFactory',
    'gaDomUtils',
    'IndIndigauUserAppFactory',
    'ApplicationFactory',
  ];
  return hpoNavigation;
});
